/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.HashMap;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.util.Conversions;

public class PrimitiveType
extends AbstractClass
implements JavaConstants {
    @CodeSharingSafe(value="StaticField")
    public static final PrimitiveType[] PRIMITIVE_objects = PrimitiveType.initPrimitiveObjects();
    @CodeSharingSafe(value="StaticField")
    public static final PrimitiveType[] PRIMITIVE_lookup = PrimitiveType.initPrimitiveLookup();
    @CodeSharingSafe(value="StaticField")
    public static final PrimitiveType[] PRIMITIVE_alpha = PrimitiveType.initPrimitiveAlpha();
    @CodeSharingSafe(value="StaticField")
    private static final HashMap<String, PrimitiveType> PRIMITIVE_hashtable = PrimitiveType.initPrimitiveHashTable();
    @CodeSharingSafe(value="StaticField")
    private static final HashMap<String, PrimitiveType> PRIMITIVE_unboxing = PrimitiveType.initPrimitiveUnboxing();
    private static final int NARROWING_BIT = 16;
    private static final int WIDENING_BIT = 8;
    private static final int FL_NUMERIC = 32;
    @CodeSharingSafe(value="StaticField")
    private static int[] PRIMITIVE_flags = new int[]{0, 64049, 717874, 456755, 978996, 2023477, 4112422, 8290343, 0, 0};
    public final byte primCode;

    private static PrimitiveType[] initPrimitiveObjects() {
        PrimitiveType[] objects = new PrimitiveType[10];
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            objects[i] = new PrimitiveType(i);
        }
        return objects;
    }

    private static PrimitiveType[] initPrimitiveLookup() {
        PrimitiveType[] lookups = new PrimitiveType[50];
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            short tk = PRIMITIVE_tokens[i];
            if (96 > tk || tk >= 146) continue;
            lookups[tk - 96] = PRIMITIVE_objects[i];
        }
        return lookups;
    }

    private static PrimitiveType[] initPrimitiveAlpha() {
        PrimitiveType[] alphas = new PrimitiveType[26];
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            String desc = PRIMITIVE_descriptors[i];
            char ch = desc.charAt(0);
            if ('A' > ch || ch > 'Z') continue;
            alphas[ch - 65] = PRIMITIVE_objects[i];
        }
        return alphas;
    }

    private static HashMap<String, PrimitiveType> initPrimitiveHashTable() {
        HashMap<String, PrimitiveType> map = new HashMap<String, PrimitiveType>();
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            short tk = PRIMITIVE_tokens[i];
            if (96 > tk || tk >= 146) continue;
            String kw = KW_words[tk - 96];
            map.put(kw, PRIMITIVE_objects[i]);
        }
        map.put("null", PRIMITIVE_objects[8]);
        return map;
    }

    public static PrimitiveType lookupPrimitive(String name) {
        return PRIMITIVE_hashtable.get(name);
    }

    public static PrimitiveType getNullType() {
        return PRIMITIVE_objects[8];
    }

    public static PrimitiveType getVoidType() {
        return PRIMITIVE_objects[9];
    }

    public static PrimitiveType getPrimitiveType(int primitiveType) {
        if (primitiveType >= 0 && primitiveType < 10) {
            return PRIMITIVE_objects[primitiveType];
        }
        return null;
    }

    private static HashMap<String, PrimitiveType> initPrimitiveUnboxing() {
        HashMap<String, PrimitiveType> map = new HashMap<String, PrimitiveType>();
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            String autobox = PRIMITIVE_autoboxes[i];
            if (autobox == null) continue;
            map.put(autobox, PRIMITIVE_objects[i]);
        }
        return map;
    }

    @Deprecated
    public static PrimitiveType applyUnboxingConversion(JavaType input) {
        if (input == null) {
            return null;
        }
        JdkVersion jdkVersion = null;
        if (input.isSourceElement()) {
            jdkVersion = ((SourceElement)((Object)input)).getJdkVersion();
        }
        if (jdkVersion == null) {
            jdkVersion = JavaParser.getJdkVersion();
        }
        return PrimitiveType.applyUnboxingConversion(input, jdkVersion);
    }

    public static PrimitiveType applyUnboxingConversion(JavaType input, JdkVersion jdkVersion) {
        if (input == null) {
            return null;
        }
        if (input.isPrimitive()) {
            return PrimitiveType.lookupPrimitive(input.getName());
        }
        String name = input.getVMName();
        if (!name.startsWith("java/lang/")) {
            return null;
        }
        if (jdkVersion == null) {
            jdkVersion = JavaParser.getJdkVersion();
        }
        if (!jdkVersion.isJdk5OrAbove()) {
            return null;
        }
        return PRIMITIVE_unboxing.get(name);
    }

    public static JavaType applyBoxingConversion(PrimitiveType input, JavaProvider provider, JdkVersion jdkVersion) {
        return Conversions.applyBoxingConversion((JavaType)input, provider, jdkVersion);
    }

    public static boolean isNumeric(PrimitiveType subject) {
        int flags = PRIMITIVE_flags[subject.primCode];
        return (flags & 0x20) != 0;
    }

    public static boolean applyWideningConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 8 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    public static boolean applyNarrowingConversion(PrimitiveType subject, PrimitiveType target) {
        if (subject == null || target == null) {
            return false;
        }
        if (subject.primCode == target.primCode) {
            return true;
        }
        if (!PrimitiveType.isNumeric(subject) || !PrimitiveType.isNumeric(target)) {
            return false;
        }
        int subjectFlags = PRIMITIVE_flags[subject.primCode];
        int assignableBit = 1 << 16 + target.primCode;
        return (subjectFlags & assignableBit) != 0;
    }

    @Override
    public int getElementKind() {
        return 3;
    }

    public boolean isNumeric() {
        return 1 <= this.primCode && this.primCode <= 7;
    }

    public boolean isIntegral() {
        return 1 <= this.primCode && this.primCode <= 5;
    }

    public boolean isFloatingPoint() {
        return this.primCode == 6 || this.primCode == 7;
    }

    @Override
    public JavaFile getFile() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getVMName() {
        return this.getName();
    }

    @Override
    public String getName() {
        short tk = PRIMITIVE_tokens[this.primCode];
        if (tk != 15) {
            return KW_words[tk - 96];
        }
        return "null";
    }

    @Override
    public String getDescriptor() {
        return PRIMITIVE_descriptors[this.primCode];
    }

    @Override
    public String getTypeSignature() {
        return this.getDescriptor();
    }

    @Override
    public String getSignature() {
        return this.getDescriptor();
    }

    @Override
    public int getModifiers() {
        return 17;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public boolean isVoid() {
        return this.primCode == 9;
    }

    public boolean isNull() {
        return this.primCode == 8;
    }

    protected PrimitiveType(byte code) {
        this.primCode = code;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof JavaType) {
            return this.getName().equals(((JavaType)object).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.primCode;
    }

    @Override
    public JavaProvider getProvider() {
        return null;
    }

    @Override
    public JavaType getQualifyingType() {
        return null;
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
    }

    @Override
    public JavaType getNonParameterizedType() {
        return this;
    }
}

