/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.BindingRegistry;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.FileObj;
import oracle.javatools.parser.java.v2.internal.compiler.FlowAnalysisErrors;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.PackageSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymIndex;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.model.FlowAnalysisListener;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaModule;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceModule;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourceFileListener;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.Log;

public final class FileSym
extends ObjectSym
implements SourceFile {
    @CodeSharingSafe(value="StaticField")
    private static final Log logger = new Log("jot");
    private URL url;
    private JavaProvider provider;
    private SourcePreferences preferences;
    private SourceFileListener[] listeners = SourceFileListener.EMPTY_ARRAY;
    private TextBuffer tmpBuffer;
    private TextBuffer pinnedBuffer;
    public int bufferChangeId = -1;
    private BufferTracker bufferTracker;
    private CompilerDriver pinnedCompiler;
    private WeakReference<CompilerDriver> compilerReference;
    private volatile Object compilerLock;
    private FileObj fileObj;
    private SymTransaction transaction;
    private NodeBindingMap compiledInfoMap = new NodeBindingMap();
    private NodeBindingMap compiledCacheMap = new NodeBindingMap();
    private boolean fullCompilation;
    private boolean fullyCompiled;
    protected final SymFactory factory = new SymFactory(this);
    public TreeSym parseErrors;
    public final TreeSym compileErrors;
    private TokenArray tokenArray;
    private SoftReference<SymIndex> indexReference;
    private List<String> possibleTypes = Collections.emptyList();
    private List<FlowAnalysisListener> flowAnalysisListeners;
    private int bindingIdentifierCounter;
    private JdkVersion jdkVersion;
    private int checkCancelCounter;
    private boolean isPackageInfoFile;
    private volatile boolean isExpired;
    private long expirationTime;
    private String expirationThread;
    private Throwable expirationCause;
    public boolean isLightSourceFile;
    private boolean expireAfterTransactionClose;
    private Map<String, JavaType> importedTypes;
    private Map<String, JavaHasType> importedNames;
    private PrintStream clearCompiledInfoLog;
    @CodeSharingSafe(value="StaticField")
    private static final int PARSE_ERROR_BINDING_TYPE = BindingRegistry.register("FileSym.Parse.Error.Binding.Type");
    @CodeSharingSafe(value="StaticField")
    private static final int COMPILE_ERROR_BINDING_TYPE = BindingRegistry.register("FileSym.Compile.Error.Binding.Type");

    public FileSym() {
        this.symFile = this;
        this.parseErrors = (TreeSym)SymFactory.createNode(this, 93);
        this.parseErrors.symParent = this;
        this.compileErrors = (TreeSym)SymFactory.createNode(this, 93);
        this.compileErrors.symParent = this;
    }

    @Override
    public void installImportCache() {
        this.importedTypes = new HashMap<String, JavaType>();
        this.importedNames = new HashMap<String, JavaHasType>();
    }

    @Override
    public void releaseImportCache() {
        this.importedTypes = null;
        this.importedNames = null;
    }

    public Map<String, JavaType> getImportedTypesCache() {
        return this.importedTypes;
    }

    public Map<String, JavaHasType> getImportedNamesCache() {
        return this.importedNames;
    }

    public Log getLogger() {
        return logger;
    }

    @Override
    public JdkVersion getJdkVersion() {
        return this.jdkVersion;
    }

    public void setJdkVersion(JdkVersion jdkVersion) {
        this.jdkVersion = jdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenArray getTokenArray() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            return this.tokenArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenArray(TokenArray tokenArray) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.tokenArray = tokenArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SourceToken> getTokens(int startIndex, int endIndex, Short desiredTokenValue) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.checkIndex(startIndex, this.tokenArray);
            this.checkIndex(endIndex, this.tokenArray);
            ArrayList<SourceToken> tokens = new ArrayList<SourceToken>();
            int start = startIndex >= 0 ? startIndex : 0;
            int end = endIndex < this.tokenArray.tokenCount ? endIndex : this.tokenArray.tokenCount - 1;
            for (int index = start; index <= end; ++index) {
                short value = this.tokenArray.tokenValues[index];
                if (desiredTokenValue != null && value != desiredTokenValue) continue;
                tokens.add(new SourceToken(this.tokenArray.tokenStarts[index], this.tokenArray.tokenEnds[index], value));
            }
            return tokens;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceToken getFirstToken(int startIndex, int endIndex, short desiredTokenValue) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.checkIndex(startIndex, this.tokenArray);
            this.checkIndex(endIndex, this.tokenArray);
            int start = startIndex >= 0 ? startIndex : 0;
            int end = endIndex < this.tokenArray.tokenCount ? endIndex : this.tokenArray.tokenCount - 1;
            for (int index = start; index <= end; ++index) {
                short tokenValue = this.tokenArray.tokenValues[index];
                if (desiredTokenValue != tokenValue) continue;
                return new SourceToken(this.tokenArray.tokenStarts[index], this.tokenArray.tokenEnds[index], tokenValue);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SourceToken getLastToken(int startIndex, int endIndex, short desiredTokenValue) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int end;
            this.checkIndex(startIndex, this.tokenArray);
            this.checkIndex(endIndex, this.tokenArray);
            int start = startIndex >= 0 ? startIndex : 0;
            for (int index = end = endIndex < this.tokenArray.tokenCount ? endIndex : this.tokenArray.tokenCount - 1; index >= start; --index) {
                short tokenValue = this.tokenArray.tokenValues[index];
                if (desiredTokenValue != tokenValue) continue;
                return new SourceToken(this.tokenArray.tokenStarts[index], this.tokenArray.tokenEnds[index], tokenValue);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBindingIdentifier(Sym sym) {
        int bindingIdentifier = sym.bindingIdentifier;
        if (bindingIdentifier == 0) {
            NodeBindingMap nodeBindingMap = this.compiledInfoMap;
            synchronized (nodeBindingMap) {
                sym.bindingIdentifier = bindingIdentifier = ++this.bindingIdentifierCounter;
            }
        }
        return bindingIdentifier;
    }

    NodeBinding getCompilerBinding(Sym sym, int key) {
        return this.getBinding(sym, key, this.compiledInfoMap);
    }

    NodeBinding getCacheBinding(Sym sym, int key) {
        return this.getBinding(sym, key, this.compiledCacheMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeBinding getBinding(Sym sym, int key, NodeBindingMap map) {
        NodeBindingMap nodeBindingMap = map;
        synchronized (nodeBindingMap) {
            NodeBinding[] bindings = map.get(this.getBindingIdentifier(sym));
            if (bindings != null) {
                for (NodeBinding binding : bindings) {
                    if (binding.getBindingType() != key) continue;
                    return binding;
                }
            }
        }
        return null;
    }

    void clearCompilerBinding(Sym sym, int key) {
        this.clearBinding(this.getBindingIdentifier(sym), key, this.compiledInfoMap);
    }

    void clearCacheBinding(Sym sym, int key) {
        this.clearBinding(this.getBindingIdentifier(sym), key, this.compiledCacheMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBinding(int bindingIdentifier, int key, NodeBindingMap map) {
        NodeBindingMap nodeBindingMap = map;
        synchronized (nodeBindingMap) {
            NodeBinding[] bindings = map.get(bindingIdentifier);
            if (bindings != null) {
                int oldLength = bindings.length;
                for (int x = 0; x < oldLength; ++x) {
                    if (bindings[x].getBindingType() != key) continue;
                    if (oldLength == 1) {
                        map.remove(bindingIdentifier);
                        break;
                    }
                    NodeBinding[] newBindings = new NodeBinding[oldLength - 1];
                    int z = 0;
                    for (int y = 0; y < oldLength; ++y) {
                        if (y == x) continue;
                        newBindings[z++] = bindings[y];
                    }
                    map.put(bindingIdentifier, newBindings);
                    break;
                }
            }
        }
    }

    void setCompilerBinding(Sym sym, NodeBinding newNodeBinding) {
        this.setBinding(sym, newNodeBinding, this.compiledInfoMap);
    }

    void setCacheBinding(Sym sym, NodeBinding newNodeBinding) {
        this.setBinding(sym, newNodeBinding, this.compiledCacheMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBinding(Sym sym, NodeBinding newNodeBinding, NodeBindingMap map) {
        NodeBindingMap nodeBindingMap = map;
        synchronized (nodeBindingMap) {
            int bindingIdentifier = this.getBindingIdentifier(sym);
            NodeBinding[] bindings = map.get(bindingIdentifier);
            if (bindings == null) {
                bindings = new NodeBinding[]{newNodeBinding};
                map.put(bindingIdentifier, bindings);
            } else {
                boolean existingBinding = false;
                int oldLength = bindings.length;
                for (int x = 0; x < oldLength; ++x) {
                    if (bindings[x].getBindingType() != newNodeBinding.getBindingType()) continue;
                    existingBinding = true;
                    bindings[x] = newNodeBinding;
                    break;
                }
                if (!existingBinding) {
                    NodeBinding[] newBindings = new NodeBinding[oldLength + 1];
                    for (int x = 0; x < oldLength; ++x) {
                        newBindings[x] = bindings[x];
                    }
                    newBindings[oldLength] = newNodeBinding;
                    map.put(bindingIdentifier, newBindings);
                }
            }
        }
    }

    @Override
    public void clearAllBindings(int key) {
        this.clearAllBindings(key, this.compiledInfoMap);
        this.clearAllBindings(key, this.compiledCacheMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllBindings(int key, NodeBindingMap map) {
        NodeBindingMap nodeBindingMap = map;
        synchronized (nodeBindingMap) {
            ArrayList<Integer> bindingIdentifiers = new ArrayList<Integer>(map.keySet());
            for (Integer bindingIdentifier : bindingIdentifiers) {
                this.clearBinding(bindingIdentifier, key, map);
            }
        }
    }

    @Override
    public int getElementKind() {
        return 6;
    }

    public final boolean flag_noAutoSavepoint() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public SourceFile getSourceElement() {
        return this.getOwningSourceFile();
    }

    @Override
    public JavaModule getModule() {
        return this.getSourceModule();
    }

    @Override
    public int getLanguageVersion() {
        return this.getJdkVersion().getJ2se();
    }

    @Override
    public SourcePackage getSourcePackage() {
        return this.getRoot().getSourcePackage();
    }

    @Override
    public String getPackageName() {
        SourcePackage packageSym = this.getSourcePackage();
        if (packageSym == null) {
            return "";
        }
        return packageSym.getName();
    }

    @Override
    public void setSourcePackage(SourcePackage packageD) {
        this.getRoot().setSourcePackage(packageD);
    }

    @Override
    public void setPackageName(String name) {
        if (name.length() > 0) {
            this.getRoot().setPackageName(name);
        } else {
            RootSym root = this.getRoot();
            PackageSym packageSym = root.getPackageSym();
            if (packageSym != null) {
                packageSym.removeSelf();
            }
        }
    }

    @Override
    public List<SourceImport> getSourceImports() {
        return this.getRoot().getSourceImports();
    }

    @Override
    public Set<String> getSourceImportNames() {
        return this.getRoot().getSourceImportNames();
    }

    @Override
    public List<SourceClass> getSourceClasses() {
        return this.getRoot().getSourceClasses();
    }

    @Override
    public SourceClass getSourceClass(String name) {
        return this.getRoot().getSourceClass(name);
    }

    public SourceName getSqlContext() {
        return this.getRoot().getSqlContext();
    }

    public final RootSym getRoot() {
        return (RootSym)this.getChild((byte)92);
    }

    @Override
    public SourceClass getSourcePrimaryClass() {
        return this.getPrimaryClassSym();
    }

    public ClassSym getPrimaryClassSym() {
        RootSym rootSym = this.getRoot();
        if (this.url != null) {
            String path = this.url.getPath();
            int lastSlash = path.lastIndexOf(47);
            int lastDot = path.lastIndexOf(46);
            if (lastDot != -1) {
                String target = path.substring(lastSlash + 1, lastDot);
                for (ClassSym classSym : rootSym.getSourceClasses()) {
                    if (!target.equals(classSym.getName())) continue;
                    return classSym;
                }
            }
        } else {
            return (ClassSym)rootSym.getChild((byte)3);
        }
        return null;
    }

    @Override
    public SourceModule getSourceModule() {
        RootSym rootSym = this.getRoot();
        return rootSym != null ? (SourceModule)((Object)rootSym.getChild((byte)32)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaPackage getPackage() {
        JavaProvider provider;
        String packageName = this.getPackageName();
        FileSym fileSym = this;
        synchronized (fileSym) {
            provider = this.provider;
            if (provider == null) {
                return null;
            }
        }
        return provider.getPackage(packageName);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return this.getRoot().getClasses();
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public JavaClass getPrimaryClass() {
        return this.getPrimaryClassSym();
    }

    @Override
    public List<String> getPossibleTypes() {
        return this.possibleTypes;
    }

    public void setPossibleTypes(List<String> possibleTypes) {
        this.possibleTypes = possibleTypes;
    }

    @Override
    public boolean hasParseErrors() {
        return this.parseErrors.getChildCount(8) > 0;
    }

    @Override
    public List<SourceError> getParseErrors() {
        ParseErrorBinding binding = (ParseErrorBinding)this.getBinding(PARSE_ERROR_BINDING_TYPE);
        if (binding != null) {
            return binding.errors;
        }
        return this.parseErrors.getChildrenList(8);
    }

    @Override
    public boolean hasCompileErrors() {
        return this.compileErrors.getChildCount(8) > 0;
    }

    @Override
    public List<SourceError> getCompileErrors() {
        CompileErrorBinding binding = (CompileErrorBinding)this.getBinding(COMPILE_ERROR_BINDING_TYPE);
        if (binding != null) {
            return binding.errors;
        }
        return this.compileErrors.getChildrenList(8);
    }

    @Override
    public void setParseErrors(List<SourceError> errors) {
        ParseErrorBinding errorBinding = new ParseErrorBinding();
        errorBinding.errors = errors;
        this.setBinding(errorBinding);
    }

    @Override
    public void setCompileErrors(List<SourceError> errors) {
        CompileErrorBinding errorBinding = new CompileErrorBinding();
        errorBinding.errors = errors;
        this.setBinding(errorBinding);
    }

    @Override
    public boolean hasErrors(int severity, int errorCategory) {
        if ((errorCategory & 2) != 0 && this.hasParseErrors()) {
            for (SourceError error : this.getParseErrors()) {
                if (severity > error.getErrorSeverity()) continue;
                return true;
            }
        }
        if ((errorCategory & 4) != 0) {
            if (!this.isCompiled()) {
                this.compile();
            }
            if (this.hasCompileErrors()) {
                for (SourceError error : this.getCompileErrors()) {
                    if (severity > error.getErrorSeverity()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Collection<SourceError> getErrors(int severity, int errorCategory) {
        if (!this.hasParseErrors() && !this.hasCompileErrors()) {
            return Collections.emptyList();
        }
        ArrayList<SourceError> list = new ArrayList<SourceError>();
        if (this.hasParseErrors()) {
            list.addAll(this.getParseErrors());
        }
        if (this.hasCompileErrors()) {
            if (!this.isCompiled()) {
                this.compile();
            }
            list.addAll(this.getCompileErrors());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SourceError error = (SourceError)iterator.next();
            if (error.getErrorSeverity() >= severity) continue;
            iterator.remove();
        }
        return list;
    }

    @Override
    public final SourceElement getElementAt(int offset) {
        return this.getSymAt(offset);
    }

    @Override
    public final SourceElement getElementAt(int offset, int mask) {
        EnumSet<SourceFile.ElementAtMask> newMask = EnumSet.noneOf(SourceFile.ElementAtMask.class);
        if ((mask & 0x70000) != 0) {
            newMask.add(SourceFile.ElementAtMask.ALL);
        }
        if ((mask & 0x40000) != 0) {
            newMask.add(SourceFile.ElementAtMask.BLANKLINES);
        }
        if ((mask & 0x20000) != 0) {
            newMask.add(SourceFile.ElementAtMask.COMMENTS);
        }
        if ((mask & 0x10000) != 0) {
            newMask.add(SourceFile.ElementAtMask.DEFAULT);
        }
        if ((mask & 0x10000) != 0) {
            newMask.add(SourceFile.ElementAtMask.DEFAULT);
        }
        if ((mask & 0) != 0) {
            newMask.add(SourceFile.ElementAtMask.NONE);
        }
        newMask.add(SourceFile.ElementAtMask.STRUCTURAL);
        newMask.add(SourceFile.ElementAtMask.AFTER);
        return this.getSymAt(offset, newMask);
    }

    @Override
    public SourceElement getElementAt(int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        return this.getSymAt(offset, mask);
    }

    @Override
    public final SourceElement getElementContaining(int startOffset, int endOffset) {
        return this.getSymContaining(startOffset, endOffset, null);
    }

    @Override
    public final SourceElement getElementContaining(int startOffset, int endOffset, EnumSet<SourceFile.ElementAtMask> mask) {
        EnumSet<SourceFile.ElementAtMask> maskToUse = null;
        if (mask != null) {
            maskToUse = EnumSet.copyOf(mask);
            maskToUse.remove((Object)SourceFile.ElementAtMask.AFTER);
            maskToUse.remove((Object)SourceFile.ElementAtMask.BEFORE);
            maskToUse.remove((Object)SourceFile.ElementAtMask.NEAREST);
            maskToUse.remove((Object)SourceFile.ElementAtMask.SAME_LINE);
            maskToUse.remove((Object)SourceFile.ElementAtMask.STRUCTURAL);
        }
        return this.getSymContaining(startOffset, endOffset, maskToUse);
    }

    public Sym getSymAt(int offset) {
        return this.getSymAt(offset, null);
    }

    public Sym getSymAt(final int offset, final EnumSet<SourceFile.ElementAtMask> mask) {
        Callable<Sym> callable = new Callable<Sym>(){

            @Override
            public Sym call() {
                return FileSym.this.getSymAtImpl(offset, mask);
            }
        };
        try {
            return this.checkTransactionAndCall(callable);
        }
        catch (ExpiredTextBufferException etbe) {
            throw etbe;
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            return null;
        }
    }

    private Sym getSymAtImpl(int offset, EnumSet<SourceFile.ElementAtMask> mask) {
        try {
            SymIndex symIndex = this.getIndex();
            return symIndex.getSymAt(offset, mask);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Sym getSymContaining(int startOffset, int endOffset, EnumSet<SourceFile.ElementAtMask> mask) {
        Sym sym;
        Sym search;
        for (search = sym = this.getSymAt(startOffset, mask); search != null; search = search.getParentSym()) {
            boolean containsEnd;
            boolean bl = containsEnd = search.getStartOffset() <= endOffset && endOffset <= search.getEndOffset();
            if (containsEnd) break;
        }
        return search;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SourceToken getTokenAt(int offset) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int tokenIndex = this.tokenArray.findTokenIndexAtOffset(offset);
            if (tokenIndex < 0) {
                tokenIndex = this.tokenArray.findTokenIndexAtOffset(offset - 1);
            }
            if (tokenIndex >= 0 && tokenIndex < this.tokenArray.tokenCount) {
                return new SourceToken(this.tokenArray.tokenStarts[tokenIndex], this.tokenArray.tokenEnds[tokenIndex], this.tokenArray.tokenValues[tokenIndex]);
            }
            return null;
        }
    }

    @Override
    protected void checkCloneable() {
        FileSym.unsupported("Use cloneSelf(TextBuffer)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceFile cloneSelf(TextBuffer cloneTextBuffer) {
        FileSym sym;
        TextBuffer thisTextBuffer = this.getTextBuffer();
        if (thisTextBuffer == null) {
            FileSym.unsupported("No underlying text buffer");
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            SymTransaction transaction = this.getTransactionSym();
            if (transaction != null && transaction.hasOutstandingChanges()) {
                FileSym.unsupported("Open transaction with outstanding changes");
            }
            if (cloneTextBuffer == null) {
                cloneTextBuffer = TextBufferFactory.createArrayTextBuffer();
            }
            char[] thisChars = thisTextBuffer.getChars(0, thisTextBuffer.getLength());
            cloneTextBuffer.insert(0, thisChars);
            sym = SymFactory.createFile();
            sym.setJdkVersion(this.getJdkVersion());
            sym.pinTextBuffer(cloneTextBuffer);
            sym.buildSelf();
            sym.setJdkVersion(this.getJdkVersion());
            Sym out = this.cloneSelf(sym);
            if (out != sym) {
                FileSym.panic("FileSym mismatch");
            }
            sym.adjustSelf(this);
            sym.clearFormatInfo();
        }
        return sym;
    }

    @Override
    public Sym cloneSelfImpl(FileSym alreadyCreated) {
        return alreadyCreated;
    }

    @Override
    public Sym cloneSelf(FileSym alreadyCreated) {
        FileSym sym = (FileSym)super.cloneSelf(alreadyCreated);
        if (sym != alreadyCreated) {
            FileSym.panic("FileSym mismatch");
        }
        sym.url = this.url;
        sym.provider = this.provider;
        sym.preferences = this.preferences;
        sym.possibleTypes = this.possibleTypes;
        return sym;
    }

    @Override
    public SourceFactory getFactory() {
        return this.factory;
    }

    public SymFactory getSymFactory() {
        return this.factory;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
        this.isPackageInfoFile = url != null && url.getPath().replace('\\', '/').endsWith("/package-info.java");
    }

    @Override
    public JavaProvider getProvider() {
        return this.provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvider(JavaProvider provider) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.provider = provider;
            this.pinnedCompiler = null;
            if (this.compilerReference != null) {
                this.compilerReference.clear();
            }
            this.compilerReference = null;
        }
    }

    @Override
    public SourcePreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = new SourcePreferences();
        }
        return this.preferences;
    }

    @Override
    public void setPreferences(SourcePreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    protected void add(Sym child, byte filter) {
        this.getRoot().add(child, filter);
    }

    @Override
    public int getChildCount(int mask) {
        return this.getRoot().getChildCount(mask);
    }

    @Override
    public List<SourceElement> getChildren() {
        return this.getRoot().getChildren();
    }

    @Override
    public List<SourceElement> getChildren(int mask) {
        return this.getRoot().getChildrenList(mask);
    }

    @Override
    public <T extends SourceElement> List<T> getChildrenList(int mask) {
        return this.getRoot().getChildrenList(mask, null);
    }

    @Override
    protected <T extends SourceElement> List<T> getChildrenList(int mask, Sym include) {
        return this.getRoot().getChildrenList(mask, include);
    }

    @Override
    public <T extends SourceElement> List<T> getChildrenList(byte filter, Sym include) {
        return this.getRoot().getChildrenList(filter, include);
    }

    @Override
    public final void compile(List<FlowAnalysisListener> listeners) {
        this.flowAnalysisListeners = listeners;
        this.doFullCompile();
    }

    @Override
    public final boolean isFullyCompiled() {
        return this.fullyCompiled;
    }

    @Override
    public final void doFullCompile() {
        this.fullCompilation = true;
        try {
            this.fullyCompiled = false;
            super.compile();
            this.fullyCompiled = true;
        }
        finally {
            this.fullCompilation = false;
        }
    }

    @Override
    public void cancelCompile() {
        CompilerDriver currentCompiler = this.pinnedCompiler;
        if (currentCompiler != null) {
            currentCompiler.cancel();
            this.checkCancelCounter = 0;
        }
    }

    public boolean inCompilation() {
        CompilerDriver currentCompiler = this.pinnedCompiler;
        if (currentCompiler != null) {
            return currentCompiler.getThread() == Thread.currentThread();
        }
        return false;
    }

    boolean hasBeenCanceled(CompilerDriver compiler) {
        if (--this.checkCancelCounter < 0) {
            this.checkCancelCounter = 16;
            if (compiler.isCanceled() || Thread.currentThread().isInterrupted()) {
                this.checkCancelCounter = 0;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCompiled() {
        return this.isProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            return this.isExpired;
        }
    }

    @Override
    public synchronized void expire() {
        if (this.isExpired) {
            return;
        }
        if (this.transaction != null) {
            this.expireAfterTransactionClose = true;
            return;
        }
        this.isExpired = true;
        this.expirationTime = System.currentTimeMillis();
        this.expirationThread = Thread.currentThread().getName();
        this.expirationCause = new Throwable("expiration cause");
        this.cancelCompile();
        int count = this.listeners.length;
        for (int i = count - 1; i >= 0; --i) {
            this.listeners[i].expiredUpdate(this);
        }
        this.listeners = SourceFileListener.EMPTY_ARRAY;
    }

    @Override
    public boolean isPackageInfoFile() {
        return this.isPackageInfoFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSelf() {
        super.buildSelf();
        this.parseErrors.buildSelf();
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer = this.getTextBuffer();
            if (textBuffer != null) {
                int newBufferChangeId = textBuffer.getChangeId();
                if (this.getTokenArray() == null || newBufferChangeId != this.bufferChangeId) {
                    this.clearIndex();
                    JavaLexer lexer = new JavaLexer(this.getJdkVersion());
                    lexer.setTextBuffer(textBuffer);
                    this.setTokenArray(new TokenArray(lexer));
                }
                this.bufferChangeId = newBufferChangeId;
            }
            this.symEnd = this.getTokenArray().tokenCount - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileLock() {
        Object foundLock = null;
        FileSym fileSym = this;
        synchronized (fileSym) {
            foundLock = this.compilerLock;
            if (foundLock == null) {
                this.compilerLock = new String("Compile in progress");
            }
        }
        return foundLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileWait(Object foundLock) {
        Object object = foundLock;
        synchronized (object) {
            int attempts = 2;
            boolean firstAttempt = true;
            while (this.compilerLock != null && this.compilerLock == foundLock) {
                if (firstAttempt && this.pinnedCompiler != null) {
                    FileSym.unsupported("Re-entered compile()");
                }
                firstAttempt = false;
                try {
                    foundLock.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (--attempts != 0) continue;
                FileSym.panic("Starved while waiting for the compile to finish");
            }
        }
    }

    public void logClearCompiledInfo(PrintStream clearCompiledInfoLog) {
        this.clearCompiledInfoLog = clearCompiledInfoLog;
    }

    @Override
    public final void clearCompiledInfo() {
        PrintStream localClearCompiledInfoLog = this.clearCompiledInfoLog;
        if (localClearCompiledInfoLog != null) {
            new Exception("Use of SourceFile.clearCompiledInfo()").printStackTrace(localClearCompiledInfoLog);
        }
        this.compileErrors.treeChildren = Sym.EMPTY_ARRAY;
        this.clearCompiledInfoImpl();
        this.clearCompiledCacheImpl();
        this.fullyCompiled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCompiledInfoImpl() {
        NodeBindingMap nodeBindingMap = this.compiledInfoMap;
        synchronized (nodeBindingMap) {
            this.compiledInfoMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCompiledCacheImpl() {
        NodeBindingMap nodeBindingMap = this.compiledCacheMap;
        synchronized (nodeBindingMap) {
            this.compiledCacheMap.clear();
            this.releaseImportCache();
        }
    }

    CompilerDriver createCompiler() {
        if (this.provider == null) {
            return null;
        }
        return new CompilerDriver(this.provider, this.getJdkVersion(), false, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompilerDriver getCompiler() {
        CompilerDriver compiler;
        CompilerDriver currentPinnedCompiler = this.pinnedCompiler;
        if (currentPinnedCompiler != null && Thread.currentThread() == currentPinnedCompiler.getThread()) {
            return currentPinnedCompiler;
        }
        if (this.compilerReference != null && (compiler = (CompilerDriver)this.compilerReference.get()) != null && Thread.currentThread() == compiler.getThread()) {
            return compiler;
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.provider == null) {
                return null;
            }
            CompilerDriver compiler2 = this.createCompiler();
            this.compilerReference = new WeakReference<CompilerDriver>(compiler2);
            return compiler2;
        }
    }

    protected CompilerDriver getForgivingCompiler() {
        JavaProvider provider = this.getProvider();
        if (provider == null) {
            return null;
        }
        return new CompilerDriver(provider, this.getJdkVersion(), true, this);
    }

    @Override
    public JavaFile getCompiledObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JavaFile compileImpl(CompilerDriver compiler) {
        Object foundLock = this.compileLock();
        if (foundLock != null) {
            this.compileWait(foundLock);
            return this.getCompiledObject();
        }
        Object object = this.compilerLock;
        synchronized (object) {
            long time = System.currentTimeMillis();
            boolean saveSkipCompilations = compiler.skipCompilations();
            try {
                SyntaxData errorData;
                boolean doFlowAnalysis;
                this.pinnedCompiler = compiler;
                compiler.clearCancel();
                if (this.fullCompilation && this.isFullyCompiled() || !this.fullCompilation && this.isCompiled()) {
                    logger.trace("Skipping JOT compile, SourceFile has already been compiled");
                    JavaFile javaFile = this.getCompiledObject();
                    return javaFile;
                }
                this.pinnedCompiler.setSkipCompilations(!this.fullCompilation);
                boolean bl = doFlowAnalysis = !compiler.skipCompilations();
                if (doFlowAnalysis) {
                    List<SourceError> errors = this.getParseErrors();
                    for (SourceError errorSym : errors) {
                        int errorSeverity;
                        int kind = errorSym.getSymbolKind();
                        if (kind > 82 && kind < 89 || (errorSeverity = errorSym.getErrorSeverity()) != 4 && errorSeverity != 5) continue;
                        doFlowAnalysis = false;
                        break;
                    }
                }
                if (doFlowAnalysis) {
                    ArrayList<FlowAnalysisListener> listeners = new ArrayList<FlowAnalysisListener>();
                    if (this.flowAnalysisListeners != null) {
                        listeners.addAll(this.flowAnalysisListeners);
                    }
                    listeners.add(new FlowAnalysisErrors(this.pinnedCompiler));
                    this.pinnedCompiler.startFlowAnalysis(listeners);
                } else {
                    this.pinnedCompiler.startFlowAnalysis(Collections.emptyList());
                }
                this.clearCompiledInfo();
                this.installImportCache();
                this.symData = null;
                FileObj fileObj = this.getFileObj();
                fileObj.errorData = errorData = new SyntaxData();
                try {
                    super.compileImpl(compiler);
                    this.compileErrors.symData = errorData;
                    this.compileErrors.buildSelf();
                    FileSym.removeDuplicateErrors(this.compileErrors);
                    this.setProcessed();
                }
                catch (CancellationException e) {
                    this.clearCompiledInfoImpl();
                    this.symData = null;
                    fileObj.errorData = new SyntaxData();
                    throw e;
                }
                JavaFile javaFile = this.getCompiledObject();
                return javaFile;
            }
            finally {
                Object lock = this.compilerLock;
                this.compilerLock = null;
                lock.notifyAll();
                this.pinnedCompiler.endFlowAnalysis();
                this.pinnedCompiler.setSkipCompilations(saveSkipCompilations);
                this.pinnedCompiler.clearCancel();
                this.releaseImportCache();
                this.pinnedCompiler = null;
                this.clearCompiledCacheImpl();
                logger.trace("JOT compile time: " + (System.currentTimeMillis() - time) + "msec");
            }
        }
    }

    private static void removeDuplicateErrors(TreeSym errors) {
        Sym[] array = errors.treeChildren;
        int count = array.length;
        if (count < 2) {
            return;
        }
        errors.sortSelf();
        ArrayList<Sym> list = new ArrayList<Sym>();
        list.add(array[0]);
        for (int i = 1; i < count; ++i) {
            Sym sym = array[i];
            Sym previousSym = array[i - 1];
            if (sym.equals(previousSym)) continue;
            list.add(sym);
        }
        int size = list.size();
        errors.treeChildren = list.toArray(new Sym[size]);
    }

    public FileObj getFileObj() {
        if (this.fileObj == null) {
            FileObj obj = new FileObj();
            obj.objSym = this;
            this.fileObj = obj;
        }
        return this.fileObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FormatRegion reformatRegion(int startOffset, int endOffset) {
        SymTransaction transaction;
        SymTransaction symTransaction = transaction = this.verifyTransaction();
        synchronized (symTransaction) {
            if (transaction.hasOutstandingChanges()) {
                FileSym.unsupported("Cannot format region with outstanding changes");
            }
            transaction.regionBeingFormatted = new int[]{startOffset, endOffset};
            try {
                FileSym fileSym = this;
                synchronized (fileSym) {
                    FormatRegion region = FormatRegion.create_fromOffsets(startOffset, endOffset, this.getTokenArray());
                    SymOperation op = transaction.newOperation((byte)7);
                    op.opTarget = this;
                    op.setFormatRegion(region);
                    op.buildSelf();
                    transaction.savepoint();
                    FormatRegion formatRegion = region;
                    return formatRegion;
                }
            }
            finally {
                transaction.regionBeingFormatted = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reformatSubtree(Sym sym, int formatMask) {
        SymTransaction transaction;
        SymTransaction symTransaction = transaction = this.verifyTransaction();
        synchronized (symTransaction) {
            transaction.savepoint();
            transaction.symBeingFormatted = sym;
            try {
                FileSym fileSym = this;
                synchronized (fileSym) {
                    int opKind = 6;
                    SymOperation op = transaction.newOperation((byte)6);
                    op.opTarget = sym;
                    op.buildSelf();
                    transaction.savepoint();
                }
            }
            finally {
                transaction.symBeingFormatted = null;
            }
        }
    }

    protected void adjustOffsets() {
        SyntaxData parseErrorData;
        TextBuffer textBuffer = this.getTextBuffer();
        FileSym otherSym = (FileSym)JavaParser.parse((ReadTextBuffer)textBuffer, this.getJdkVersion());
        if (otherSym == null) {
            FileSym.panic();
        }
        RootSym thisRoot = this.getRoot();
        RootSym otherRoot = otherSym.getRoot();
        thisRoot.clearOffsets();
        thisRoot.adjustSelf(otherRoot);
        this.setTokenArray(otherSym.getTokenArray());
        this.bufferChangeId = otherSym.bufferChangeId;
        this.possibleTypes = otherSym.possibleTypes;
        this.clearIndex();
        this.parseErrors.treeChildren = Sym.EMPTY_ARRAY;
        this.parseErrors.symData = parseErrorData = new SyntaxData();
        for (Sym otherError : otherSym.parseErrors.treeChildren) {
            try {
                Sym clonedError = otherError.cloneSelf(this);
                if (clonedError == null) continue;
                parseErrorData.addKid(clonedError);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.buildSelf();
    }

    public void mapSelf(FileSym otherFile) {
        this.mapSelfImpl(otherFile);
        RootSym thisRoot = this.getRoot();
        RootSym otherRoot = otherFile.getRoot();
        thisRoot.mapSelf(otherRoot);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        RootSym rootSym = this.getRoot();
        if (rootSym != null) {
            rootSym.print(out);
        }
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 92: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    public LineMap getLineMap() {
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer != null) {
            return textBuffer.getLineMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextBuffer getTextBuffer() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer transTextBuffer;
            if (this.isExpired) {
                throw new ExpiredTextBufferException(this.getClass(), this.url, false, this.expirationTime, this.expirationThread, this.expirationCause);
            }
            if (this.tmpBuffer != null) {
                return this.tmpBuffer;
            }
            SymTransaction transaction = this.getTransactionSym();
            if (transaction != null && transaction.getTransactionThread() == Thread.currentThread() && (transTextBuffer = transaction.getTextBuffer()) != null) {
                return transTextBuffer;
            }
            if (this.pinnedBuffer != null) {
                return this.pinnedBuffer;
            }
        }
        if (this.provider == null || this.url == null) {
            return null;
        }
        TextBuffer backupBuffer = this.provider.getTextBuffer(this.url);
        return backupBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTextBuffer(TextBuffer textBuffer) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            if (this.pinnedBuffer == null) {
                this.pinnedBuffer = textBuffer;
                this.bufferChangeId = textBuffer.getChangeId();
                this.bufferTracker = new BufferTracker(this, textBuffer);
            } else if (this.pinnedBuffer != textBuffer) {
                FileSym.unsupported("Different pinned buffer");
            }
        }
    }

    @Override
    public void pinTextBuffer(TextBuffer textBuffer) {
        this.setTextBuffer(textBuffer);
    }

    @Override
    public void unpinTextBuffer() {
        this.pinnedBuffer = null;
        if (this.bufferTracker != null) {
            this.bufferTracker.clear();
            this.bufferTracker = null;
        }
    }

    private int findSourceFileListener(SourceFileListener listener) {
        int count = this.listeners.length;
        for (int i = 0; i < count; ++i) {
            if (this.listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSourceFileListener(SourceFileListener listener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int index = this.findSourceFileListener(listener);
            if (index != -1) {
                return;
            }
            int count = this.listeners.length;
            SourceFileListener[] newArray = new SourceFileListener[count + 1];
            if (count > 0) {
                System.arraycopy(this.listeners, 0, newArray, 0, count);
            }
            newArray[count] = listener;
            this.listeners = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSourceFileListener(SourceFileListener listener) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int index = this.findSourceFileListener(listener);
            if (index == -1) {
                return;
            }
            int count = this.listeners.length;
            if (count == 1) {
                this.listeners = SourceFileListener.EMPTY_ARRAY;
            } else {
                SourceFileListener[] newArray = new SourceFileListener[count - 1];
                if (index != 0) {
                    System.arraycopy(this.listeners, 0, newArray, 0, index);
                }
                if (index != count - 1) {
                    System.arraycopy(this.listeners, index + 1, newArray, index, count - 1 - index);
                }
                this.listeners = newArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(SymTransaction transaction) {
        FileSym fileSym = this;
        synchronized (fileSym) {
            int count = this.listeners.length;
            for (int i = count - 1; i >= 0; --i) {
                this.listeners[i].changeUpdate(this, transaction);
            }
        }
    }

    @Override
    public UndoableEdit editInTransaction(Function<SourceTransaction, Boolean> editingCode) {
        return SymTransaction.editInAutoTransaction(this, editingCode);
    }

    @Override
    public <E extends Exception> UndoableEdit editInTransactionEx(SourceFile.FunctionEx<SourceTransaction, Boolean, E> editingCode) throws E {
        return SymTransaction.editInAutoTransactionEx(this, editingCode);
    }

    @Override
    public UndoableEdit runInTransaction(Function<SourceTransaction, Boolean> editingCode) {
        return this.editInTransaction(editingCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceTransaction beginTransaction() {
        SymTransaction t;
        if (this.isLightSourceFile) {
            throw new IllegalStateException("Need a SourceFile for a transaction");
        }
        if (this.isExpired) {
            throw new ExpiredTextBufferException(this.getClass(), this.url, false, this.expirationTime, this.expirationThread, this.expirationCause);
        }
        FileSym fileSym = this;
        synchronized (fileSym) {
            TextBuffer textBuffer;
            if (this.transaction != null) {
                FileSym.errorOpenTransaction();
            }
            if ((textBuffer = this.getTextBuffer()) == null) {
                FileSym.errorNoTextBuffer();
            }
            t = new SymTransaction(this, textBuffer);
        }
        t.begin();
        fileSym = this;
        synchronized (fileSym) {
            this.transaction = t;
        }
        return t;
    }

    @Override
    public SourceTransaction getTransaction() {
        return this.getTransactionSym();
    }

    public synchronized SymTransaction getTransactionSym() {
        return this.transaction;
    }

    synchronized void releaseTransaction() {
        this.transaction = null;
    }

    protected synchronized void closeTransaction() {
        if (this.expireAfterTransactionClose) {
            this.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymIndex getIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            SymIndex index = null;
            if (this.indexReference != null) {
                index = this.indexReference.get();
            }
            if (index == null) {
                index = this.buildIndex();
            }
            this.indexReference = new SoftReference<SymIndex>(index);
            return index;
        }
    }

    private SymIndex buildIndex() {
        return new SymIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndex() {
        FileSym fileSym = this;
        synchronized (fileSym) {
            this.indexReference = null;
        }
    }

    @Override
    protected int indexSelf(Sym[] index, int pos, TokenArray tokenArray) {
        RootSym rootSym = this.getRoot();
        pos = rootSym.indexSelf(index, pos, tokenArray);
        int tokenCount = tokenArray.tokenCount;
        while (pos < tokenCount) {
            index[pos++] = this;
        }
        return pos;
    }

    @Override
    protected void verboseSelf(StringBuilder stringBuffer) {
        stringBuffer.append(" url ");
        stringBuffer.append(this.getURL());
        stringBuffer.append(" id ");
        stringBuffer.append(System.identityHashCode(this));
    }

    private static class NodeBindingMap {
        Map<Integer, NodeBinding[]> map = new HashMap<Integer, NodeBinding[]>(1024);

        NodeBindingMap() {
        }

        NodeBinding[] get(Integer key) {
            return this.map.get(key);
        }

        NodeBinding[] remove(Integer key) {
            return this.map.remove(key);
        }

        NodeBinding[] put(Integer key, NodeBinding[] binding) {
            return this.map.put(key, binding);
        }

        Set<Integer> keySet() {
            return this.map.keySet();
        }

        void clear() {
            this.map.clear();
            this.map = new HashMap<Integer, NodeBinding[]>(1024);
        }
    }

    private static class CompileErrorBinding
    implements NodeBinding {
        private List<SourceError> errors;

        private CompileErrorBinding() {
        }

        @Override
        public int getBindingType() {
            return COMPILE_ERROR_BINDING_TYPE;
        }
    }

    private static class ParseErrorBinding
    implements NodeBinding {
        private List<SourceError> errors;

        private ParseErrorBinding() {
        }

        @Override
        public int getBindingType() {
            return PARSE_ERROR_BINDING_TYPE;
        }
    }

    private static class BufferTracker
    implements TextBufferListener {
        private WeakReference<SourceFile> _sourceFileRef;
        private WeakReference<TextBuffer> _textBufferRef;

        private BufferTracker(SourceFile sourceFile, TextBuffer textBuffer) {
            this._sourceFileRef = new WeakReference<SourceFile>(sourceFile);
            this._textBufferRef = new WeakReference<TextBuffer>(textBuffer);
            textBuffer.addTextBufferListener(this);
        }

        public void clear() {
            TextBuffer textBuffer = (TextBuffer)this._textBufferRef.get();
            if (textBuffer != null) {
                textBuffer.removeTextBufferListener(this);
            }
            this._textBufferRef = null;
            this._sourceFileRef = null;
        }

        @Override
        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            this.bufferChanged();
        }

        @Override
        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            this.bufferChanged();
        }

        @Override
        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private void bufferChanged() {
            if (this._sourceFileRef != null) {
                boolean detach = false;
                SourceFile sourceFile = (SourceFile)this._sourceFileRef.get();
                if (sourceFile == null) {
                    detach = true;
                } else if (sourceFile.getTransaction() == null) {
                    detach = true;
                    sourceFile.expire();
                }
                if (detach) {
                    this.clear();
                }
            }
        }
    }
}

