/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentListSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeBinding;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeArgumentList;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class TypeSym
extends ObjectSym
implements SourceTypeReference {
    @CodeSharingSafe(value="StaticField")
    private static JavaType noType = new AbstractClass(){

        @Override
        public int getElementKind() {
            return 1;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        @Override
        public String getVMName() {
            return "";
        }

        @Override
        public String getDescriptor() {
            return "";
        }

        @Override
        public String getUniqueIdentifier() {
            return "";
        }

        @Override
        public JavaClass getTypeErasure() {
            return this;
        }

        @Override
        public String getTypeSignature() {
            return "";
        }

        @Override
        public JavaFile getFile() {
            return null;
        }

        @Override
        public JavaProvider getProvider() {
            return null;
        }

        @Override
        public JavaType getQualifyingType() {
            return null;
        }

        @Override
        public void setQualifyingType(JavaType qualifyingType) {
        }

        @Override
        public JavaType getNonParameterizedType() {
            return this;
        }
    };
    public short typeBaseDimension = 0;
    public short typeXtraDimension = 0;
    public short typeToken;

    private JavaType getTypeResolved() {
        TypeBinding binding = (TypeBinding)this.getInternalBinding(12);
        if (binding != null) {
            return binding.getResolvedType();
        }
        return null;
    }

    private void setTypeResolved(JavaType resolvedType) {
        TypeBinding binding = new TypeBinding(resolvedType);
        this.setInternalBinding(binding);
    }

    public void setExtraArrayDimensionsTypeAnnotations(Collection<List<SourceAnnotation>> typeAnnotations) {
        if (typeAnnotations == null || typeAnnotations.isEmpty()) {
            this.clearInternalBinding(24);
        } else {
            this.setInternalBinding(new ObjectBinding<Collection<List<SourceAnnotation>>>(24, typeAnnotations));
        }
    }

    public List<List<SourceAnnotation>> getBaseArrayDimensionsTypeAnnotations() {
        ArrayList listOfLists = null;
        List<SourceElement> children = this.getChildren(1);
        for (int i = 0; i < children.size(); ++i) {
            AnnotateSym annotateSym = (AnnotateSym)children.get(i);
            if (annotateSym.dimensionIndex <= 0) continue;
            if (listOfLists == null) {
                listOfLists = new ArrayList();
                for (int x = 0; x < this.typeBaseDimension; ++x) {
                    listOfLists.add(new ArrayList());
                }
            }
            ((List)listOfLists.get(annotateSym.dimensionIndex - 1)).add(annotateSym);
        }
        return listOfLists == null ? Collections.emptyList() : listOfLists;
    }

    public Collection<List<SourceAnnotation>> getArrayDimensionsTypeAnnotations() {
        List<List<SourceAnnotation>> baseArrayDimensionsTypeAnnotations = this.getBaseArrayDimensionsTypeAnnotations();
        ObjectBinding objectBinding = (ObjectBinding)this.getInternalBinding(24);
        Collection extraArrayDimensionsTypeAnnotations = objectBinding != null ? (Collection)objectBinding.getObject() : null;
        ArrayList<List<SourceAnnotation>> arrayDimensionsTypeAnnotations = new ArrayList<List<SourceAnnotation>>();
        if (extraArrayDimensionsTypeAnnotations != null) {
            arrayDimensionsTypeAnnotations.addAll(extraArrayDimensionsTypeAnnotations);
        }
        if (baseArrayDimensionsTypeAnnotations != null) {
            arrayDimensionsTypeAnnotations.addAll(baseArrayDimensionsTypeAnnotations);
        }
        return arrayDimensionsTypeAnnotations;
    }

    @Override
    public boolean isPrimitive() {
        return 96 <= this.typeToken && this.typeToken < 146;
    }

    @Override
    public boolean isArray() {
        return this.getArrayDimension() > 0;
    }

    @Override
    public SourceTypeReference getQualifyingType() {
        return this.getTypeSym();
    }

    @Override
    public List<SourceTypeArgument> getTypeArguments() {
        TypeArgumentListSym typeArgList = (TypeArgumentListSym)this.getTypeArgumentList();
        return typeArgList.getTypeArguments();
    }

    @Override
    public SourceTypeArgumentList getTypeArgumentList() {
        return (TypeArgumentListSym)this.getChildOrCreateSkeleton((byte)29);
    }

    @Override
    public void setTypeArguments(List<SourceTypeArgument> typeArguments) {
        if (typeArguments == null) {
            this.removeTypeArguments();
            return;
        }
        TypeArgumentListSym sym = (TypeArgumentListSym)this.getTypeArgumentList();
        List<SourceTypeArgument> existingTypeArguments = sym.getTypeArguments();
        existingTypeArguments.clear();
        existingTypeArguments.addAll(typeArguments);
        sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFFB);
    }

    @Override
    public boolean isGeneric() {
        TypeArgumentListSym child = (TypeArgumentListSym)this.getChild((byte)29);
        if (child == null) {
            return false;
        }
        if (!child.isSkeleton()) {
            return true;
        }
        return !child.getTypeArguments().isEmpty();
    }

    private void removeTypeArguments() {
        Sym child = this.getChild((byte)29);
        if (child != null) {
            this.remove(child);
        }
    }

    @Override
    public int getArrayDimension() {
        if (!this.isVarargs()) {
            return this.typeBaseDimension + this.typeXtraDimension;
        }
        return this.typeBaseDimension + this.typeXtraDimension + 1;
    }

    @Override
    public String getText() {
        String text = super.getText();
        for (int i = 0; i < this.typeXtraDimension; ++i) {
            text = text + "[]";
        }
        if (this.isVarargs()) {
            text = text + "...";
        }
        return text;
    }

    @Override
    public JavaType getCompiledObject() {
        return this.getResolvedType();
    }

    @Override
    public JavaType getResolvedType() {
        JavaType currentTypeResolved = this.getTypeResolved();
        if (currentTypeResolved == null) {
            currentTypeResolved = (JavaType)this.resolve();
        }
        return currentTypeResolved == noType ? null : currentTypeResolved;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: 
            case 29: {
                return true;
            }
            case 1: {
                return this.getJdkVersion().isJdk8OrAbove();
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        this.symAccess = (char)(this.symAccess & 0xFFFFEFFF);
    }

    @Override
    protected void unlinkSelfTrigger(TreeSym parent, byte filter) {
        this.symKind = (byte)27;
        super.unlinkSelfTrigger(parent, filter);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 29: {
                break;
            }
            case 1: 
            case 20: {
                int lastAnnotation = this.lastIndexOf((byte)1);
                if (lastAnnotation != -1) {
                    return lastAnnotation + 1;
                }
                return 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        JavaType currentTypeResolved = this.getTypeResolved();
        if (currentTypeResolved == null) {
            currentTypeResolved = compiler.resolve(this);
            this.setTypeResolved(currentTypeResolved == null ? noType : currentTypeResolved);
        }
        return currentTypeResolved == noType ? null : currentTypeResolved;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImpl(compiler);
        if (!compiler.skipCompilations()) {
            if (result != null) {
                compiler.compile(this);
            }
            this.checkAnnotations(compiler);
        }
        return result;
    }

    private String qualifySelfImpl() {
        TypeSym nestedType;
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null && !resolvedType.isPrimitive() && resolvedType instanceof JavaClass && resolvedType.isExported() && (nestedType = this.getTypeSym()) == null) {
            JavaClass javaClass = (JavaClass)resolvedType;
            String qualifiedName = javaClass.getRawName();
            int firstBracket = qualifiedName.indexOf(91);
            if (firstBracket >= 0) {
                qualifiedName = qualifiedName.substring(0, firstBracket);
            }
            if (TypeSym.isValidPackageName(qualifiedName) && !this.getName().equals(qualifiedName)) {
                return qualifiedName;
            }
        }
        return null;
    }

    @Override
    public final void qualifySelf() {
        NameSym nameSym;
        String qualifiedName = this.qualifySelfImpl();
        if (qualifiedName != null && (nameSym = this.getNameSym()) != null) {
            nameSym.setValue(qualifiedName);
            this.symFormat = (char)(this.symFormat | 0x10);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        NameSym nameSym;
        String qualifiedName;
        TypeSym sym = (TypeSym)super.cloneSelf(targetFile);
        sym.typeBaseDimension = this.typeBaseDimension;
        sym.typeXtraDimension = this.typeXtraDimension;
        sym.typeToken = this.typeToken;
        SourcePreferences preferences = this.symFile.getPreferences();
        if (preferences.getBoolean(107) && (qualifiedName = this.qualifySelfImpl()) != null && (nameSym = sym.getNameSym()) != null) {
            nameSym.nameString = qualifiedName;
        }
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        this.print(out);
        for (int i = 0; i < this.typeXtraDimension; ++i) {
            out.append('[');
            out.append(']');
        }
    }

    @Override
    public List<SourceAnnotation> getSourceAnnotations() {
        List<SourceAnnotation> annotations = super.getSourceAnnotations();
        if (this.getJdkVersion().isJdk8OrAbove() && this.getQualifyingType() == null) {
            Sym parent;
            for (parent = this.getParentSym(); parent != null && parent.getSymbolKind() == 27; parent = parent.getParentSym()) {
            }
            if (parent != null) {
                VardeclSym declaration;
                if (parent.symKind == 9 || parent.symKind == 19 || parent.symKind == 13 || parent.symKind == 18) {
                    return ((ObjectSym)parent).getDeclaredTypeAnnotations(false);
                }
                if (parent.symKind == 10) {
                    VardeclSym declaration2 = ((FieldSym)parent).getOwningDeclarationSym();
                    if (declaration2 != null) {
                        return declaration2.getDeclaredTypeAnnotations(false);
                    }
                } else if (parent.symKind == 17 && (declaration = ((LocalVariableSym)parent).getOwningDeclarationSym()) != null) {
                    return declaration.getDeclaredTypeAnnotations(false);
                }
            }
        }
        return annotations;
    }
}

