/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.List;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ConstantExpressionEvaluator;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentListSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ExprBinding;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeArgumentList;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

public abstract class Expr
extends TreeSym
implements SourceExpression {
    @CodeSharingSafe(value="StaticField")
    protected static final JavaHasType kEmptyResult = CompilerDriver.kEmptyResult;
    public byte exprRequirety;
    public byte exprOptcode;
    public short optCount = 0;

    protected void setExprResolved(JavaHasType exprResolved) {
        ExprBinding binding = new ExprBinding(exprResolved);
        this.setInternalBinding(binding);
    }

    protected JavaHasType getExprResolved() {
        ExprBinding binding = (ExprBinding)this.getInternalBinding(14);
        if (binding != null) {
            return binding.getResolvedExpr();
        }
        return null;
    }

    @Override
    public final int getExpressionCode() {
        return this.exprOptcode;
    }

    @Override
    public final int getOperatorCode() {
        return this.exprOptcode;
    }

    public final boolean flag_extraComma() {
        return this.testSymFlag((byte)32);
    }

    public final boolean flag_maybePackage() {
        return this.testSymFlag((byte)64);
    }

    public final boolean flag_lvalue() {
        return this.testSymFlag((byte)-128);
    }

    @Override
    public final SourceExpression getFirstOperand() {
        return (SourceExpression)((Object)this.getChild((byte)102));
    }

    @Override
    public final SourceExpression getSecondOperand() {
        return (SourceExpression)((Object)this.getNthChild((byte)102, 1));
    }

    @Override
    public final SourceExpression getThirdOperand() {
        return (SourceExpression)((Object)this.getNthChild((byte)102, 2));
    }

    @Override
    public final List<SourceExpression> getOperands() {
        return this.getChildrenList(102);
    }

    @Override
    public int getOperandCount() {
        return this.count((byte)102);
    }

    @Override
    public SourceExpression getOperandAt(int i) {
        return this.getNthOperandSym(i);
    }

    public final SourceExpression getLhsOperand() {
        return this.getLhsOperandSym();
    }

    public Expr getLhsOperandSym() {
        return null;
    }

    public final void setLhsOperand(SourceExpression e) {
        this.setLhsOperandSym((Expr)e);
    }

    public void setLhsOperandSym(Expr e) {
        Expr.notImplementedYet();
    }

    public final Expr getNthOperandSym(int i) {
        return (Expr)this.getNthChild((byte)102, i);
    }

    @Override
    public Object getConstantValue() {
        return ConstantExpressionEvaluator.evaluateUnconstrained(this);
    }

    public JavaHasType getResolvedLhs() {
        Expr lhsOp = this.getLhsOperandSym();
        if (lhsOp != null) {
            return lhsOp.getResolvedObject();
        }
        return null;
    }

    @Override
    public JavaType getResolvedType() {
        JavaHasType type = this.getResolvedObject();
        if (type != null) {
            return type.getResolvedType();
        }
        return null;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        JavaHasType type = this.getResolvedObject();
        if (type != null) {
            return type.getUnresolvedType();
        }
        return super.getUnresolvedType();
    }

    @Override
    public JavaHasType getResolvedObject() {
        return this.getCompiledObject();
    }

    @Override
    public synchronized JavaHasType getCompiledObject() {
        JavaHasType localExprResolved = this.getExprResolved();
        if (localExprResolved == null) {
            localExprResolved = (JavaHasType)this.resolve();
        }
        if (localExprResolved != kEmptyResult) {
            return localExprResolved;
        }
        return null;
    }

    @Override
    public String printCompiledInfo() {
        JavaHasType result = this.getResolvedObject();
        if (result != null) {
            return "result " + result.printCompiledInfo();
        }
        return "result <none>";
    }

    public final int getPrecedence() {
        if (1 <= this.exprOptcode && this.exprOptcode < 62) {
            return OPT_precedence[this.exprOptcode - 1];
        }
        return 0;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        if (Expr.srcIsExpr(symKind)) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChild(int index, Sym child, byte filter) {
        Sym actualChild = this.checkLinkChildForPrecedence(child);
        super.linkChild(index, actualChild, filter);
    }

    @Override
    protected void replaceChild(int index, Sym child, byte filter) {
        Sym actualChild = this.checkLinkChildForPrecedence(child);
        super.replaceChild(index, actualChild, filter);
    }

    private Sym checkLinkChildForPrecedence(Sym child) {
        if (child == null) {
            return null;
        }
        if (child.isFilter((byte)102)) {
            Expr e = (Expr)child;
            int ePrecedence = e.getPrecedence();
            int thisPrecedence = this.getPrecedence();
            if (ePrecedence > 0 && thisPrecedence > 0 && thisPrecedence < ePrecedence) {
                Expr wrapper = SymFactory.createExpr(this.symFile, (byte)38);
                wrapper.symFormat = (char)(wrapper.symFormat | 2);
                if (wrapper.getPrecedence() != 0) {
                    Expr.panic();
                }
                wrapper.add(e);
                return wrapper;
            }
        }
        return child;
    }

    @Override
    protected synchronized JavaElement resolveImpl(CompilerDriver compiler) {
        return this.actualResolveImplCode(compiler);
    }

    protected JavaElement actualResolveImplCode(CompilerDriver compiler) {
        JavaHasType localExprResolved = this.getExprResolved();
        if (localExprResolved == null) {
            localExprResolved = (JavaHasType)this.resolveImplImpl(compiler);
            this.setExprResolved(localExprResolved);
        } else if (localExprResolved == kEmptyResult) {
            return null;
        }
        if (localExprResolved != null) {
            return localExprResolved;
        }
        this.setExprResolved(kEmptyResult);
        return null;
    }

    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected Sym cloneSelfImpl(FileSym targetFile) {
        return SymFactory.createExpr(targetFile, this.exprOptcode);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        Expr sym = (Expr)super.cloneSelf(targetFile);
        sym.exprRequirety = this.exprRequirety;
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        int code = this.getOperatorCode();
        String exprString = "<unknown>";
        if (code != 0) {
            exprString = OPT_words[code - 1];
        }
        buffer.append(" expr \"");
        buffer.append(exprString);
        buffer.append('\"');
    }

    public List<SourceTypeArgument> getTypeArguments() {
        TypeArgumentListSym typeArgs = (TypeArgumentListSym)this.getTypeArgumentList();
        return typeArgs.getTypeArguments();
    }

    public SourceTypeArgumentList getTypeArgumentList() {
        return (SourceTypeArgumentList)((Object)this.getChildOrCreateSkeleton((byte)29));
    }

    public boolean isGeneric() {
        TypeArgumentListSym child = (TypeArgumentListSym)this.getChild((byte)29);
        if (child == null) {
            return false;
        }
        if (!child.isSkeleton()) {
            return true;
        }
        return !child.getTypeArguments().isEmpty();
    }
}

