/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;

public class SSBSchedulerSchedule
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("REPEAT_INTERVAL", "REPEAT_INTERVAL");
        this.excludeMap.put("FILE_WATCHER_NAME", "FILE_WATCHER_NAME");
        this.excludeMap.put("FILE_WATCHER_OWNER", "FILE_WATCHER_OWNER");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("EVENT_QUEUE_OWNER", "EVENT_QUEUE_OWNER");
        this.excludeMap.put("EVENT_QUEUE_NAME", "EVENT_QUEUE_NAME");
        this.excludeMap.put("EVENT_QUEUE_AGENT", "EVENT_QUEUE_AGENT");
        this.excludeMap.put("EVENT_CONDITION", "EVENT_CONDITION");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerSchedule) {
            SchedulerSchedule sched = (SchedulerSchedule)object;
            if (sched.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerSchedule.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 1);
                if (sched.isEventSchedule()) {
                    SSBSchedulerSchedule.appendStringWithSpace(buffer, "DBMS_SCHEDULER.CREATE_EVENT_SCHEDULE(");
                } else {
                    SSBSchedulerSchedule.appendStringWithSpace(buffer, "DBMS_SCHEDULER.CREATE_SCHEDULE(");
                }
                SSBSchedulerSchedule.appendObjectName(buffer, sched, prettyPrint);
                SSBSchedulerSchedule.appendParams(buffer, sched, prettyPrint);
                SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerSchedule.appendStringWithSpace(buffer, ");");
                this.appendAtrtributes(buffer, sched, prettyPrint, excludeMap);
                SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerSchedule.appendString(buffer, "END");
                SSBSchedulerSchedule.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerSchedule.appendStringWithSpace(oldbuffer, "invalid schedule definitiion for " + String.valueOf(sched.getName() + "\n schedule name and repeat interval, or queue or file watcher should be defined"));
            }
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerSchedule.appendString(buffer, "schedule_name => '" + obj.getNameFormatted() + "'");
    }

    public static void appendParams(StringBuffer buffer, SchedulerSchedule obj, boolean prettyPrint) {
        String stype = obj.getProperty("SCHEDULE_TYPE");
        if (stype != null && !stype.isEmpty()) {
            switch (stype.toUpperCase()) {
                case "CALENDAR": {
                    SSBSchedulerSchedule.appendRepeatInterval(buffer, obj, prettyPrint);
                    break;
                }
                case "FILE_WATCHER": {
                    SSBSchedulerSchedule.appendFileWatcher(buffer, obj, prettyPrint);
                    break;
                }
                case "EVENT": {
                    SSBSchedulerSchedule.appendEventQueueSpec(buffer, obj, prettyPrint);
                }
            }
        } else {
            SSBSchedulerSchedule.appendRepeatInterval(buffer, obj, prettyPrint);
            SSBSchedulerSchedule.appendFileWatcher(buffer, obj, prettyPrint);
            SSBSchedulerSchedule.appendEventQueueSpec(buffer, obj, prettyPrint);
        }
    }

    public static void appendRepeatInterval(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type = obj.getProperty("REPEAT_INTERVAL");
        if (type != null && !type.isEmpty()) {
            SSBSchedulerSchedule.appendString(buffer, ',');
            SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerSchedule.appendString(buffer, "repeat_interval => '" + type + "'");
        }
    }

    public static void appendFileWatcher(StringBuffer buffer, SchedulerSchedule obj, boolean prettyPrint) {
        String name = obj.getFormatedFileWatcherName();
        if (name != null && !name.isEmpty()) {
            String event = obj.getProperty("event_condition");
            if (event != null && !event.isEmpty()) {
                SSBSchedulerSchedule.appendString(buffer, ',');
                SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerSchedule.appendString(buffer, "event_condition => '" + event + "'");
            }
            SSBSchedulerSchedule.appendString(buffer, ',');
            SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerSchedule.appendString(buffer, "queue_spec => '" + name + "'");
        }
    }

    public static void appendEventQueueSpec(StringBuffer buffer, SchedulerSchedule obj, boolean prettyPrint) {
        Object name = obj.getFormatedEventQueueName();
        if (name != null && !((String)name).isEmpty()) {
            String agent;
            String event = obj.getProperty("event_condition");
            if (event != null && !event.isEmpty()) {
                SSBSchedulerSchedule.appendString(buffer, ',');
                SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
                SSBSchedulerSchedule.appendString(buffer, "event_condition => '" + event + "'");
            }
            if ((agent = obj.getProperty("EVENT_QUEUE_AGENT")) != null && !agent.isEmpty()) {
                name = (String)name + "," + SchedulerObject.getFormatedSimpleName(agent);
            }
            SSBSchedulerSchedule.appendString(buffer, ',');
            SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerSchedule.appendString(buffer, "queue_spec => '" + (String)name + "'");
        }
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerSchedule.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerSchedule.appendStringWithSpace(buffer, "DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerSchedule;
    }
}

