/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;

public class AbstractDTObject
extends DesignObject {
    Collection allViews = new ArrayList();
    private List relationConnections = new ArrayList();
    private boolean predefined = false;
    private boolean isNullInstance = false;

    public AbstractDTObject(DesignPart designPart) {
        super(designPart);
        this.addObjectListener((DataTypesDesign)this.getDesignPart());
    }

    void add(DTRelation.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(null);
    }

    void remove(DTRelation.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(null);
    }

    public DTRelation.Connection[] getAllLinks() {
        return (DTRelation.Connection[])this.relationConnections.toArray(DTRelation.CONNECTION_PROTO_ARRAY);
    }

    public void removeLinks() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            DTRelation.Connection c;
            DTRelation dtRelation;
            if (this.relationConnections.size() <= 0 || (dtRelation = (c = (DTRelation.Connection)this.relationConnections.get(i)).getDTRelation()) == null) continue;
            if (dtRelation.getSource() != null) {
                dtRelation.getSource().remove(c);
            }
            if (dtRelation.getTargetDTObject() == null) continue;
            dtRelation.getTargetDTObject().remove(c);
        }
    }

    @Override
    public void remove() {
        this.removeLinks();
        this.removeAllViews();
        super.remove();
    }

    public void removeAllViews() {
    }

    public void resetViewNumbers() {
    }

    public int getTopViewsCount() {
        int count = 0;
        return count;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        if (this.predefined != predefined) {
            this.predefined = predefined;
            this.fireChange(ObjectChangeEvent.PREDEFINED_STATUS_CHANGED);
        }
    }

    public boolean isNullInstance() {
        return this.isNullInstance;
    }

    public void setIsNullInstance(boolean value) {
        this.isNullInstance = value;
    }

    public List getAllViewsWithCellViews() {
        ArrayList list = new ArrayList();
        return list;
    }
}

