/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.FontObjectWr;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public abstract class TopView
implements ObjectListener,
ID_ObjectPropertyTranslator {
    public static final Integer DEFAULT_LAYER = new Integer(0);
    public static final Integer RELATION_LAYER = new Integer(-1);
    public static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    public final TopView[] EMPTY_ARRAY = new TopView[0];
    protected DesignObject model;
    private String viewID = null;
    private String generatorID;
    protected Dimension size = new Dimension(TOPVIEW_SIZE);
    protected Point location = new Point(20, 20);
    protected DesignPartView dpv;
    private int viewNumber = 0;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    protected boolean noBackgroundColor = false;
    protected boolean noForegroundColor = false;
    private boolean useDefaultColor = true;
    private boolean useCustomFormat = false;
    private boolean hideElementsInCurrentOnly = false;
    private List hiddenElements;
    private List editableFonts = new ArrayList();
    private boolean mainObject = false;
    private Set showParentChildListeners = new HashSet();
    private Design design;
    protected int lineWidth = 1;

    public TopView(DesignPartView dpv) {
        this.dpv = dpv;
        dpv.registerTopView(this);
    }

    public TopView() {
    }

    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    public Design getDesign() {
        if (this.model != null) {
            return this.model.getDesign();
        }
        return this.design;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public void setModel(DesignObject object) {
        if (this.model != null) {
            this.model.removeObjectListener(this);
        }
        this.model = object;
        object.setTopView(this);
        this.model.addObjectListener(this);
    }

    public DesignObject getModel() {
        return this.model;
    }

    public String getViewID() {
        if (this.viewID == null) {
            this.viewID = new GUID().toString();
        }
        return this.viewID;
    }

    public void setViewID(String id) {
        if (this.getDesign().getLoadedVersion() < 2.4f) {
            return;
        }
        this.viewID = id;
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public ContainerView createViewSynonym(DesignPartView dpv) {
        return null;
    }

    public boolean isConnection() {
        return false;
    }

    public void makeSelected() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append('[').append(this.getModel()).append(']');
        return buf.toString();
    }

    public boolean calculateConnectionPoints() {
        return false;
    }

    public Object getLayerConstraint() {
        return DEFAULT_LAYER;
    }

    public boolean canRemove() {
        return true;
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public void setSize(int arg0, int arg1) {
        this.setSize(new Dimension(arg0, arg1));
    }

    public void setLocation(int arg0, int arg1) {
        this.setLocation(new Point(arg0, arg1));
    }

    public void setBounds(Rectangle bounds) {
        this.size.width = bounds.width;
        this.size.height = bounds.height;
        this.location.x = bounds.x;
        this.location.y = bounds.y;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.location, this.size);
    }

    public void move(int dx, int dy) {
        this.location.x += dx;
        this.location.y += dy;
    }

    public void setVisible(boolean visible) {
    }

    public String getGeneratorID() {
        return this.generatorID;
    }

    public void setGeneratorID(String topViewID) {
        this.generatorID = topViewID;
    }

    public Rectangle getCalculatedBounds() {
        Rectangle bounds = this.getBounds();
        return bounds;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public boolean getNoBackgroundColor() {
        if (this.useCustomFormat()) {
            return this.noBackgroundColor;
        }
        return this.getModel().getNoBackgroundColor();
    }

    public void setNoBackgroundColor(boolean noBackgroundColor) {
        this.noBackgroundColor = noBackgroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setNoBackgroundColor(noBackgroundColor);
        }
    }

    public boolean getNoForegroundColor() {
        if (this.useCustomFormat()) {
            return this.noForegroundColor;
        }
        return this.getModel().getNoForegroundColor();
    }

    public void setNoForegroundColor(boolean noForegroundColor) {
        this.noForegroundColor = noForegroundColor;
        if (!this.useCustomFormat()) {
            this.getModel().setNoForegroundColor(noForegroundColor);
        }
    }

    public boolean useDefaultColor() {
        return this.useDefaultColor;
    }

    public void setUseDefaultColor(boolean useDefaultColor) {
        this.useDefaultColor = useDefaultColor;
    }

    public boolean useCustomFormat() {
        return this.useCustomFormat;
    }

    public void setUseCustomFormat(boolean useCustomFormat) {
        this.useCustomFormat = useCustomFormat;
    }

    public List getEditableFonts() {
        return this.editableFonts;
    }

    public List getDefaultEditableFonts() {
        DefaultFontAndColor dfc = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType());
        if (dfc != null) {
            return dfc.getEditableFonts();
        }
        return Collections.EMPTY_LIST;
    }

    public FontObject getFontObject(String type) {
        DefaultFontAndColor dfc;
        FontObject fo = null;
        if (this.useCustomFormat()) {
            for (FontObject next : this.editableFonts) {
                if (!type.equalsIgnoreCase(next.getType())) continue;
                fo = next;
                break;
            }
            if (fo != null) {
                return fo;
            }
            DefaultFontAndColor dfc2 = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType());
            if (dfc2 != null && (fo = dfc2.getFontObject(type)) != null) {
                fo = fo.copy();
                this.editableFonts.add(fo);
                return fo;
            }
        }
        if (this.getModel() instanceof EditableFonts && (dfc = this.getDesign().getDesignLevelSettings().getDefaultFCObject(((EditableFonts)((Object)this.getModel())).getFCObjectType())) != null) {
            return dfc.getFontObject(type);
        }
        return null;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getViewNumber() {
        return this.viewNumber;
    }

    public void setViewNumber(int viewNumber) {
        this.viewNumber = viewNumber;
    }

    public int getDefaultLineWidth() {
        return 1;
    }

    public Color getDefaultLineColor() {
        return Color.BLACK;
    }

    public List getFontObjectWrappers() {
        List fonts;
        if (this.useCustomFormat() && (fonts = this.getEditableFonts()).size() > 0) {
            ArrayList<FontObjectWr> list = new ArrayList<FontObjectWr>();
            for (FontObject fo : fonts) {
                FontObjectWr wr = new FontObjectWr(fo);
                list.add(wr);
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public FontObjectWr createFontObjectWr() {
        return new FontObjectWr();
    }

    public void addFontObjectWrapper(FontObjectWr foWr) {
        List fonts = this.getEditableFonts();
        String type = foWr.getFoType();
        boolean fontEnabled = true;
        if (type != null) {
            FontObject fo = this.getFontObject(type);
            if (fo != null) {
                fontEnabled = fo.isFontEnabled();
                fonts.remove(fo);
            }
            fo = new FontObject(type, new Font(foWr.getFontName(), foWr.getFontStyle(), foWr.getFontSize()), new Color(foWr.getColor_RGB()), fontEnabled);
            fonts.add(fo);
        }
    }

    public List getHiddenElements() {
        if (this.hiddenElements == null) {
            this.hiddenElements = new ArrayList();
        }
        return this.hiddenElements;
    }

    public boolean isHideElementsInCurrentOnly() {
        return this.hideElementsInCurrentOnly;
    }

    public void setHideElementsInCurrentOnly(boolean hideElementsInCurrentOnly) {
        this.hideElementsInCurrentOnly = hideElementsInCurrentOnly;
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        DesignObject dobj = this.getModel();
        if (dobj != null) {
            return dobj.translateObjectToID(propertyName, object);
        }
        return null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject dobj = this.getModel();
        if (dobj != null) {
            return dobj.translateIdToObject(propertyName, id);
        }
        return null;
    }

    public boolean isMainObject() {
        return this.mainObject;
    }

    public void setAsMainObject(boolean main) {
        this.mainObject = main;
    }

    protected void clearShowParentChildListeners() {
        this.showParentChildListeners.clear();
    }

    public void copy(TopView topView) {
        topView.setUseCustomFormat(this.useCustomFormat());
        topView.setUseDefaultColor(this.useDefaultColor());
        topView.setBackgroundColor(this.getBackgroundColor());
        topView.setForegroundColor(this.getForegroundColor());
        if (this.editableFonts.size() > 0) {
            topView.getEditableFonts().clear();
            if (topView.getModel() instanceof EditableFonts) {
                for (FontObject next : this.editableFonts) {
                    topView.getEditableFonts().add(next.copy());
                }
            }
        }
    }

    public Point2D getCenterPoint() {
        Rectangle r = this.getBounds();
        return new Point2D.Double(r.getCenterX(), r.getCenterY());
    }
}

