/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesignSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.metadata.ClassDescription;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.search.SearchResultObject;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.HTMLReportSingleFileWeb;
import oracle.dbtools.crest.swingui.wizards.reports.ReportColumn;
import oracle.dbtools.crest.swingui.wizards.reports.ReportSection;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.ResourceProvider;
import oracle.dbtools.crest.util.dmweb.DiagramToSVG;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportsGenerator {
    private static final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss");
    private ToStringComparator toStringComparator = new ToStringComparator();
    private final String SHOW = "show";
    private String reportsPath;
    private String reportFileName = "";
    private String xsltFile = null;
    private List<String> generatedDiagramsNamesListPerModel = new ArrayList<String>();
    String modelExtraFilesDirName = "";
    private String fileFormat;
    private Design design;
    private String reportCaption = "";
    private String customReportFileName = "";
    private Boolean replaceBooleanValues;
    private String strTrue;
    private String strFalse;
    private List objectsBookmarksNamesList = new ArrayList();
    private Settings settings;
    private ResourceProvider resourceProvider;
    private Boolean addTables;
    private Boolean addViews;
    private String cssFiles = "";
    private static final Logger LOGGER = new Logger(ReportsGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(Class clazz, ModelIDObject model, List objects, HashMap extraParams, OutputStream outStream, DesignPartView dpv, boolean createTOC, boolean dmwdef, List<DiagramToSVG.Line> lines) {
        block121: {
            Document doc = null;
            File outputFile = null;
            String tocTagName = "";
            StandardReportTemplate reportTemplate = (StandardReportTemplate)extraParams.get("report_template");
            CustomReportTemplate customReportTemplate = (CustomReportTemplate)extraParams.get("custom_report_template");
            if (model != null) {
                this.modelExtraFilesDirName = model.getName().replaceAll("[^a-zA-Z1-9_]", "_") + "_" + model.getShortObjectID();
                this.design = model.getDesign();
            }
            this.settings = this.design.getSettings();
            this.reportsPath = (String)extraParams.get("reports_path");
            this.fileFormat = ((String)extraParams.get("out_format")).toLowerCase();
            this.reportCaption = (String)extraParams.get("reportCaption");
            this.replaceBooleanValues = (Boolean)extraParams.get("pboolean");
            this.strTrue = (String)extraParams.get("ptrue");
            this.strFalse = (String)extraParams.get("pfalse");
            this.customReportFileName = ((String)extraParams.get("reportCustomFilenName")).trim();
            this.addTables = (Boolean)extraParams.get("addTables");
            this.addViews = (Boolean)extraParams.get("addViews");
            this.cssFiles = (String)extraParams.get("cssFiles");
            if (clazz == Table.class || clazz == Column.class || clazz == FKIndexAssociation.class || clazz == Index.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleTableDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleTableData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleTableDetails_" + this.fileFormat + ".xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllTablesData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllTablesDetails_" + this.fileFormat + ".xslt";
                    tocTagName = "TableName";
                }
            } else if (clazz == StructuredType.class || clazz == TypeElement.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleStructuredTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleStructuredTypeData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleStructuredTypeDetails_" + this.fileFormat + ".xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllStructuredTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllStructuredTypesData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllStructuredTypesDetails_" + this.fileFormat + ".xslt";
                    tocTagName = "STName";
                }
            } else if (clazz == CollectionType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleCollectionTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleCollectionTypeData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleCollectionTypeDetails_" + this.fileFormat + ".xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllCollectionTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllCollectionTypesData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllCollectionTypesDetails_" + this.fileFormat + ".xslt";
                    tocTagName = "CTName";
                }
            } else if (clazz == DistinctType.class) {
                if (objects.size() == 1) {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "SingleDistinctTypeDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherSingleDistinctTypeData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/SingleDistinctTypeDetails_" + this.fileFormat + ".xslt";
                } else {
                    this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllDistinctTypesDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                    doc = this.gatherAllDistinctTypesData((DesignPart)model, reportTemplate, objects);
                    this.xsltFile = "datamodeler/reports/xslt/10/AllDistinctTypesDetails_" + this.fileFormat + ".xslt";
                    tocTagName = "DTName";
                }
            } else if (clazz == Label.class) {
                this.reportFileName = this.customReportFileName.equals("") ? ReportUtils.getReportFileName(this.reportsPath, "AllTablesaAndViewsDetails") + "." + this.fileFormat : this.customReportFileName + "." + this.fileFormat;
                doc = this.gatherAllTablesAndViewsData((DesignPart)model, reportTemplate, objects);
                this.xsltFile = "datamodeler/reports/xslt/10/AllTablesAndViewsDetails_" + this.fileFormat + ".xslt";
            }
            outputFile = new File(this.reportsPath, this.reportFileName);
            BufferedReader xmlISR = null;
            InputStream xsltIS = null;
            OutputStreamWriter xmlOSW = null;
            OutputStreamWriter osw = null;
            PrintWriter htmlIDXPW = null;
            PrintWriter htmlTOCPW = null;
            try {
                if (doc != null) {
                    DOMSource domSource = new DOMSource(doc);
                    ByteArrayOutputStream xmlOutStream = new ByteArrayOutputStream();
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)xmlOutStream, "UTF-8");
                    StreamResult result = new StreamResult(out);
                    TransformerFactory trFact = null;
                    try {
                        trFact = TransformerFactory.newInstance();
                        trFact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        trFact.setURIResolver(IgnoreURIResolver.INSTANCE);
                    }
                    catch (Exception e) {
                        Logger.error(e);
                    }
                    Transformer tr = trFact.newTransformer();
                    tr.setOutputProperty("encoding", "UTF-8");
                    tr.transform(domSource, result);
                    ByteArrayInputStream inStream = new ByteArrayInputStream(xmlOutStream.toByteArray());
                    InputStreamReader inr = new InputStreamReader((InputStream)inStream, Charset.forName("UTF-8"));
                    StreamSource xmlStreamSource = new StreamSource(inr);
                    if (this.xsltFile != null) {
                        xsltIS = this.getInputStreamFor(this.xsltFile);
                        StreamSource xsltSource = new StreamSource(xsltIS);
                        TransformerFactory transFact = TransformerFactory.newInstance();
                        transFact.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        transFact.setURIResolver(IgnoreURIResolver.INSTANCE);
                        Transformer trans = transFact.newTransformer(xsltSource);
                        trans.setOutputProperty("encoding", "UTF-8");
                        if (this.cssFiles.trim() != "") {
                            String paramName = "p";
                            int c = 0;
                            for (String s : Arrays.asList(this.cssFiles.split("\\s+"))) {
                                trans.setParameter(paramName + ++c, s);
                            }
                        }
                        trans.setOutputProperty("encoding", "UTF-8");
                        if (outStream == null) {
                            FileOutputStream fos = new FileOutputStream(outputFile);
                            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                            trans.transform(xmlStreamSource, new StreamResult(osw));
                            osw.flush();
                            fos.close();
                        } else if (this.settings.isGenerateHTMLReportTOCInSeparateFile()) {
                            osw = new OutputStreamWriter(outStream, "UTF-8");
                            trans.transform(xmlStreamSource, new StreamResult(osw));
                            osw.flush();
                        } else {
                            ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
                            osw = new OutputStreamWriter((OutputStream)tempStream, "UTF-8");
                            StreamResult sr = new StreamResult(osw);
                            trans.transform(xmlStreamSource, sr);
                            TreeMap<String, ModelIDObject> map = new TreeMap<String, ModelIDObject>();
                            if (createTOC) {
                                for (ModelIDObject obj : objects) {
                                    if (this.addTables.booleanValue() && obj instanceof Table) {
                                        map.put(obj.getLongName(), obj);
                                        continue;
                                    }
                                    if (!this.addViews.booleanValue() || !(obj instanceof TableView)) continue;
                                    map.put(obj.getLongName(), obj);
                                }
                            }
                            String diagram = null;
                            if (dpv != null) {
                                diagram = DiagramToSVG.getSVGForDiagram(dpv, true, "__dg_rm", dmwdef, lines);
                            }
                            PrintStream printStream = new PrintStream(outStream, false, "UTF-8");
                            StringBuffer buf = HTMLReportSingleFileWeb.createHTML(map, tempStream, diagram, "", null);
                            printStream.print(buf);
                        }
                    } else {
                        LOGGER.error("Required XSLT file " + this.xsltFile + " for report generation not found. Process is terminated.");
                    }
                    break block121;
                }
                LOGGER.error("DomDocument missing or invalid");
            }
            catch (TransformerConfigurationException e) {
                LOGGER.error("TransformerConfigurationException during report generation " + e);
            }
            catch (TransformerException e) {
                LOGGER.error("TransformerException during report generation" + e);
            }
            catch (FileNotFoundException e) {
                if (e.getMessage().contains("Access is denied")) {
                    LOGGER.error("FileNotFoundException during report generation " + e);
                } else {
                    LOGGER.error("FileNotFoundException during report generation " + e);
                }
            }
            catch (IOException e) {
                LOGGER.error("IOException during report generation " + e);
            }
            catch (Exception e) {
                LOGGER.error("Exception during report generation " + e);
            }
            catch (Throwable e) {
                LOGGER.error("IOException during report generation " + e);
            }
            finally {
                if (xmlOSW != null) {
                    try {
                        xmlOSW.flush();
                        xmlOSW.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close raw XML file : " + e);
                    }
                }
                if (osw != null) {
                    try {
                        if (outStream == null) {
                            osw.flush();
                            osw.close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT1.0 generated report " + this.reportFileName + ": " + e);
                    }
                }
                if (htmlIDXPW != null) {
                    htmlIDXPW.close();
                }
                if (htmlTOCPW != null) {
                    htmlTOCPW.close();
                }
                if (xmlISR != null) {
                    try {
                        xmlISR.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close the buffered reader : " + e);
                    }
                }
                if (xsltIS != null) {
                    try {
                        xsltIS.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("ReportsGenerator.createReport() Unable to close XSLT file : " + e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleTableData(DesignPart model, StandardReportTemplate reportTemplate, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/table", "osdmSingleTable:Table");
            document.appendChild(rootElement);
            String namespace = "osdmSingleTable:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element e = null;
            Table table = (Table)tables.get(0);
            e = document.createElement(namespace + "TableName");
            e.appendChild(document.createTextNode(table.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "ObjectTypeName");
            e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
            rootElement.appendChild(e);
            if (reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                description = table.getComment() == null || table.getComment().equals("") ? table.getCommentInRDBMS() : table.getComment();
                if (description != "" && description != null) {
                    Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    rootElement.appendChild(descriptionNotesElement);
                }
            }
            e = document.createElement(namespace + "MVPrebuilt");
            e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
            rootElement.appendChild(e);
            if (table.getUserDefinedSQL() != null) {
                e = document.createElement(namespace + "MVQuery");
                e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                rootElement.appendChild(e);
            }
            if (reportTemplate.isUseTableColumns()) {
                int columnsCounter = 0;
                Element columnsCollection = null;
                for (Column column : Arrays.asList(table.getElements())) {
                    String personalInfo;
                    if (columnsCounter == 0) {
                        columnsCollection = document.createElement(namespace + "ColumnsCollection");
                        rootElement.appendChild(columnsCollection);
                    }
                    Element columnDetails = document.createElement(namespace + "ColumnDetails");
                    columnsCollection.appendChild(columnDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "ColumnName");
                    e.appendChild(document.createTextNode(column.getName()));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "PK");
                    e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "FK");
                    String fk = column.isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                    e.appendChild(document.createTextNode(fk));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                    columnDetails.appendChild(e);
                    String dataType = "";
                    String string = "";
                    String domainName = "";
                    switch (column.getUse()) {
                        case 0: {
                            String string2 = "DOM";
                            Domain dom = column.getDomain();
                            domainName = dom.getName();
                            dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                            domainName = domainName.replace("Unknown", "");
                            domainName = domainName.replace("unknown", "");
                            domainName = domainName.replace("UNKNOWN", "");
                            break;
                        }
                        case 1: {
                            String string3 = "LT";
                            dataType = column.getNativeDataType();
                            break;
                        }
                        case 2: {
                            String string4 = "DT";
                            dataType = column.getDistinctType().getName();
                            break;
                        }
                        case 3: {
                            if (column.isReference()) {
                                String string5 = "RST";
                            } else {
                                String string6 = "ST";
                            }
                            dataType = column.getStructuredType().getName();
                            break;
                        }
                        case 4: {
                            String string7 = "CT";
                            dataType = column.getCollectionType().getName();
                        }
                    }
                    e = document.createElement(namespace + "DataType");
                    String ai = column.isAutoIncrementColumn() ? " - AI" : "";
                    String id = column.isIdentityColumn() ? " - ID" : "";
                    e.appendChild(document.createTextNode(dataType + ai + id));
                    columnDetails.appendChild(e);
                    e = document.createElement(namespace + "Formula");
                    e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                    columnDetails.appendChild(e);
                    Object security = "";
                    String string8 = column.isContainsPII() == null ? "" : (personalInfo = column.isContainsPII() != false ? "Y" : "");
                    String sensitiveInfo = column.isContainsSensitiveInformation() == null ? "" : (column.isContainsSensitiveInformation() != false ? "Y" : "");
                    String maskInfo = column.getMaskingType();
                    if (maskInfo == null) {
                        maskInfo = "";
                    }
                    security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                    security = ((String)security).replace("//", "");
                    e = document.createElement(namespace + "Security");
                    e.appendChild(document.createTextNode((String)security));
                    columnDetails.appendChild(e);
                    String columnDescription = "";
                    columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                    if (columnDescription != "" && columnDescription != null) {
                        Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                        columnDetails.appendChild(columnDescriptionElement);
                    }
                    ++columnsCounter;
                }
            }
            if (reportTemplate.isUseTableIndexes()) {
                int indesexCounter = 0;
                HashMap<String, String> usedNames = new HashMap<String, String>();
                Element indesexCollection = null;
                Iterator iterator = table.getKeySet().iterator();
                while (iterator.hasNext()) {
                    Index index = (Index)iterator.next();
                    if (index.isFK()) continue;
                    if (indesexCounter == 0) {
                        indesexCollection = document.createElement(namespace + "IndexesCollection");
                        rootElement.appendChild(indesexCollection);
                    }
                    Iterator<ContainedObject> itIdxColumns = null;
                    if (index.hasIndexExpression()) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(" ");
                        itIdxColumns = list.iterator();
                    } else {
                        itIdxColumns = Arrays.asList(index.getElements()).iterator();
                    }
                    while (itIdxColumns.hasNext()) {
                        void var20_42;
                        Column col = null;
                        Object var20_39 = null;
                        ContainedObject obj = itIdxColumns.next();
                        if (obj instanceof Column) {
                            col = (Column)obj;
                            String string = col.getName();
                        } else {
                            String string = ((Object)obj).toString();
                        }
                        Element indexdetails = document.createElement(namespace + "IndexDetails");
                        indesexCollection.appendChild(indexdetails);
                        String state = index.getIndexState();
                        boolean nameUsed = false;
                        String cName = index.getName();
                        for (Map.Entry pair : usedNames.entrySet()) {
                            String name = (String)pair.getKey();
                            String st = (String)pair.getValue();
                            if (!name.equals(cName) || !st.equals(state)) continue;
                            nameUsed = true;
                            break;
                        }
                        if (!nameUsed) {
                            usedNames.put(cName, state);
                        }
                        e = document.createElement(namespace + "IndexName");
                        e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                        indexdetails.appendChild(e);
                        state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                        e = document.createElement(namespace + "IndexState");
                        e.appendChild(document.createTextNode(nameUsed ? "" : state));
                        indexdetails.appendChild(e);
                        e = document.createElement(namespace + "IndexFunctional");
                        e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                        indexdetails.appendChild(e);
                        e = document.createElement(namespace + "IndexSpatial");
                        e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                        indexdetails.appendChild(e);
                        e = document.createElement(namespace + "IndexExpression");
                        e.appendChild(document.createTextNode(index.getIndexExpression()));
                        indexdetails.appendChild(e);
                        e = document.createElement(namespace + "IndexColumnName");
                        e.appendChild(document.createTextNode((String)var20_42));
                        indexdetails.appendChild(e);
                        e = document.createElement(namespace + "IndexSortOrder");
                        if (col != null) {
                            e.appendChild(document.createTextNode(index.getColumnSortOrder(col)));
                        } else {
                            e.appendChild(document.createTextNode(" "));
                        }
                        indexdetails.appendChild(e);
                    }
                    ++indesexCounter;
                }
            }
            if (reportTemplate.isUseTableConstraints()) {
                int constraintsCounter = 0;
                Element constraintsCollection = null;
                Node tableLevelConstraintsCollection = null;
                for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                    if (constraintsCounter == 0) {
                        constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                        rootElement.appendChild(constraintsCollection);
                        tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                        constraintsCollection.appendChild(tableLevelConstraintsCollection);
                    }
                    Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                    tableLevelConstraintsCollection.appendChild(constraintDetails);
                    e = document.createElement(namespace + "TLConstraintType");
                    e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                    constraintDetails.appendChild(e);
                    e = document.createElement(namespace + "TLConstraintName");
                    e.appendChild(document.createTextNode(tlConstraint.getName()));
                    constraintDetails.appendChild(e);
                    Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                    tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                    constraintDetails.appendChild(tlConstraintElement);
                    ++constraintsCounter;
                }
                int columnConstraintsCounter = 0;
                Element columnLevelConstraintsCollection = null;
                for (Column column : Arrays.asList(table.getElements())) {
                    if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                    if (constraintsCounter == 0) {
                        constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                        rootElement.appendChild(constraintsCollection);
                    }
                    if (columnConstraintsCounter == 0) {
                        columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                        constraintsCollection.appendChild(columnLevelConstraintsCollection);
                    }
                    Object constraintName = "";
                    CheckConstraint ccConstraint = column.getCheck();
                    if (ccConstraint != null && !((String)(constraintName = ccConstraint.getName())).equals("")) {
                        constraintName = " / " + (String)constraintName;
                    }
                    Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                    columnLevelConstraintsCollection.appendChild(constraintDetails);
                    e = document.createElement(namespace + "ContstraintType");
                    e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                    constraintDetails.appendChild(e);
                    e = document.createElement(namespace + "ALCConstraintName");
                    e.appendChild(document.createTextNode(column.getName() + (String)constraintName));
                    constraintDetails.appendChild(e);
                    Element rangesCollection = null;
                    Iterator itRanges = column.getAVTs().iterator();
                    int rgCounter = 0;
                    while (itRanges.hasNext()) {
                        AVT avt = (AVT)itRanges.next();
                        if (rgCounter == 0) {
                            rangesCollection = document.createElement(namespace + "RangesCollection");
                            constraintDetails.appendChild(rangesCollection);
                        }
                        Element rangeDetails = document.createElement(namespace + "RangeDetails");
                        rangesCollection.appendChild(rangeDetails);
                        e = document.createElement(namespace + "RangeBeginValue");
                        e.appendChild(document.createTextNode(avt.getBeginValue()));
                        rangeDetails.appendChild(e);
                        e = document.createElement(namespace + "RangeEndValue");
                        e.appendChild(document.createTextNode(avt.getEndValue()));
                        rangeDetails.appendChild(e);
                        e = document.createElement(namespace + "RangeShortDescription");
                        e.appendChild(document.createTextNode(avt.getDescription()));
                        rangeDetails.appendChild(e);
                        ++rgCounter;
                    }
                    Element vlCollection = null;
                    int vlCounter = 0;
                    if (column.getValueList() != null) {
                        Iterator itVL = column.getValueIterator();
                        while (itVL.hasNext()) {
                            Object key = itVL.next();
                            String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                            if (vlCounter == 0) {
                                vlCollection = document.createElement(namespace + "ValueListsCollection");
                                constraintDetails.appendChild(vlCollection);
                            }
                            Element vlDetails = document.createElement(namespace + "ValueListDetails");
                            vlCollection.appendChild(vlDetails);
                            e = document.createElement(namespace + "VLValue");
                            e.appendChild(document.createTextNode(key.toString()));
                            vlDetails.appendChild(e);
                            e = document.createElement(namespace + "VLShortDescription");
                            e.appendChild(document.createTextNode(value));
                            vlDetails.appendChild(e);
                            ++vlCounter;
                        }
                    }
                    if (ccConstraint != null) {
                        Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                        constraintDetails.appendChild(ccCollection);
                        String generic = ccConstraint.getGenericConstraint();
                        if (!generic.trim().equalsIgnoreCase("")) {
                            Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                            ccCollection.appendChild(ccDetails);
                            Element ccText = document.createElement(namespace + "CheckConstraintText");
                            ccText.appendChild(document.createCDATASection(generic));
                            ccDetails.appendChild(ccText);
                            e = document.createElement(namespace + "DatabaseType");
                            e.appendChild(document.createTextNode("Generic Constraint"));
                            ccDetails.appendChild(e);
                        }
                        Object[] types = ccConstraint.getTypes();
                        for (int i = 0; i < types.length; ++i) {
                            RDBMSType rdbmsType = (RDBMSType)types[i];
                            String text = ccConstraint.getImplementationFor(rdbmsType);
                            if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                            Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                            ccCollection.appendChild(ccDetails);
                            Element ccText = document.createElement(namespace + "CheckConstraintText");
                            ccText.appendChild(document.createCDATASection(text));
                            ccDetails.appendChild(ccText);
                            e = document.createElement(namespace + "DatabaseType");
                            e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                            ccDetails.appendChild(e);
                        }
                    }
                    ++columnConstraintsCounter;
                }
            }
            if (reportTemplate.isUseTableFKReferringTo()) {
                this.processFKeysReferTo(table, document, e, namespace);
            }
            if (reportTemplate.isUseTableFKReferredFrom()) {
                this.processFKeysReferTo(table, document, e, namespace);
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during single table report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single table report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherAllTablesData(DesignPart model, StandardReportTemplate reportTemplate, List tables) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tables", "osdmAllTables:Tables");
            document.appendChild(rootElement);
            String namespace = "osdmAllTables:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode(model.getName()));
                rootElement.appendChild(e);
            }
            Element tablesCollection = document.createElement(namespace + "TablesCollection");
            rootElement.appendChild(tablesCollection);
            List currentObjectsList = new ArrayList();
            if (tables.size() != 0) {
                currentObjectsList = tables;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (Table table : currentObjectsList) {
                Element tableDetails = document.createElement(namespace + "TableDetails");
                tablesCollection.appendChild(tableDetails);
                e = document.createElement(namespace + "TableName");
                e.appendChild(document.createTextNode(table.getLongName()));
                tableDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedTableName");
                e.appendChild(document.createTextNode(table.getShortObjectID()));
                tableDetails.appendChild(e);
                e = document.createElement(namespace + "ObjectTypeName");
                e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
                tableDetails.appendChild(e);
                String description = "";
                description = table.getComment() == null || table.getComment().equals("") ? table.getCommentInRDBMS() : table.getComment();
                if (description != "" && description != null) {
                    Element descriptionElement = document.createElement(namespace + "Description");
                    descriptionElement.appendChild(document.createCDATASection(description));
                    tableDetails.appendChild(descriptionElement);
                }
                e = document.createElement(namespace + "MVPrebuilt");
                e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
                tableDetails.appendChild(e);
                if (table.getUserDefinedSQL() != null) {
                    e = document.createElement(namespace + "MVQuery");
                    e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                    tableDetails.appendChild(e);
                }
                if (reportTemplate.isUseTableColumns()) {
                    int columnsCounter = 0;
                    Element columnsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        String personalInfo;
                        if (columnsCounter == 0) {
                            columnsCollection = document.createElement(namespace + "ColumnsCollection");
                            tableDetails.appendChild(columnsCollection);
                        }
                        Element columnDetails = document.createElement(namespace + "ColumnDetails");
                        columnsCollection.appendChild(columnDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        String fk = column.isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                        e.appendChild(document.createTextNode(fk));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        columnDetails.appendChild(e);
                        String dataType = "";
                        String string = "";
                        String domainName = "";
                        switch (column.getUse()) {
                            case 0: {
                                String string2 = "DOM";
                                Domain dom = column.getDomain();
                                domainName = dom.getName();
                                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                                domainName = domainName.replace("Unknown", "");
                                domainName = domainName.replace("unknown", "");
                                domainName = domainName.replace("UNKNOWN", "");
                                break;
                            }
                            case 1: {
                                String string3 = "LT";
                                dataType = column.getNativeDataType();
                                break;
                            }
                            case 2: {
                                String string4 = "DT";
                                dataType = column.getDistinctType().getName();
                                break;
                            }
                            case 3: {
                                if (column.isReference()) {
                                    String string5 = "RST";
                                } else {
                                    String string6 = "ST";
                                }
                                dataType = column.getStructuredType().getName();
                                break;
                            }
                            case 4: {
                                String string7 = "CT";
                                dataType = column.getCollectionType().getName();
                            }
                        }
                        e = document.createElement(namespace + "DataType");
                        String ai = column.isAutoIncrementColumn() ? " - AI" : "";
                        String id = column.isIdentityColumn() ? " - ID" : "";
                        e.appendChild(document.createTextNode(dataType + ai + id));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "Formula");
                        e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                        columnDetails.appendChild(e);
                        Object security = "";
                        String string8 = column.isContainsPII() == null ? "" : (personalInfo = column.isContainsPII() != false ? "Y" : "");
                        String sensitiveInfo = column.isContainsSensitiveInformation() == null ? "" : (column.isContainsSensitiveInformation() != false ? "Y" : "");
                        String maskInfo = column.getMaskingType();
                        if (maskInfo == null) {
                            maskInfo = "";
                        }
                        security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                        security = ((String)security).replace("//", "");
                        e = document.createElement(namespace + "Security");
                        e.appendChild(document.createTextNode((String)security));
                        columnDetails.appendChild(e);
                        String columnDescription = "";
                        columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                        if (columnDescription != "" && columnDescription != null) {
                            Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                            columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                            columnDetails.appendChild(columnDescriptionElement);
                        }
                        ++columnsCounter;
                    }
                }
                if (reportTemplate.isUseTableIndexes()) {
                    int indesexCounter = 0;
                    HashMap<String, String> usedNames = new HashMap<String, String>();
                    Element indesexCollection = null;
                    Iterator iterator = table.getKeySet().iterator();
                    while (iterator.hasNext()) {
                        Index index = (Index)iterator.next();
                        if (index.isFK()) continue;
                        if (indesexCounter == 0) {
                            indesexCollection = document.createElement(namespace + "IndexesCollection");
                            tableDetails.appendChild(indesexCollection);
                        }
                        Iterator<ContainedObject> itIdxColumns = null;
                        if (index.hasIndexExpression()) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(" ");
                            itIdxColumns = list.iterator();
                        } else {
                            itIdxColumns = Arrays.asList(index.getElements()).iterator();
                        }
                        while (itIdxColumns.hasNext()) {
                            void var26_48;
                            Column col = null;
                            Object var26_45 = null;
                            ContainedObject obj = itIdxColumns.next();
                            if (obj instanceof Column) {
                                col = (Column)obj;
                                String string = col.getName();
                            } else {
                                String string = ((Object)obj).toString();
                            }
                            Element indexdetails = document.createElement(namespace + "IndexDetails");
                            indesexCollection.appendChild(indexdetails);
                            String state = index.getIndexState();
                            boolean nameUsed = false;
                            String cName = index.getName();
                            for (Map.Entry pair : usedNames.entrySet()) {
                                String name = (String)pair.getKey();
                                String st = (String)pair.getValue();
                                if (!name.equals(cName) || !st.equals(state)) continue;
                                nameUsed = true;
                                break;
                            }
                            if (!nameUsed) {
                                usedNames.put(cName, state);
                            }
                            e = document.createElement(namespace + "IndexName");
                            e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                            indexdetails.appendChild(e);
                            state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                            e = document.createElement(namespace + "IndexState");
                            e.appendChild(document.createTextNode(nameUsed ? "" : state));
                            indexdetails.appendChild(e);
                            e = document.createElement(namespace + "IndexFunctional");
                            e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                            indexdetails.appendChild(e);
                            e = document.createElement(namespace + "IndexSpatial");
                            e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                            indexdetails.appendChild(e);
                            e = document.createElement(namespace + "IndexExpression");
                            e.appendChild(document.createTextNode(index.getIndexExpression()));
                            indexdetails.appendChild(e);
                            e = document.createElement(namespace + "IndexColumnName");
                            e.appendChild(document.createTextNode((String)var26_48));
                            indexdetails.appendChild(e);
                            e = document.createElement(namespace + "IndexSortOrder");
                            if (col != null) {
                                e.appendChild(document.createTextNode(index.getColumnSortOrder(col)));
                            } else {
                                e.appendChild(document.createTextNode(" "));
                            }
                            indexdetails.appendChild(e);
                        }
                        ++indesexCounter;
                    }
                }
                if (reportTemplate.isUseTableConstraints()) {
                    int constraintsCounter = 0;
                    Element constraintsCollection = null;
                    Node tableLevelConstraintsCollection = null;
                    for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            tableDetails.appendChild(constraintsCollection);
                            tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                            constraintsCollection.appendChild(tableLevelConstraintsCollection);
                        }
                        Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                        tableLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "TLConstraintType");
                        e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "TLConstraintName");
                        e.appendChild(document.createTextNode(tlConstraint.getName()));
                        constraintDetails.appendChild(e);
                        Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                        tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                        constraintDetails.appendChild(tlConstraintElement);
                        ++constraintsCounter;
                    }
                    int columnConstraintsCounter = 0;
                    Element columnLevelConstraintsCollection = null;
                    for (Column column : Arrays.asList(table.getElements())) {
                        if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                        if (constraintsCounter == 0) {
                            constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                            tableDetails.appendChild(constraintsCollection);
                        }
                        if (columnConstraintsCounter == 0) {
                            columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                            constraintsCollection.appendChild(columnLevelConstraintsCollection);
                        }
                        Object constraintName = "";
                        CheckConstraint ccConstraint = column.getCheck();
                        if (ccConstraint != null && !((String)(constraintName = ccConstraint.getName())).equals("")) {
                            constraintName = " / " + (String)constraintName;
                        }
                        Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                        columnLevelConstraintsCollection.appendChild(constraintDetails);
                        e = document.createElement(namespace + "ContstraintType");
                        e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                        constraintDetails.appendChild(e);
                        e = document.createElement(namespace + "ALCConstraintName");
                        e.appendChild(document.createTextNode(column.getName() + (String)constraintName));
                        constraintDetails.appendChild(e);
                        Element rangesCollection = null;
                        Iterator itRanges = column.getAVTs().iterator();
                        int rgCounter = 0;
                        while (itRanges.hasNext()) {
                            AVT avt = (AVT)itRanges.next();
                            if (rgCounter == 0) {
                                rangesCollection = document.createElement(namespace + "RangesCollection");
                                constraintDetails.appendChild(rangesCollection);
                            }
                            Element rangeDetails = document.createElement(namespace + "RangeDetails");
                            rangesCollection.appendChild(rangeDetails);
                            e = document.createElement(namespace + "RangeBeginValue");
                            e.appendChild(document.createTextNode(avt.getBeginValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeEndValue");
                            e.appendChild(document.createTextNode(avt.getEndValue()));
                            rangeDetails.appendChild(e);
                            e = document.createElement(namespace + "RangeShortDescription");
                            e.appendChild(document.createTextNode(avt.getDescription()));
                            rangeDetails.appendChild(e);
                            ++rgCounter;
                        }
                        Element vlCollection = null;
                        int vlCounter = 0;
                        if (column.getValueList() != null) {
                            Iterator itVL = column.getValueIterator();
                            while (itVL.hasNext()) {
                                Object key = itVL.next();
                                String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                                if (vlCounter == 0) {
                                    vlCollection = document.createElement(namespace + "ValueListsCollection");
                                    constraintDetails.appendChild(vlCollection);
                                }
                                Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                vlCollection.appendChild(vlDetails);
                                e = document.createElement(namespace + "VLValue");
                                e.appendChild(document.createTextNode(key.toString()));
                                vlDetails.appendChild(e);
                                e = document.createElement(namespace + "VLShortDescription");
                                e.appendChild(document.createTextNode(value));
                                vlDetails.appendChild(e);
                                ++vlCounter;
                            }
                        }
                        if (ccConstraint != null) {
                            Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                            constraintDetails.appendChild(ccCollection);
                            String generic = ccConstraint.getGenericConstraint();
                            if (!generic.trim().equalsIgnoreCase("")) {
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(generic));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode("Generic Constraint"));
                                ccDetails.appendChild(e);
                            }
                            Object[] types = ccConstraint.getTypes();
                            for (int i = 0; i < types.length; ++i) {
                                RDBMSType rdbmsType = (RDBMSType)types[i];
                                String text = ccConstraint.getImplementationFor(rdbmsType);
                                if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                ccCollection.appendChild(ccDetails);
                                Element ccText = document.createElement(namespace + "CheckConstraintText");
                                ccText.appendChild(document.createCDATASection(text));
                                ccDetails.appendChild(ccText);
                                e = document.createElement(namespace + "DatabaseType");
                                e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                ccDetails.appendChild(e);
                            }
                        }
                        ++columnConstraintsCounter;
                    }
                }
                if (reportTemplate.isUseTableFKReferringTo()) {
                    this.processFKeysReferTo(table, document, tableDetails, namespace);
                }
                if (!reportTemplate.isUseTableFKReferredFrom()) continue;
                this.processFKeysReferFrom(table, document, tableDetails, namespace);
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all tables report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private int processFKeysReferFrom(FKContainer table, Document document, Element tableDetails, String namespace) {
        int fkCount = 0;
        Element e = null;
        Element fkCollection = null;
        FKIndexAssociationSet set = ((RelationalDesign)table.getDesignPart()).getFKIndexAssociationSet();
        for (FKIndexAssociation fk : set.getAssociationsWith(table)) {
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRFCollection");
                tableDetails.appendChild(fkCollection);
            }
            Element fkDetails = document.createElement(namespace + "FKRFDetails");
            fkCollection.appendChild(fkDetails);
            e = document.createElement(namespace + "FKName");
            e.appendChild(document.createTextNode(fk.getName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredFrom");
            e.appendChild(document.createTextNode(fk.getContainerWithKeyObject().getName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKMandatory");
            e.appendChild(document.createTextNode(fk.isMandatory() ? "Y" : ""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKTransferable");
            e.appendChild(document.createTextNode(fk.isTransferable() ? "Y" : ""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKInArc");
            e.appendChild(document.createTextNode(fk.getArc() != null ? "Y" : ""));
            fkDetails.appendChild(e);
            List<ContainedObject> rFKList = null;
            KeyObject ri = fk.getRemoteIndex();
            if (ri != null) {
                rFKList = Arrays.asList(ri.getElements());
            }
            List<ContainedObject> lFKList = Arrays.asList(fk.getLocalFKIndex().getElements());
            LinkedHashMap<FKElement, FKElement> fkColumnsMap = new LinkedHashMap<FKElement, FKElement>();
            for (int i = 0; i < lFKList.size(); ++i) {
                FKElement localColumn = (FKElement)lFKList.get(i);
                FKElement remoteColumn = null;
                if (rFKList != null) {
                    remoteColumn = (FKElement)rFKList.get(i);
                }
                fkColumnsMap.put(localColumn, remoteColumn);
            }
            Object columnsNames = "";
            Object refColumnsNames = "";
            for (Map.Entry pairs : fkColumnsMap.entrySet()) {
                FKElement lColumn = (FKElement)pairs.getKey();
                FKElement rColumn = (FKElement)pairs.getValue();
                if (lColumn != null) {
                    columnsNames = (String)columnsNames + "\n" + lColumn.getName();
                }
                if (rColumn == null) continue;
                refColumnsNames = (String)refColumnsNames + "\n" + rColumn.getName();
            }
            e = document.createElement(namespace + "FKColumnName");
            e.appendChild(document.createTextNode(((String)refColumnsNames).trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredColumnName");
            e.appendChild(document.createTextNode(((String)columnsNames).trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKDeleteRule");
            e.appendChild(document.createTextNode(fk.getDeleteRule().equals("NO ACTION") ? "" : fk.getDeleteRule()));
            fkDetails.appendChild(e);
            ++fkCount;
        }
        return fkCount;
    }

    /*
     * WARNING - void declaration
     */
    private int processFKeysReferTo(FKContainer table, Document document, Element tableDetails, String namespace) {
        Object columnsNames;
        Element fkDetails;
        int fkCount = 0;
        Element e = null;
        Element fkCollection = null;
        for (FKIndexAssociation fk : table.getFKAssociationsList()) {
            Object rFKList;
            KeyObject ri;
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRTCollection");
                tableDetails.appendChild(fkCollection);
            }
            if ((ri = fk.getRemoteIndex()) == null) {
                fkDetails = document.createElement(namespace + "FKRTDetails");
                fkCollection.appendChild(fkDetails);
                e = document.createElement(namespace + "FKName");
                e.appendChild(document.createTextNode(fk.getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferringTo");
                e.appendChild(document.createTextNode(fk.getReferredTableLongName()));
                fkDetails.appendChild(e);
                rFKList = fk.getReferredColumnNames();
                columnsNames = "";
                for (FKElement fKElement : Arrays.asList(fk.getLocalFKIndex().getElements())) {
                    if (fKElement == null) continue;
                    columnsNames = (String)columnsNames + "\n" + fKElement.getName();
                }
                e = document.createElement(namespace + "FKColumnName");
                e.appendChild(document.createTextNode(((String)columnsNames).trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferredColumnName");
                e.appendChild(document.createTextNode(((String)rFKList).replaceAll(",", "\n")));
                fkDetails.appendChild(e);
            } else {
                void var15_20;
                void var15_18;
                fkDetails = document.createElement(namespace + "FKRTDetails");
                fkCollection.appendChild(fkDetails);
                e = document.createElement(namespace + "FKName");
                e.appendChild(document.createTextNode(fk.getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferringTo");
                e.appendChild(document.createTextNode(fk.getRemoteTable().getName()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKMandatory");
                e.appendChild(document.createTextNode(fk.isMandatory() ? "Y" : ""));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKTransferable");
                e.appendChild(document.createTextNode(fk.isTransferable() ? "Y" : ""));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKInArc");
                e.appendChild(document.createTextNode(fk.getArc() != null ? "Y" : ""));
                fkDetails.appendChild(e);
                rFKList = Arrays.asList(ri.getElements());
                List<ContainedObject> lFKList = Arrays.asList(fk.getLocalFKIndex().getElements());
                LinkedHashMap<FKElement, FKElement> fkColumnsMap = new LinkedHashMap<FKElement, FKElement>();
                boolean bl = false;
                while (var15_18 < lFKList.size()) {
                    FKElement localColumn = (FKElement)lFKList.get((int)var15_18);
                    FKElement remoteColumn = null;
                    if (rFKList != null) {
                        remoteColumn = (FKElement)rFKList.get((int)var15_18);
                    }
                    fkColumnsMap.put(localColumn, remoteColumn);
                    ++var15_18;
                }
                String string = "";
                Object refColumnsNames = "";
                for (Map.Entry pairs : fkColumnsMap.entrySet()) {
                    FKElement lColumn = (FKElement)pairs.getKey();
                    FKElement rColumn = (FKElement)pairs.getValue();
                    if (lColumn != null) {
                        String string2 = (String)var15_20 + "\n" + lColumn.getName();
                    }
                    if (rColumn == null) continue;
                    refColumnsNames = (String)refColumnsNames + "\n" + rColumn.getName();
                }
                e = document.createElement(namespace + "FKColumnName");
                e.appendChild(document.createTextNode(var15_20.trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKReferredColumnName");
                e.appendChild(document.createTextNode(((String)refColumnsNames).trim()));
                fkDetails.appendChild(e);
                e = document.createElement(namespace + "FKDeleteRule");
                e.appendChild(document.createTextNode(fk.getDeleteRule().equals("NO ACTION") ? "" : fk.getDeleteRule()));
                fkDetails.appendChild(e);
            }
            ++fkCount;
        }
        for (Join join : table.getImpliedFKeys()) {
            if (fkCount == 0) {
                fkCollection = document.createElement(namespace + "FKRTCollection");
                tableDetails.appendChild(fkCollection);
            }
            fkDetails = document.createElement(namespace + "FKRTDetails");
            fkCollection.appendChild(fkDetails);
            e = document.createElement(namespace + "FKName");
            Object nameText = "implied Fkey - source:\n";
            nameText = (String)nameText + join.getFormattedDiscoverySource();
            e.appendChild(document.createTextNode((String)nameText));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferringTo");
            e.appendChild(document.createTextNode(join.getRefTableLongName()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKMandatory");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKTransferable");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKInArc");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
            columnsNames = join.getColumnName();
            String refColumnsNames = join.getRefColumnName();
            e = document.createElement(namespace + "FKColumnName");
            e.appendChild(document.createTextNode(((String)columnsNames).trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKReferredColumnName");
            e.appendChild(document.createTextNode(refColumnsNames.trim()));
            fkDetails.appendChild(e);
            e = document.createElement(namespace + "FKDeleteRule");
            e.appendChild(document.createTextNode(""));
            fkDetails.appendChild(e);
        }
        return fkCount;
    }

    private Document gatherSingleCollectionTypeData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontype", "osdmSingleCollectionType:CollectionType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleCollectionType:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element e = document.createElement(namespace + "DesignName");
            e.appendChild(document.createTextNode(this.design.getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "VersionDate");
            e.appendChild(document.createTextNode(dateFormat.format(new Date())));
            rootElement.appendChild(e);
            Object descriptionNotesIterator = null;
            String designComment = this.design.getComment();
            if (designComment != "" && designComment != null) {
                Element versionCommentElement = document.createElement(namespace + "VersionComment");
                versionCommentElement.appendChild(document.createCDATASection(designComment));
                rootElement.appendChild(versionCommentElement);
            }
            e = document.createElement(namespace + "ModelName");
            e.appendChild(document.createTextNode(model.getName()));
            rootElement.appendChild(e);
            CollectionType collectionType = (CollectionType)collectionTypes.get(0);
            if (reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                description = collectionType.getComment() == null || collectionType.getComment().equals("") ? collectionType.getCommentInRDBMS() : collectionType.getComment();
                String notes = collectionType.getNotes();
                if (description != "" && description != null || notes != "" && notes != null) {
                    Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    if (notes != "" && notes != null) {
                        Element notesElement = document.createElement(namespace + "Notes");
                        notesElement.appendChild(document.createCDATASection(notes));
                        descriptionNotesElement.appendChild(notesElement);
                    }
                    rootElement.appendChild(descriptionNotesElement);
                }
            }
            e = document.createElement(namespace + "CTName");
            e.appendChild(document.createTextNode(collectionType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTType");
            e.appendChild(document.createTextNode(collectionType.getType()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTMaxElements");
            e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
            rootElement.appendChild(e);
            String dataType = "";
            String dataTypeKind = "";
            String domainName = "";
            DesignObject dtType = collectionType.getDataType();
            if (dtType instanceof Domain) {
                dataTypeKind = "DOM";
                Domain dom = (Domain)dtType;
                domainName = dom.getName();
                dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                domainName = domainName.replace("Unknown", "");
                domainName = domainName.replace("unknown", "");
                domainName = domainName.replace("UNKNOWN", "");
            } else if (dtType instanceof LogicalDatatype) {
                dataTypeKind = "LT";
                LogicalDatatype lt = (LogicalDatatype)dtType;
                dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
            } else if (dtType instanceof DistinctType) {
                dataTypeKind = "DT";
            } else if (dtType instanceof StructuredType) {
                dataTypeKind = "ST";
            } else if (dtType instanceof CollectionType) {
                dataTypeKind = "CT";
            }
            e = document.createElement(namespace + "CTDataType");
            e.appendChild(document.createTextNode(dataType));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDataTypeKind");
            e.appendChild(document.createTextNode(dataTypeKind));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "CTDomainName");
            e.appendChild(document.createTextNode(domainName));
            rootElement.appendChild(e);
            boolean create_header = true;
            Element tablesCollection = null;
            ArrayList<String> modelUsedNames = new ArrayList<String>();
            ArrayList<String> tableUsedNames = new ArrayList<String>();
            if (reportTemplate.isUseCTUsedInTables()) {
                RelationalDesignSet rds = this.design.getRelationalDesigns();
                for (RelationalDesign rd : rds) {
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 4 || column.getCollectionType() != collectionType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                rootElement.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during single collection type report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllCollectionTypesData(DesignPart model, StandardReportTemplate reportTemplate, List collectionTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/collectiontypes", "osdmAllCollectionTypes:CollectionTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllCollectionTypes:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            Object descriptionNotesIterator = null;
            Iterator relationalDesignsIterator = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                descriptionNotesIterator = null;
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode(model.getName()));
                rootElement.appendChild(e);
                relationalDesignsIterator = this.design.getRelationalDesigns().iterator();
            }
            Element ctCollection = document.createElement(namespace + "CTCollection");
            rootElement.appendChild(ctCollection);
            List currentObjectsList = new ArrayList();
            if (collectionTypes.size() > 0) {
                currentObjectsList = collectionTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (CollectionType collectionType : currentObjectsList) {
                Element ctDetails = document.createElement(namespace + "CTDetails");
                ctCollection.appendChild(ctDetails);
                if (reportTemplate.isUseDescriptionInfo()) {
                    String description = "";
                    description = collectionType.getComment() == null || collectionType.getComment().equals("") ? collectionType.getCommentInRDBMS() : collectionType.getComment();
                    String notes = collectionType.getNotes();
                    if (description != "" && description != null || notes != "" && notes != null) {
                        Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                        if (description != "" && description != null) {
                            Element descriptionElement = document.createElement(namespace + "Description");
                            descriptionElement.appendChild(document.createCDATASection(description));
                            descriptionNotesElement.appendChild(descriptionElement);
                        }
                        if (notes != "" && notes != null) {
                            Element notesElement = document.createElement(namespace + "Notes");
                            notesElement.appendChild(document.createCDATASection(notes));
                            descriptionNotesElement.appendChild(notesElement);
                        }
                        ctDetails.appendChild(descriptionNotesElement);
                    }
                }
                e = document.createElement(namespace + "CTName");
                e.appendChild(document.createTextNode(collectionType.getLongName()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTType");
                e.appendChild(document.createTextNode(collectionType.getType()));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTMaxElements");
                e.appendChild(document.createTextNode(Integer.valueOf(collectionType.getMaxElement()).toString()));
                ctDetails.appendChild(e);
                String dataType = "";
                String dataTypeKind = "";
                String domainName = "";
                DesignObject dtType = collectionType.getDataType();
                if (dtType instanceof Domain) {
                    dataTypeKind = "DOM";
                    Domain dom = (Domain)dtType;
                    domainName = dom.getName();
                    dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                    domainName = domainName.replace("Unknown", "");
                    domainName = domainName.replace("unknown", "");
                    domainName = domainName.replace("UNKNOWN", "");
                } else if (dtType instanceof LogicalDatatype) {
                    dataTypeKind = "LT";
                    LogicalDatatype lt = (LogicalDatatype)dtType;
                    dataType = this.getSizePrecisionScale(collectionType.getElementType(), lt.getName());
                } else if (dtType instanceof DistinctType) {
                    dataTypeKind = "DT";
                } else if (dtType instanceof StructuredType) {
                    dataTypeKind = "ST";
                } else if (dtType instanceof CollectionType) {
                    dataTypeKind = "CT";
                }
                e = document.createElement(namespace + "CTDataType");
                e.appendChild(document.createTextNode(dataType));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDataTypeKind");
                e.appendChild(document.createTextNode(dataTypeKind));
                ctDetails.appendChild(e);
                e = document.createElement(namespace + "CTDomainName");
                e.appendChild(document.createTextNode(domainName));
                ctDetails.appendChild(e);
                boolean create_header = true;
                Element tablesCollection = null;
                ArrayList<String> modelUsedNames = new ArrayList<String>();
                ArrayList<String> tableUsedNames = new ArrayList<String>();
                if (!reportTemplate.isUseCTUsedInTables()) continue;
                while (relationalDesignsIterator.hasNext()) {
                    RelationalDesign rd = (RelationalDesign)relationalDesignsIterator.next();
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 4 || column.getCollectionType() != collectionType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                ctDetails.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all collection type report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all collection type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private Document gatherSingleStructuredTypeData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtype", "osdmSingleStructuredType:StructuredType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleStructuredType:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element e = document.createElement(namespace + "DesignName");
            e.appendChild(document.createTextNode(this.design.getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "VersionDate");
            e.appendChild(document.createTextNode(dateFormat.format(new Date())));
            rootElement.appendChild(e);
            Iterator<String> descriptionNotesIterator = null;
            String designComment = this.design.getComment();
            if (designComment != "" && designComment != null) {
                Element versionCommentElement = document.createElement(namespace + "VersionComment");
                versionCommentElement.appendChild(document.createCDATASection(designComment));
                rootElement.appendChild(versionCommentElement);
            }
            e = document.createElement(namespace + "ModelName");
            e.appendChild(document.createTextNode(model.getName()));
            rootElement.appendChild(e);
            StructuredType structuredType = (StructuredType)structuredTypes.get(0);
            e = document.createElement(namespace + "STName");
            e.appendChild(document.createTextNode(structuredType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "STSuperType");
            e.appendChild(document.createTextNode(structuredType.getParentType() != null ? structuredType.getParentType().getName() : ""));
            rootElement.appendChild(e);
            if (reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                description = structuredType.getComment() == null || structuredType.getComment().equals("") ? structuredType.getCommentInRDBMS() : structuredType.getComment();
                String notes = structuredType.getNotes();
                if (description != "" && description != null || notes != "" && notes != null) {
                    Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    if (notes != "" && notes != null) {
                        Element notesElement = document.createElement(namespace + "Notes");
                        notesElement.appendChild(document.createCDATASection(notes));
                        descriptionNotesElement.appendChild(notesElement);
                    }
                    rootElement.appendChild(descriptionNotesElement);
                }
            }
            if (reportTemplate.isUseSTAttributes()) {
                int attrCount = 0;
                Element attributesCollection = null;
                for (TypeElement attribute : Arrays.asList(structuredType.getElements())) {
                    if (attrCount == 0) {
                        attributesCollection = document.createElement(namespace + "AttributesCollection");
                        rootElement.appendChild(attributesCollection);
                    }
                    Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                    attributesCollection.appendChild(attributeDetails);
                    e = document.createElement(namespace + "Sequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attrCount + 1).toString()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "M");
                    e.appendChild(document.createTextNode(attribute.isMandatory() ? "Y" : ""));
                    attributeDetails.appendChild(e);
                    String dataType = "";
                    String dataTypeKind = "";
                    String domainName = "";
                    DesignObject dtType = attribute.getType();
                    if (dtType instanceof Domain) {
                        dataTypeKind = "DOM";
                        Domain dom = attribute.getDomain();
                        domainName = attribute.getType().getName();
                        dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                        domainName = domainName.replace("Unknown", "");
                        domainName = domainName.replace("unknown", "");
                        domainName = domainName.replace("UNKNOWN", "");
                    } else if (dtType instanceof LogicalDatatype) {
                        dataTypeKind = "LT";
                        dataType = this.getSizePrecisionScale(attribute, attribute.getType().getName());
                    } else if (dtType instanceof DistinctType) {
                        dataTypeKind = "DT";
                    } else if (dtType instanceof StructuredType) {
                        dataTypeKind = "ST";
                    } else if (dtType instanceof CollectionType) {
                        dataTypeKind = "CT";
                    }
                    e = document.createElement(namespace + "DataType");
                    e.appendChild(document.createTextNode(dataType));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DataTypeKind");
                    e.appendChild(document.createTextNode(dataTypeKind));
                    attributeDetails.appendChild(e);
                    e = document.createElement(namespace + "DomainName");
                    e.appendChild(document.createTextNode(domainName));
                    attributeDetails.appendChild(e);
                    ++attrCount;
                }
            }
            if (reportTemplate.isUseSTAttributesComments()) {
                int attributeCommentsCounter = 0;
                Element attributesCommentsCollection = null;
                for (TypeElement attribute : structuredType.getAttributesList()) {
                    void var25_36;
                    String attributeDescription = "";
                    attributeDescription = attribute.getComment() == null || attribute.getComment().equals("") ? attribute.getCommentInRDBMS() : attribute.getComment();
                    String attributeNotes = attribute.getNotes();
                    if ((attributeDescription == null || attributeDescription.equals("")) && (attributeNotes == null || attributeNotes.equals(""))) continue;
                    if (attributeCommentsCounter == 0) {
                        attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                        rootElement.appendChild(attributesCommentsCollection);
                    }
                    Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                    attributesCommentsCollection.appendChild(attributeCommentsDetails);
                    e = document.createElement(namespace + "AttributeCommentsSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(attributeCommentsCounter + 1).toString()));
                    attributeCommentsDetails.appendChild(e);
                    e = document.createElement(namespace + "AttributeCommentsName");
                    e.appendChild(document.createTextNode(attribute.getName()));
                    attributeCommentsDetails.appendChild(e);
                    Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                    columnDescriptionElement.appendChild(document.createCDATASection(attributeDescription));
                    attributeCommentsDetails.appendChild(columnDescriptionElement);
                    Element attributeNotesElement = document.createElement(namespace + "AttributeNotes");
                    Element attributeNotesDetailsElement = document.createElement(namespace + "AttributeNotesDetails");
                    Object var25_35 = null;
                    for (String s : Arrays.asList(attributeNotes.split("\\n"))) {
                        Element element = document.createElement(namespace + "AttributeNoteRow");
                        element.appendChild(document.createTextNode(s));
                        attributeNotesDetailsElement.appendChild(element);
                    }
                    if (var25_36 == null) {
                        Element element = document.createElement(namespace + "AttributeNoteRow");
                        element.appendChild(document.createTextNode(""));
                        attributeNotesDetailsElement.appendChild(element);
                    }
                    attributeNotesElement.appendChild(attributeNotesDetailsElement);
                    attributeCommentsDetails.appendChild(attributeNotesElement);
                    ++attributeCommentsCounter;
                }
            }
            if (reportTemplate.isUseSTMethods()) {
                int methodsCounter = 0;
                Element methodsCollection = null;
                for (Method method : structuredType.getMethodsList()) {
                    if (methodsCounter == 0) {
                        methodsCollection = document.createElement(namespace + "MethodsCollection");
                        rootElement.appendChild(methodsCollection);
                    }
                    Element methodDetails = document.createElement(namespace + "MethodDetails");
                    methodsCollection.appendChild(methodDetails);
                    e = document.createElement(namespace + "MethodSequence");
                    e.appendChild(document.createTextNode(Integer.valueOf(methodsCounter + 1).toString()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodName");
                    e.appendChild(document.createTextNode(method.getName()));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodConstructor");
                    e.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverriding");
                    e.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodOverridenMethod");
                    e.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                    methodDetails.appendChild(e);
                    e = document.createElement(namespace + "MethodReturnValue");
                    e.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                    methodDetails.appendChild(e);
                    int paramCounter = 0;
                    Element methodsParamsCollection = null;
                    for (MethodParam param : method.getParameters()) {
                        if (paramCounter == 0) {
                            methodsParamsCollection = document.createElement(namespace + "MethodParametersCollection");
                            methodDetails.appendChild(methodsParamsCollection);
                        }
                        Element methodParamsDetails = document.createElement(namespace + "MethodParameterDetails");
                        methodsParamsCollection.appendChild(methodParamsDetails);
                        e = document.createElement(namespace + "ParameterName");
                        e.appendChild(document.createTextNode(param.getName()));
                        methodParamsDetails.appendChild(e);
                        e = document.createElement(namespace + "ParameterType");
                        e.appendChild(document.createTextNode(param.getDataType()));
                        methodParamsDetails.appendChild(e);
                        ++paramCounter;
                    }
                    ++methodsCounter;
                }
            }
            boolean create_header = true;
            Element tablesCollection = null;
            ArrayList<String> modelUsedNames = new ArrayList<String>();
            ArrayList<String> tableUsedNames = new ArrayList<String>();
            if (reportTemplate.isUseSTUsedInTables()) {
                RelationalDesignSet rds = this.design.getRelationalDesigns();
                for (RelationalDesign rd : rds) {
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 3 || column.getStructuredType() != structuredType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                rootElement.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during single structured type report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single structured type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllStructuredTypesData(DesignPart model, StandardReportTemplate reportTemplate, List structuredTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/structuredtypes", "osdmAllStructuredTypes:StructuredTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllStructuredTypes:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            Iterator<String> descriptionNotesIterator = null;
            Iterator relationalDesignsIterator = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                descriptionNotesIterator = null;
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode(model.getName()));
                rootElement.appendChild(e);
                relationalDesignsIterator = this.design.getRelationalDesigns().iterator();
            }
            Element stCollection = document.createElement(namespace + "STCollection");
            rootElement.appendChild(stCollection);
            List currentObjectsList = new ArrayList();
            if (structuredTypes.size() > 0) {
                currentObjectsList = structuredTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (StructuredType structuredType : currentObjectsList) {
                Element stDetails = document.createElement(namespace + "STDetails");
                stCollection.appendChild(stDetails);
                e = document.createElement(namespace + "STName");
                e.appendChild(document.createTextNode(structuredType.getLongName()));
                stDetails.appendChild(e);
                e = document.createElement(namespace + "STSuperType");
                e.appendChild(document.createTextNode(structuredType.getParentType() != null ? structuredType.getParentType().getName() : ""));
                stDetails.appendChild(e);
                if (reportTemplate.isUseDescriptionInfo()) {
                    String description = "";
                    description = structuredType.getComment() == null || structuredType.getComment().equals("") ? structuredType.getCommentInRDBMS() : structuredType.getComment();
                    String notes = structuredType.getNotes();
                    if (description != "" && description != null || notes != "" && notes != null) {
                        Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                        if (description != "" && description != null) {
                            Element descriptionElement = document.createElement(namespace + "Description");
                            descriptionElement.appendChild(document.createCDATASection(description));
                            descriptionNotesElement.appendChild(descriptionElement);
                        }
                        if (notes != "" && notes != null) {
                            Element notesElement = document.createElement(namespace + "Notes");
                            notesElement.appendChild(document.createCDATASection(notes));
                            descriptionNotesElement.appendChild(notesElement);
                        }
                        stDetails.appendChild(descriptionNotesElement);
                    }
                }
                if (reportTemplate.isUseSTAttributes()) {
                    int attrCount = 0;
                    Element attributesCollection = null;
                    for (TypeElement attribute : Arrays.asList(structuredType.getElements())) {
                        if (attrCount == 0) {
                            attributesCollection = document.createElement(namespace + "AttributesCollection");
                            stDetails.appendChild(attributesCollection);
                        }
                        Element attributeDetails = document.createElement(namespace + "AttributeDetails");
                        attributesCollection.appendChild(attributeDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(attrCount + 1).toString()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeName");
                        e.appendChild(document.createTextNode(attribute.getName()));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(attribute.isMandatory() ? "Y" : ""));
                        attributeDetails.appendChild(e);
                        String dataType = "";
                        String dataTypeKind = "";
                        String domainName = "";
                        DesignObject designObject = attribute.getType();
                        if (designObject instanceof Domain) {
                            dataTypeKind = "DOM";
                            Domain dom = attribute.getDomain();
                            domainName = attribute.getType().getName();
                            dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                            domainName = domainName.replace("Unknown", "");
                            domainName = domainName.replace("unknown", "");
                            domainName = domainName.replace("UNKNOWN", "");
                        } else if (designObject instanceof LogicalDatatype) {
                            dataTypeKind = "LT";
                            dataType = this.getSizePrecisionScale(attribute, attribute.getType().getName());
                        } else if (designObject instanceof DistinctType) {
                            dataTypeKind = "DT";
                        } else if (designObject instanceof StructuredType) {
                            dataTypeKind = "ST";
                        } else if (designObject instanceof CollectionType) {
                            dataTypeKind = "CT";
                        }
                        e = document.createElement(namespace + "DataType");
                        e.appendChild(document.createTextNode(dataType));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DataTypeKind");
                        e.appendChild(document.createTextNode(dataTypeKind));
                        attributeDetails.appendChild(e);
                        e = document.createElement(namespace + "DomainName");
                        e.appendChild(document.createTextNode(domainName));
                        attributeDetails.appendChild(e);
                        ++attrCount;
                    }
                }
                if (reportTemplate.isUseSTAttributesComments()) {
                    int attributeCommentsCounter = 0;
                    Element attributesCommentsCollection = null;
                    for (TypeElement attribute : structuredType.getAttributesList()) {
                        String attributeDescription = "";
                        attributeDescription = attribute.getComment() == null || attribute.getComment().equals("") ? attribute.getCommentInRDBMS() : attribute.getComment();
                        String attributeNotes = attribute.getNotes();
                        if ((attributeDescription == null || attributeDescription.equals("")) && (attributeNotes == null || attributeNotes.equals(""))) continue;
                        if (attributeCommentsCounter == 0) {
                            attributesCommentsCollection = document.createElement(namespace + "AttributesCommentsCollection");
                            stDetails.appendChild(attributesCommentsCollection);
                        }
                        Element attributeCommentsDetails = document.createElement(namespace + "AttributeCommentsDetails");
                        attributesCommentsCollection.appendChild(attributeCommentsDetails);
                        e = document.createElement(namespace + "AttributeCommentsSequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(attributeCommentsCounter + 1).toString()));
                        attributeCommentsDetails.appendChild(e);
                        e = document.createElement(namespace + "AttributeCommentsName");
                        e.appendChild(document.createTextNode(attribute.getName()));
                        attributeCommentsDetails.appendChild(e);
                        Element columnDescriptionElement = document.createElement(namespace + "AttributeDescription");
                        columnDescriptionElement.appendChild(document.createCDATASection(attributeDescription));
                        attributeCommentsDetails.appendChild(columnDescriptionElement);
                        Element element = document.createElement(namespace + "AttributeNotes");
                        Element attributeNotesDetailsElement = document.createElement(namespace + "AttributeNotesDetails");
                        Element attributeNotesRowElement = null;
                        for (String s : Arrays.asList(attributeNotes.split("\\n"))) {
                            attributeNotesRowElement = document.createElement(namespace + "AttributeNoteRow");
                            attributeNotesRowElement.appendChild(document.createTextNode(s));
                            attributeNotesDetailsElement.appendChild(attributeNotesRowElement);
                        }
                        if (attributeNotesRowElement == null) {
                            attributeNotesRowElement = document.createElement(namespace + "AttributeNoteRow");
                            attributeNotesRowElement.appendChild(document.createTextNode(""));
                            attributeNotesDetailsElement.appendChild(attributeNotesRowElement);
                        }
                        element.appendChild(attributeNotesDetailsElement);
                        attributeCommentsDetails.appendChild(element);
                        ++attributeCommentsCounter;
                    }
                }
                if (reportTemplate.isUseSTMethods()) {
                    int methodsCounter = 0;
                    Element methodsCollection = null;
                    for (Method method : structuredType.getMethodsList()) {
                        if (methodsCounter == 0) {
                            methodsCollection = document.createElement(namespace + "MethodsCollection");
                            stDetails.appendChild(methodsCollection);
                        }
                        Element methodDetails = document.createElement(namespace + "MethodDetails");
                        methodsCollection.appendChild(methodDetails);
                        e = document.createElement(namespace + "MethodSequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(methodsCounter + 1).toString()));
                        methodDetails.appendChild(e);
                        e = document.createElement(namespace + "MethodName");
                        e.appendChild(document.createTextNode(method.getName()));
                        methodDetails.appendChild(e);
                        e = document.createElement(namespace + "MethodConstructor");
                        e.appendChild(document.createTextNode(method.isConstructor() ? "Y" : ""));
                        methodDetails.appendChild(e);
                        e = document.createElement(namespace + "MethodOverriding");
                        e.appendChild(document.createTextNode(method.isOverriding() ? "Y" : ""));
                        methodDetails.appendChild(e);
                        e = document.createElement(namespace + "MethodOverridenMethod");
                        e.appendChild(document.createTextNode(method.getOverridedMethod() != null ? method.getOverridedMethod().getName() : ""));
                        methodDetails.appendChild(e);
                        e = document.createElement(namespace + "MethodReturnValue");
                        e.appendChild(document.createTextNode(method.getReturnValue() != null ? method.getReturnValue().getDataType() : ""));
                        methodDetails.appendChild(e);
                        int paramCounter = 0;
                        Element methodsParamsCollection = null;
                        for (MethodParam methodParam : method.getParameters()) {
                            if (paramCounter == 0) {
                                methodsParamsCollection = document.createElement(namespace + "MethodParametersCollection");
                                methodDetails.appendChild(methodsParamsCollection);
                            }
                            Element methodParamsDetails = document.createElement(namespace + "MethodParameterDetails");
                            methodsParamsCollection.appendChild(methodParamsDetails);
                            e = document.createElement(namespace + "ParameterName");
                            e.appendChild(document.createTextNode(methodParam.getName()));
                            methodParamsDetails.appendChild(e);
                            e = document.createElement(namespace + "ParameterType");
                            e.appendChild(document.createTextNode(methodParam.getDataType()));
                            methodParamsDetails.appendChild(e);
                            ++paramCounter;
                        }
                        ++methodsCounter;
                    }
                }
                boolean create_header = true;
                Element tablesCollection = null;
                ArrayList<String> modelUsedNames = new ArrayList<String>();
                ArrayList<String> tableUsedNames = new ArrayList<String>();
                if (!reportTemplate.isUseSTUsedInTables()) continue;
                while (relationalDesignsIterator.hasNext()) {
                    RelationalDesign rd = (RelationalDesign)relationalDesignsIterator.next();
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 3 || column.getStructuredType() != structuredType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                stDetails.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all structured types report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all structured types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherSingleDistinctTypeData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttype", "osdmSingleDistinctType:DistinctType");
            document.appendChild(rootElement);
            String namespace = "osdmSingleDistinctType:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element e = document.createElement(namespace + "DesignName");
            e.appendChild(document.createTextNode(this.design.getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "VersionDate");
            e.appendChild(document.createTextNode(dateFormat.format(new Date())));
            rootElement.appendChild(e);
            Object descriptionNotesIterator = null;
            String designComment = this.design.getComment();
            if (designComment != "" && designComment != null) {
                Element versionCommentElement = document.createElement(namespace + "VersionComment");
                versionCommentElement.appendChild(document.createCDATASection(designComment));
                rootElement.appendChild(versionCommentElement);
            }
            e = document.createElement(namespace + "ModelName");
            e.appendChild(document.createTextNode(model.getName()));
            rootElement.appendChild(e);
            DistinctType distinctType = (DistinctType)distinctTypes.get(0);
            e = document.createElement(namespace + "DTName");
            e.appendChild(document.createTextNode(distinctType.getLongName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTLogicalType");
            e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTSize");
            String sz = distinctType.getSize();
            if (sz != null) {
                e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
            } else {
                e.appendChild(document.createTextNode(""));
            }
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTPrecision");
            int p = distinctType.getPrecision();
            e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
            rootElement.appendChild(e);
            e = document.createElement(namespace + "DTScale");
            int s = distinctType.getScale();
            e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
            rootElement.appendChild(e);
            if (reportTemplate.isUseDescriptionInfo()) {
                String description = "";
                description = distinctType.getComment() == null || distinctType.getComment().equals("") ? distinctType.getCommentInRDBMS() : distinctType.getComment();
                String notes = distinctType.getNotes();
                if (description != "" && description != null || notes != "" && notes != null) {
                    Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        descriptionNotesElement.appendChild(descriptionElement);
                    }
                    if (notes != "" && notes != null) {
                        Element notesElement = document.createElement(namespace + "Notes");
                        notesElement.appendChild(document.createCDATASection(notes));
                        descriptionNotesElement.appendChild(notesElement);
                    }
                    rootElement.appendChild(descriptionNotesElement);
                }
            }
            boolean create_header = true;
            Element tablesCollection = null;
            ArrayList<String> modelUsedNames = new ArrayList<String>();
            ArrayList<String> tableUsedNames = new ArrayList<String>();
            if (reportTemplate.isUseDTUsedInTables()) {
                RelationalDesignSet rds = this.design.getRelationalDesigns();
                for (RelationalDesign rd : rds) {
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 2 || column.getDistinctType() != distinctType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                rootElement.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during single distinct type report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during single distinct type report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document gatherAllDistinctTypesData(DesignPart model, StandardReportTemplate reportTemplate, List distinctTypes) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/distincttypes", "osdmAllDistinctTypes:DistinctTypes");
            document.appendChild(rootElement);
            String namespace = "osdmAllDistinctTypes:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            Object descriptionNotesIterator = null;
            Iterator relationalDesignsIterator = null;
            Object allEntitiesIterator = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                descriptionNotesIterator = null;
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode("Data Types"));
                rootElement.appendChild(e);
                relationalDesignsIterator = this.design.getRelationalDesigns().iterator();
            }
            Element dtCollection = document.createElement(namespace + "DTCollection");
            rootElement.appendChild(dtCollection);
            List currentObjectsList = new ArrayList();
            if (distinctTypes.size() > 0) {
                currentObjectsList = distinctTypes;
            } else {
                Iterator it0 = this.design.getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (DistinctType distinctType : currentObjectsList) {
                Element dtDetails = document.createElement(namespace + "DTDetails");
                dtCollection.appendChild(dtDetails);
                e = document.createElement(namespace + "DTName");
                e.appendChild(document.createTextNode(distinctType.getLongName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTLogicalType");
                e.appendChild(document.createTextNode(distinctType.getLogicalDataType().getName()));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTSize");
                String sz = distinctType.getSize();
                if (sz != null) {
                    e.appendChild(document.createTextNode(!sz.equals("") && !sz.equals("0") ? distinctType.getSize() : ""));
                } else {
                    e.appendChild(document.createTextNode(""));
                }
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTPrecision");
                int p = distinctType.getPrecision();
                e.appendChild(document.createTextNode(p > 0 ? Integer.valueOf(distinctType.getPrecision()).toString() : ""));
                dtDetails.appendChild(e);
                e = document.createElement(namespace + "DTScale");
                int s = distinctType.getScale();
                e.appendChild(document.createTextNode(s > 0 ? Integer.valueOf(distinctType.getScale()).toString() : ""));
                dtDetails.appendChild(e);
                if (reportTemplate.isUseDescriptionInfo()) {
                    String description = "";
                    description = distinctType.getComment() == null || distinctType.getComment().equals("") ? distinctType.getCommentInRDBMS() : distinctType.getComment();
                    String notes = distinctType.getNotes();
                    if (description != "" && description != null || notes != "" && notes != null) {
                        Element descriptionNotesElement = document.createElement(namespace + "DescriptionNotes");
                        if (description != "" && description != null) {
                            Element descriptionElement = document.createElement(namespace + "Description");
                            descriptionElement.appendChild(document.createCDATASection(description));
                            descriptionNotesElement.appendChild(descriptionElement);
                        }
                        if (notes != "" && notes != null) {
                            Element notesElement = document.createElement(namespace + "Notes");
                            notesElement.appendChild(document.createCDATASection(notes));
                            descriptionNotesElement.appendChild(notesElement);
                        }
                        dtDetails.appendChild(descriptionNotesElement);
                    }
                }
                boolean create_header = true;
                Element tablesCollection = null;
                ArrayList<String> modelUsedNames = new ArrayList<String>();
                ArrayList<String> tableUsedNames = new ArrayList<String>();
                if (!reportTemplate.isUseDTUsedInTables()) continue;
                while (relationalDesignsIterator.hasNext()) {
                    RelationalDesign rd = (RelationalDesign)relationalDesignsIterator.next();
                    Iterator itAllTables = rd.getTableSet().iterator();
                    while (itAllTables.hasNext()) {
                        Table table = (Table)itAllTables.next();
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getUse() != 2 || column.getDistinctType() != distinctType) continue;
                            if (create_header) {
                                tablesCollection = document.createElement(namespace + "TablesCollection");
                                dtDetails.appendChild(tablesCollection);
                                create_header = false;
                            }
                            Element tableDetails = document.createElement(namespace + "TableDetails");
                            tablesCollection.appendChild(tableDetails);
                            boolean modelNameUsed = false;
                            String cName = rd.getName();
                            for (String name : modelUsedNames) {
                                if (!name.equals(cName)) continue;
                                modelNameUsed = true;
                                break;
                            }
                            if (!modelNameUsed) {
                                modelUsedNames.add(cName);
                            }
                            boolean tableNameUsed = false;
                            String tName = table.getLongName();
                            for (String name : tableUsedNames) {
                                if (!name.equals(tName)) continue;
                                tableNameUsed = true;
                                break;
                            }
                            if (!tableNameUsed) {
                                tableUsedNames.add(tName);
                            }
                            e = document.createElement(namespace + "ModelName");
                            e.appendChild(document.createTextNode(modelNameUsed ? "" : rd.getName()));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "TableName");
                            e.appendChild(document.createTextNode(!tableNameUsed ? table.getLongName() : ""));
                            tableDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            tableDetails.appendChild(e);
                        }
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all distinct types report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all distinct types report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private Document generateSearchResultsDomDocument(CustomReportTemplate crt, ModelIDObject model, List objects, HashMap extraParams) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/searchresults", "osdmSearchResults:SearchResults");
            document.appendChild(rootElement);
            String namespace = "osdmSearchResults:";
            Element rCaption = document.createElement(namespace + "title");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            boolean showFilter = (Boolean)extraParams.get("show");
            Element objShowFilter = document.createElement(namespace + "showFilter");
            objShowFilter.appendChild(document.createTextNode(((Boolean)extraParams.get("show")).toString()));
            rootElement.appendChild(objShowFilter);
            Element objPattern = document.createElement(namespace + "pattern");
            objPattern.appendChild(document.createTextNode((String)extraParams.get("pattern")));
            rootElement.appendChild(objPattern);
            if (showFilter) {
                Element objFilter = document.createElement(namespace + "filter");
                objFilter.appendChild(document.createTextNode(((SearchSet)extraParams.get("filterObject")).getTypeName() + " " + model.getName()));
                rootElement.appendChild(objFilter);
            }
            Element tableWidth = document.createElement(namespace + "tw");
            rootElement.appendChild(tableWidth);
            Element isML = document.createElement(namespace + "multiLevel");
            boolean ml = false;
            if (!crt.getName().trim().equals("") && crt.getReportSections().size() > 1) {
                ml = true;
            }
            isML.appendChild(document.createTextNode(Boolean.toString(ml)));
            rootElement.appendChild(isML);
            Element sections = document.createElement(namespace + "sections");
            rootElement.appendChild(sections);
            Element objectsCollection = document.createElement(namespace + "objects");
            rootElement.appendChild(objectsCollection);
            ArrayList<ReportSection> usedSections = new ArrayList<ReportSection>();
            HashMap usedPropertiesMap = new HashMap();
            ArrayList<String> propertiesList = null;
            int sCounter = 0;
            for (ReportSection rs : crt.getReportSections()) {
                if (rs.getLevel() > 0) {
                    usedSections.add(rs);
                }
                if (sCounter <= 30) {
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("name", rs.getCustomName());
                    section.setAttribute("tw", "100%");
                    sections.appendChild(section);
                    int columnsCount = 0;
                    int colsWithZeroLength = 0;
                    double percentageUsed = 0.0;
                    for (ReportColumn rc : rs.getReportColumns()) {
                        if (rc.getColumnSize() == 0.0) {
                            ++colsWithZeroLength;
                        } else {
                            percentageUsed += rc.getColumnSize();
                        }
                        ++columnsCount;
                    }
                    double sizeForZeroLengthColumns = 0.0;
                    if (columnsCount != colsWithZeroLength) {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    } else {
                        if (colsWithZeroLength > 0) {
                            sizeForZeroLengthColumns = (100.0 - percentageUsed) / (double)colsWithZeroLength;
                        }
                        if (rs.getLevel() == 0) {
                            tableWidth.appendChild(document.createTextNode("100%"));
                        }
                    }
                    HashMap<CallSite, Integer> columnsOrderMap = new HashMap<CallSite, Integer>();
                    int cCounter = 0;
                    propertiesList = new ArrayList<String>();
                    for (ReportColumn rc : rs.getReportColumns()) {
                        propertiesList.add(rc.getPropertyName());
                        if (++cCounter > 30) continue;
                        Element column = document.createElement(namespace + "c" + cCounter);
                        Element show = document.createElement(namespace + "show");
                        show.appendChild(document.createTextNode("true"));
                        Element name = document.createElement(namespace + "name");
                        name.appendChild(document.createTextNode(rc.getPropertyName()));
                        Element cn = document.createElement(namespace + "customName");
                        cn.appendChild(document.createTextNode(rc.getColumnName()));
                        Element w = document.createElement(namespace + "width");
                        double columnSize = rc.getColumnSize();
                        if (columnSize == 0.0) {
                            columnSize = sizeForZeroLengthColumns;
                        }
                        w.appendChild(document.createTextNode(Double.toString(columnSize) + "%"));
                        column.appendChild(show);
                        column.appendChild(name);
                        column.appendChild(cn);
                        column.appendChild(w);
                        section.appendChild(column);
                        if (rc.getColumnOrder().equals("")) continue;
                        columnsOrderMap.put((CallSite)((Object)("c" + cCounter)), Integer.parseInt(rc.getColumnOrder()));
                    }
                }
                usedPropertiesMap.put(rs.getElementClass(), propertiesList);
                ++sCounter;
            }
            Collections.sort(objects, new PropertiesComparator(objects, ((ReportSection)crt.getReportSections().get(0)).getReportColumns()));
            for (SearchResultObject ro : objects) {
                ModelIDObject obj = (ModelIDObject)ro.getObj();
                String objName = obj.getLongName();
                this.objectsBookmarksNamesList.add(objName);
                ClassDescription cd = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(obj.getClass().getName());
                Element baseObject = document.createElement(namespace + "object");
                objectsCollection.appendChild(baseObject);
                Element values = document.createElement(namespace + "values");
                baseObject.appendChild(values);
                Element elValue = document.createElement(namespace + "v0");
                elValue.appendChild(document.createTextNode(objName));
                values.appendChild(elValue);
                int vCounter = 0;
                for (String propertyName : (List)usedPropertiesMap.get(obj.getClass())) {
                    elValue = document.createElement(namespace + "v" + ++vCounter);
                    values.appendChild(elValue);
                    ClassDescription.PropertyDescription pd = cd.getSearchablePropertyDescriptionByName(propertyName);
                    String value = "";
                    if (pd != null) {
                        String className = pd.className;
                        java.lang.reflect.Method method = pd.getter;
                        value = this.getPropertiesValue(method, className, obj);
                    } else {
                        value = obj.getProperty(propertyName);
                    }
                    elValue.appendChild(document.createTextNode(value));
                }
                sCounter = 0;
                for (ReportSection rs : usedSections) {
                    Object cd1;
                    if (++sCounter > 30) continue;
                    Element section = document.createElement(namespace + "section" + sCounter);
                    section.setAttribute("tw", "100%");
                    baseObject.appendChild(section);
                    java.lang.reflect.Method method = null;
                    if (rs.getType().equals("collection")) {
                        cd1 = (ClassDescription.CollectionDescription)rs.getElement();
                        method = ((ClassDescription.CollectionDescription)cd1).getter;
                    } else if (rs.getType().equals("roPropertiesList")) {
                        ClassDescription.PropertyDescription pd = (ClassDescription.PropertyDescription)rs.getElement();
                        method = pd.getter;
                    } else {
                        cd1 = (ClassDescription)rs.getElement();
                        ClassDescription.PropertyDescription pd = ((ClassDescription)cd1).getSearchablePropertyDescriptionByName(rs.getPropertyName());
                        if (pd != null) {
                            method = pd.getter;
                        }
                    }
                    Iterator<Object> itemsListIt = null;
                    if (method != null) {
                        List<Object> l;
                        Object col = method.invoke((Object)obj, new Object[0]);
                        if (col instanceof Collection) {
                            l = new ArrayList((Collection)col);
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        } else if (col instanceof ElementSet) {
                            l = Arrays.asList(((ElementSet)col).toArray());
                            Collections.sort(l, new PropertiesComparator(l, rs.getReportColumns()));
                            itemsListIt = l.iterator();
                        }
                    }
                    if (itemsListIt == null) continue;
                    while (itemsListIt.hasNext()) {
                        Object rObj = itemsListIt.next();
                        Element oObject = document.createElement(namespace + "object");
                        section.appendChild(oObject);
                        Element values1 = document.createElement(namespace + "values");
                        oObject.appendChild(values1);
                        ClassDescription cd12 = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(rObj.getClass().getName());
                        int pCounter = 0;
                        for (ReportColumn rc : rs.getReportColumns()) {
                            elValue = document.createElement(namespace + "v" + ++pCounter);
                            values1.appendChild(elValue);
                            String value = "";
                            ClassDescription.PropertyDescription pd = cd12.getSearchablePropertyDescriptionByName(rc.getPropertyName());
                            if (pd != null) {
                                String className = pd.className;
                                java.lang.reflect.Method method1 = pd.getter;
                                value = this.getPropertiesValue(method1, className, rObj);
                            }
                            elValue.appendChild(document.createTextNode(value));
                        }
                    }
                }
                Element section = document.createElement(namespace + "section");
                section.setAttribute("tw", "100%");
                baseObject.appendChild(section);
            }
        }
        catch (Exception e) {
            LOGGER.error("ReportsGenerator.generateSearchResultsDomDocument() Exception : " + e);
        }
        return document;
    }

    /*
     * Could not resolve type clashes
     */
    private Document gatherAllTablesAndViewsData(DesignPart model, StandardReportTemplate reportTemplate, List tablesAndViews) {
        Document document = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            document = builder.newDocument();
            Element rootElement = document.createElementNS("http://oracle.com/datamodeler/reports/tablesandviews", "osdmAllTablesAndViews:TablesAndViews");
            document.appendChild(rootElement);
            String namespace = "osdmAllTablesAndViews:";
            Element rCaption = document.createElement(namespace + "ReportCaption");
            rCaption.appendChild(document.createTextNode(this.reportCaption));
            rootElement.appendChild(rCaption);
            Element rCompanyName = document.createElement(namespace + "CompanyName");
            rCompanyName.appendChild(document.createTextNode(this.settings.getReportsCompanyName()));
            rootElement.appendChild(rCompanyName);
            Element usePageBreaks = document.createElement(namespace + "UsePageBreaks");
            usePageBreaks.appendChild(document.createTextNode(this.settings.isUsePageBreaksInReports() ? "true" : "false"));
            rootElement.appendChild(usePageBreaks);
            Element e = null;
            Object descriptionNotesIterator = null;
            if (model != null) {
                e = document.createElement(namespace + "DesignName");
                e.appendChild(document.createTextNode(this.design.getName()));
                rootElement.appendChild(e);
                e = document.createElement(namespace + "VersionDate");
                e.appendChild(document.createTextNode(dateFormat.format(new Date())));
                rootElement.appendChild(e);
                String designComment = this.design.getComment();
                if (designComment != "" && designComment != null) {
                    Element versionCommentElement = document.createElement(namespace + "VersionComment");
                    versionCommentElement.appendChild(document.createCDATASection(designComment));
                    rootElement.appendChild(versionCommentElement);
                }
                e = document.createElement(namespace + "ModelName");
                e.appendChild(document.createTextNode(model.getName()));
                rootElement.appendChild(e);
            }
            Element tablesCollection = document.createElement(namespace + "TablesCollection");
            rootElement.appendChild(tablesCollection);
            Element viewsCollection = document.createElement(namespace + "TablesViewsCollection");
            rootElement.appendChild(viewsCollection);
            List currentObjectsList = new ArrayList();
            if (tablesAndViews.size() != 0) {
                currentObjectsList = tablesAndViews;
            } else {
                Iterator it0 = ((RelationalDesign)model).getTableSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
                it0 = ((RelationalDesign)model).getTableViewSet().iterator();
                while (it0.hasNext()) {
                    currentObjectsList.add(it0.next());
                }
            }
            Collections.sort(currentObjectsList, new ObjectsComparator());
            for (Object dObj : currentObjectsList) {
                String fk;
                Element tableDetails;
                if (dObj instanceof Table && this.addTables.booleanValue()) {
                    Table table = (Table)dObj;
                    tableDetails = document.createElement(namespace + "TableDetails");
                    tablesCollection.appendChild(tableDetails);
                    e = document.createElement(namespace + "TableName");
                    e.appendChild(document.createTextNode(table.getLongName()));
                    tableDetails.appendChild(e);
                    e = document.createElement(namespace + "EncodedTableName");
                    e.appendChild(document.createTextNode(table.getShortObjectID()));
                    tableDetails.appendChild(e);
                    e = document.createElement(namespace + "ObjectTypeName");
                    e.appendChild(document.createTextNode(table.getBasedOnStructuredType() != null ? table.getBasedOnStructuredType().getName() : ""));
                    tableDetails.appendChild(e);
                    String description = "";
                    description = table.getComment() == null || table.getComment().equals("") ? table.getCommentInRDBMS() : table.getComment();
                    if (description != "" && description != null) {
                        Element descriptionElement = document.createElement(namespace + "Description");
                        descriptionElement.appendChild(document.createCDATASection(description));
                        tableDetails.appendChild(descriptionElement);
                    }
                    e = document.createElement(namespace + "MVPrebuilt");
                    e.appendChild(document.createTextNode(table.isOnPrebuiltTable() ? "Yes" : ""));
                    tableDetails.appendChild(e);
                    if (table.getUserDefinedSQL() != null) {
                        e = document.createElement(namespace + "MVQuery");
                        e.appendChild(document.createCDATASection(table.getUserDefinedSQL()));
                        tableDetails.appendChild(e);
                    }
                    if (reportTemplate.isUseTableColumns()) {
                        int columnsCounter = 0;
                        Element columnsCollection = null;
                        for (FKElement column : Arrays.asList(table.getElements())) {
                            String personalInfo;
                            if (columnsCounter == 0) {
                                columnsCollection = document.createElement(namespace + "ColumnsCollection");
                                tableDetails.appendChild(columnsCollection);
                            }
                            Element columnDetails = document.createElement(namespace + "ColumnDetails");
                            columnsCollection.appendChild(columnDetails);
                            e = document.createElement(namespace + "Sequence");
                            e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "ColumnName");
                            e.appendChild(document.createTextNode(column.getName()));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "PK");
                            e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "FK");
                            fk = ((Column)column).isFKElement() || column.isPartOfUnresolvedFK(table) ? "F" : "";
                            e.appendChild(document.createTextNode(fk));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "M");
                            e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                            columnDetails.appendChild(e);
                            String dataType = "";
                            String dataTypeKind = "";
                            String domainName = "";
                            switch (column.getUse()) {
                                case 0: {
                                    dataTypeKind = "DOM";
                                    Domain dom = column.getDomain();
                                    domainName = dom.getName();
                                    dataType = this.getSizePrecisionScale(dom, dom.getLogicalDatatype().getName());
                                    domainName = domainName.replace("Unknown", "");
                                    domainName = domainName.replace("unknown", "");
                                    domainName = domainName.replace("UNKNOWN", "");
                                    break;
                                }
                                case 1: {
                                    dataTypeKind = "LT";
                                    dataType = ((Column)column).getNativeDataType();
                                    break;
                                }
                                case 2: {
                                    dataTypeKind = "DT";
                                    dataType = column.getDistinctType().getName();
                                    break;
                                }
                                case 3: {
                                    dataTypeKind = column.isReference() ? "RST" : "ST";
                                    dataType = column.getStructuredType().getName();
                                    break;
                                }
                                case 4: {
                                    dataTypeKind = "CT";
                                    dataType = column.getCollectionType().getName();
                                }
                            }
                            e = document.createElement(namespace + "DataType");
                            String ai = ((Column)column).isAutoIncrementColumn() ? " - AI" : "";
                            String id = ((Column)column).isIdentityColumn() ? " - ID" : "";
                            e.appendChild(document.createTextNode(dataType + ai + id));
                            columnDetails.appendChild(e);
                            e = document.createElement(namespace + "Formula");
                            e.appendChild(document.createTextNode((column.getFormulaDesc() + " " + column.getDefaultValue()).trim()));
                            columnDetails.appendChild(e);
                            Object security = "";
                            String string = ((Column)column).isContainsPII() == null ? "" : (personalInfo = ((Column)column).isContainsPII() != false ? "Y" : "");
                            String sensitiveInfo = ((Column)column).isContainsSensitiveInformation() == null ? "" : (((Column)column).isContainsSensitiveInformation() != false ? "Y" : "");
                            String maskInfo = ((Column)column).getMaskingType();
                            if (maskInfo == null) {
                                maskInfo = "";
                            }
                            security = personalInfo + "/" + sensitiveInfo + "/" + maskInfo;
                            security = ((String)security).replace("//", "");
                            e = document.createElement(namespace + "Security");
                            e.appendChild(document.createTextNode((String)security));
                            columnDetails.appendChild(e);
                            String columnDescription = "";
                            columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                            if (columnDescription != "" && columnDescription != null) {
                                Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                                columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                                columnDetails.appendChild(columnDescriptionElement);
                            }
                            ++columnsCounter;
                        }
                    }
                    if (reportTemplate.isUseTableIndexes()) {
                        int indesexCounter = 0;
                        HashMap<String, String> usedNames = new HashMap<String, String>();
                        Element indesexCollection = null;
                        Iterator itIndexes = table.getKeySet().iterator();
                        while (itIndexes.hasNext()) {
                            Index index = (Index)itIndexes.next();
                            if (index.isFK()) continue;
                            if (indesexCounter == 0) {
                                indesexCollection = document.createElement(namespace + "IndexesCollection");
                                tableDetails.appendChild(indesexCollection);
                            }
                            Iterator<ContainedObject> itIdxColumns = null;
                            if (index.hasIndexExpression()) {
                                ArrayList<String> list = new ArrayList<String>();
                                list.add(" ");
                                itIdxColumns = list.iterator();
                            } else {
                                itIdxColumns = Arrays.asList(index.getElements()).iterator();
                            }
                            while (itIdxColumns.hasNext()) {
                                Column col = null;
                                String colName = null;
                                ContainedObject obj = itIdxColumns.next();
                                if (obj instanceof Column) {
                                    col = (Column)obj;
                                    colName = col.getName();
                                } else {
                                    colName = ((Object)obj).toString();
                                }
                                Element indexdetails = document.createElement(namespace + "IndexDetails");
                                indesexCollection.appendChild(indexdetails);
                                String state = index.getIndexState();
                                boolean nameUsed = false;
                                String cName = index.getName();
                                for (Map.Entry pair : usedNames.entrySet()) {
                                    String name = (String)pair.getKey();
                                    String st = (String)pair.getValue();
                                    if (!name.equals(cName) || !st.equals(state)) continue;
                                    nameUsed = true;
                                    break;
                                }
                                if (!nameUsed) {
                                    usedNames.put(cName, state);
                                }
                                e = document.createElement(namespace + "IndexName");
                                e.appendChild(document.createTextNode(nameUsed ? "" : index.getName()));
                                indexdetails.appendChild(e);
                                state = state.equals("Unique Plain Index") ? "UN" : (state.equals("Unique Constraint") ? "UK" : (state.equals("Primary Constraint") ? "PK" : ""));
                                e = document.createElement(namespace + "IndexState");
                                e.appendChild(document.createTextNode(nameUsed ? "" : state));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexFunctional");
                                e.appendChild(document.createTextNode(!"".equalsIgnoreCase(index.getIndexExpression()) ? "Y" : ""));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexSpatial");
                                e.appendChild(document.createTextNode(index.isSpatialIndex() ? "Y" : ""));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexExpression");
                                e.appendChild(document.createTextNode(index.getIndexExpression()));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexColumnName");
                                e.appendChild(document.createTextNode(colName));
                                indexdetails.appendChild(e);
                                e = document.createElement(namespace + "IndexSortOrder");
                                if (col != null) {
                                    e.appendChild(document.createTextNode(index.getColumnSortOrder(col)));
                                } else {
                                    e.appendChild(document.createTextNode(" "));
                                }
                                indexdetails.appendChild(e);
                            }
                            ++indesexCounter;
                        }
                    }
                    if (reportTemplate.isUseTableConstraints()) {
                        int constraintsCounter = 0;
                        Element constraintsCollection = null;
                        Node tableLevelConstraintsCollection = null;
                        for (TableLevelConstraint tlConstraint : table.getCheckConstraints()) {
                            if (constraintsCounter == 0) {
                                constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                                tableDetails.appendChild(constraintsCollection);
                                tableLevelConstraintsCollection = document.createElement(namespace + "TableLevelConstraintsCollection");
                                constraintsCollection.appendChild(tableLevelConstraintsCollection);
                            }
                            Element constraintDetails = document.createElement(namespace + "TableLevelConstraintDetails");
                            tableLevelConstraintsCollection.appendChild(constraintDetails);
                            e = document.createElement(namespace + "TLConstraintType");
                            e.appendChild(document.createTextNode(constraintsCounter == 0 ? "Table Level" : ""));
                            constraintDetails.appendChild(e);
                            e = document.createElement(namespace + "TLConstraintName");
                            e.appendChild(document.createTextNode(tlConstraint.getName()));
                            constraintDetails.appendChild(e);
                            Element tlConstraintElement = document.createElement(namespace + "TLConstraintRule");
                            tlConstraintElement.appendChild(document.createCDATASection(tlConstraint.getRule()));
                            constraintDetails.appendChild(tlConstraintElement);
                            ++constraintsCounter;
                        }
                        int columnConstraintsCounter = 0;
                        Element columnLevelConstraintsCollection = null;
                        for (Column column : Arrays.asList(table.getElements())) {
                            if (column.getAVTs().size() <= 0 && column.getValueList() == null && column.getCheck() == null) continue;
                            if (constraintsCounter == 0) {
                                constraintsCollection = document.createElement(namespace + "ConstraintsCollection");
                                tableDetails.appendChild(constraintsCollection);
                            }
                            if (columnConstraintsCounter == 0) {
                                columnLevelConstraintsCollection = document.createElement(namespace + "ColumnLevelConstraintsCollection");
                                constraintsCollection.appendChild(columnLevelConstraintsCollection);
                            }
                            Object constraintName = "";
                            CheckConstraint ccConstraint = column.getCheck();
                            if (ccConstraint != null && !((String)(constraintName = ccConstraint.getName())).equals("")) {
                                constraintName = " / " + (String)constraintName;
                            }
                            Element constraintDetails = document.createElement(namespace + "ConstraintDetails");
                            columnLevelConstraintsCollection.appendChild(constraintDetails);
                            e = document.createElement(namespace + "ContstraintType");
                            e.appendChild(document.createTextNode(columnConstraintsCounter == 0 ? "Column Level" : ""));
                            constraintDetails.appendChild(e);
                            e = document.createElement(namespace + "ALCConstraintName");
                            e.appendChild(document.createTextNode(column.getName() + (String)constraintName));
                            constraintDetails.appendChild(e);
                            Element rangesCollection = null;
                            Iterator itRanges = column.getAVTs().iterator();
                            int rgCounter = 0;
                            while (itRanges.hasNext()) {
                                AVT avt = (AVT)itRanges.next();
                                if (rgCounter == 0) {
                                    rangesCollection = document.createElement(namespace + "RangesCollection");
                                    constraintDetails.appendChild(rangesCollection);
                                }
                                Element rangeDetails = document.createElement(namespace + "RangeDetails");
                                rangesCollection.appendChild(rangeDetails);
                                e = document.createElement(namespace + "RangeBeginValue");
                                e.appendChild(document.createTextNode(avt.getBeginValue()));
                                rangeDetails.appendChild(e);
                                e = document.createElement(namespace + "RangeEndValue");
                                e.appendChild(document.createTextNode(avt.getEndValue()));
                                rangeDetails.appendChild(e);
                                e = document.createElement(namespace + "RangeShortDescription");
                                e.appendChild(document.createTextNode(avt.getDescription()));
                                rangeDetails.appendChild(e);
                                ++rgCounter;
                            }
                            Element vlCollection = null;
                            int vlCounter = 0;
                            if (column.getValueList() != null) {
                                Iterator itVL = column.getValueIterator();
                                while (itVL.hasNext()) {
                                    Object key = itVL.next();
                                    String value = (String)column.getValueList().getValuesDescriptionMap().get(key);
                                    if (vlCounter == 0) {
                                        vlCollection = document.createElement(namespace + "ValueListsCollection");
                                        constraintDetails.appendChild(vlCollection);
                                    }
                                    Element vlDetails = document.createElement(namespace + "ValueListDetails");
                                    vlCollection.appendChild(vlDetails);
                                    e = document.createElement(namespace + "VLValue");
                                    e.appendChild(document.createTextNode(key.toString()));
                                    vlDetails.appendChild(e);
                                    e = document.createElement(namespace + "VLShortDescription");
                                    e.appendChild(document.createTextNode(value));
                                    vlDetails.appendChild(e);
                                    ++vlCounter;
                                }
                            }
                            if (ccConstraint != null) {
                                Element ccCollection = document.createElement(namespace + "CheckConstraintsCollection");
                                constraintDetails.appendChild(ccCollection);
                                String generic = ccConstraint.getGenericConstraint();
                                if (!generic.trim().equalsIgnoreCase("")) {
                                    Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                    ccCollection.appendChild(ccDetails);
                                    Element ccText = document.createElement(namespace + "CheckConstraintText");
                                    ccText.appendChild(document.createCDATASection(generic));
                                    ccDetails.appendChild(ccText);
                                    e = document.createElement(namespace + "DatabaseType");
                                    e.appendChild(document.createTextNode("Generic Constraint"));
                                    ccDetails.appendChild(e);
                                }
                                Object[] types = ccConstraint.getTypes();
                                for (int i = 0; i < types.length; ++i) {
                                    RDBMSType rdbmsType = (RDBMSType)types[i];
                                    String text = ccConstraint.getImplementationFor(rdbmsType);
                                    if (!(text != null & !text.trim().equalsIgnoreCase(""))) continue;
                                    Element ccDetails = document.createElement(namespace + "CheckConstraintDetails");
                                    ccCollection.appendChild(ccDetails);
                                    Element ccText = document.createElement(namespace + "CheckConstraintText");
                                    ccText.appendChild(document.createCDATASection(text));
                                    ccDetails.appendChild(ccText);
                                    e = document.createElement(namespace + "DatabaseType");
                                    e.appendChild(document.createTextNode(rdbmsType != null ? rdbmsType.getName() : ""));
                                    ccDetails.appendChild(e);
                                }
                            }
                            ++columnConstraintsCounter;
                        }
                    }
                    if (reportTemplate.isUseTableFKReferringTo()) {
                        this.processFKeysReferTo(table, document, tableDetails, namespace);
                    }
                    if (!reportTemplate.isUseTableFKReferredFrom()) continue;
                    this.processFKeysReferFrom(table, document, tableDetails, namespace);
                    continue;
                }
                if (!(dObj instanceof TableView) || !this.addViews.booleanValue()) continue;
                TableView view = (TableView)dObj;
                tableDetails = document.createElement(namespace + "TableViewDetails");
                viewsCollection.appendChild(tableDetails);
                e = document.createElement(namespace + "ViewName");
                e.appendChild(document.createTextNode(view.getLongName()));
                tableDetails.appendChild(e);
                e = document.createElement(namespace + "EncodedViewName");
                e.appendChild(document.createTextNode(view.getShortObjectID()));
                tableDetails.appendChild(e);
                if (this.settings.isIncludeSelectStatementInViewReport()) {
                    e = document.createElement(namespace + "SelectStatement");
                    e.appendChild(document.createCDATASection(view.getUserDefinedSQL()));
                    tableDetails.appendChild(e);
                }
                if (view.isBST()) {
                    e = document.createElement(namespace + "StructuredTypeName");
                    e.appendChild(document.createTextNode(view.getBasedOnStructuredTypeName()));
                    rootElement.appendChild(e);
                }
                if (reportTemplate.isUseTableColumns()) {
                    int columnsCounter = 0;
                    Element columnsCollection = null;
                    Iterator<ContainedObject> itColumns = Arrays.asList(view.getElements()).iterator();
                    int seq = 0;
                    while (itColumns.hasNext()) {
                        FKElement column;
                        ++seq;
                        column = (ColumnView)itColumns.next();
                        if (columnsCounter == 0) {
                            columnsCollection = document.createElement(namespace + "ColumnsCollection");
                            tableDetails.appendChild(columnsCollection);
                        }
                        Element columnDetails = document.createElement(namespace + "ColumnDetails");
                        columnsCollection.appendChild(columnDetails);
                        e = document.createElement(namespace + "Sequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(seq).toString()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PK");
                        e.appendChild(document.createTextNode(column.isPKElement() ? "P" : ""));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "FK");
                        fk = ((AbstractViewElement)column).isFKElement() || column.isPartOfUnresolvedFK(view) ? "F" : "";
                        e.appendChild(document.createTextNode(fk));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "M");
                        e.appendChild(document.createTextNode(column.getNullsAllowed() ? "" : "Y"));
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "DataType");
                        e.appendChild(document.createTextNode(((AbstractViewElement)column).getDataTypeString()));
                        columnDetails.appendChild(e);
                        columnDetails.appendChild(e);
                        e = document.createElement(namespace + "PreferredAbbreviation");
                        e.appendChild(document.createTextNode(((AbstractViewElement)column).getAbbreviation()));
                        columnDetails.appendChild(e);
                        ++columnsCounter;
                    }
                }
                if (reportTemplate.isUseTableColumnsComments()) {
                    int columnsCommentsCounter = 0;
                    Element columnsCommentsCollection = null;
                    for (ColumnView column : Arrays.asList(view.getElements())) {
                        String columnDescription = "";
                        columnDescription = column.getComment() == null || column.getComment().equals("") ? column.getCommentInRDBMS() : column.getComment();
                        String columnNotes = column.getNotes();
                        if ((columnDescription == null || columnDescription.equals("")) && (columnNotes == null || columnNotes.equals(""))) continue;
                        if (columnsCommentsCounter == 0) {
                            columnsCommentsCollection = document.createElement(namespace + "ColumnsCommentsCollection");
                            tableDetails.appendChild(columnsCommentsCollection);
                        }
                        Element columnCommentsDetails = document.createElement(namespace + "ColumnCommentsDetails");
                        columnsCommentsCollection.appendChild(columnCommentsDetails);
                        e = document.createElement(namespace + "ColumnCommentsSequence");
                        e.appendChild(document.createTextNode(Integer.valueOf(column.getContainer().getIndexOf(column) + 1).toString()));
                        columnCommentsDetails.appendChild(e);
                        e = document.createElement(namespace + "ColumnCommentsName");
                        e.appendChild(document.createTextNode(column.getName()));
                        columnCommentsDetails.appendChild(e);
                        if (columnDescription != "" && columnDescription != null) {
                            Element columnDescriptionElement = document.createElement(namespace + "ColumnDescription");
                            columnDescriptionElement.appendChild(document.createCDATASection(columnDescription));
                            columnCommentsDetails.appendChild(columnDescriptionElement);
                        }
                        if (columnNotes != "" && columnNotes != null) {
                            Element columnNotesElement = document.createElement(namespace + "ColumnNotes");
                            columnNotesElement.appendChild(document.createCDATASection(columnNotes));
                            columnCommentsDetails.appendChild(columnNotesElement);
                        }
                        ++columnsCommentsCounter;
                    }
                }
                if (reportTemplate.isUseTableFKReferringTo()) {
                    this.processFKeysReferTo(view, document, tableDetails, namespace);
                }
                if (!reportTemplate.isUseTableFKReferredFrom()) continue;
                this.processFKeysReferFrom(view, document, tableDetails, namespace);
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Exception during all tables and views report generation " + e);
        }
        catch (Exception e) {
            LOGGER.error("Exception during all tables and views report generation " + e.getMessage(), e);
            return null;
        }
        return document;
    }

    private String getSizePrecisionScale(Object obj, String dataType) {
        if (((String)dataType).equalsIgnoreCase("unknown")) {
            return "";
        }
        String precision = "";
        String scale = "";
        String size = "";
        if (obj instanceof Column) {
            precision = ((Column)obj).getPrecision();
            scale = ((Column)obj).getScale();
            size = ((Column)obj).getSize();
        } else if (obj instanceof Domain) {
            precision = ((Domain)obj).getPrecision();
            scale = ((Domain)obj).getScale();
            size = ((Domain)obj).getSize();
        } else if (obj instanceof TypeElement) {
            precision = Integer.valueOf(((TypeElement)obj).getPrecision()).toString();
            scale = Integer.valueOf(((TypeElement)obj).getScale()).toString();
            size = ((TypeElement)obj).getSize();
        }
        if (precision != null && !precision.trim().equals("") && !precision.trim().equals("0")) {
            if (((String)(dataType = (String)dataType + " (" + precision)).indexOf("(") > -1) {
                if (scale != null && !scale.trim().equals("") && !scale.trim().equals("0")) {
                    dataType = (String)dataType + "," + scale;
                }
                dataType = (String)dataType + ")";
            }
        } else if (size != null && !size.trim().equals("") && !size.trim().equals("0")) {
            dataType = (String)dataType + " (" + size + ") ";
        }
        dataType = ((String)dataType).replace("(0,0)", "");
        dataType = ((String)dataType).replace("(0)", "");
        dataType = ((String)dataType).replace("()", "");
        dataType = ((String)dataType).replace("Unknown", "");
        dataType = ((String)dataType).replace("unknown", "");
        dataType = ((String)dataType).replace("UNKNOWN", "");
        return dataType;
    }

    private String getPropertiesValue(java.lang.reflect.Method method, String className, Object obj) {
        String value = "";
        try {
            if (method != null) {
                Object object = method.invoke(obj, new Object[0]);
                if (className.indexOf("java.lang.String") > -1) {
                    if (object != null) {
                        value = (String)object;
                    }
                } else if (className.indexOf("java.lang.Integer") > -1) {
                    if (object != null) {
                        value = ((Integer)object).toString();
                    }
                } else if (className.indexOf("java.lang.Boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? ((Boolean)object != false ? this.strTrue : this.strFalse) : ((Boolean)object).toString();
                    }
                } else if (className.indexOf("boolean") > -1) {
                    if (object != null) {
                        value = this.replaceBooleanValues.booleanValue() ? (object.toString().equals("true") ? this.strTrue : this.strFalse) : object.toString();
                    }
                } else if (className.indexOf("float") > -1 || className.indexOf("short") > -1 || className.indexOf("long") > -1 || className.indexOf("double") > -1 || className.indexOf("int") > -1) {
                    if (object != null) {
                        value = object.toString();
                    }
                } else if (className.indexOf("java.util.Map") <= -1 && object != null) {
                    value = object != null && object instanceof List ? ReportUtils.listToString((List)object) : (object instanceof ModelObject ? ((ModelObject)object).getName() : object.toString());
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    private String getNameLOV(Map map, Class clazz) {
        Object obj = map.get(clazz);
        if (obj == null) {
            Class cl;
            Iterator it = map.keySet().iterator();
            while (it.hasNext() && (!clazz.isAssignableFrom(cl = (Class)it.next()) || (obj = map.get(cl)) == null)) {
            }
            if (obj != null) {
                map.put(clazz, obj);
            } else {
                for (Class sup = clazz.getSuperclass(); sup != null && !sup.getName().equalsIgnoreCase("Object"); sup = sup.getSuperclass()) {
                    obj = map.get(sup);
                    if (obj == null) {
                        continue;
                    }
                    map.put(clazz, obj);
                    break;
                }
            }
        }
        return (String)obj;
    }

    public InputStream getInputStreamFor(String location) {
        InputStream is = null;
        if (MetaFileLoader.DMWEB) {
            is = this.getClass().getClassLoader().getResourceAsStream(location);
        } else {
            is = this.getResourceProvider().getResourceAsStriam(location);
            if (is == null) {
                LOGGER.error("Data inputstream is null (path: " + location + ")");
            }
        }
        return is;
    }

    public ResourceProvider getResourceProvider() {
        if (this.resourceProvider == null) {
            this.resourceProvider = new ResourceProvider("");
        }
        return this.resourceProvider;
    }

    private static final class IgnoreURIResolver
    implements URIResolver {
        static final IgnoreURIResolver INSTANCE = new IgnoreURIResolver();

        private IgnoreURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return new StreamSource(new StringReader(""));
        }
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, Integer> base;

        public ValueComparator(Map<String, Integer> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            Integer y;
            Integer x = this.base.get(a);
            if (x.equals(y = this.base.get(b))) {
                return a.compareTo(b);
            }
            return x.compareTo(y);
        }
    }

    class PropertiesComparator
    implements Comparator {
        TreeMap tm = new TreeMap();
        Iterator it0 = null;

        public PropertiesComparator(List searchResultObjectslist, List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                String order = rc.getColumnOrder();
                if (order == null || order.equals("")) continue;
                this.tm.put(rc.getColumnOrder(), rc.getPropertyName());
            }
            if (this.tm.size() == 0) {
                this.sortByName(searchablePropertieslist);
            }
        }

        private void sortByName(List searchablePropertieslist) {
            for (ReportColumn rc : searchablePropertieslist) {
                if (!rc.getColumnName().equalsIgnoreCase("name")) continue;
                this.tm.put(1, rc.getPropertyName());
            }
        }

        public int compare(Object o1, Object o2) {
            ClassDescription cd1 = null;
            ClassDescription cd2 = null;
            Object obj1 = null;
            Object obj2 = null;
            if (o1 instanceof SearchResultObject) {
                SearchResultObject ro1 = (SearchResultObject)o1;
                obj1 = ro1.getObj();
            } else {
                obj1 = o1;
            }
            Class<?> classObj1 = obj1.getClass();
            cd1 = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(classObj1.getName());
            if (o2 instanceof SearchResultObject) {
                SearchResultObject ro2 = (SearchResultObject)o2;
                obj2 = ro2.getObj();
            } else {
                obj2 = o2;
            }
            Class<?> classObj2 = obj2.getClass();
            cd2 = XMLTransformationManager.getInstance().getMetaDataManager().getClassDescription(classObj2.getName());
            String className1 = "";
            for (Map.Entry pairs : this.tm.entrySet()) {
                String v1 = "";
                String v2 = "";
                try {
                    ClassDescription.PropertyDescription pd2;
                    ClassDescription.PropertyDescription pd1 = cd1.getPropertyDescriptionByNameInclRO((String)pairs.getValue());
                    if (pd1 != null) {
                        className1 = pd1.className;
                        java.lang.reflect.Method method1 = pd1.getter;
                        v1 = ReportUtils.getValue((ModelIDObject)obj1, method1, className1);
                    }
                    if ((pd2 = cd2.getPropertyDescriptionByNameInclRO((String)pairs.getValue())) != null) {
                        String className2 = pd2.className;
                        java.lang.reflect.Method method2 = pd2.getter;
                        v2 = ReportUtils.getValue((ModelIDObject)obj2, method2, className2);
                    }
                    if (v1.equals(v2)) continue;
                    if (pd1.isDateTime()) {
                        Date d1 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v1);
                        Date d2 = new SimpleDateFormat(ReportUtils.dateFormat).parse(v2);
                        return d1.compareTo(d2);
                    }
                    if (className1.indexOf("java.lang.Integer") > -1) {
                        return new Integer(v1).compareTo(new Integer(v2));
                    }
                    if (className1.indexOf("java.lang.Float") > -1) {
                        return new Float(v1).compareTo(new Float(v2));
                    }
                    if (className1.indexOf("java.lang.Short") > -1) {
                        return new Short(v1).compareTo(new Short(v2));
                    }
                    if (className1.indexOf("java.lang.Long") > -1) {
                        return new Long(v1).compareTo(new Long(v2));
                    }
                    if (className1.indexOf("java.lang.Double") > -1) {
                        return new Double(v1).compareTo(new Double(v2));
                    }
                    if (className1.indexOf("int") > -1) {
                        return Integer.valueOf(v1).compareTo(Integer.valueOf(v2));
                    }
                    if (className1.indexOf("float") > -1) {
                        return Float.valueOf(v1).compareTo(Float.valueOf(v2));
                    }
                    if (className1.indexOf("short") > -1) {
                        return Short.valueOf(v1).compareTo(Short.valueOf(v2));
                    }
                    if (className1.indexOf("long") > -1) {
                        return Long.valueOf(v1).compareTo(Long.valueOf(v2));
                    }
                    if (className1.indexOf("double") > -1) {
                        return Double.valueOf(v1).compareTo(Double.valueOf(v2));
                    }
                    return v1.compareTo(v2);
                }
                catch (Exception e) {
                    LOGGER.error("Exception in search results report generation (objects sort) " + e);
                }
            }
            return 0;
        }
    }

    private class ObjectsComparator
    implements Comparator {
        private ObjectsComparator() {
        }

        public int compare(Object one, Object two) {
            String s1 = "";
            String s2 = "";
            if (one instanceof DesignObject) {
                s1 = ((DesignObject)one).getName();
            }
            if (two instanceof DesignObject) {
                s2 = ((DesignObject)two).getName();
            }
            return s1.compareTo(s2);
        }
    }
}

