/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.mle_js;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.ImpExpVisitor;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.ModuleMetadata;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptLexer;
import oracle.dbtools.mle_js.antlr_base_js.JavaScriptParser;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class AntlrAstParser {
    public static void main(String[] args) {
    }

    public static ModuleMetadata getModuleMetadataFromJS(String code) {
        ModuleMetadata moduleMetadata;
        ByteArrayInputStream stream = new ByteArrayInputStream(code.getBytes(StandardCharsets.UTF_8.name()));
        try {
            JavaScriptLexer lexer = new JavaScriptLexer(CharStreams.fromStream((InputStream)stream, (Charset)StandardCharsets.UTF_8));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            tokens.fill();
            Map<Long, ImpExpVisitor.Comment> comments = ImpExpVisitor.getComments(tokens);
            JavaScriptParser parser = new JavaScriptParser((TokenStream)tokens);
            JavaScriptParser.ProgramContext tree = parser.program();
            ImpExpVisitor visitor = new ImpExpVisitor();
            visitor.visit((ParseTree)tree);
            Map<String, Object> map = ImpExpVisitor.toMap(visitor.imports, visitor.exports, visitor.functions, visitor.classes);
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            String json = ow.writeValueAsString(map);
            ArrayList<ExpNode> exps = new ArrayList<ExpNode>();
            ArrayList<ExpNode> imps = new ArrayList<ExpNode>();
            ArrayList<ExpNode> notResolved = new ArrayList<ExpNode>();
            ArrayList<String> lines = new ArrayList<String>();
            code.lines().forEach(line -> lines.add(line + System.lineSeparator()));
            AntlrAstParser.parseJSON(json, exps, imps, notResolved, comments, lines);
            ModuleMetadata meta = new ModuleMetadata();
            meta.exports = exps;
            meta.imports = imps;
            meta.notResolved = notResolved;
            moduleMetadata = meta;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return moduleMetadata;
    }

    static String listToJson(String name, List<ExpNode> exps, int baseTab) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addNL_Tabs("\"" + name + "\":[", baseTab);
        boolean first = true;
        for (ExpNode exp : exps) {
            if (first) {
                s.addNL().addText(exp.toJson(baseTab + 1));
                first = false;
                continue;
            }
            s.addText(",").addNL().addText(exp.toJson(baseTab + 1));
        }
        s.addNL().addNL_Tabs("]", baseTab);
        return s.toString();
    }

    public static JsonObject parseJSON(String str, List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved, Map<Long, ImpExpVisitor.Comment> comments) {
        return AntlrAstParser.parseJSON(str, exps, imps, notResolved, comments, null);
    }

    public static JsonObject parseJSON(String str, List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonObject jdoc = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8.name()));){
            jdoc = ImpExpVisitor.JSF.createReader((InputStream)stream).readObject();
            AntlrAstParser.processExports(jdoc, exps, comments, lines);
            ArrayList<ExpNode> t = new ArrayList<ExpNode>();
            Hashtable<String, String> names = new Hashtable<String, String>();
            for (ExpNode node : exps) {
                if (!"exportItems".equals(node.type)) continue;
                t.add(node);
                AntlrAstParser.addExportItems(node.expItems, names);
            }
            if (t.size() > 0) {
                exps.removeAll(t);
            }
            AntlrAstParser.processFunctions(jdoc, exps, names, comments, lines);
            AntlrAstParser.processClasses(jdoc, exps, names, comments, lines);
            AntlrAstParser.createPossibleImports(notResolved, names);
            AntlrAstParser.processImports(jdoc, imps);
            AntlrAstParser.processNotResolved(exps, notResolved);
            AntlrAstParser.processNotResolved(imps, notResolved);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return jdoc;
    }

    static void processNotResolved(List<ExpNode> source, List<ExpNode> notResolved) {
        ArrayList<ExpNode> temp = new ArrayList<ExpNode>();
        for (ExpNode node : source) {
            if (node.isBuiltInModule() || node.name != null) continue;
            temp.add(node);
        }
        source.removeAll(temp);
        notResolved.addAll(temp);
    }

    static void processExports(JsonObject jdoc, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        exps.clear();
        JsonArray ja = jdoc.getJsonArray("exports");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray ar = job.getJsonArray("exportDeclaration");
                if (ar != null) {
                    AntlrAstParser.processExportDeclaration(ar, exps, comments, lines);
                    continue;
                }
                ar = job.getJsonArray("functionDeclaration");
                if (ar != null) {
                    exp = AntlrAstParser.processFunctionDeclaration(ar, exps, null, comments, lines, null);
                    if (exp == null) continue;
                    exps.add(exp);
                    continue;
                }
                ar = job.getJsonArray("variableDeclaration");
                if (ar != null) {
                    exp = AntlrAstParser.processVariableDeclaration(ar, exps, null, comments, lines);
                    if (exp == null) continue;
                    exps.add(exp);
                    continue;
                }
                ar = job.getJsonArray("classDeclaration");
                if (ar == null || (exp = AntlrAstParser.processClass(ar, exps, null, comments, lines, null)) == null) continue;
                exps.add(exp);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ExpNode processVariableDeclaration(JsonArray vdecl, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        if (vdecl == null) return null;
        String type = "var";
        String name = vdecl.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
        boolean process = names == null;
        String alias = null;
        if (names != null) {
            alias = names.get(name);
            if (alias == null) return null;
            boolean bl = true;
            process = bl;
        }
        if (!process) return null;
        JsonObject def = vdecl.getJsonObject(2);
        if (def != null) {
            JsonArray jarr = def.getJsonArray("classExpression");
            if (jarr != null) {
                ExpNode exp = AntlrAstParser.processClass(jarr, exps, names, comments, lines, name);
                if (exp == null) return null;
                exp.name = name;
                exp.type = "var_class";
                return exp;
            }
            jarr = def.getJsonArray("functionExpression");
            if (jarr != null) {
                ExpNode exp = AntlrAstParser.processFunctionExpression(jarr, exps, names, comments, lines, name);
                if (exp == null) return null;
                exp.name = name;
                exp.type = "var_function";
                return exp;
            }
            ExpNode exp = new ExpNode();
            exp.type = type;
            exp.name = name;
            return exp;
        }
        ExpNode exp = new ExpNode();
        exp.type = type;
        exp.name = name;
        return exp;
    }

    static void processExportDeclaration(JsonArray ar, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        if (ar != null) {
            JsonArray decl = null;
            int count = ar.size();
            for (int j = 1; j < count; ++j) {
                JsonArray imp2;
                ExpNode exp;
                JsonObject jo = ar.getJsonObject(j);
                decl = jo.getJsonArray("declaration");
                if (decl != null) {
                    JsonArray arf = decl.getJsonObject(0).getJsonArray("functionDeclaration");
                    if (arf != null) {
                        exp = AntlrAstParser.processFunctionDeclaration(arf, exps, null, comments, lines, null);
                        if (exp == null) continue;
                        exps.add(exp);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("variableStatement");
                    if (arf != null) {
                        ExpNode exp2;
                        JsonArray var = arf.getJsonObject(0).getJsonArray("variableDeclarationList");
                        JsonArray vdecl = var.getJsonObject(1).getJsonArray("variableDeclaration");
                        if (vdecl == null || (exp2 = AntlrAstParser.processVariableDeclaration(vdecl, exps, null, comments, lines)) == null) continue;
                        try {
                            JsonObject job = var.getJsonObject(0);
                            JsonArray var_m = job.getJsonArray("varModifier");
                            if (var_m != null) {
                                JsonValue val = (JsonValue)var_m.getJsonObject(0).get((Object)"text");
                                if (val != null) {
                                    exp2.subtype = val.toString();
                                    exp2.subtype = MLEJS_Util.getName(exp2.subtype);
                                } else {
                                    JsonArray valarr = var_m.getJsonObject(0).getJsonArray("let_");
                                    if (valarr != null) {
                                        exp2.subtype = valarr.getJsonObject(0).getString("text");
                                        exp2.subtype = MLEJS_Util.getName(exp2.subtype);
                                    }
                                }
                            } else {
                                String vtype = var_m.getJsonObject(0).getString("text");
                                exp2.subtype = MLEJS_Util.getName(vtype);
                            }
                        }
                        catch (Exception job) {
                            // empty catch block
                        }
                        exps.add(exp2);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("variableDeclaration");
                    if (arf != null) {
                        exp = AntlrAstParser.processVariableDeclaration(arf, exps, null, comments, lines);
                        if (exp == null) continue;
                        exps.add(exp);
                        continue;
                    }
                    arf = decl.getJsonObject(0).getJsonArray("classDeclaration");
                    if (arf == null || (exp = AntlrAstParser.processClass(arf, exps, null, comments, lines, null)) == null) continue;
                    exps.add(exp);
                    continue;
                }
                decl = jo.getJsonArray("exportFromBlock");
                if (decl == null) continue;
                JsonArray are = decl.getJsonObject(0).getJsonArray("moduleItems");
                if (are != null) {
                    exp = new ExpNode();
                    exps.add(exp);
                    exp.expItems = new ArrayList<String>();
                    exp.type = "exportItems";
                    for (JsonValue p : are) {
                        String alias;
                        JsonArray po = ((JsonObject)p).getJsonArray("aliasName");
                        if (po == null) continue;
                        int pos = po.size();
                        Object name = po.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                        if (pos > 2 && (alias = po.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text")) != null) {
                            name = (String)name + " as " + alias;
                        }
                        exp.expItems.add((String)name);
                    }
                    try {
                        imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                        if (imp2 == null) continue;
                        exp.imp_name = imp2.getJsonObject(1).getString("text");
                        exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                        exp.type = "exportItemsFromModule";
                    }
                    catch (Exception imp2) {}
                    continue;
                }
                are = decl.getJsonObject(0).getJsonArray("importNamespace");
                if (are == null) continue;
                exp = new ExpNode();
                exps.add(exp);
                exp.type = "exportNamespace";
                exp.scope = are.getJsonObject(0).getString("text");
                try {
                    imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                    if (imp2 == null) continue;
                    exp.imp_name = imp2.getJsonObject(1).getString("text");
                    exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                    exp.type = "exportNamespaceFromModule";
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    static void processImports(JsonObject jdoc, List<ExpNode> exps) {
        JsonArray ja = jdoc.getJsonArray("imports");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                JsonObject job = ja.getJsonObject(i);
                JsonArray ar = job.getJsonArray("importStatement");
                if (ar == null) continue;
                JsonArray decl = null;
                int count = ar.size();
                for (int j = 1; j < count; ++j) {
                    JsonArray imp2;
                    ExpNode exp;
                    JsonObject jo = ar.getJsonObject(j);
                    decl = jo.getJsonArray("importFromBlock");
                    if (decl == null) continue;
                    JsonArray are = decl.getJsonObject(0).getJsonArray("moduleItems");
                    if (are != null) {
                        exp = new ExpNode();
                        exps.add(exp);
                        exp.expItems = new ArrayList<String>();
                        exp.type = "importItems";
                        for (JsonValue p : are) {
                            String alias;
                            JsonArray po = ((JsonObject)p).getJsonArray("aliasName");
                            if (po == null) continue;
                            int pos = po.size();
                            Object name = po.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            if (pos > 2 && (alias = po.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text")) != null) {
                                name = (String)name + " as " + alias;
                            }
                            exp.expItems.add((String)name);
                        }
                        try {
                            imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                            if (imp2 == null) continue;
                            exp.imp_name = imp2.getJsonObject(1).getString("text");
                            exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                        }
                        catch (Exception imp2) {}
                        continue;
                    }
                    are = decl.getJsonObject(0).getJsonArray("importNamespace");
                    if (are == null) continue;
                    exp = new ExpNode();
                    exps.add(exp);
                    exp.type = "importNamespace";
                    exp.scope = are.getJsonObject(0).getString("text");
                    try {
                        if (are.size() > 2) {
                            exp.imp_alias = are.getJsonObject(2).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    try {
                        imp2 = decl.getJsonObject(1).getJsonArray("importFrom");
                        if (imp2 == null) continue;
                        exp.imp_name = imp2.getJsonObject(1).getString("text");
                        exp.imp_name = MLEJS_Util.getName(exp.imp_name);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static void processFunctions(JsonObject jdoc, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonArray ja = jdoc.getJsonArray("functions");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray arf = job.getJsonArray("functionDeclaration");
                if (arf != null) {
                    ExpNode exp2 = AntlrAstParser.processFunctionDeclaration(arf, exps, names, comments, lines, null);
                    if (exp2 == null) continue;
                    exps.add(exp2);
                    continue;
                }
                JsonArray vdecl = job.getJsonArray("variableDeclaration");
                if (vdecl == null || (exp = AntlrAstParser.processVariableDeclaration(vdecl, exps, names, comments, lines)) == null) continue;
                exps.add(exp);
            }
        }
    }

    static ExpNode processFunctionExpression(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            JsonArray arr = arf.getJsonObject(0).getJsonArray("functionDecl");
            if (arr != null) {
                JsonArray decl = arr.getJsonObject(0).getJsonArray("functionDeclaration");
                if (decl != null) {
                    return AntlrAstParser.processFunctionDeclaration(decl, exps, names, comments, lines, varName);
                }
            } else {
                arr = arf.getJsonObject(0).getJsonArray("anonymousFunctionDecl");
                if (arr != null) {
                    return AntlrAstParser.processFunctionDeclaration(arr, exps, names, comments, lines, varName);
                }
                arr = arf.getJsonObject(0).getJsonArray("arrowFunction");
                if (arr != null) {
                    return AntlrAstParser.processArrowFunction(arr, exps, names, comments, lines, varName);
                }
            }
        }
        return null;
    }

    static ExpNode processFunctionDeclaration(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            FuncHelp hlp = AntlrAstParser.getFuncType(arf);
            int start = hlp.start;
            int stop = hlp.stop;
            int k = hlp.count + 1;
            JsonArray identif = arf.getJsonObject(k).getJsonArray("identifier");
            String name = "";
            if (identif != null) {
                name = identif.getJsonObject(0).getString("text");
            }
            boolean process = names == null;
            String alias = null;
            if (names != null) {
                alias = varName != null ? names.get(varName) : names.get(name);
                boolean bl = process = alias != null;
            }
            if (process) {
                JsonArray par;
                int arfs;
                ExpNode exp = new ExpNode();
                exp.type = "function";
                if (hlp.async) {
                    exp.subtype = "async";
                }
                if (alias != null) {
                    exp.name = alias;
                    exp.name_in_code = name;
                } else {
                    exp.name = name;
                }
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (names != null) {
                    if (varName != null) {
                        names.remove(varName);
                    } else {
                        names.remove(name);
                    }
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if ((arfs = arf.size()) > 4 && (par = arf.getJsonObject(3).getJsonArray("formalParameterList")) != null) {
                    exp.params = new ArrayList<ExpNode.Param>();
                    for (JsonValue p : par) {
                        JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                        if (po == null) continue;
                        String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                        ExpNode.Param param = new ExpNode.Param();
                        param.name = pname;
                        exp.params.add(param);
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static ExpNode processArrowFunction(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            int k = 0;
            JsonArray fparam = arf.getJsonObject(k).getJsonArray("arrowFunctionParameters");
            if (fparam != null) {
                ++k;
            }
            int start = arf.getJsonObject(k).getInt("start");
            int stop = arf.getJsonObject(k).getInt("stop");
            boolean process = true;
            if (process) {
                JsonArray par;
                ExpNode exp = new ExpNode();
                exp.name = "";
                exp.type = "function";
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (names != null && varName != null) {
                    names.remove(varName);
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if ((par = fparam.getJsonObject(1).getJsonArray("formalParameterList")) != null) {
                    exp.params = new ArrayList<ExpNode.Param>();
                    for (JsonValue p : par) {
                        JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                        if (po == null) continue;
                        String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                        ExpNode.Param param = new ExpNode.Param();
                        param.name = pname;
                        exp.params.add(param);
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static void processClasses(JsonObject jdoc, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines) {
        JsonArray ja = jdoc.getJsonArray("classes");
        if (ja != null) {
            int size = ja.size();
            for (int i = 0; i < size; ++i) {
                ExpNode exp;
                JsonObject job = ja.getJsonObject(i);
                JsonArray arf = job.getJsonArray("classDeclaration");
                if (arf != null) {
                    ExpNode exp2 = AntlrAstParser.processClass(arf, exps, names, comments, lines, null);
                    if (exp2 == null) continue;
                    exps.add(exp2);
                    continue;
                }
                JsonArray jarr = job.getJsonArray("variableDeclaration");
                if (jarr == null || (exp = AntlrAstParser.processVariableDeclaration(jarr, exps, names, comments, lines)) == null) continue;
                exp.type = "var_class";
                exps.add(exp);
            }
        }
    }

    static ExpNode processClass(JsonArray arf, List<ExpNode> exps, Map<String, String> names, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, String varName) {
        if (arf != null) {
            boolean process;
            int start = arf.getJsonObject(0).getInt("start");
            int stop = arf.getJsonObject(0).getInt("stop");
            int k = 1;
            String alias = null;
            JsonArray identif = arf.getJsonObject(k).getJsonArray("identifier");
            String name = "";
            if (identif != null) {
                name = identif.getJsonObject(0).getString("text");
                ++k;
            }
            boolean bl = process = names == null;
            if (names != null) {
                alias = varName != null ? names.get(varName) : names.get(name);
                boolean bl2 = process = alias != null;
            }
            if (process) {
                JsonArray par;
                ExpNode exp = new ExpNode();
                exp.type = "class";
                if (alias != null) {
                    exp.name_in_code = name;
                    exp.name = alias;
                } else {
                    exp.name = name;
                }
                ImpExpVisitor.Comment c = comments.get(start - 1);
                if (c != null) {
                    exp.comment = c.comment;
                }
                if (names != null) {
                    if (varName != null) {
                        names.remove(varName);
                    } else {
                        names.remove(name);
                    }
                }
                if (lines != null) {
                    exp.code = ImpExpVisitor.getCode(lines, start, stop);
                }
                if ((par = arf.getJsonObject(k).getJsonArray("classTail")) != null) {
                    JsonValue val = (JsonValue)par.getJsonObject(0).get((Object)"text");
                    if (val != null) {
                        try {
                            String txt = val.toString();
                            if ("\"extends\"".equals(txt)) {
                                String cname;
                                exp.extendsClass = cname = par.getJsonObject(1).getJsonArray("identifierExpression").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    exp.methods = new ArrayList<ExpNode>();
                    for (JsonValue p : par) {
                        ExpNode elem;
                        JsonArray po = ((JsonObject)p).getJsonArray("classElement");
                        if (po == null || (elem = AntlrAstParser.processClassElement(po, exps, comments, lines, start = arf.getJsonObject(0).getInt("start"), stop = arf.getJsonObject(0).getInt("stop"))) == null) continue;
                        if (elem.type.startsWith("method")) {
                            if (exp.methods == null) {
                                exp.methods = new ArrayList<ExpNode>();
                            }
                            exp.methods.add(elem);
                            continue;
                        }
                        if (!elem.type.startsWith("property")) continue;
                        if (exp.properties == null) {
                            exp.properties = new ArrayList<ExpNode>();
                        }
                        exp.properties.add(elem);
                    }
                }
                return exp;
            }
        }
        return null;
    }

    static ExpNode processClassElement(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop) {
        if (arf != null) {
            FuncHelp fh = AntlrAstParser.getClassElementSubType(arf);
            String ce_sub = fh.type;
            ExpNode exp = AntlrAstParser.processMethod(arf, exps, comments, lines, start, stop, fh.count);
            if (exp == null) {
                exp = AntlrAstParser.procesProperty(arf, exps, comments, lines, start, stop, fh.count);
            }
            if (exp != null) {
                exp.subtype = ce_sub == null ? exp.subtype : (exp.subtype == null ? ce_sub : ce_sub + "_" + exp.subtype);
            }
            return exp;
        }
        return null;
    }

    static ExpNode procesProperty(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop, int startIndex) {
        JsonArray mdef = arf.getJsonObject(startIndex).getJsonArray("propertyName");
        ExpNode exp = null;
        if (mdef != null) {
            int k = startIndex;
            String name = mdef.getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
            JsonObject job = arf.getJsonObject(k += 2);
            if (job.containsKey((Object)"functionExpression")) {
                JsonArray jar = job.getJsonArray("functionExpression");
                exp = AntlrAstParser.processFunctionExpression(jar, exps, null, comments, lines, null);
            } else if (job.containsKey((Object)"classExpression")) {
                JsonArray jar = job.getJsonArray("classExpression");
                exp = AntlrAstParser.processClass(jar, exps, null, comments, lines, null);
            }
            if (exp != null) {
                exp.type = "property" + (String)(exp.type == null ? "" : "_" + exp.type);
                if (name != null) {
                    exp.name = name;
                }
            } else {
                exp = new ExpNode();
                exp.name = name;
                exp.type = "property";
            }
        }
        return exp;
    }

    static ExpNode processMethod(JsonArray arf, List<ExpNode> exps, Map<Long, ImpExpVisitor.Comment> comments, List<String> lines, int start, int stop, int startIndex) {
        JsonArray mdef = arf.getJsonObject(startIndex).getJsonArray("methodDefinition");
        if (mdef != null) {
            JsonArray par;
            int arfs;
            int k = 0;
            FuncHelp fh = AntlrAstParser.getSubType(mdef);
            k = fh.count;
            String name = "";
            String typeExt = null;
            String subType = fh.type;
            JsonObject kind = mdef.getJsonObject(k);
            if (kind.containsKey((Object)"propertyName")) {
                name = kind.getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
            } else if (kind.containsKey((Object)"setter")) {
                name = kind.getJsonArray("setter").getJsonObject(1).getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                typeExt = "getter";
            } else if (kind.containsKey((Object)"getter")) {
                name = kind.getJsonArray("getter").getJsonObject(1).getJsonArray("propertyName").getJsonObject(0).getJsonArray("identifierName").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                typeExt = "getter";
            }
            ExpNode exp = new ExpNode();
            exp.type = "method";
            exp.subtype = subType;
            if (typeExt != null) {
                exp.type = exp.type + "_" + typeExt;
            }
            exp.name = name;
            ImpExpVisitor.Comment c = comments.get(start - 1);
            if (c != null) {
                exp.comment = c.comment;
            }
            if ((arfs = mdef.size()) > k + 2 && (par = mdef.getJsonObject(k += 2).getJsonArray("formalParameterList")) != null) {
                exp.params = new ArrayList<ExpNode.Param>();
                for (JsonValue p : par) {
                    JsonArray po = ((JsonObject)p).getJsonArray("formalParameterArg");
                    if (po == null) continue;
                    String pname = po.getJsonObject(0).getJsonArray("assignable").getJsonObject(0).getJsonArray("identifier").getJsonObject(0).getString("text");
                    ExpNode.Param param = new ExpNode.Param();
                    param.name = pname;
                    exp.params.add(param);
                }
            }
            return exp;
        }
        return null;
    }

    public static ModuleMetadata getModuleMetaDataFromJSON(String json) {
        ModuleMetadata moduleMetadata;
        ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8.name()));
        try {
            JsonObject jdoc = ImpExpVisitor.JSF.createReader((InputStream)stream).readObject();
            ModuleMetadata obj = new ModuleMetadata();
            JSONToPropertiesObject tr = new JSONToPropertiesObject();
            tr.processProperties(obj, jdoc);
            moduleMetadata = obj;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)stream).close();
        return moduleMetadata;
    }

    public static String getMetadataFromJS(String code) {
        ModuleMetadata meta = AntlrAstParser.getModuleMetadataFromJS(code);
        if (meta != null) {
            String res = AntlrAstParser.toJsonMetadata(meta.exports, meta.imports, meta.notResolved);
            return res;
        }
        return null;
    }

    public static String getMetadataFromJS(ModuleMetadata meta) {
        if (meta != null) {
            String res = AntlrAstParser.toJsonMetadata(meta.exports, meta.imports, meta.notResolved);
            return res;
        }
        return null;
    }

    public static String toJsonMetadata(List<ExpNode> exps, List<ExpNode> imps, List<ExpNode> notResolved) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addText("{");
        s.addText(AntlrAstParser.listToJson("exports", exps, 1));
        s.addText(",").addText(AntlrAstParser.listToJson("imports", imps, 1));
        if (notResolved.size() > 0) {
            s.addText(",").addText(AntlrAstParser.listToJson("notResolved", notResolved, 1));
        }
        s.addNL().addText("}");
        return s.toString();
    }

    public static String toJsonMetadata(String name, List<ExpNode> list) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addText("{");
        s.addText(AntlrAstParser.listToJson(name, list, 1));
        s.addNL().addText("}");
        return s.toString();
    }

    public static void createPossibleImports(List<ExpNode> notResolved, Map<String, String> names) {
        for (Map.Entry<String, String> val : names.entrySet()) {
            ExpNode exp = new ExpNode();
            exp.type = "exportPossibleImport";
            exp.name_in_code = val.getKey();
            exp.name = val.getValue();
            notResolved.add(exp);
        }
        names.clear();
    }

    static void addExportedVars(List<ExpNode> exps, Map<String, String> names) {
        for (String key : names.keySet()) {
            ExpNode exp = new ExpNode();
            exps.add(exp);
            exp.type = "var";
            exp.name = key;
        }
    }

    static void addExportItems(List<String> items, Map<String, String> names) {
        if (items != null && items.size() > 0) {
            for (String name : items) {
                String[] parts;
                String alias = name = name.strip();
                if (name.indexOf(" as ") > 0 && (parts = name.split(" as ")).length == 2) {
                    name = parts[0];
                    alias = parts[1];
                }
                names.put(name, alias);
            }
        }
    }

    static FuncHelp getClassElementSubType(JsonArray mdef) {
        if (mdef != null) {
            int k = 0;
            Object subType = null;
            JsonObject kind = mdef.getJsonObject(k);
            while (kind.containsKey((Object)"text") || kind.containsKey((Object)"identifier")) {
                String val;
                if (kind.containsKey((Object)"text")) {
                    val = kind.getString("text");
                    String str = val.toString();
                    if ("static".equals(str)) {
                        subType = subType != null ? subType + "_static" : "static";
                    } else if ("async".equals(str)) {
                        subType = subType != null ? (String)subType + "_async" : "async";
                    } else if ("#".equals(str)) {
                        subType = subType != null ? (String)subType + "_private" : "private";
                    } else if ("*".equals(str)) {
                        subType = subType != null ? (String)subType + "_generator" : "generator";
                    }
                } else if (kind.containsKey((Object)"identifier")) {
                    val = kind.getJsonArray("identifier").getJsonObject(0).getString("text");
                    subType = subType != null ? (String)subType + "_" + val : val;
                }
                kind = mdef.getJsonObject(++k);
            }
            FuncHelp fh = new FuncHelp();
            fh.type = subType;
            fh.count = k;
            return fh;
        }
        return null;
    }

    static FuncHelp getFuncType(JsonArray arf) {
        JsonValue jv;
        FuncHelp hlp = new FuncHelp();
        int k = 0;
        String val = arf.getJsonObject(k).getString("text");
        if (val != null && "async".equalsIgnoreCase(val)) {
            hlp.async = true;
            k = 1;
        }
        if (k == 1) {
            val = arf.getJsonObject(k).getString("text");
        }
        if ("function".equalsIgnoreCase(val)) {
            hlp.start = arf.getJsonObject(k).getInt("start");
            hlp.stop = arf.getJsonObject(k).getInt("stop");
        }
        if ((jv = (JsonValue)arf.getJsonObject(++k).get((Object)"text")) != null) {
            val = jv.toString();
            if ("*".equals(val)) {
                hlp.generator = true;
                ++k;
            }
        } else {
            --k;
        }
        hlp.count = k;
        return hlp;
    }

    static FuncHelp getSubType(JsonArray mdef) {
        if (mdef != null) {
            int k = 0;
            Object subType = null;
            JsonObject kind = mdef.getJsonObject(k);
            while (kind.containsKey((Object)"text")) {
                String val = kind.getString("text");
                String str = val.toString();
                if ("#".equals(str)) {
                    subType = subType != null ? subType + "_private" : "private";
                } else if ("*".equals(str)) {
                    subType = subType != null ? (String)subType + "_private" : "generator";
                }
                kind = mdef.getJsonObject(++k);
            }
            FuncHelp fh = new FuncHelp();
            fh.type = subType;
            fh.count = k;
            return fh;
        }
        return null;
    }

    static class FuncHelp {
        boolean async;
        boolean generator;
        boolean private_def;
        boolean static_def;
        String identifier;
        String type;
        int count = 0;
        int start = -1;
        int stop = -1;

        FuncHelp() {
        }
    }
}

