<?xml version="1.0"?>
<!-- Copyright (c) 2000, 2011, Oracle and/or its affiliates. 
All rights reserved. -->
<!--
NAME
    kucolumn.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_column_list_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    abodge      03/07/11 - Fix workaround for bug 10622414
    abodge      11/01/03 - Workaround XDK bug 10395834
    tbhukya     08/03/09 - Bug 8736866: Add intg algo for encrypted column
    sdavidso    02/27/09 - bug 7567327 - ORA-904 importing xmltype
    sdavidso    01/20/09 - bug 5672035: fix quote handling for
                           remap_column_name
    ebatbout    07/02/08 - Bug 4919556: Change raw(36) to raw('length in col$')
                           since ref's can vary in length.
    spetride    04/21/08 - replace XMLTYPE.CREATEXMLFROMBINARY by SYS_SC_2_XMLT 
    ebatbout    01/25/08 - Bug 6021971: Sort Lob columns by intcol_num
    tbhukya     10/03/07 - Bug 6130606: Enable BYTE length semantic for expdp
    mjangir     09/04/07 - bug 5881123: filter mviews hidden cols 
    rapayne     07/23/07 - bug ???: expand type generation.
    lbarton     02/01/07 - IMPORT_CONVENTIONAL
    lbarton     07/09/07 - bug 6005996: suppress unused columns
    jkaloger    06/13/07 - Fix version comparison checks for 11.0
    sdavidso    04/11/07 - avoid export of hierarchy related hidden columns
    lbarton     03/27/07 - bug 5859052: in ext tbls clob cols sort together
    lbarton     07/17/06 - bug 5386908: XMLTYPE_STREAM_FORMAT param 
    lbarton     09/07/06 - lrg 2453260: version compatibility
    lbarton     03/16/06 - bug 45216042: export XMLType as binary 
    htseng      05/31/06 - add column replace null with hextoraw clause 
    htseng      05/18/06 - add virtual columns support 
    lbarton     12/29/05 - REMAP_COLUMN_NAME
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      03/04/05 - bug 4154125: trim the last column with default 
    rapayne     10/12/04 - Bug 3928528: add password to encrypted col desc.
    lbarton     09/16/04 - Bug 3887535: NO SALT in encryption
    lbarton     08/17/04 - lrg1728547/bug 3047454: ADT attr of unused col 
    lbarton     08/05/04 - Bug 3813945: encryption password
    lbarton     07/16/04 - add encryption support 
    htseng      02/26/04 - bug 3369569: exclude hidden column through network 
    lbarton     02/12/04 - Bug 3330599: enhance Trim_string 
    lbarton     09/02/03 - Bug 3113231: ext tbls and unused cols 
    lbarton     08/14/03 - Bug 3047175: TTS and unused cols 
    lbarton     04/28/03 - remove blob_to_ref, ref_to_blob
    lbarton     02/26/03 - emit owner with type synonym
    lbarton     02/10/03 - bugfix: blob_to_opaque should be blob_to_image
    lbarton     02/04/03 - type synonyms
    srseshad    12/06/02 - dtydef values changed for binary_float and binary_double
    lbarton     12/05/02 - new image-blob operators for ext tbl
    htseng      10/01/02 - add SORT support
    htseng      09/26/02 - add floating-point datatypes support
    lbarton     09/24/02 - change spelling of SQL operators
    dgagne      08/27/02 - fix not null constraints
    lbarton     08/09/02 - transportable export
    lbarton     07/25/02 - hidden snapshot base table column
    lbarton     06/03/02 - data layer and network support
    htseng      10/12/01 - add trim_string.
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     10/24/00 - sort in views, not xsl
    lbarton     10/13/00 - bugfix: NOT NULL constraints on adt and ref cols
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/10/00 - bugfix: distinguish NCLOB from CLOB
    lbarton     09/25/00 - codepoint semantics
    lbarton     09/21/00 - bugfix: use SPARE3 for NCHAR length
    lbarton	08/18/00 - logical standby support
    lbarton	07/24/00 - use uriref in import
    lbarton	06/23/00 - TIMESTAMP, INTERVAL
    lbarton	05/15/00 - Params for new API
    lbarton	03/17/00 - Add module header
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kuconstr.xsl"/>
 <!-- Templates -->
 <xsl:template match="COL_LIST">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="DoLF">1</xsl:param>
  <xsl:param name="DoHidden">0</xsl:param>
  <xsl:param name="DoREMAP">0</xsl:param>
  <xsl:param name="Network">0</xsl:param>
  <xsl:param name="Prefix" select="''"/>
  <xsl:param name="ExtTbl">0</xsl:param>
  <xsl:param name="ExtTblOps">0</xsl:param>
  <xsl:param name="ExtTblEncrypt">0</xsl:param>
  <xsl:param name="Mview">0</xsl:param>
  <!-- *******************************************************************
Template: COL_LIST - process a COL_LIST and its members
Parameters:
  ADT_type  - Object type
               'TABLE' - table objects (full column attributes)
               'INDEX' - index (and other) objects (col name only)
  DoLF      - 1 = emit a line feed between columns (if PRETTY=1)
  DoHidden  - 0 = exclude hidden columns
              non-0 = include hidden columns
  DoREMAP   - 0 = don't remap column names
              non-0 = okay to remap column names
  Network   - 1 = NETWORK operation (INSERT into tbl SELECT from remote tbl)
  Prefix    - value of a prefix (e.g., "C1_REC.") to append to the
               column name
  ExtTbl    - for ADT_type='TABLE', what kind of operation
               0 = normal CREATE table
               1 = EXPORT, i.e., External Table unload
               2 = IMPORT, i.e., External Table load
               3 = IMPORT_CONVENTIONAL select statement
               4 = IMPORT_CONVENTIONAL import statement column names
               5 = IMPORT_CONVENTIONAL import statement values clause
                   (3-5 for conventional path load)
  ExtTblOps - do/don't use the special sql operators for external tables
              e.g., SYS_ET_BFILE_TO_RAW.
               0 = don't use
               non-0 = do use
  ExtTblEncrypt - do/don't use the ENCRYPT keyword for encrypted columns
              when ExtTbl !=0
               0 = don't use
               non-0 = do use
******************************************************************** -->
  <xsl:choose>
   <!-- ExtTbl=1 - External table export/import; should not come through here
    -->
   <xsl:when test="$ExtTbl>0"> ** ERROR ** </xsl:when>
   <!-- Special rules for TRANSPORTABLE:
        exclude hidden columns                            - prop bit 0x000020
        but do include unused column (data in row)        - prop bit 0x008000
         that is not ADT attribute                        - prop bit 0x000001
        and do include hidden snapshot base table column  - prop bit 0x100000
        and do include RLS hidden column                  - prop bit 0x800000
     -->
   <xsl:when test="$TRANSPORTABLE!=0">
    <xsl:for-each select="COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
				     or ( (PROPERTY mod 65536)>=32768
                                      and (PROPERTY mod 2)&lt;1)
				     or (PROPERTY mod 2097152)>=1048576
				     or (PROPERTY mod 8388608)>=4194304]">
     <xsl:sort select="INTCOL_NUM" data-type="number"/>
     <xsl:call-template name="DoCOL_LIST_ITEM">
      <xsl:with-param name="ADT_type" select="$ADT_type"/>
      <xsl:with-param name="DoLF" select="$DoLF"/>
      <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
      <xsl:with-param name="Network" select="$Network"/>
      <xsl:with-param name="Prefix" select="$Prefix"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <!-- exclude hidden columns                            - prop bit 0x000020
	when through Network
	bug 3369569
     -->
   <xsl:when test="$Network=1">
    <xsl:for-each select="COL_LIST_ITEM[(PROPERTY mod 64)&lt;32]">
     <!--xsl:sort select="COL_NUM" data-type="number"/-->
     <xsl:call-template name="DoCOL_LIST_ITEM">
      <xsl:with-param name="ADT_type" select="$ADT_type"/>
      <xsl:with-param name="DoLF" select="$DoLF"/>
      <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
      <xsl:with-param name="Network" select="$Network"/>
      <xsl:with-param name="Prefix" select="$Prefix"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:when>
   <!--  
        always exclude unused columns                     - prop bit 0x008000
        also exclude hidden columns                       - prop bit 0x000020
        (but do include hidden snapshot base table column - prop bit 0x100000
         and do include RLS hidden column                 - prop bit 0x800000)
	 and virtual columns that is not                  - prop bit 0x010000
	     system-generated column                      - prop bit 0x000100)
     -->
   <xsl:when test="$DoHidden=0">
    <xsl:if test="$Mview=1">
     <xsl:for-each select="COL_LIST_ITEM[((PROPERTY mod 65536)&lt;32768) and
                                        ((PROPERTY mod 64)&lt;32
                                      or (PROPERTY mod 2097152)>=1048576
                                      or (PROPERTY mod 8388608)>=4194304)
                                      and PROPERTY!=1048608]">
      <!--xsl:sort select="COL_NUM" data-type="number"/-->
      <xsl:call-template name="DoCOL_LIST_ITEM">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="DoLF" select="$DoLF"/>
       <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
       <xsl:with-param name="Network" select="$Network"/>
       <xsl:with-param name="Prefix" select="$Prefix"/>
      </xsl:call-template>
     </xsl:for-each>
    </xsl:if>
    <xsl:if test="$Mview=0">
     <xsl:for-each select="COL_LIST_ITEM[((PROPERTY mod 65536)&lt;32768) and
                                       ((PROPERTY mod 64)&lt;32
                                     or (PROPERTY mod 2097152)>=1048576
                                     or (PROPERTY mod 8388608)>=4194304)]">
      <!--xsl:sort select="COL_NUM" data-type="number"/-->
      <xsl:call-template name="DoCOL_LIST_ITEM">
       <xsl:with-param name="ADT_type" select="$ADT_type"/>
       <xsl:with-param name="DoLF" select="$DoLF"/>
       <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
       <xsl:with-param name="Network" select="$Network"/>
       <xsl:with-param name="Prefix" select="$Prefix"/>
      </xsl:call-template>
     </xsl:for-each>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:for-each select="COL_LIST_ITEM">
     <!--xsl:sort select="COL_NUM" data-type="number"/-->
     <xsl:call-template name="DoCOL_LIST_ITEM">
      <xsl:with-param name="ADT_type" select="$ADT_type"/>
      <xsl:with-param name="DoLF" select="$DoLF"/>
      <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
      <xsl:with-param name="Network" select="$Network"/>
      <xsl:with-param name="Prefix" select="$Prefix"/>
     </xsl:call-template>
    </xsl:for-each>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoExtTblCOL_LIST">
  <xsl:param name="Scalars" select="''"/>
  <xsl:param name="Lobs" select="''"/>
  <xsl:param name="Longs" select="''"/>
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="DoLF">1</xsl:param>
  <xsl:param name="DoHidden">0</xsl:param>
  <xsl:param name="DoREMAP">0</xsl:param>
  <xsl:param name="Network">0</xsl:param>
  <xsl:param name="Prefix" select="''"/>
  <xsl:param name="ExtTbl">0</xsl:param>
  <xsl:param name="ExtTblOps">0</xsl:param>
  <xsl:param name="ExtTblEncrypt">0</xsl:param>
  <!-- *******************************************************************
Template: DoExtTblCOL_LIST - process a COL_LIST and its members
  for external table export or import
Parameters:
  Scalars   - the node set of scalar COL_LIST_ITEM elements
  Lobs      - the node set of lob COL_LIST_ITEM elements
  Longs     - the node set of long COL_LIST_ITEM elements
  ADT_type  - Object type
               'TABLE' - table objects (full column attributes)
               'INDEX' - index (and other) objects (col name only)
  DoLF      - 1 = emit a line feed between columns (if PRETTY=1)
  DoHidden  - 0 = exclude hidden columns
              non-0 = include hidden columns
  DoREMAP   - 0 = don't remap column names
              non-0 = okay to remap column names
  Network   - 1 = NETWORK operation (INSERT into tbl SELECT from remote tbl)
  Prefix    - value of a prefix (e.g., "C1_REC.") to append to the
               column name
  ExtTbl    - for ADT_type='TABLE', what kind of operation
               1 = EXPORT, i.e., External Table unload
               2 = IMPORT, i.e., External Table load
               3 = IMPORT_CONVENTIONAL select statement
               4 = IMPORT_CONVENTIONAL import statement column names
               5 = IMPORT_CONVENTIONAL import statement values clause
                   (3-5 for conventional path load)
  ExtTblOps - do/don't use the special sql operators for external tables
              e.g., SYS_ET_BFILE_TO_RAW.
               0 = don't use
               non-0 = do use
  ExtTblEncrypt - do/don't use the ENCRYPT keyword for encrypted columns
              when ExtTbl !=0
               0 = don't use
               non-0 = do use
Notes:
   Columns in segcol order EXCEPT
      columns that form the expansion of an XMLType stored relationally
       are omitted
      LOBs (or anything that can be stored as a lob such as varrays
       or opaques) are moved to the end but remain in segcol order
       Schema-based and binary XMLType columns are exported in self-
       describing binary as a BLOB, but they sort with all the other LOBs.
      LONGs come last no matter what
   in addition:
       exclude unused columns                            - prop bit 0x008000

       type_num 112 = CLOB
                113 = BLOB
                123 = VARRAY
                 58 = OPAQUE
                  8 = LONG
                 24 = LONG RAW
  base_col_type   1 = UDT
                  2 = XMLType stored OR or CSX
                  3 = XMLType stored as CLOB
                  0 = other
******************************************************************** -->
  <!-- First emit safe scalar types: not lobs, not columns that
       are part of an XMLType stored relationally.
-->
  <xsl:for-each select="$Scalars">
   <xsl:sort select="SEGCOL_NUM" data-type="number"/>
   <xsl:call-template name="DoCOL_LIST_ITEM">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="DoLF" select="$DoLF"/>
    <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
    <xsl:with-param name="Network" select="$Network"/>
    <xsl:with-param name="Prefix" select="$Prefix"/>
    <xsl:with-param name="ExtTbl" select="$ExtTbl"/>
    <xsl:with-param name="ExtTblOps" select="$ExtTblOps"/>
    <xsl:with-param name="ExtTblEncrypt" select="$ExtTblEncrypt"/>
    <xsl:with-param name="Pos" select="position()"/>
   </xsl:call-template>
  </xsl:for-each>
  <!-- now a comma (maybe): if we did any non-lob cols...
       and now we have some lob cols... -->
  <xsl:if test="count($Scalars)>0 and count($Lobs)>0">
   <!-- ... then insert a comma between the last non-lob col
               and the first lob col -->
   <xsl:call-template name="EmitCommaLF">
    <xsl:with-param name="DoLF" select="$DoLF"/>
   </xsl:call-template>
  </xsl:if>
  <!-- LOBs (or anything that can be stored as a lob such as varrays
       or opaques, including schema-based and binary XMLType
       columns are exported in self-describing binary as a BLOB).
       We must sort by intcol_num instead of segcol_num because the
       XMLType columns always have segcol_num=0 and as a result sorting
       by segcol_num would produce the columns in the wrong order -->
  <xsl:for-each select="$Lobs">
   <xsl:sort select="INTCOL_NUM" data-type="number"/>
   <xsl:call-template name="DoCOL_LIST_ITEM">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="DoLF" select="$DoLF"/>
    <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
    <xsl:with-param name="Network" select="$Network"/>
    <xsl:with-param name="Prefix" select="$Prefix"/>
    <xsl:with-param name="ExtTbl" select="$ExtTbl"/>
    <xsl:with-param name="ExtTblOps" select="$ExtTblOps"/>
    <xsl:with-param name="ExtTblEncrypt" select="$ExtTblEncrypt"/>
    <xsl:with-param name="Pos" select="count($Scalars)+position()"/>
   </xsl:call-template>
  </xsl:for-each>
  <!-- now a comma (maybe) -->
  <xsl:if test="(count($Scalars)+count($Lobs))>0 and count($Longs)>0">
   <xsl:call-template name="EmitCommaLF">
    <xsl:with-param name="DoLF" select="$DoLF"/>
   </xsl:call-template>
  </xsl:if>
  <!-- now LONGs (of which there can be at most 1 but, hey, whatever) -->
  <xsl:for-each select="$Longs">
   <xsl:sort select="SEGCOL_NUM" data-type="number"/>
   <xsl:call-template name="DoCOL_LIST_ITEM">
    <xsl:with-param name="ADT_type" select="$ADT_type"/>
    <xsl:with-param name="DoLF" select="$DoLF"/>
    <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
    <xsl:with-param name="Network" select="$Network"/>
    <xsl:with-param name="Prefix" select="$Prefix"/>
    <xsl:with-param name="ExtTbl" select="$ExtTbl"/>
    <xsl:with-param name="ExtTblOps" select="$ExtTblOps"/>
    <xsl:with-param name="ExtTblEncrypt" select="$ExtTblEncrypt"/>
    <xsl:with-param name="Pos" select="count($Scalars)+count($Lobs)+position()"/>
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoCOL_LIST_ITEM">
  <xsl:param name="ADT_type">TABLE</xsl:param>
  <xsl:param name="DoLF">1</xsl:param>
  <xsl:param name="DoREMAP">0</xsl:param>
  <xsl:param name="Network">0</xsl:param>
  <xsl:param name="Prefix" select="''"/>
  <xsl:param name="ExtTbl">0</xsl:param>
  <xsl:param name="ExtTblOps">0</xsl:param>
  <xsl:param name="ExtTblEncrypt">0</xsl:param>
  <xsl:param name="Pos">0</xsl:param>
  <!-- *******************************************************************
Template: DoCOL_LIST_ITEM - process a COL_LIST_ITEM
Parameters:
  ADT_type  - Object type
               'TABLE' - table objects (full column attributes)
               'INDEX' - index (and other) objects (col name only)
  DoLF      - 1 = emit a line feed between columns (if PRETTY=1)
  DoREMAP   - 0 = don't remap column names
              non-0 = okay to remap column names
  Network   - 1 = NETWORK operation (INSERT into tbl SELECT from remote tbl)
  Prefix    - value of a prefix (e.g., "C1_REC.") to append to the
               column name
  ExtTbl    - for ADT_type='TABLE', what kind of operation
               0 = normal CREATE table
               1 = EXPORT, i.e., External Table unload
               2 = IMPORT, i.e., External Table load
               3 = IMPORT_CONVENTIONAL select statement (column name only)
               4 = IMPORT_CONVENTIONAL import statement column names
                     (column name only)
               5 = IMPORT_CONVENTIONAL import statement values clause
                     (bind variable plus optional sql operator)
                   (3-5 for conventional path load)
  ExtTblOps - do/don't use the special sql operators for external tables
              e.g., SYS_ET_BFILE_TO_RAW.
               0 = don't use
               non-0 = do use
  ExtTblEncrypt - do/don't use the ENCRYPT keyword for encrypted columns
              when ExtTbl !=0
               0 = don't use
               non-0 = do use
  Pos        - 1-based position of item
******************************************************************** -->
  <xsl:if test="$PRETTY and $DoLF=1">
   <xsl:text>	</xsl:text>
  </xsl:if>
  <xsl:if test="string-length($Prefix)!=0">
   <xsl:value-of select="$Prefix"/>
  </xsl:if>
  <!--  Type num	Datatype	Comment
	   ========	========	=======
		114	BFILE
		  8	LONG		Import is direct path only
		 24	LONG RAW	Import is direct path only
		 58	OPAQUE
		112	character lob (10.x support of xmltype stored as clob)
		123	VARRAY
	-->
  <xsl:if test="($ExtTbl=1 or $ExtTbl=2 or $ExtTbl=5) and $ExtTblOps!=0 and
          $ADT_type!='TABLE' and
          (TYPE_NUM=114 or
	   TYPE_NUM=8 or
	   TYPE_NUM=24 or
	   TYPE_NUM=58 or
	   TYPE_NUM=112 or
           TYPE_NUM=123)">
   <xsl:choose>
    <xsl:when test="$OPERATION_TYPE='EXPORT'">
     <xsl:choose>
      <xsl:when test="TYPE_NUM=114">SYS_ET_BFILE_TO_RAW(</xsl:when>
      <xsl:when test="TYPE_NUM=8">TO_LOB(</xsl:when>
      <xsl:when test="TYPE_NUM=24">TO_LOB(</xsl:when>
      <xsl:when test="TYPE_NUM=58">
       <xsl:choose>
        <xsl:when test="OPQMD/TYPE=1">
         <!-- XMLType -->
         <xsl:choose>
          <!-- flags 64  = binary XML
                         2  = schema based
                         4  = store as lob
         -->
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='BLOB'">SYS_XMLT_2_SC(</xsl:when>
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='CLOB'">KU$.</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 128)>=64">SYS_XMLT_2_SC(</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 4)>=2">SYS_XMLT_2_SC(</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 8)>=4">KU$.</xsl:when>
         </xsl:choose>
        </xsl:when>
        <!-- not XMLType -->
        <xsl:otherwise>SYS_ET_IMAGE_TO_BLOB(SYS_OP_ITR(</xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:when test="TYPE_NUM=123">SYS_ET_IMAGE_TO_BLOB(</xsl:when>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="$OPERATION_TYPE='IMPORT' or
                    $OPERATION_TYPE='IMPORT_CONVENTIONAL'">
     <xsl:choose>
      <xsl:when test="TYPE_NUM=114">SYS_ET_RAW_TO_BFILE(</xsl:when>
      <xsl:when test="TYPE_NUM=8 and $OPERATION_TYPE='IMPORT'">*** ERROR *** </xsl:when>
      <xsl:when test="TYPE_NUM=24 and $OPERATION_TYPE='IMPORT'">*** ERROR *** </xsl:when>
      <xsl:when test="TYPE_NUM=58">
       <xsl:choose>
        <xsl:when test="OPQMD/TYPE=1">
         <!-- XMLType -->
         <xsl:choose>
          <!-- flags 64  = binary XML
                         2  = schema based
                         4  = store as lob
         -->
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='BLOB'">SYS_SC_2_XMLT(</xsl:when>
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='CLOB'">SYS.XMLTYPE.CREATEXML(</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 128)>=64">SYS_SC_2_XMLT(</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 4)>=2">SYS_SC_2_XMLT(</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 8)>=4">SYS.XMLTYPE.CREATEXML(</xsl:when>
         </xsl:choose>
        </xsl:when>
        <!-- not XMLType -->
        <xsl:otherwise>SYS_OP_ITR(SYS_ET_BLOB_TO_IMAGE(</xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <!--CLOB column with base_col_type=3 will only occur for 10.x import - on 11.1 and later, xmltype import is as type=58-->
      <xsl:when test="TYPE_NUM=112 and BASE_COL_TYPE=3 and $XMLCOL_V10P=1">
       <xsl:text>SYS.XMLTYPE.CREATEXML(</xsl:text>
      </xsl:when>
      <xsl:when test="TYPE_NUM=123">SYS_ET_BLOB_TO_IMAGE(</xsl:when>
     </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>***ERROR: UNEXPECTED OPERATION_TYPE: </xsl:text>
     <xsl:value-of select="$OPERATION_TYPE"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="$ExtTbl=5">
    <!-- build bind variable from position -->
    <xsl:text>:</xsl:text>
    <xsl:value-of select="$Pos"/>
   </xsl:when>
   <!--for xmltype store as CLOB, in 10.x import - we insert into the xmltype column (as the name of the clob column is system generated and may have changed)-->
   <xsl:when test="$ExtTbl>=2 and BASE_COL_NAME and $XMLCOL_V10P=1">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="BASE_COL_NAME"/>
    <xsl:text>"</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoColName">
     <xsl:with-param name="DoREMAP" select="$DoREMAP"/>
     <xsl:with-param name="ExtTbl" select="$ExtTbl"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="($ExtTbl=1 or $ExtTbl=2 or $ExtTbl=5) and $ExtTblOps!=0 and
          $ADT_type!='TABLE' and
          (TYPE_NUM=114 or
	   TYPE_NUM=8 or
	   TYPE_NUM=24 or
	   TYPE_NUM=58 or
	   (TYPE_NUM=112 and $ExtTbl>=2) or
           TYPE_NUM=123)">
   <xsl:choose>
    <xsl:when test="TYPE_NUM=114 or
	   (TYPE_NUM=112 and BASE_COL_TYPE=3 and $XMLCOL_V10P=1)">)</xsl:when>
    <xsl:when test="TYPE_NUM=8 or TYPE_NUM=24">
     <xsl:if test="$OPERATION_TYPE!='IMPORT_CONVENTIONAL'">)</xsl:if>
    </xsl:when>
    <xsl:when test="TYPE_NUM=58">
     <xsl:choose>
      <xsl:when test="$OPERATION_TYPE='EXPORT'">
       <xsl:choose>
        <xsl:when test="OPQMD/TYPE=1">
         <!-- XMLType -->
         <xsl:choose>
          <!-- flags 64  = binary XML
                         2  = schema based
                         4  = store as lob
         -->
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='BLOB'">)</xsl:when>
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='CLOB'">.getClobVal()</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 128)>=64">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 4)>=2">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 2)>=1">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 8)>=4">.getClobVal()</xsl:when>
         </xsl:choose>
        </xsl:when>
        <!-- not XMLType -->
        <xsl:otherwise>,1))</xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:when test="$OPERATION_TYPE='IMPORT' or
                      $OPERATION_TYPE='IMPORT_CONVENTIONAL'">
       <xsl:choose>
        <xsl:when test="OPQMD/TYPE=1">
         <!-- XMLType -->
         <xsl:choose>
          <!-- flags 64  = binary XML
                         2  = schema based
                         4  = store as lob
         -->
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='BLOB'">)</xsl:when>
          <xsl:when test="$XMLTYPE_STREAM_FORMAT='CLOB'">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 128)>=64">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 4)>=2">)</xsl:when>
          <xsl:when test="(OPQMD/FLAGS mod 8)>=4">)</xsl:when>
         </xsl:choose>
        </xsl:when>
        <!-- not XMLType -->
        <xsl:otherwise>
         <xsl:text>,'</xsl:text>
         <xsl:value-of select="TYPEMD/SCHEMA_OBJ/NAME"/>
         <xsl:text>','</xsl:text>
         <xsl:value-of select="TYPEMD/SCHEMA_OBJ/OWNER_NAME"/>
         <xsl:text>'),0)</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>
     </xsl:choose>
    </xsl:when>
    <xsl:when test="TYPE_NUM=123">
     <xsl:choose>
      <xsl:when test="$OPERATION_TYPE='EXPORT'">)</xsl:when>
      <xsl:when test="$OPERATION_TYPE='IMPORT' or
                      $OPERATION_TYPE='IMPORT_CONVENTIONAL'">
       <xsl:text>,'</xsl:text>
       <xsl:value-of select="TYPEMD/SCHEMA_OBJ/NAME"/>
       <xsl:text>','</xsl:text>
       <xsl:value-of select="TYPEMD/SCHEMA_OBJ/OWNER_NAME"/>
       <xsl:text>')</xsl:text>
      </xsl:when>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$ADT_type='TABLE'">
   <!-- emit datatype -->
   <xsl:text> </xsl:text>
   <xsl:apply-templates select="TYPE_NUM">
    <xsl:with-param name="ExtTbl" select="$ExtTbl"/>
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:apply-templates>
   <xsl:if test="(PROPERTY mod 268435456)>= 134217728">
    <xsl:text> SORT</xsl:text>
   </xsl:if>
   <xsl:choose>
    <!-- normal CREATE TABLE -->
    <xsl:when test="$ExtTbl=0">
     <xsl:if test="DEFLENGTH !=0">
      <xsl:choose>
       <!-- virtual column -->
       <xsl:when test="(PROPERTY mod 131072)>= 65536">
        <xsl:text> GENERATED ALWAYS AS (</xsl:text>
        <xsl:apply-templates select="DEFAULT_VAL"/>
        <xsl:choose>
         <xsl:when test="(PROPERTY mod 64)>=32">
          <xsl:text>) VIRTUAL HIDDEN </xsl:text>
         </xsl:when>
         <xsl:otherwise>
          <xsl:text>) VIRTUAL VISIBLE </xsl:text>
         </xsl:otherwise>
        </xsl:choose>
       </xsl:when>
       <!-- no default val for hidden snapshot base table column -->
       <xsl:when test="(PROPERTY mod 2097152)&lt;1048576">
        <!-- default value -->
        <xsl:text> DEFAULT </xsl:text>
        <xsl:apply-templates select="DEFAULT_VAL"/>
        <!-- replace null with hextoraw() -->
        <xsl:if test="BINARYDEFVAL and $TRANSPORTABLE=1">
         <xsl:text> REPLACE NULL WITH HEXTORAW('</xsl:text>
         <xsl:value-of select="BINARYDEFVAL"/>
         <xsl:text>')</xsl:text>
        </xsl:if>
       </xsl:when>
      </xsl:choose>
     </xsl:if>
     <!-- encryption -->
     <xsl:if test="(PROPERTY mod 134217728)>=67108864">
      <xsl:text> ENCRYPT USING </xsl:text>
      <xsl:choose>
       <xsl:when test="../../ENCALG='1'">'3DES168'</xsl:when>
       <xsl:when test="../../ENCALG='2'">'AES128'</xsl:when>
       <xsl:when test="../../ENCALG='3'">'AES192'</xsl:when>
       <xsl:when test="../../ENCALG='4'">'AES256'</xsl:when>
      </xsl:choose>
      <xsl:choose>
       <xsl:when test="../../INTALG='1'"> 'SHA-1'</xsl:when> 
       <xsl:when test="../../INTALG='2'"> 'NOMAC'</xsl:when>
      </xsl:choose>
      <xsl:if test="(PROPERTY mod 1073741824)>=536870912">
       <xsl:text> NO SALT </xsl:text>
      </xsl:if>
     </xsl:if>
     <!-- Export always emits not null constraints -->
     <xsl:choose>
      <xsl:when test="$CONSTRAINTS=1">
       <xsl:apply-templates select="CON"/>
      </xsl:when>
      <xsl:when test="$CONSTRAINTS=0 and $EXPORT=1 and 
			(CON/CONTYPE='7' or CON/CONTYPE='11')">
       <xsl:apply-templates select="CON"/>
      </xsl:when>
     </xsl:choose>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <!-- External table unload/load and encryption -->
  <xsl:if test="$ExtTbl!=0 and $ExtTblEncrypt!=0
                              and (PROPERTY mod 134217728)>=67108864">
   <xsl:if test="string-length($ENCRYPTION_PASSWORD)>0">
    <xsl:text> ENCRYPT USING 'AES128' IDENTIFIED BY "</xsl:text>
    <xsl:value-of select="$ENCRYPTION_PASSWORD"/>
    <xsl:text>" </xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- Put out a comma / LF if not the last col -->
  <xsl:if test="not(position()=last())">
   <xsl:call-template name="EmitCommaLF">
    <xsl:with-param name="DoLF" select="$DoLF"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoColName">
  <xsl:param name="DoREMAP">0</xsl:param>
  <xsl:param name="ExtTbl">0</xsl:param>
  <!-- *******************************************************************
Template: DoColName - emit the column name (remapped if necessary)
 Current node is COL_LIST_ITEM
Parameters:
  DoREMAP   - 0 = don't remap column names
              non-0 = okay to remap column names
  ExtTbl    - for ADT_type='TABLE', what kind of operation
               0 = normal CREATE table
               1 = EXPORT, i.e., External Table unload
               2 = IMPORT, i.e., External Table load
               3 = IMPORT_CONVENTIONAL select statement
               4 = IMPORT_CONVENTIONAL import statement column names
               5 = IMPORT_CONVENTIONAL import statement values clause
                   (3-5 for conventional path load)
******************************************************************** -->
  <!-- Remap  column name if specified 
        The actual column name will appear as an alias,
        e.g., func(EMPNO) "EMPNO" -->
  <xsl:if test="$DoREMAP!=0">
   <xsl:choose>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO1">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN1"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO2">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN2"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO3">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN3"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO4">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN4"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO5">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN5"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO6">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN6"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO7">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN7"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO8">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN8"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO9">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN9"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="NAME=$REMAP_COLUMN_NAMEO10">
     <xsl:call-template name="SubstQuot">
      <xsl:with-param name="String" select="$REMAP_COLUMN_NAMEN10"/>
     </xsl:call-template>
     <xsl:text> </xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="$ExtTbl=0">
    <xsl:call-template name="ColNameOrAttr">
     <xsl:with-param name="ColItem" select="current()"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!-- For EXPORT or IMPORT always use the col name, not the attrname -->
    <xsl:text>"</xsl:text>
    <xsl:value-of select="NAME"/>
    <xsl:text>"</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="EmitCommaLF">
  <xsl:param name="DoLF">1</xsl:param>
  <!-- *******************************************************************
Template: EmitCommaLF - Emit a comma and (optionally) a line-feed.
Parameters:
  DoLF      - 1 = emit a line feed between columns (if PRETTY=1)
******************************************************************** -->
  <xsl:text>, </xsl:text>
  <xsl:if test="$PRETTY=1 and $DoLF=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="TYPE_NUM">
  <xsl:param name="ExtTbl">0</xsl:param>
  <xsl:param name="ParentNode">0</xsl:param>
  <!-- *******************************************************************
Template: TYPE_NUM - emit column datatype for TABLE
Parameters:
  ExtTbl    - for ADT_type='TABLE', what kind of operation
               0 = normal CREATE table
               1 = EXPORT, i.e., External Table unload
               2 = IMPORT, i.e., External Table load
               3 = IMPORT_CONVENTIONAL select statement
               4 = IMPORT_CONVENTIONAL import statement column names
               5 = IMPORT_CONVENTIONAL import statement values clause
                   (3-5 for conventional path load)
 ParentNode = Node containing TYPEMD, LENGTH, CHARSETFORM,etc
                     (i.e., it use to be ..)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test=".='1' or .='9'">
    <xsl:choose>
     <xsl:when test="$ParentNode/CHARSETFORM='2'">
      <xsl:text>NVARCHAR2(</xsl:text>
      <xsl:value-of select="$ParentNode/SPARE3"/>
      <xsl:text>)</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>VARCHAR2</xsl:text>
      <xsl:call-template name="DoCharLength">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='2'">
    <xsl:choose>
     <xsl:when test="($ParentNode/PRECISION_NUM) and not($ParentNode/SCALE)">FLOAT</xsl:when>
     <xsl:otherwise>NUMBER</xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="DoPrecScale">
     <xsl:with-param name="Node" select="$ParentNode"/>
    </xsl:call-template>
   </xsl:when>
   <!-- 3 - integer
      7 - packed decimal
      246 - smallint
-->
   <xsl:when test=".='3' or
                               .='246'">
    <xsl:text>INTEGER</xsl:text>
   </xsl:when>
   <!-- 7 - packed decimal -->
   <xsl:when test=".='7'">
    <xsl:text>DECIMAL</xsl:text>
    <xsl:call-template name="DoPrecScale">
     <xsl:with-param name="Node" select="$ParentNode"/>
     <xsl:with-param name="TypeObj">1</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test=".='4' or 
                               .='22'">
    <xsl:text>FLOAT</xsl:text>
    <xsl:call-template name="DoPrecScale">
     <xsl:with-param name="Node" select="$ParentNode"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test=".='8'">
    <xsl:choose>
     <xsl:when test="$ExtTbl=0">LONG</xsl:when>
     <xsl:otherwise>CLOB</xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='12'">DATE</xsl:when>
   <xsl:when test=".='100'">
    <xsl:text>BINARY_FLOAT</xsl:text>
   </xsl:when>
   <xsl:when test=".='101'">
    <xsl:text>BINARY_DOUBLE</xsl:text>
   </xsl:when>
   <xsl:when test=".='178'">
    <xsl:text>TIME (</xsl:text>
    <xsl:value-of select="../SCALE"/>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test=".='179'">
    <xsl:text>TIME (</xsl:text>
    <xsl:value-of select="../SCALE"/>
    <xsl:text>) WITH TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test=".='180'">
    <xsl:text>TIMESTAMP (</xsl:text>
    <xsl:value-of select="../SCALE"/>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test=".='181'">
    <xsl:text>TIMESTAMP (</xsl:text>
    <xsl:value-of select="../SCALE"/>
    <xsl:text>) WITH TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test=".='231'">
    <xsl:text>TIMESTAMP (</xsl:text>
    <xsl:value-of select="../SCALE"/>
    <xsl:text>) WITH LOCAL TIME ZONE</xsl:text>
   </xsl:when>
   <xsl:when test=".='182'">
    <xsl:text>INTERVAL YEAR (</xsl:text>
    <xsl:value-of select="../PRECISION_NUM"/>
    <xsl:text>) TO MONTH</xsl:text>
   </xsl:when>
   <xsl:when test=".='183'">
    <xsl:text>INTERVAL DAY (</xsl:text>
    <xsl:value-of select="$ParentNode/PRECISION_NUM"/>
    <xsl:text>) TO SECOND (</xsl:text>
    <xsl:value-of select="$ParentNode/SCALE"/>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test=".='21'">
    <xsl:text>REAL</xsl:text>
   </xsl:when>
   <xsl:when test=".='23' or .='95'">
    <xsl:text>RAW</xsl:text>
    <xsl:apply-templates select="$ParentNode/LENGTH"/>
   </xsl:when>
   <xsl:when test=".='24'">
    <xsl:choose>
     <xsl:when test="$ExtTbl=0">LONG RAW</xsl:when>
     <xsl:otherwise>BLOB</xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='69'">
    <xsl:text>ROWID</xsl:text>
   </xsl:when>
   <xsl:when test=".='208'">
    <xsl:text>UROWID (</xsl:text>
    <xsl:value-of select="$ParentNode/LENGTH"/>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test=".='96'">
    <xsl:choose>
     <xsl:when test="../CHARSETFORM='2'">
      <xsl:text>NCHAR(</xsl:text>
      <xsl:value-of select="$ParentNode/SPARE3"/>
      <xsl:text>)</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>CHAR</xsl:text>
      <xsl:call-template name="DoCharLength">
       <xsl:with-param name="ParentNode" select="$ParentNode"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='105'">MLSLABEL</xsl:when>
   <xsl:when test=".='111'">
    <xsl:choose>
     <xsl:when test="$ExtTbl=0">
      <xsl:for-each select="$ParentNode/TYPEMD">
       <xsl:text>REF </xsl:text>
       <xsl:apply-templates select="SCHEMA_OBJ"/>
      </xsl:for-each>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>RAW(</xsl:text>
      <xsl:value-of select="$ParentNode/LENGTH"/>
      <xsl:text>)</xsl:text>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='112'">
    <xsl:choose>
     <xsl:when test="$ParentNode/CHARSETFORM='2'">NCLOB</xsl:when>
     <xsl:otherwise>CLOB</xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test=".='113'">BLOB</xsl:when>
   <xsl:when test=".='114'">
    <xsl:choose>
     <xsl:when test="$ExtTbl=0">BFILE</xsl:when>
     <xsl:otherwise>RAW(530)</xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <!--  Type num	Datatype
	   ========	========
		108 NTY
	-->
   <xsl:when test=".='108'">
    <xsl:if test="($ParentNode/PROPERTIES mod 65536)>=32768">
     <xsl:text>REF </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="$ParentNode/TYPEMD/SCHEMA_OBJ">
     <xsl:with-param name="TrailingBlank">0</xsl:with-param>
    </xsl:apply-templates>
   </xsl:when>
   <!--  Type num	Datatype
	   ========	========
		121	UDT
		122	Nested table
		123	Varray
		 58	Opaque
	-->
   <xsl:when test=".='121' or .='122' or .='123' or .='58'">
    <xsl:choose>
     <xsl:when test="$ExtTbl=0">
      <xsl:choose>
       <xsl:when test="$ParentNode/TYPEMD">
        <xsl:for-each select="$ParentNode/TYPEMD">
         <xsl:choose>
          <xsl:when test="SYN_NAME">
           <xsl:if test="SYN_OWNER!='PUBLIC'">
            <xsl:text>"</xsl:text>
            <xsl:value-of select="SYN_OWNER"/>
            <xsl:text>".</xsl:text>
           </xsl:if>
           <xsl:text>"</xsl:text>
           <xsl:value-of select="SYN_NAME"/>
           <xsl:text>"</xsl:text>
          </xsl:when>
          <xsl:otherwise>
           <xsl:apply-templates select="SCHEMA_OBJ"/>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
        <!-- TYPE_SPEC have a <SCHEMA_OBJ> rather than a <TYPEMD> -->
        <xsl:apply-templates select="$ParentNode/SCHEMA_OBJ">
         <xsl:with-param name="TrailingBlank">0</xsl:with-param>
        </xsl:apply-templates>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:choose>
       <xsl:when test=".='121'">RAW(2)</xsl:when>
       <xsl:when test=".='122'">RAW(16)</xsl:when>
       <xsl:when test=".='123'">BLOB</xsl:when>
       <xsl:when test=".='58'">
        <xsl:choose>
         <xsl:when test="$ParentNode/OPQMD/TYPE=1">
          <!-- XMLType -->
          <xsl:choose>
           <!-- flags 64  = binary XML
                         2  = schema based
                         4  = store as lob
         -->
           <xsl:when test="$XMLTYPE_STREAM_FORMAT='BLOB'">BLOB</xsl:when>
           <xsl:when test="$XMLTYPE_STREAM_FORMAT='CLOB'">CLOB</xsl:when>
           <xsl:when test="($ParentNode/OPQMD/FLAGS mod 128)>=64">BLOB</xsl:when>
           <xsl:when test="($ParentNode/OPQMD/FLAGS mod 4)>=2">BLOB</xsl:when>
           <xsl:otherwise>CLOB</xsl:otherwise>
          </xsl:choose>
         </xsl:when>
         <!-- not XMLType -->
         <xsl:otherwise>BLOB</xsl:otherwise>
        </xsl:choose>
       </xsl:when>
       <xsl:otherwise>*** INTERNAL ERROR ***</xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>***UNSUPPORTED DATA TYPE (</xsl:text>
    <xsl:value-of select="current()"/>
    <xsl:text>)***</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoCharLength">
  <xsl:param name="ParentNode">0</xsl:param>
  <!-- *******************************************************************
Template: DoCharLength - emit the length of a character datatype
           (CHAR, NCHAR, VARCHAR, NVARCHAR) and, optionally,
           the CHAR or BYTE keyword
Paremeter:
          ParentNode 
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:choose>
   <!-- character-length semantics -->
   <xsl:when test="($ParentNode/PROPERTY mod 16777216)>=8388608">
    <xsl:value-of select="../SPARE3"/>
    <xsl:text> CHAR</xsl:text>
   </xsl:when>
   <!-- byte-length semantics -->
   <xsl:otherwise>
    <xsl:value-of select="$ParentNode/LENGTH"/>
    <xsl:if test="$SIZE_BYTE_KEYWORD=1 or $EXPORT=1">
     <xsl:text> BYTE</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="LENGTH">
  <!-- *******************************************************************
Template: LENGTH - used for length of RAWs
******************************************************************** -->
  <xsl:text>(</xsl:text>
  <xsl:value-of select="."/>
  <xsl:if test="(../SCALE) and not(../SCALE='0')">
   <xsl:text>,</xsl:text>
   <xsl:value-of select="../SCALE"/>
  </xsl:if>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template name="DoPrecScale">
  <xsl:param name="Node" select="''"/>
  <xsl:param name="TypeObj">0</xsl:param>
  <!-- *******************************************************************
Template: DoPrecScale
     This template used for  NUMBER(x,y) and FLOAT(z)
     There are 4 cases (see below)
Parameters:
 Node - parent node of SCALE, PRECISION_NUM, etc.
 TypeObj - TYPE definitions do not allow wildcarding PRECISION (e.g., NUMBER(*,2)
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="($Node/PRECISION_NUM)">
    <!--
     precision	scale	result
	Y	  Y	NUMBER(prec,scale)
	Y	  N	FLOAT(prec)
 -->
    <xsl:text>(</xsl:text>
    <xsl:value-of select="($Node/PRECISION_NUM)"/>
    <xsl:if test="($Node/SCALE)">
     <xsl:text>,</xsl:text>
     <xsl:value-of select="$Node/SCALE"/>
    </xsl:if>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:when test="($Node/PRECISION)">
    <!--
     precision	scale	result
	Y	  Y	NUMBER(prec,scale)
	Y	  N	FLOAT(prec)
 -->
    <xsl:text>(</xsl:text>
    <xsl:value-of select="($Node/PRECISION)"/>
    <xsl:if test="($Node/SCALE)">
     <xsl:text>,</xsl:text>
     <xsl:value-of select="$Node/SCALE"/>
    </xsl:if>
    <xsl:text>)</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <!--
     precision	scale	result
	N	  Y	NUMBER(*,scale)
	N	  N	NUMBER
 -->
    <xsl:if test="($Node/SCALE) and $TypeObj!=1">
     <xsl:text>(*,</xsl:text>
     <xsl:value-of select="$Node/SCALE"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="DEFAULT_VAL">
  <!-- *******************************************************************
Template: DEFAULT_VAL - column default
******************************************************************** -->
  <xsl:call-template name="Trim_string">
   <xsl:with-param name="String" select="."/>
   <xsl:with-param name="TrimAllWS">1</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="Trim_string">
  <xsl:param name="String"/>
  <xsl:param name="TrimAllWS">0</xsl:param>
  <!-- *******************************************************************
Template: Trim_string - trim trailing white space, then output string
     Parameters:   String = the string to trim
                   TrimAllWS = 0: only trim trailing space (default)
                               1: trim all trailing whitespace
     TrimAllWS is designed to handle default values that are stored
     in the dictionary with a trailing new-line, e.g.,

       create table foo( a number default 1
                    );

     The default value is stored as "1<NL>".
     Since pretty-printing introduces a new-line before the trailing right
     paren, failure to trim the new-line in the default value can cause
     a blank line in the generated DDL:

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1

         );

     Trimming the new-line fixes the problem in this case, but it doesn't
     if the column default value includes a comment and the column is not the
     last item before the right paren: in that case the comma separator
     appears right after the comment, i.e., it becomes part of the comment.  
     (Since XSL does not allow the string "dash-dash" inside xsl comments,
     in this and subsequent examples the comment string is represented "- -").

       create table foo(a number default 1 - - this is a comment
                    , constraint bar foreign key ...
                    );

     We would generate

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment,
         CONSTRAINT "BAR" FOREIGN KEY ...
         );

     The code below causes the least harm but is still not perfect, e.g.,

       create table foo(a number default 1 - - this is a comment
                    );

     still results in a blank line

       CREATE TABLE "FOO" (
         "A" NUMBER DEFAULT 1 - - this is a comment

         );

     (All this would be much easier if xsl allowed us to keep state.)
******************************************************************** -->
  <!-- Workaround for bug 10622414/10395834 -->
  <xsl:variable name='strlen' select='string-length($String)'/>
  <xsl:choose>
   <xsl:when test="$TrimAllWS=1 and contains($String,'--')=0 and
string-length(normalize-space(substring($String,$strlen,1)))=0">
    <xsl:call-template name="Trim_string">
     <xsl:with-param name="String" select="substring($String,1,($strlen)-1)"/>
     <xsl:with-param name="TrimAllWS">1</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="substring($String,$strlen,1)=' '">
    <xsl:value-of select="substring($String,1,($strlen)-1)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$String"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template match="CON">
  <!-- *******************************************************************
Template: CON - emit not-null constraint
******************************************************************** -->
  <xsl:if test="CONTYPE='7' or CONTYPE='11'">
   <xsl:call-template name="DoConstraint">
    <xsl:with-param name="TAB_CONSTRAINT">0</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoParseLongPosition">
  <xsl:param name="Scalars" select="''"/>
  <xsl:param name="Lobs" select="''"/>
  <xsl:param name="Longs" select="''"/>
  <!-- *******************************************************************
Template: DoParseLongPosition
Parameters:
  Scalars   - the node set of scalar COL_LIST_ITEM elements
  Lobs      - the node set of lob COL_LIST_ITEM elements
  Longs     - the node set of long COL_LIST_ITEM elements
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="count($Longs)!=0">
    <xsl:value-of select="count($Scalars)+count($Lobs)+1"/>
   </xsl:when>
   <xsl:otherwise>0</xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
