<?xml version="1.0"?>
<!-- 
NAME
    kumviewl.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_m_viewlog_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    wesmith     07/15/08 - 11.2 MV log exp/imp support
    wesmith     04/07/08 - Project 25482: add support for COMMIT SCN
    wesmith     12/21/07 - MV log purge optimization
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      10/19/05 - bug 4120481: fix MONITORING for 9.2
    lbarton     12/03/03 - Bug 3293307: suppress NEW VALUES if export 
    lbarton     07/15/03 - Bug 3045654: nested table tablespace if vsn >= 10
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     08/02/02 - transportable export
    htseng      11/08/01 - fix bug 2100506 -follow the object_type rolue.
    dgagne      10/22/01 - update for compress and row movement
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kutable.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <!--
<xsl:import href="kuiot.xsl"/>
<xsl:import href="kuprtobj.xsl"/>
-->
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- the following are for storage parameters only -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="M_VIEW_LOG_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">MATERIALIZED VIEW LOG</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="MVIEWLOG/MOWNER"/>
   <xsl:with-param name="BaseNameNode" select="MVIEWLOG/MASTER"/>
  </xsl:call-template>
  <xsl:text>CREATE MATERIALIZED VIEW LOG ON "</xsl:text>
  <xsl:value-of select="MVIEWLOG/MOWNER"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="MVIEWLOG/MASTER"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="$EXPORT = 0">
   <xsl:call-template name="DoMetaDataMVL"/>
  </xsl:if>
  <xsl:if test="$PRETTY=1 and $EXPORT=0">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> WITH</xsl:text>
  <xsl:call-template name="DoMVLWith">
   <xsl:with-param name="BitPos" select="512"/>
   <xsl:with-param name="CommaNeeded" select="0"/>
  </xsl:call-template>
  <xsl:if test="$EXPORT = 0">
   <xsl:if test="(MVIEWLOG/FLAG mod 8) >= 4">
    <xsl:text> ( </xsl:text>
    <xsl:choose>
     <xsl:when test="((MVIEWLOG/FLAG mod 4) >= 2) or
                      ((MVIEWLOG/FLAG mod 8192) >= 4096)">
      <xsl:for-each select="MVIEWLOG/FC_LIST/FC_LIST_ITEM[FLAG != 2]">
       <xsl:if test="position()!=1">
        <xsl:text>, </xsl:text>
       </xsl:if>
       <xsl:text>"</xsl:text>
       <xsl:value-of select="COLNAME"/>
       <xsl:text>"</xsl:text>
      </xsl:for-each>
     </xsl:when>
     <xsl:otherwise>
      <xsl:for-each select="MVIEWLOG/FC_LIST//FC_LIST_ITEM">
       <xsl:if test="position()!=1">
        <xsl:text>, </xsl:text>
       </xsl:if>
       <xsl:text>"</xsl:text>
       <xsl:value-of select="COLNAME"/>
       <xsl:text>"</xsl:text>
      </xsl:for-each>
     </xsl:otherwise>
    </xsl:choose>
    <xsl:text> )</xsl:text>
   </xsl:if>
   <xsl:if test="(MVIEWLOG/FLAG mod 32) >= 16">
    <xsl:text> INCLUDING NEW VALUES</xsl:text>
   </xsl:if>
   <xsl:if test="(MVIEWLOG/FLAG mod 64) >= 32">
    <xsl:text> EXCLUDING NEW VALUES</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="MVIEWLOG/VERS_MAJOR>1 or 
                (MVIEWLOG/VERS_MAJOR=1 and MVIEWLOG/VERS_MINOR>=1)">
   <xsl:if test="(MVIEWLOG/FLAG mod 32768) >= 16384">
    <xsl:text> PURGE IMMEDIATE ASYNCHRONOUS</xsl:text>
   </xsl:if>
   <xsl:if test="(MVIEWLOG/FLAG mod 65536) >= 32768">
    <xsl:text> PURGE START WITH TO_DATE('</xsl:text>
    <xsl:value-of select="MVIEWLOG/PURGE_START"/>
    <xsl:text>', 'YYYY-MM-DD:HH24:MI:SS')</xsl:text>
    <xsl:if test="string-length(MVIEWLOG/PURGE_NEXT) !=0">
     <xsl:text> NEXT </xsl:text>
     <xsl:value-of select="MVIEWLOG/PURGE_NEXT"/>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <xsl:if test="$EXPORT = 1">
   <xsl:call-template name="DoExpMVL"/>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <!-- bug 4120481: in 9.2 MONITORING bit was set up and check but not 10g -->
  <xsl:if test="$EXPORT = 0 and (MVIEWLOG_TAB/FLAGS mod 4194304)>=2097152">
   <xsl:text>&#xa; </xsl:text>
   <xsl:text> ALTER TABLE "</xsl:text>
   <xsl:value-of select="MVIEWLOG_TAB/SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>"."</xsl:text>
   <xsl:value-of select="MVIEWLOG_TAB/SCHEMA_OBJ/NAME"/>
   <xsl:text>" MONITORING</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoMVLWith">
  <xsl:param name="BitPos"/>
  <xsl:param name="CommaNeeded"/>
  <xsl:choose>
   <xsl:when test="$BitPos = 512">
    <xsl:choose>
     <xsl:when test="(MVIEWLOG/FLAG mod 1024) >= 512">
      <xsl:text> OBJECT ID</xsl:text>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="2"/>
       <xsl:with-param name="CommaNeeded" select="1"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="2"/>
       <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$BitPos = 2">
    <xsl:choose>
     <xsl:when test="(MVIEWLOG/FLAG mod 4) >= 2">
      <xsl:if test="$CommaNeeded = 1">
       <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:text> PRIMARY KEY</xsl:text>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="1"/>
       <xsl:with-param name="CommaNeeded" select="1"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="1"/>
       <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$BitPos = 1">
    <xsl:choose>
     <xsl:when test="(MVIEWLOG/FLAG mod 2) = 1">
      <xsl:if test="$CommaNeeded = 1">
       <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:text> ROWID</xsl:text>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="1024"/>
       <xsl:with-param name="CommaNeeded" select="1"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="1024"/>
       <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$BitPos = 1024">
    <xsl:choose>
     <xsl:when test="(MVIEWLOG/FLAG mod 2048) >= 1024">
      <xsl:if test="$CommaNeeded = 1">
       <xsl:text>,</xsl:text>
      </xsl:if>
      <xsl:text> SEQUENCE</xsl:text>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="65536"/>
       <xsl:with-param name="CommaNeeded" select="1"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoMVLWith">
       <xsl:with-param name="BitPos" select="65536"/>
       <xsl:with-param name="CommaNeeded" select="$CommaNeeded"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:when test="$BitPos = 65536">
    <xsl:if test="(MVIEWLOG/VERS_MAJOR>1 or 
                   (MVIEWLOG/VERS_MAJOR=1 and MVIEWLOG/VERS_MINOR>=1)) and
                  (MVIEWLOG/FLAG mod 131072) >= 65536">
     <xsl:if test="$CommaNeeded = 1">
      <xsl:text>,</xsl:text>
     </xsl:if>
     <xsl:text> COMMIT SCN</xsl:text>
    </xsl:if>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <!-- Template for Metadata text -->
 <xsl:template name="DoMetaDataMVL">
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:apply-templates select="MVIEWLOG_TAB"/>
 </xsl:template>
 <xsl:template match="MVIEWLOG_TAB">
  <xsl:call-template name="GenTablePhysicalAttrs">
   <xsl:with-param name="MVIEW_LOG" select="1"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="DoExpMVL">
  <xsl:text> USING ("</xsl:text>
  <xsl:value-of select="MVIEWLOG/LOG"/>
  <xsl:text>", (</xsl:text>
  <xsl:choose>
   <xsl:when test="MVIEWLOG/VERS_MAJOR>1 or 
                   (MVIEWLOG/VERS_MAJOR=1 and MVIEWLOG/VERS_MINOR>=1)">
    <xsl:value-of select="10"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="5"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>, '</xsl:text>
  <xsl:value-of select="MVIEWLOG/GLOBAL_DB_NAME"/>
  <xsl:text>', </xsl:text>
  <xsl:value-of select="MVIEWLOG/FLAG"/>
  <xsl:text>, '</xsl:text>
  <xsl:value-of select="MVIEWLOG/YOUNGEST"/>
  <xsl:text>', '</xsl:text>
  <xsl:value-of select="MVIEWLOG/OLDEST_PK"/>
  <xsl:text>', '</xsl:text>
  <xsl:value-of select="MVIEWLOG/MTIME"/>
  <xsl:text>', '</xsl:text>
  <xsl:value-of select="MVIEWLOG/OLDEST_OID"/>
  <xsl:text>', '</xsl:text>
  <xsl:value-of select="MVIEWLOG/OLDEST_NEW"/>
  <xsl:if test="MVIEWLOG/VERS_MAJOR>1 or 
                (MVIEWLOG/VERS_MAJOR=1 and MVIEWLOG/VERS_MINOR>=1)">
   <xsl:text>', '</xsl:text>
   <xsl:value-of select="MVIEWLOG/OLDEST_SEQ"/>
  </xsl:if>
  <xsl:text>'</xsl:text>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEWLOG/FC_COUNT"/>
  <xsl:if test="MVIEWLOG/FC_COUNT > 0">
   <xsl:for-each select="MVIEWLOG/FC_LIST/FC_LIST_ITEM">
    <xsl:text>, "</xsl:text>
    <xsl:value-of select="COLNAME"/>
    <xsl:text>", '</xsl:text>
    <xsl:value-of select="OLDEST"/>
    <xsl:text>', </xsl:text>
    <xsl:value-of select="FLAG"/>
    <xsl:text/>
   </xsl:for-each>
  </xsl:if>
  <xsl:text>, </xsl:text>
  <xsl:value-of select="MVIEWLOG/LM_COUNT"/>
  <xsl:if test="MVIEWLOG/LM_COUNT > 0">
   <xsl:for-each select="MVIEWLOG/LM_LIST/LM_LIST_ITEM">
    <xsl:text>, </xsl:text>
    <xsl:value-of select="SNAPID"/>
    <xsl:text>, '</xsl:text>
    <xsl:value-of select="SNAPTIME"/>
    <xsl:text>'</xsl:text>
    <xsl:if test="../../VERS_MAJOR>1 or 
                   (../../VERS_MAJOR=1 and ../../VERS_MINOR>=1)">
     <xsl:text>, </xsl:text>
     <xsl:value-of select="TSCN"/>
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
  <xsl:if test="MVIEWLOG/TEMP_LOG">
   <xsl:text>, ("</xsl:text>
   <xsl:value-of select="MVIEWLOG/TEMP_LOG"/>
   <xsl:text>")</xsl:text>
  </xsl:if>
  <xsl:text>))</xsl:text>
 </xsl:template>
</xsl:stylesheet>
