<?xml version="1.0"?>
<!--

 Copyright (c) 2000, 2009, Oracle and/or its affiliates. All rights reserved. 

NAME
    kutable.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_{h/fh/pfh/io}table_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    tbhukya     08/27/09 - Bug 8787512: Add space after MAPPING TABLE clause
    sdavidso    07/29/09 - bug 7712504: TTS and tables with hierarchy
    dgagne      07/29/09 - add patchdictionary calls
    lbarton     06/17/09 - lrg 3543159: XMLType virtual columns
    lbarton     06/15/09 - remove hybrid columnar noise words
    sdavidso    04/23/09 - bug 7597578: support NT partition properties
    lbarton     11/25/08 - archive level compression
    sdavidso    04/10/09 - bug 7567327: fix import of xmltype col from 10.x
    lbarton     10/07/08 - bug 5661474: network exp/imp of (sub)partitions
    lbarton     02/18/09 - bug 8252494: more deferred segment creation
    rapayne     12/06/09 - handle different BLOCKSIZE paths for CM.
    lbarton     01/21/09 - bug 7831566: SEGMENT CREATION IMMEDIATE
    lbarton     10/23/08 - bug 7503865: GLOBAL keyword in
                           nested_table_col_properties
    lbarton     08/28/08 - bug 7334782: more xmltype virt cols
    lbarton     06/23/08 - bug 6523175: xmltype virtual columns
    lbarton     03/18/08 - deferred segment creation
    dgagne      11/14/07 - add network name transform
    lbarton     11/02/07 - bug 6060058: flashback archived tables
    lbarton     02/01/07 - IMPORT_CONVENTIONAL
    rapayne     04/01/07 - bug 5910237: ensure additional space after
                           RETURN AS VALUE/LOCATOR clause.
    lbarton     09/18/06 - bug 5212908: PARALLEL_HINT
    lbarton     07/17/06 - bug 5386908: XMLTYPE_STREAM_FORMAT param 
    dgagne      05/12/06 - remove transportable requirement to departition a 
                           table 
    weizhang    05/30/06 - proj 19400: enable TABLESPACE for GTT
    cchiappa    04/11/06 - ORGANIZATION CUBE tables 
    cmlim       11/29/05 - support dml error logging 
    lbarton     01/20/06 - partition transportable; split off kutabcon.xsl
                            and kuntab.xsl
    rapayne     01/27/06 - lrg 2035104:ROW MOVEMENT tied to FLAGS not TRIGFLAGS
    lbarton     01/20/06 - fix test for ext tbl 
    htseng      12/16/05 - add transform param PARTITIONING 
    lbarton     12/29/05 - REMAP_COLUMN_NAME
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      10/19/05 - fix bug 4120481:add MVIEW_LOG param to DoParallel 
    sdavidso    09/20/05 - fix compressed keys in partioned IOT 
    htseng      08/05/05 - bug 3560220: get correct behavior from processor
    lbarton     05/04/05 - bug 4347010: exclude unused columns
    htseng      02/10/05 - bug 3966743: enable row movement
    htseng      01/18/05 - fix bug 4128169 : setup correct filter for 
                           tablespace 
    lbarton     01/04/05 - bug 4017065: SUBSTITUTABLE on object table 
    rpfau       12/01/04 - Fix problem if system generated column name for 
                           object attr. Put out XMLschema info if needed for
                           attributes in object tables.
    rpfau       11/22/04 - Do not put out check_type calls for transportable 
                           classic. 
    rpfau       10/25/04 - More on bug 3599656 - remove just added owner_name 
                           and name from ku_subcoltype_t and do versioning. 
    rpfau       10/15/04 - bug 3599656 - call check_type before creating 
                           tables for transportable import.
    lbarton     08/17/04 - lrg1728547/bug 3047454: ADT attr of unused col 
    lbarton     08/05/04 - Bug 3813945: encryption password
    rpfau       06/22/04 - Pretty up alignment in template match "PLOBMD".
    htseng      07/12/04 - fix default value for substitutable clause 
    htseng      06/24/04 - bug 3678702: long raw column is not last one 
    lbarton     05/14/04 - Add TRANSPORTABLE_CLASSIC 
    htseng      04/27/04 - bug 3566300 - support subtitutable column
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    htseng      04/15/04 - enhance bug3470826 fix 
    rpfau       04/12/04 - Cleanup based on Lee's review. 
    htseng      03/22/04 - bug 3470826: duplicate column 
    rpfau       03/31/04 - Fix temporary table with name specified for 
                           oidindex - bug 3470762. 
    emagrath    02/10/04 - Transportable OID/SETID constraints/indexes
    lbarton     12/02/03 - Bug 3281574: dataobj# for nested IOTs 
    bmccarth    10/30/03 - get REF correct for XMLSchemas 
    lbarton     09/22/03 - Bug 3149477: SUBPARTITION_NAME param 
    lbarton     09/24/03 - lrg 1572904: define PRS_PATCHTABLEMETADATA 
    dgagne      09/08/03 - add convert parse item for PATCHTABLEMETADATA 
    htseng      08/14/03 - fix bug 3080271 add alter table modify clause 
    lbarton     08/14/03 - Bug 3047175: TTS and unused cols 
    lbarton     07/10/03 - Bug 3045654: nested table tablespace if vsn >= 10
    emagrath    06/06/03 - Correct index info for constraints
    emagrath    05/20/03 - Revamp constraint processing
    lbarton     03/20/03 - Bug 2844132: omit oidindex on temp table
    htseng      02/20/03 - fix CON1_LIST to pass correct $Property value
    lbarton     01/30/03 - primary key for nested IOT
    lbarton     12/31/02 - add plobmd to pcolumn_t for transportable
    htseng      11/01/02 - temp disable nested tablespace
    lbarton     10/11/02 - new parse item: SYSTEM_GENERATED
    htseng      10/28/02 - add tablespace for nested table
    lbarton     08/02/02 - transportable export
    lbarton     07/22/02 - Network export
    htseng      07/29/02 - add more parse params
    lbarton     06/03/02 - data layer and network support
    emagrath    05/17/02 - Stabilize constraint generation order
    lbarton     04/01/02 - xdb fix
    emagrath    01/31/02 - Complete support for REF constraints
    dgagne      11/05/01 - remove row movement from partitions
    lbarton     10/25/01 - xdb support
    lbarton     10/05/01 - Support Ordered Collections in Tables
    dgagne      10/15/01 - add heap segment compression support
    dgagne      06/27/01 - add external table clause
    lbarton     06/01/01 - remove oradb-style imports
    lbarton     04/17/01 - do it again and do it right
    lbarton     04/16/01 - bugfix
    lbarton     01/12/01 - add comments
    lbarton     01/10/01 - nested table referential constraints
    lbarton     12/20/00 - NOT NULL for adt/ref col
    lbarton     12/01/00 - XMLType support
    lbarton     11/01/00 - align table constraints
    lbarton     10/24/00 - sort in views, not xsl
    gclaborn    10/30/00 - Add external imports; change name
    lbarton     10/05/00 - more bugfixes
    lbarton     09/21/00 - bugfixes
    lbarton     08/18/00 - logical standby support
    lbarton     07/24/00 - use uriref in import
    lbarton     06/23/00 - Multinested collections
    lbarton     06/12/00 - constraints in CREATE TABLE
    lbarton     06/01/00 - support parsing
    lbarton     05/15/00 - Params for new API
    lbarton     03/29/00 - More partitioning support
    lbarton     03/17/00 - Multinested collections
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kuprtobj.xsl"/>
 <xsl:import href="kuconstr.xsl"/>
 <xsl:import href="kuobjtbl.xsl"/>
 <xsl:import href="kuiot.xsl"/>
 <xsl:import href="kucot.xsl"/>
 <xsl:import href="kulob.xsl"/>
 <xsl:import href="kuidxwrk.xsl"/>
 <xsl:import href="kuexttbl.xsl"/>
 <xsl:import href="kutabcon.xsl"/>
 <xsl:import href="kuntab.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="REF_CONSTRAINTS">1</xsl:param>
 <xsl:param name="CONSTRAINTS_AS_ALTER">0</xsl:param>
 <xsl:param name="OID">0</xsl:param>
 <xsl:param name="SIZE_BYTE_KEYWORD">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="TRANSPORTABLE_CLASSIC">0</xsl:param>
 <xsl:param name="PCTSPACE">100</xsl:param>
 <!-- params for Logical Standby -->
 <xsl:param name="INSERT">0</xsl:param>
 <xsl:param name="DBLINK">0</xsl:param>
 <!-- params for load/unload and network -->
 <xsl:param name="OPERATION_TYPE">CREATE</xsl:param>
 <xsl:param name="EXT_TABLE_NAME" select="''"/>
 <xsl:param name="EXT_TABLE_SCHEMA" select="''"/>
 <xsl:param name="EXT_TABLE_CLAUSE" select="''"/>
 <xsl:param name="SCN">0</xsl:param>
 <xsl:param name="DATAOBJ_NUM" select="''"/>
 <xsl:param name="NETWORK_LINK" select="''"/>
 <xsl:param name="NETWORK_SCHEMA" select="''"/>
 <xsl:param name="NETWORK_NAME" select="''"/>
 <!-- QUERY is the old param. Now we also pass
 (a) QUERY_WHERE -  WHERE clause minus the WHERE keyword
 (b) QUERY_ORDER_BY - ORDER BY clause
 -->
 <xsl:param name="QUERY" select="''"/>
 <xsl:param name="QUERY_WHERE" select="''"/>
 <xsl:param name="QUERY_ORDER_BY" select="''"/>
 <xsl:param name="DROP">0</xsl:param>
 <xsl:param name="SAMPLE" select="''"/>
 <xsl:param name="ENCRYPTION_PASSWORD" select="''"/>
 <xsl:param name="PARTITIONING">1</xsl:param>
 <xsl:param name="DML_ERROR_LOGGING_CLAUSE" select="''"/>
 <xsl:param name="USE_DML_APPEND_HINT">1</xsl:param>
 <xsl:param name="XMLTYPE_STREAM_FORMAT" select="''"/>
 <xsl:param name="XMLCOL_V10P">0</xsl:param>
 <xsl:param name="PARALLEL_HINT" select="''"/>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SYSTEM_GENERATED">0</xsl:param>
 <xsl:param name="PRS_BIND_PATTERN">0</xsl:param>
 <xsl:param name="PRS_ALT_CONNECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_LONG_POSITION">0</xsl:param>
 <!-- Params for column name remapping -->
 <xsl:param name="REMAP_COLUMN_NAMEO1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN1" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN2" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN3" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN4" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN5" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN6" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN7" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN8" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN9" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEO10" select="''"/>
 <xsl:param name="REMAP_COLUMN_NAMEN10" select="''"/>
 <!-- Templates -->
 <xsl:template match="TABLE_T">
  <!-- *******************************************************************
Template: TABLE_T - top-level template for tables.
  Depending on OPERATION_TYPE this template calls
   CreateDBTable (in this module) for CREATE
   LoadTableFromNetwork (in kuexttbl.xsl) for NETWORK
   CreExtTable (in kuexttbl.xsl) for EXPORT or IMPORT
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$OPERATION_TYPE='CREATE'">
    <xsl:call-template name="CreateDBTable"/>
   </xsl:when>
   <xsl:when test="$OPERATION_TYPE='NETWORK'">
    <xsl:call-template name="LoadTableFromNetwork">
     <xsl:with-param name="DBlinkName" select="$NETWORK_LINK"/>
     <xsl:with-param name="RemoteSchema" select="$NETWORK_SCHEMA"/>
     <xsl:with-param name="RemoteName" select="$NETWORK_NAME"/>
     <xsl:with-param name="PartitionName" select="$PARTITION_NAME"/>
     <xsl:with-param name="SubpartitionName" select="$SUBPARTITION_NAME"/>
     <xsl:with-param name="DataobjNum" select="$DATAOBJ_NUM"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="$OPERATION_TYPE='IMPORT' or
                   $OPERATION_TYPE='IMPORT_CONVENTIONAL'">
    <xsl:call-template name="CreateExtTable"/>
   </xsl:when>
   <xsl:when test="$OPERATION_TYPE='EXPORT'">
    <xsl:call-template name="CreateExtTable">
     <xsl:with-param name="DBlinkName" select="$NETWORK_LINK"/>
     <xsl:with-param name="RemoteSchema" select="$NETWORK_SCHEMA"/>
     <xsl:with-param name="RemoteName" select="$NETWORK_NAME"/>
     <xsl:with-param name="PartitionName" select="$PARTITION_NAME"/>
     <xsl:with-param name="SubpartitionName" select="$SUBPARTITION_NAME"/>
     <xsl:with-param name="DataobjNum" select="$DATAOBJ_NUM"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>***ERROR: UNEXPECTED OPERATION_TYPE: </xsl:text>
    <xsl:value-of select="$OPERATION_TYPE"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CreateDBTable">
  <!-- *******************************************************************
Template: CreateDBTable
******************************************************************** -->
  <xsl:if test="$TRANSPORTABLE=1 and $TRANSPORTABLE_CLASSIC=0 and
                PROPERTY mod 4 > 0">
   <!-- This ddl statement needs a bind variable of the xml clob.  This is
        defined as a bind_pattern of 2.  So set bind_pattern=2 -->
   <xsl:if test="$PRS_BIND_PATTERN=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>ABIND_PATTERN</xsl:text>
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>B2</xsl:text>
   </xsl:if>
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DELETE_INSERT</xsl:with-param>
    <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
   </xsl:call-template>
   <xsl:text>BEGIN </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>DELETE FROM sys.expimp_tts_ct$ WHERE </xsl:text>
   <xsl:call-template name="EscapeString">
    <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Leading">owner = '</xsl:with-param>
    <xsl:with-param name="Trailing">'</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="EscapeString">
    <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="Leading"> AND tablename = '</xsl:with-param>
    <xsl:with-param name="Trailing">'; </xsl:with-param>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>INSERT INTO sys.expimp_tts_ct$ values(</xsl:text>
   <xsl:call-template name="EscapeString">
    <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="Leading">'</xsl:with-param>
    <xsl:with-param name="Trailing">',</xsl:with-param>
   </xsl:call-template>
   <xsl:call-template name="EscapeString">
    <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="Leading">'</xsl:with-param>
    <xsl:with-param name="Trailing">',:1,SYSDATE); </xsl:with-param>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>COMMIT; </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text>END;</xsl:text>
   <!-- Terminate the SQL statement -->
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>
/
</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- Add check_type calls for object types used directly by the table.
      Do this first, so the parse parameters defined right after this are
      create table parse items, not check_type parse items.
   -->
  <xsl:call-template name="CheckTypes"/>
  <!-- If transportable and property has types then need to drop info from
       sys.expimp_tts_ct$ and then reload it for this table -->
  <!--
    Generate parse items for CREATE TABLE
    If the table has xmlschema columns, then the table needs to be created
    as if connected as the table owner.  Create a bind variable
    ALT_CONNECT_TYPE=HARD
   -->
  <xsl:if test="$PRS_ALT_CONNECT_TYPE=1 and XMLSCHEMACOLS='Y'">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AALT_CONNECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>BHARD</xsl:text>
  </xsl:if>
  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:choose>
    <xsl:when test="(PART_OBJ)">
     <xsl:value-of select="PART_OBJ/PARTOBJ/DEFTS_NAME"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="TS_NAME"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <!-- 
      CREATE [ GLOBAL TEMPORARY ] TABLE foo.bar
  -->
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="(PROPERTY mod 8388608)>=4194304">
   <xsl:text>GLOBAL TEMPORARY </xsl:text>
  </xsl:if>
  <xsl:text>TABLE </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <!--
     Dispatch to processing template for relational/object table
-->
  <xsl:choose>
   <xsl:when test="(PROPERTY mod 2)=0">
    <!-- relational table -->
    <xsl:call-template name="CreRelTable"/>
   </xsl:when>
   <xsl:when test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'
              or 
      COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/NAME='XMLTYPE'">
    <!-- xmltype table -->
    <xsl:call-template name="CreXMLTypeTable"/>
   </xsl:when>
   <xsl:otherwise>
    <!-- object table -->
    <xsl:call-template name="CreObjTable"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <!-- Terminate the SQL statement -->
   <xsl:text>;</xsl:text>
  </xsl:if>
  <!--
       For transportable, generate ALTER TABLE SET UNUSED for unused cols
      (prop bit 0x8000) that are not ADT attributes (prop bit 0x01) 
-->
  <xsl:if test="$TRANSPORTABLE=1 and $TRANSPORTABLE_CLASSIC=0">
   <!-- For transportable xmltype table, may need to deal with hierarchy enable-->
   <xsl:if test="(COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'
              or 
      COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/NAME='XMLTYPE') and
   COL_LIST/COL_LIST_ITEM[NAME='ACLOID']">
    <!-- xmltype table -->
    <xsl:call-template name="GenHierarchy">
     <xsl:with-param name="Enable" select='"ENABLE_HIERARCHY"'/>
    </xsl:call-template>
    <xsl:call-template name="GenHierarchy">
     <xsl:with-param name="Enable" select='"DISABLE_HIERARCHY"'/>
    </xsl:call-template>
   </xsl:if>
   <xsl:for-each select="CON1_LIST/CON1_LIST_ITEM[OID_OR_SETID!=0]">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:call-template name="DoHiddenConstraint">
     <xsl:with-param name="SchemaObjParent" select="../.."/>
     <xsl:with-param name="ConstraintNode" select="current()"/>
    </xsl:call-template>
   </xsl:for-each>
  </xsl:if>
  <xsl:if test="$TRANSPORTABLE=1">
   <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 65536)>=32768
                                           and (PROPERTY mod 2)&lt;1]">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="../../SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="../../SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>
  ALTER TABLE </xsl:text>
    <xsl:apply-templates select="../../SCHEMA_OBJ"/>
    <xsl:text>SET UNUSED ("</xsl:text>
    <xsl:value-of select="NAME"/>
    <xsl:text>")</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
     <!-- Terminate the SQL statement -->
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
  <!-- Add any top level table constraints needed as ALTER TABLE statements -->
  <xsl:call-template name="GenTableConstraints">
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="InColList">0</xsl:with-param>
   <xsl:with-param name="CommaNeeded">0</xsl:with-param>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- For transportable, ENABLE Hidden (OID or SETID) constraints -->
  <!-- (implicit part of CREATE TABLE for modes other than transportable) -->
  <!-- Not needed for original exp/imp (which has its own way of doing this) -->
  <!-- Add any nested table constraints needed as ALTER TABLE statements -->
  <xsl:if test="(PROPERTY mod 8)>=4">
   <!-- has nested-TABLE columns -->
   <xsl:call-template name="GenNestedTableConstraints">
    <xsl:with-param name="ListParent" select="NT/NTS"/>
   </xsl:call-template>
  </xsl:if>
  <!-- ALTER TABLE modify statement to get object default value -->
  <xsl:call-template name="GenObjDefValue">
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
  </xsl:call-template>
  <!-- Generate INSERT SELECT for logical standby -->
  <xsl:if test="$INSERT=1">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:call-template name="LoadTableFromNetwork">
    <xsl:with-param name="DBlinkName" select="$DBLINK"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$TRANSPORTABLE=1 and $TRANSPORTABLE_CLASSIC=0">
   <xsl:if test="PROPERTY mod 4 > 0">
    <!-- If transportable and property has types then need to drop info from
        sys.expimp_tts_ct$ that was loaded above -->
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DELETE</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>DELETE FROM sys.expimp_tts_ct$ WHERE </xsl:text>
    <xsl:call-template name="EscapeString">
     <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="Leading">owner = '</xsl:with-param>
     <xsl:with-param name="Trailing">'</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="EscapeString">
     <xsl:with-param name="OrigStr" select="SCHEMA_OBJ/NAME"/>
     <xsl:with-param name="Leading"> AND tablename = '</xsl:with-param>
     <xsl:with-param name="Trailing">'</xsl:with-param>
    </xsl:call-template>
    <xsl:if test="$SQLTERMINATOR=1">
     <!-- Terminate the SQL statement -->
     <xsl:text>;</xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- If any of these bits are set, then call patchtablemetadata -->
   <xsl:if test="(COL_LIST/COL_LIST_ITEM[TYPE_NUM=112] or
                   (COL_LIST/COL_LIST_ITEM[TYPE_NUM=8] and
                    COL_LIST/COL_LIST_ITEM[last()]/TYPE_NUM!=8) or
                   (COL_LIST/COL_LIST_ITEM[TYPE_NUM=24] and
                    COL_LIST/COL_LIST_ITEM[last()]/TYPE_NUM!=24))">
    <!-- Patchtablemetadata needs to pass in some bind varables. Set
         bind_pattern=1 -->
    <xsl:if test="$PRS_BIND_PATTERN=1">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>ABIND_PATTERN</xsl:text>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>B1</xsl:text>
    </xsl:if>
    <!-- Calls to dbms_plugtsp need to be connected as the schema running
          the import job.  So set ALT_CONNECT_TYPE = NONE -->
    <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>AALT_CONNECT_TYPE</xsl:text>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>BNONE</xsl:text>
    </xsl:if>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_PLUGTSP.PATCHTABLEMETADATA</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_PLUGTSP.PATCHTABLEMETADATA('</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:text>','</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>',:1,:2,:3);</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- Call PATCHDICTIONARY for the HAKAN factor if SPARE1 is not null. -->
   <xsl:if test="SPARE1">
    <!-- Calls to dbms_plugtsp need to be connected as the schema running
          the import job.  So set ALT_CONNECT_TYPE = NONE -->
    <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>AALT_CONNECT_TYPE</xsl:text>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>BNONE</xsl:text>
    </xsl:if>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_PLUGTSP.PATCHDICTIONARY</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_PLUGTSP.PATCHDICTIONARY('</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:text>','</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>',</xsl:text>
    <xsl:value-of select="SPARE1"/>
    <xsl:text>,'unused','unused','unused','unused',3);</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- Call PATCHDICTIONARY for the PDML if property is not null. -->
   <xsl:if test="PROPERTY">
    <!-- Calls to dbms_plugtsp need to be connected as the schema running
          the import job.  So set ALT_CONNECT_TYPE = NONE -->
    <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>AALT_CONNECT_TYPE</xsl:text>
     <xsl:value-of select="$PRS_DELIM"/>
     <xsl:text>BNONE</xsl:text>
    </xsl:if>
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">DBMS_PLUGTSP.PATCHDICTIONARY</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
     <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>SYS.DBMS_PLUGTSP.PATCHDICTIONARY('</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:text>','</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>',</xsl:text>
    <xsl:value-of select="PROPERTY"/>
    <xsl:text>,'unused','unused','unused','unused',2);</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>END;</xsl:text>
    <!-- Terminate the SQL statement -->
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/
</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CreRelTable">
  <!-- *******************************************************************
Template: CreRelTable - syntax for relational tables
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <!-- Begin any CREATE TABLE properties with open paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">1</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- column list -->
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">TABLE</xsl:with-param>
  </xsl:apply-templates>
  <!-- Add any table constraints needed in CREATE TABLE properties -->
  <!--  (Need initial comma for relational tables) -->
  <xsl:call-template name="GenTableConstraints">
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="InColList">1</xsl:with-param>
   <xsl:with-param name="CommaNeeded">1</xsl:with-param>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- End any CREATE TABLE properties with close paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">0</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- if temp table emit ON COMMIT... -->
  <xsl:call-template name="GenOnCommitAction"/>
  <xsl:if test="(PROPERTY mod 262144)>=131072">
   <!-- AQ -->
   <xsl:text>USAGE QUEUE </xsl:text>
  </xsl:if>
  <xsl:if test="(PROPERTY mod 128)>=64">
   <!-- IOT -->
   <xsl:call-template name="OrgIndex"/>
  </xsl:if>
  <!-- physical properties -->
  <xsl:call-template name="PhysicalProperties">
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:call-template>
  <!-- table properties: skip if departitioning  -->
  <xsl:if test="(string-length($PARTITION_NAME)=0 and
                 string-length($SUBPARTITION_NAME)=0)">
   <xsl:call-template name="TableProperties">
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CreObjTable">
  <!-- *******************************************************************
Template: CreObjTable - syntax for object tables and XMLTYPE tables
******************************************************************** -->
  <!-- OF TYPE foo.bar + object_table_substitution -->
  <xsl:call-template name="ObjTable"/>
  <!-- Begin any CREATE TABLE properties with open paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">1</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- Add any table constraints needed in CREATE TABLE properties -->
  <!--  (No initial comma for object tables) -->
  <xsl:call-template name="GenTableConstraints">
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="InColList">1</xsl:with-param>
   <xsl:with-param name="CommaNeeded">0</xsl:with-param>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- End any CREATE TABLE properties with close paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">0</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- if temp table emit ON COMMIT... -->
  <xsl:call-template name="GenOnCommitAction"/>
  <xsl:if test="(PROPERTY mod 8192)>=4096">
   <!-- has primary-key OID -->
   <xsl:text>OBJECT IDENTIFIER IS PRIMARY KEY </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;   </xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- OIDINDEX  -->
  <xsl:call-template name="DoOidindex"/>
  <xsl:if test="(PROPERTY mod 262144)>=131072">
   <!-- AQ -->
   <xsl:text>USAGE QUEUE </xsl:text>
  </xsl:if>
  <xsl:if test="(PROPERTY mod 128)>=64">
   <!-- IOT -->
   <xsl:call-template name="OrgIndex"/>
  </xsl:if>
  <!-- physical properties -->
  <xsl:call-template name="PhysicalProperties">
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:call-template>
  <!-- table properties -->
  <xsl:call-template name="TableProperties">
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="CreXMLTypeTable">
  <!-- *******************************************************************
Template: CreXMLTypeTable - syntax for XMLType tables
******************************************************************** -->
  <xsl:text>OF XMLTYPE </xsl:text>
  <!-- Begin any CREATE TABLE properties with open paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">1</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- Add any table constraints needed in CREATE TABLE properties -->
  <!--  (No initial comma for object tables) -->
  <xsl:call-template name="GenTableConstraints">
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="InColList">1</xsl:with-param>
   <xsl:with-param name="CommaNeeded">0</xsl:with-param>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <!-- End any CREATE TABLE properties with close paren -->
  <xsl:call-template name="TablePropertyParen">
   <xsl:with-param name="OpenParen">0</xsl:with-param>
   <xsl:with-param name="SchemaObjParent" select="current()"/>
   <xsl:with-param name="ListParent" select="current()"/>
   <xsl:with-param name="Property" select="PROPERTY"/>
   <xsl:with-param name="Nested">0</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="$OID=1">
   <!-- Emit the undocumented OID clause using the table's OID -->
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> OID &apos;</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/OID"/>
   <xsl:text>&apos; </xsl:text>
  </xsl:if>
  <!-- XMLType storage -->
  <xsl:variable name="TabBlocksize" select="BLOCKSIZE"/>
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/LOBMD">
   <xsl:call-template name="DoLOBStoreAs">
    <xsl:with-param name="ColList" select="../.."/>
    <xsl:with-param name="Intcolnum" select="../INTCOL_NUM"/>
    <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
    <xsl:with-param name="XMLType_storage">1</xsl:with-param>
   </xsl:call-template>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:for-each>
  <!-- XMLSchema_spec, if any -->
  <xsl:if test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
   <xsl:choose>
    <xsl:when test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/LOBMD"/>
    <xsl:when test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:when>
   </xsl:choose>
   <xsl:call-template name="DoSchemaElmt">
    <xsl:with-param name="SchemaElmt" select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD">
   <xsl:call-template name="DoAllowDisallow">
    <xsl:with-param name="OpqmdElmt" select="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:call-template name="XMLTypeVirtualColumns"/>
  <!-- OID index seems to be invalid -->
  <xsl:choose>
   <xsl:when test="true()"/>
   <xsl:otherwise>
    <xsl:call-template name="DoOidindex"/>
   </xsl:otherwise>
  </xsl:choose>
  <!-- physical properties -->
  <xsl:call-template name="PhysicalProperties">
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:call-template>
  <!-- table properties -->
  <xsl:call-template name="TableProperties">
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   <xsl:with-param name="XMLType_table">1</xsl:with-param>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="OrgIndex">
  <!-- *******************************************************************
Template: OrgIndex - ORGANIZATION INDEX ( COMPRESS n | NOCOMPRESS )
******************************************************************** -->
  <xsl:text>ORGANIZATION INDEX </xsl:text>
  <!-- 
      If departitionin don't generate COMPRESS
      value will come from partition
-->
  <xsl:if test="string-length($PARTITION_NAME)=0 and
                string-length($SUBPARTITION_NAME)=0">
   <xsl:choose>
    <xsl:when test="NUMKEYCOLS>0">
     <xsl:text>COMPRESS </xsl:text>
     <xsl:value-of select="NUMKEYCOLS"/>
     <xsl:text> </xsl:text>
    </xsl:when>
    <xsl:otherwise>NOCOMPRESS </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="PhysicalProperties">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: PhysicalProperties:
 Current node: TABLE_T or MVIEW_TAB
 Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="PROPERTY>=2147483648">
    <!-- External table -->
    <xsl:call-template name="GenExtTableClauses"/>
   </xsl:when>
   <xsl:when test="(PROPERTY2 mod 2)=1">
    <!-- CUBE table -->
    <xsl:call-template name="GenCubeTableClauses">
     <xsl:with-param name="CubeTab" select="CUBETAB"/>
     <xsl:with-param name="PrettyCR">1</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="(PROPERTY mod 2048)>=1024">
    <!-- clustered table -->
    <xsl:apply-templates select="TABCLUSTER"/>
    <xsl:if test="$TRANSPORTABLE=1">
     <xsl:text> STORAGE (TABNO </xsl:text>
     <xsl:value-of select="TAB_NUM"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:when test="4194304>(PROPERTY mod 8388608)">
    <!-- non-temporary table: generate the physical attributes -->
    <xsl:call-template name="GenTablePhysicalAttrs">
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="(PROPERTY mod 8388608)>=4194304">
    <!-- global temporary table: generate the tablespace clause -->
    <xsl:if test="$TABLESPACE=1">
     <!-- only handle GTT with explicitly specified tablespace -->
     <xsl:if test="(current()/TS_NAME)!='SYSTEM'">
      <xsl:apply-templates select="current()/TS_NAME"/>
     </xsl:if>
    </xsl:if>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="TableProperties">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="XMLType_table">0</xsl:param>
  <!-- *******************************************************************
Template: TableProperties:
  column properties
  XMLType_virtual_columns
  table partitioning clauses
  CACHE/NOCACHE
  result cache
  parallel
  rowdependencies
  enable_disable
  row movement
  flashback archive
 Current node: TABLE_T or MVIEW_TAB
 Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
  XMLType_table - 1 = generate properties for xmltype table
******************************************************************** -->
  <!-- skip if temporary table or cluster table -->
  <xsl:if test="not ((PROPERTY mod 8388608)>=4194304) and
                not ((PROPERTY mod 2048)>=1024)">
   <xsl:call-template name="ColumnProperties">
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
    <xsl:with-param name="XMLType_table" select="$XMLType_table"/>
   </xsl:call-template>
   <xsl:if test="$XMLType_table=0">
    <xsl:call-template name="XMLTypeVirtualColumns"/>
   </xsl:if>
   <!-- PARTITION BY... -->
   <xsl:if test="(PART_OBJ) and ($PARTITIONING=1)">
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <xsl:call-template name="DoPIOTPartitionClause">
       <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
       <xsl:with-param name="PartCompress" select="NUMKEYCOLS>0"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoPartitionClause">
       <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:if>
   <!-- Do only if SEGMENT_ATTRIBUTES is true -->
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <!-- DoParallel in kustorag.xsl does
         ROWDEPENDENCIES
         RESULT_CACHE
         CACHE
         MONITORING
         PARALLEL
   -->
    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="current()"/>
     <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:if test="(FLAGS mod 262144) >= 131072">
    <!-- row movement -->
    <xsl:text> ENABLE ROW MOVEMENT </xsl:text>
   </xsl:if>
   <!-- flashback archive (no data pump support yet) -->
   <xsl:if test="$EXPORT=0">
    <xsl:apply-templates select="FBA"/>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ColumnProperties">
  <xsl:param name="Pctspace">100</xsl:param>
  <xsl:param name="XMLType_table">0</xsl:param>
  <!-- *******************************************************************
Template: ColumnProperties:
  object_type_col_properties
  nested_table_col_properties
  varray_col_properties
  LOB_storage_clause
  XMLType_column_properties
 Current node: TABLE_T
 Parameters:
  Pctspace - value of the PCTSPACE param; defaults to 100
  XMLType_table - 1 = generate properties for xmltype table
******************************************************************** -->
  <xsl:call-template name="ObjectTypeColProperties"/>
  <xsl:if test="(PROPERTY mod 8)>=4">
   <!--has nested-TABLE columns: template "NT" is in kuntab.xsl -->
   <xsl:apply-templates select="NT">
    <xsl:with-param name="Pctspace" select="$Pctspace"/>
    <xsl:with-param name="ParentProperty" select="PROPERTY"/>
    <xsl:with-param name="DoingTable">1</xsl:with-param>
   </xsl:apply-templates>
  </xsl:if>
  <!-- LOB, VARRAY AS LOB -->
  <xsl:call-template name="DoLobColsIf">
   <xsl:with-param name="XMLType_table" select="$XMLType_table"/>
  </xsl:call-template>
  <xsl:call-template name="XMLSchemaBasedCols"/>
 </xsl:template>
 <xsl:template name="ObjectTypeColProperties">
  <!-- *******************************************************************
Template: ObjectTypeColProperties:
  substitutable
 Current node: TABLE_T
******************************************************************** -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[TYPE_NUM=121]">
   <xsl:choose>
    <!-- bug 4347010: skip all of this if column is unused -->
    <xsl:when test="(PROPERTY mod 65536)>=32768"/>
    <!-- skip SYS_NC_ROWINFO$ -->
    <xsl:when test="NAME='SYS_NC_ROWINFO$'"/>
    <!--  0x800 - SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(TYPEMD/FLAGS mod 4096)>= 2048">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;  </xsl:text>
     </xsl:if>
     <xsl:text>COLUMN </xsl:text>
     <xsl:value-of select="NAME"/>
     <xsl:text> SUBSTITUTABLE AT ALL LEVELS </xsl:text>
    </xsl:when>
    <!--  0x400 - NOT SUBSTITUTABLE specified explicitly -->
    <xsl:when test="(TYPEMD/FLAGS mod 2048)>=1024">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;  </xsl:text>
     </xsl:if>
     <xsl:text>COLUMN </xsl:text>
     <xsl:value-of select="NAME"/>
     <xsl:text> NOT SUBSTITUTABLE AT ALL LEVELS </xsl:text>
    </xsl:when>
    <xsl:when test="(TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/FLAGS mod 4) =3">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;  </xsl:text>
     </xsl:if>
     <xsl:text>COLUMN </xsl:text>
     <xsl:value-of select="NAME"/>
     <xsl:text> IS OF TYPE (ONLY </xsl:text>
     <xsl:apply-templates select="TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM/SCHEMA_OBJ"/>
     <xsl:text>) </xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoLobColsIf">
  <xsl:param name="XMLType_table">0</xsl:param>
  <!-- *******************************************************************
Template: DoLobColsIf
Current node: TABLE_T
Parameters:
  XMLType_table - 1 = generate properties for xmltype table
******************************************************************** -->
  <!-- LOB, VARRAY AS LOB -->
  <!--  PROPERTY bits:     16 = has array columns (VARRAY)
                          2048 = has internal LOB columns
                        262144 = has user-defined LOB columns
 -->
  <xsl:if test="((PROPERTY mod 32)>=16 or
                  (PROPERTY mod 4096)>=2048 or
                  (PROPERTY mod 524288)>=262144)">
   <xsl:call-template name="DoLOBCols">
    <xsl:with-param name="MetaType">
     <xsl:choose>
      <xsl:when test="(PROPERTY mod 64)>=32">PartLob</xsl:when>
      <xsl:otherwise>Lob</xsl:otherwise>
     </xsl:choose>
    </xsl:with-param>
    <xsl:with-param name="TabBlocksize" select="BLOCKSIZE"/>
    <xsl:with-param name="XMLType_table" select="$XMLType_table"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoLOBCols">
  <xsl:param name="MetaType">Lob</xsl:param>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <xsl:param name="XMLType_table">0</xsl:param>
  <!-- *******************************************************************
Template: DoLOBCols
Parameters:
  MetaType
     Lob         - lob column metadata in non-partitioned table
     PartLob     - table level defaults
     LobFrag     - actual partition- or subpartition-level lob attributes
     LobComppart - partition-level defaults
  TabBlocksize - Table blocksize value
  XMLType_table - 1 = generate properties for xmltype table
******************************************************************** -->
  <!-- exclude system-generated columns -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[256>(PROPERTY mod 512)]/LOBMD">
   <!-- exclude XMLSchema-based columns -->
   <!-- if this is xmltype table, exclude the ROWINFO col (the info was
         already emitted by template 'CreXMLTypeTable') -->
   <xsl:choose>
    <xsl:when test="(../OPQMD/FLAGS mod 4)>=2"/>
    <xsl:when test="$XMLType_table=1 and ../NAME='SYS_NC_ROWINFO$'"/>
    <xsl:when test="../PLOBMD">
     <xsl:apply-templates select="../PLOBMD">
      <xsl:with-param name="MetaType" select="$MetaType"/>
      <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
     </xsl:apply-templates>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="DoLOBStoreAs">
      <xsl:with-param name="MetaType" select="$MetaType"/>
      <xsl:with-param name="ColList" select="../.."/>
      <xsl:with-param name="Intcolnum" select="../INTCOL_NUM"/>
      <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="PLOBMD">
  <xsl:param name="MetaType">Lob</xsl:param>
  <xsl:param name="TabBlocksize">0</xsl:param>
  <!-- *******************************************************************
Template: PLOBMD
Parameters:
  MetaType
     Lob         - lob column metadata in non-partitioned table
     PartLob     - table level defaults
     LobFrag     - actual partition- or subpartition-level lob attributes
     LobComppart - partition-level defaults
  TabBlocksize - Table blocksize value
******************************************************************** -->
  <xsl:call-template name="DoLOBStoreAs">
   <xsl:with-param name="MetaType" select="$MetaType"/>
   <xsl:with-param name="ColList" select="../.."/>
   <xsl:with-param name="Intcolnum" select="../INTCOL_NUM"/>
   <xsl:with-param name="TabBlocksize" select="$TabBlocksize"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="XMLSchemaBasedCols">
  <!-- *******************************************************************
Template: XMLSchemaBasedCols
******************************************************************** -->
  <!-- XML schema-based columns in relational tables and XML schema-based
      attributes in object tables. But don't put anything out for table
      level for an object table (already done above). Table level for an
      object table is indicated by NAME='SYS_NC_ROWINFO$'.  -->
  <!-- bug 4347010: skip unused columns (PROPERTY bit 0x8000 32768) -->
  <xsl:for-each select="COL_LIST/COL_LIST_ITEM[NAME!='SYS_NC_ROWINFO$' and
                       (32768 > (PROPERTY mod 65536)) and
                       TYPE_NUM=58 and
                       TYPEMD/SCHEMA_OBJ/OWNER_NAME='SYS' and
                       TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE' and
                       OPQMD/SCHEMA_ELMT]">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <!-- Add optional "COLUMN" -->
   <xsl:text> XMLTYPE COLUMN </xsl:text>
   <!-- Fix problem if system generated column name for an object
       attribute. Use attribute name instead of system generated name. -->
   <xsl:call-template name="ColNameOrAttr">
    <xsl:with-param name="ColItem" select="current()"/>
   </xsl:call-template>
   <xsl:apply-templates select="OPQMD/SCHEMA_ELMT"/>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="XMLTypeVirtualColumns">
  <!-- *******************************************************************
Template: XMLTypeVirtualColumns
Current node: TABLE_T
******************************************************************** -->
  <!-- XMLType virtual columns
       If this is an XMLTYPE table...  -->
  <xsl:if test="COL_LIST/COL_LIST_ITEM[NAME='SYS_NC_ROWINFO$']/TYPEMD/SCHEMA_OBJ/NAME='XMLTYPE'">
   <!-- look for columns with the following property bits:
               /* 0x0008 =       8 = virtual column                         */
               /* 0x0020 =      32 = hidden column                          */
           /* 0x00010000 =   65536 = virtual column                         */
        but the following bits must be clear
                /* 0x0100 =     256 = system-generated column                */
                /* 0x0200 =     512 = rowinfo column of typed table/view     */
                /* 0x4000 =   16384 = dropped column                         */
        Note: virtual columns are inserted in reverse order, so we must sort.
   -->
   <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 16 >= 8) and
           (PROPERTY mod 64 >= 32) and
           (PROPERTY mod 131052 >= 65536) and
           (256 > (PROPERTY mod 512)) and
           (512 > (PROPERTY mod 1024)) and
           (16384 > (PROPERTY mod 32768))]">
    <xsl:sort select="INTCOL_NUM" data-type="number" order="descending"/>
    <xsl:if test="position()=1">
     <xsl:text> VIRTUAL COLUMNS (</xsl:text>
    </xsl:if>
    <xsl:text>"</xsl:text>
    <xsl:value-of select="NAME"/>
    <xsl:text>" AS (</xsl:text>
    <xsl:value-of select="DEFAULT_VAL"/>
    <xsl:text>)</xsl:text>
    <xsl:choose>
     <xsl:when test="position()!=last()">
      <xsl:text>,</xsl:text>
      <xsl:if test="$PRETTY=1">
       <xsl:text>&#xa;</xsl:text>
      </xsl:if>
     </xsl:when>
     <xsl:otherwise>
      <xsl:text>) </xsl:text>
      <xsl:if test="$PRETTY=1 and $SEGMENT_ATTRIBUTES=1">
       <xsl:text>&#xa;  </xsl:text>
      </xsl:if>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenExtTableClauses">
  <!-- *******************************************************************
Template: GenExtTableClauses - generate clauses for external table   
******************************************************************** -->
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text>ORGANIZATION EXTERNAL </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;    </xsl:text>
  </xsl:if>
  <xsl:text>( TYPE </xsl:text>
  <xsl:value-of select="EXTTAB/TYPE"/>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text> DEFAULT DIRECTORY "</xsl:text>
  <xsl:value-of select="EXTTAB/DEFAULT_DIR"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:if test="EXTTAB/PARAM_CLOB">
   <xsl:text> ACCESS PARAMETERS</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text> ( </xsl:text>
   <xsl:value-of select="EXTTAB/PARAM_CLOB"/>
   <xsl:text>    )</xsl:text>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;     </xsl:text>
  </xsl:if>
  <xsl:text> LOCATION</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;      </xsl:text>
  </xsl:if>
  <xsl:text> ( </xsl:text>
  <xsl:for-each select="EXTTAB/LOCATION/LOCATION_ITEM">
   <xsl:if test="DIR">
    <xsl:text>"</xsl:text>
    <xsl:value-of select="DIR"/>
    <xsl:text>":</xsl:text>
   </xsl:if>
   <xsl:text>'</xsl:text>
   <xsl:value-of select="NAME"/>
   <xsl:text>'</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;         </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;      </xsl:text>
  </xsl:if>
  <xsl:text> )</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;   </xsl:text>
  </xsl:if>
  <xsl:text> )</xsl:text>
  <xsl:if test="EXTTAB/REJECT_LIMIT > 0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text> REJECT LIMIT </xsl:text>
   <xsl:choose>
    <xsl:when test="EXTTAB/REJECT_LIMIT = 2147483647">
     <xsl:text>UNLIMITED</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="EXTTAB/REJECT_LIMIT"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenObjDefValue">
  <xsl:param name="SchemaObjParent" select="''"/>
  <xsl:param name="Property">0</xsl:param>
  <!-- *******************************************************************
Template: GenObjDefValue - get object table column default value 
Parameters:
  SchemaObjParent - parent of SCHEMA_OBJ name
  Property - Table PROPERTY
******************************************************************** -->
  <xsl:if test="($Property mod 2)=1">
   <!-- object table -->
   <xsl:for-each select="COL_LIST/COL_LIST_ITEM">
    <xsl:if test="DEFLENGTH != 0  
		and (32 > (PROPERTY mod 64))   
		and (1024 > (PROPERTY mod 1024))">
     <xsl:call-template name="DoParse">
      <xsl:with-param name="Verb">ALTER</xsl:with-param>
      <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
      <xsl:with-param name="SchemaNode" select="$SchemaObjParent/SCHEMA_OBJ/OWNER_NAME"/>
      <xsl:with-param name="NameNode" select="$SchemaObjParent/SCHEMA_OBJ/NAME"/>
     </xsl:call-template>
     <xsl:text>&#xa;  </xsl:text>
     <xsl:text>ALTER TABLE </xsl:text>
     <xsl:apply-templates select="$SchemaObjParent/SCHEMA_OBJ"/>
     <xsl:text>MODIFY ( </xsl:text>
     <xsl:value-of select="NAME"/>
     <xsl:text> DEFAULT </xsl:text>
     <xsl:value-of select="DEFAULT_VAL"/>
     <xsl:text>)</xsl:text>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
      <!-- Terminate the SQL statement -->
     </xsl:if>
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenHierarchy">
  <xsl:param name="Enable" select="''"/>
  <!-- *******************************************************************
Template: GenHierarchy - enable/disable hierarchy for xmltype tables
Hierarchy enabled tables have hidden columns. Data in those columns is
likely invalid on import, but in transportable, the data will be imported.
The solumtion is to enable hierarchy, creating metadata for hidden columns,
the disable hierarchy as the data is not valid (but column metadata remains).
******************************************************************** -->
  <!--
    Generate parse items for CREATE TABLE
    If the table has xmlschema columns, then the table needs to be created
    as if connected as the table owner.  Create a bind variable
    ALT_CONNECT_TYPE=HARD
   -->
  <xsl:if test="$PRS_ALT_CONNECT_TYPE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>AALT_CONNECT_TYPE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>BHARD</xsl:text>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb" select="$Enable"/>
   <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>BEGIN DBMS_XDBZ.</xsl:text>
  <xsl:value-of select="$Enable"/>
  <xsl:text>('"</xsl:text>
  <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
  <xsl:text>"','"</xsl:text>
  <xsl:value-of select="SCHEMA_OBJ/NAME"/>
  <xsl:text>"'); END;</xsl:text>
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
  <xsl:text>&#xa;</xsl:text>
 </xsl:template>
 <xsl:template match="TABCLUSTER">
  <!-- *******************************************************************
Template: TABCLUSTER - for cluster tables
******************************************************************** -->
  <xsl:text>CLUSTER </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:text>(</xsl:text>
  <xsl:apply-templates select="COL_LIST">
   <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   <xsl:with-param name="DoLF">0</xsl:with-param>
   <xsl:with-param name="DoHidden">1</xsl:with-param>
  </xsl:apply-templates>
  <xsl:text>)</xsl:text>
 </xsl:template>
 <xsl:template match="FBA">
  <!-- *******************************************************************
Template: FBA - for flashback archive enabled tables
******************************************************************** -->
  <xsl:text>FLASHBACK ARCHIVE "</xsl:text>
  <xsl:value-of select="FA_NAME"/>
  <xsl:text>"</xsl:text>
 </xsl:template>
 <xsl:template name="GenOnCommitAction">
  <!-- *******************************************************************
Template: GenOnCommitAction - generate ON COMMIT action for temp tables
******************************************************************** -->
  <xsl:if test="(PROPERTY mod 8388608)>=4194304">
   <!-- temporary table -->
   <xsl:choose>
    <xsl:when test="(PROPERTY mod 16777216)>=8388608">
     <xsl:text>ON COMMIT PRESERVE ROWS </xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>ON COMMIT DELETE ROWS </xsl:text>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenTablePhysicalAttrs">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenTablePhysicalAttrs - dispatch to a processing template
  depending on table characteristics:
  non-partitioned heap table - GenHTablePhysicalAttrs
  non-partition IOT - GenIOTPhysicalAttrs
  partitioned heap table - GenPHTablePhysicalAttrs
  partition IOT - GenPIOTPhysicalAttrs
      *new for 11.1*
  heap partition converted to non-part table - CvtHPartToTable
  PIOT partition converted to non-part IOT - CvtPIOTPartToTable
Current node: TABLE_T
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="(PART_OBJ)">
    <!-- partitioned -->
    <xsl:choose>
     <xsl:when test="(string-length($PARTITION_NAME)!=0 or
                      string-length($SUBPARTITION_NAME)!=0)">
      <xsl:choose>
       <xsl:when test="(PROPERTY mod 128)>=64">
        <!-- convert PIOT partition to non-partitioned IOT -->
        <xsl:call-template name="CvtPIOTPartToTable">
         <xsl:with-param name="Pctspace" select="$Pctspace"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <!-- convert heap partition to non-partitioned heap table -->
        <xsl:call-template name="CvtHPartToTable">
         <xsl:with-param name="Pctspace" select="$Pctspace"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:when>
     <xsl:otherwise>
      <xsl:choose>
       <xsl:when test="(PROPERTY mod 128)>=64">
        <!-- PIOT -->
        <xsl:call-template name="GenPIOTPhysicalAttrs">
         <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
         <xsl:with-param name="Pctspace" select="$Pctspace"/>
        </xsl:call-template>
       </xsl:when>
       <xsl:otherwise>
        <!-- Partitioned heap table -->
        <xsl:call-template name="GenPHTablePhysicalAttrs">
         <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
         <xsl:with-param name="Pctspace" select="$Pctspace"/>
        </xsl:call-template>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <!-- non-partitioned -->
    <xsl:choose>
     <xsl:when test="(PROPERTY mod 128)>=64">
      <!-- IOT -->
      <xsl:call-template name="GenIOTPhysicalAttrs">
       <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
       <xsl:with-param name="Pctspace" select="$Pctspace"/>
      </xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
      <!-- Non-partitioned heap table -->
      <xsl:call-template name="GenHTablePhysicalAttrs">
       <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
       <xsl:with-param name="Pctspace" select="$Pctspace"/>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="GenHTablePhysicalAttrs">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenHTablePhysicalAttrs - Physical attrs for non-partitioned
                heap table
Current node: TABLE_T, MVIEW_TAB or MVIEWLOG_TAB
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:variable name="flagArch1">33554432</xsl:variable>
  <!-- Do only if SEGMENT_ATTRIBUTES is true -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <!-- table physical attributes (PCTFREE, PCTUSED, INITRANS, MAXTRANS) -->
   <!-- SEGMENT CREATION syntax is new in 11.2;
        not valid for *partitioned tables
                      *IOTs
                      *clustered tables
                      *temporary tables
                      typed tables
                      AQ tables
                      external tables
                      tables owned by SYS, SYSTEM, PUBLIC, OUTLN, XDB
        (* = case already excluded)
    -->
   <xsl:if test="$VERSION>=1102000000 and local-name(.)='TABLE_T'
                 and (PROPERTY mod 2)=0
                 and not ((PROPERTY mod 262144)>=131072)
                 and SCHEMA_OBJ/OWNER_NAME!='SYS'
                 and SCHEMA_OBJ/OWNER_NAME!='SYSTEM'
                 and SCHEMA_OBJ/OWNER_NAME!='PUBLIC'
                 and SCHEMA_OBJ/OWNER_NAME!='OUTLN'
                 and SCHEMA_OBJ/OWNER_NAME!='XDB'">
    <xsl:text>SEGMENT CREATION </xsl:text>
    <xsl:choose>
     <xsl:when test="(PROPERTY2 mod 8)>=4">DEFERRED </xsl:when>
     <xsl:otherwise>IMMEDIATE </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
   </xsl:if>
   <!-- if deferred segment creation, storage params are in DEFERRED_STG -->
   <!-- PCTFREE, PCTUSED, INITRANS, MAXTRANS treated the same as -->
   <!--  non-deferred storage tables; use the values in tab$ -->
   <!-- get the other storage data from deferred_stg$ -->
   <xsl:choose>
    <xsl:when test="(PROPERTY2 mod 8)>=4">
     <xsl:apply-templates select="PCT_FREE"/>
     <xsl:call-template name="DoDeferredStg">
      <xsl:with-param name="DeferredStg" select="DEFERRED_STG"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:call-template>
     <xsl:if test="$TABLESPACE=1">
      <xsl:apply-templates select="TS_NAME"/>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="GenHTablePhysicalAttrs1">
      <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
      <xsl:with-param name="Pctspace" select="$Pctspace"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenHTablePhysicalAttrs1">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenHTablePhysicalAttrs1 - Physical attrs for non-partitioned
                heap table without deferred segment creation
Current node: TABLE_T, MVIEW_TAB or MVIEWLOG_TAB
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:apply-templates select="PCT_FREE"/>
  <xsl:if test="$MVIEW_LOG=0">
   <xsl:call-template name="DoSegCompress">
    <xsl:with-param name="Compress" select="STORAGE/FLAGS"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:call-template name="DoLogging">
   <xsl:with-param name="FlagsNode" select="FLAGS"/>
  </xsl:call-template>
  <xsl:apply-templates select="STORAGE">
   <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
   <xsl:with-param name="Dataobjnum" select="DATAOBJ_NUM"/>
   <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
  </xsl:apply-templates>
  <!-- hack: if deferred segment creation, the STORAGE template will not
        be called (because there will be no STORAGE element;
        so do tablespace here -->
  <xsl:if test="(PROPERTY2 mod 8)>=4">
   <xsl:if test="$TABLESPACE=1">
    <xsl:apply-templates select="TS_NAME"/>
   </xsl:if>
  </xsl:if>
  <!-- HACK: kumviewl.xsl should call these templates directly -->
  <xsl:if test="$MVIEW_LOG=1">
   <xsl:if test="(PROPERTY mod 8)>=4">
    <!-- has nested-TABLE columns -->
    <xsl:apply-templates select="NT">
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
     <xsl:with-param name="ParentProperty" select="PROPERTY"/>
    </xsl:apply-templates>
   </xsl:if>
   <!-- Do only if SEGMENT_ATTRIBUTES is true -->
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="current()"/>
     <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenIOTPhysicalAttrs">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenIOTPhysicalAttrs - Physical attrs for non-partitioned IOT
Current node: TABLE_T
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <!-- Do only if SEGMENT_ATTRIBUTES is true -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <!-- table physical attributes (PCTFREE, PCTUSED, INITRANS, MAXTRANS) -->
   <xsl:apply-templates select="PCT_FREE">
    <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
   </xsl:apply-templates>
   <xsl:call-template name="DoLogging">
    <xsl:with-param name="FlagsNode" select="FLAGS"/>
   </xsl:call-template>
   <xsl:apply-templates select="STORAGE">
    <xsl:with-param name="BlkSize" select="../BLOCKSIZE | BLOCKSIZE"/>
    <xsl:with-param name="Dataobjnum" select="DATAOBJ_NUM"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:apply-templates>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> PCTTHRESHOLD </xsl:text>
   <xsl:value-of select="PCT_THRESH"/>
  </xsl:if>
  <!-- Do unconditionally -->
  <xsl:if test="(FLAGS mod 536870912) >= 268435456">
   <xsl:text> MAPPING TABLE </xsl:text>
  </xsl:if>
  <xsl:if test="(PROPERTY mod 256)>=128">
   <!-- IOV -->
   <xsl:call-template name="DoIOV">
    <xsl:with-param name="Node" select="current()"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
  </xsl:if>
  <!-- HACK: kumviewl.xsl should call these templates directly -->
  <xsl:if test="$MVIEW_LOG=1">
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <!-- LOB, VARRAY AS LOB -->
    <xsl:call-template name="DoLobColsIf"/>
   </xsl:if>
   <xsl:if test="(PROPERTY mod 8)>=4">
    <!-- has nested-TABLE columns -->
    <xsl:apply-templates select="NT">
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
     <xsl:with-param name="ParentProperty" select="PROPERTY"/>
    </xsl:apply-templates>
   </xsl:if>
   <!-- Do only if SEGMENT_ATTRIBUTES is true -->
   <xsl:if test="$SEGMENT_ATTRIBUTES=1">
    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="current()"/>
     <xsl:with-param name="MVIEW_LOG" select="$MVIEW_LOG"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenPHTablePhysicalAttrs">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenPHTablePhysicalAttrs - Physical attrs for partitioned heap table
Current node: TABLE_T
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <xsl:variable name="BYTE4" select="4294967296"/>
  <xsl:variable name="flagArch1">8</xsl:variable>
  <!-- Do only if SEGMENT_ATTRIBUTES is true -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:call-template name="DoPartObjSegAttrs">
    <xsl:with-param name="ADT_type">TABLE</xsl:with-param>
   </xsl:call-template>
   <xsl:if test="$MVIEW_LOG=0">
    <xsl:call-template name="DoPartOBJCompress">
     <xsl:with-param name="Compress" select="(PART_OBJ/PARTOBJ/SPARE2) div $BYTE4"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:call-template name="DoPartObjLogging"/>
   <xsl:call-template name="DoPartObjStorage">
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
   <xsl:call-template name="DoPartObjTablespace"/>
  </xsl:if>
 </xsl:template>
 <xsl:template name="GenPIOTPhysicalAttrs">
  <xsl:param name="MVIEW_LOG">0</xsl:param>
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: GenPIOTPhysicalAttrs - Physical attrs for partitioned IOT
Current node: TABLE_T
Parameters:
  MVIEW_LOG - 1 = generate attributes for materialized view log
  Pctspace - value of the PCTSPACE param; defaults to 100
******************************************************************** -->
  <!-- Do only if SEGMENT_ATTRIBUTES is true -->
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$PARTITIONING=1">
    <xsl:call-template name="DoPIOTSegAttrs">
     <xsl:with-param name="Node" select="PART_OBJ/INDPARTOBJ"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:call-template name="DoPIOTLogging">
    <!-- also does storage -->
    <xsl:with-param name="Node" select="PART_OBJ/INDPARTOBJ"/>
   </xsl:call-template>
   <xsl:call-template name="DoPartObjTablespace"/>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text> PCTTHRESHOLD </xsl:text>
   <xsl:value-of select="PCT_THRESH"/>
  </xsl:if>
  <xsl:if test="(FLAGS mod 536870912) >= 268435456">
   <xsl:text> MAPPING TABLE </xsl:text>
  </xsl:if>
  <xsl:if test="(PROPERTY mod 256)>=128">
   <!-- IOV -->
   <xsl:call-template name="DoIOV">
    <xsl:with-param name="Node" select="current()"/>
    <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CvtHPartToTable">
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: CvtHPartToTable
Current node: TABLE_T
Parameters:
  Pctspace - value of the PCTSPACE param; defaults to 100
Implicit parameters:
  PARTITION_NAME or SUBPARTITION_NAME
   (sub)partition that is the source of storage information
******************************************************************** -->
  <!-- emit SEGMENT CREATION IMMEDIATE for 11.2 -->
  <xsl:if test="$VERSION>=1102000000">
   <xsl:text>SEGMENT CREATION IMMEDIATE </xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0">
    <!--
         convert partition to table
 -->
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/PCT_FREE"/>
    <xsl:call-template name="DoSegCompress">
     <xsl:with-param name="Compress" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE/FLAGS"/>
    </xsl:call-template>
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE">
     <xsl:with-param name="BlkSize" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/LOBS">
     <xsl:with-param name="PartListItem">PART_LIST_ITEM</xsl:with-param>
     <xsl:with-param name="Parttype" select="PART_OBJ/PARTOBJ/PARTTYPE"/>
     <xsl:with-param name="Subpartition">0</xsl:with-param>
    </xsl:apply-templates>
    <!-- 
Placeholder for equipartitioned nested tables.
If a table's nested tables are not equipartitioned with the partition,
partition transportable should fail.
-->
    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="current()"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!--
         convert subpartition to table
 -->
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/PCT_FREE"/>
    <xsl:call-template name="DoSegCompress">
     <xsl:with-param name="Compress" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE/FLAGS"/>
    </xsl:call-template>
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="
PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="
PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/LOBS">
     <xsl:with-param name="PartListItem">SUBPARTS_ITEM</xsl:with-param>
     <xsl:with-param name="Parttype" select="PART_OBJ/PARTOBJ/SPARE2 mod 256"/>
     <xsl:with-param name="Subpartition">1</xsl:with-param>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CvtPIOTPartToTable">
  <xsl:param name="Pctspace">100</xsl:param>
  <!-- *******************************************************************
Template: CvtPIOTPartToTable
Current node: TABLE_T
Parameters:
  Pctspace - value of the PCTSPACE param; defaults to 100
Implicit parameters:
  PARTITION_NAME or SUBPARTITION_NAME
   (sub)partition that is the source of storage information
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="string-length($PARTITION_NAME)!=0">
    <!--
         convert partition to table
 -->
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/PCT_FREE">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
    </xsl:apply-templates>
    <xsl:call-template name="DoSegCompress">
     <xsl:with-param name="Compress" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE/FLAGS"/>
    </xsl:call-template>
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE">
     <xsl:with-param name="BlkSize" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/LOBS">
     <xsl:with-param name="PartListItem">PART_LIST_ITEM</xsl:with-param>
     <xsl:with-param name="Parttype" select="PART_OBJ/TABPARTOBJ/PARTTYPE"/>
     <xsl:with-param name="Subpartition">0</xsl:with-param>
    </xsl:apply-templates>
    <!-- 
Placeholder for equipartitioned nested tables.
If a table's nested tables are not equipartitioned with the partition,
partition transportable should fail.
-->
    <xsl:call-template name="DoIOVList">
     <xsl:with-param name="List" select="PART_OBJ/IOV_LIST"/>
     <xsl:with-param name="PNUM" select="PART_OBJ/PART_LIST/PART_LIST_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/PART_NUM"/>
     <xsl:with-param name="Pctspace" select="$Pctspace"/>
    </xsl:call-template>
    <xsl:call-template name="DoParallel">
     <xsl:with-param name="FlagsParent" select="current()"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!--
         convert subpartition to table
         (Placeholder: composite partitioned IOTs will be added in 11g)
 -->
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/PCT_FREE"/>
    <xsl:call-template name="DoSegCompress">
     <xsl:with-param name="Compress" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$PARTITION_NAME]/STORAGE/FLAGS"/>
    </xsl:call-template>
    <xsl:call-template name="DoLogging">
     <xsl:with-param name="FlagsNode" select="
PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/FLAGS"/>
    </xsl:call-template>
    <xsl:apply-templates select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/STORAGE">
     <xsl:with-param name="BlkSize" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/BLOCKSIZE"/>
     <xsl:with-param name="Dataobjnum" select="PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/DATAOBJ_NUM"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="
PART_OBJ/COMPART_LIST/COMPART_LIST_ITEM/SUBPARTS/SUBPARTS_ITEM[SCHEMA_OBJ/SUBNAME=$SUBPARTITION_NAME]/LOBS">
     <xsl:with-param name="PartListItem">SUBPARTS_ITEM</xsl:with-param>
     <xsl:with-param name="Parttype" select="PART_OBJ/TABPARTOBJ/SPARE2 mod 256"/>
     <xsl:with-param name="Subpartition">1</xsl:with-param>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="CheckTypes">
  <!-- *******************************************************************
Template: CheckTypes
 Add check_type calls for all object types used directly by the table

      If transportable tablespace import and not classic export and VERS_MAJOR
      is at least 2 and VERS_MINOR is at least 2, insert check_type calls for
      object types. For this check to work, the major and minor versions were
      all given the same values in all table views that can contain object
      types (the 4 non-heap table views ku$_fhtable_view, ku$_iotable_view,
      ku$_pfhtable_view, and ku$_piotable_view).

      Do not do this for classic because it does things differently and it
      does its own type checking. Check for not classic export is for parameter
      TRANSPORTABLE_CLASSIC=0.

******************************************************************** -->
  <xsl:if test="$TRANSPORTABLE=1 and $TRANSPORTABLE_CLASSIC=0 and
              (VERS_MAJOR>=3 or (VERS_MAJOR=2 and VERS_MINOR>=2))">
   <xsl:for-each select="COL_LIST/COL_LIST_ITEM[TYPE_NUM=121]">
    <!-- Create one begin...end block for all the calls. Also, call DoParse
        once for the begin...end block. -->
    <xsl:if test="position()=1">
     <xsl:call-template name="DoParse">
      <xsl:with-param name="Verb">SYS.DBMS_METADATA.CHECK_TYPE</xsl:with-param>
      <xsl:with-param name="ObjectType">TABLE</xsl:with-param>
      <xsl:with-param name="SchemaNode" select="../../SCHEMA_OBJ/OWNER_NAME"/>
      <xsl:with-param name="NameNode" select="../../SCHEMA_OBJ/NAME"/>
     </xsl:call-template>
     <xsl:text>BEGIN </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:if>
    <!-- If there are no subtypes, then there is 1 check_type call for the 
        type. If there are subtypes, the parent type is included at the
        TYPEMD level and again in the SUBTYPE_LIST. In that case, create
        1 call for each item in the SUBTYPE_LIST, which will include the
        top level type and each subtype. -->
    <xsl:if test="not(TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM)">
     <xsl:text>SYS.DBMS_METADATA.CHECK_TYPE('</xsl:text>
     <xsl:value-of select="TYPEMD/SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="TYPEMD/SCHEMA_OBJ/NAME"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="TYPEMD/VERSION"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="TYPEMD/HASHCODE"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="TYPEMD/TYPEID"/>
     <xsl:text>'); </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:for-each select="TYPEMD/SUBTYPE_LIST/SUBTYPE_LIST_ITEM">
     <xsl:text>SYS.DBMS_METADATA.CHECK_TYPE('</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="SCHEMA_OBJ/NAME"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="VERSION"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="HASHCODE"/>
     <xsl:text>','</xsl:text>
     <xsl:value-of select="TYPEID"/>
     <xsl:text>'); </xsl:text>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:for-each>
    <xsl:if test="position()=last()">
     <xsl:text>END;</xsl:text>
     <xsl:choose>
      <xsl:when test="$SQLTERMINATOR=1">
       <xsl:text>
/
      </xsl:text>
       <!-- Terminate the SQL statement with a CR and a "/" -->
      </xsl:when>
      <xsl:otherwise>
       <xsl:if test="$PRETTY=1">
        <xsl:text>&#xa;</xsl:text>
       </xsl:if>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>
   </xsl:for-each>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
