create or replace TYPE varcharArray IS TABLE OF VARCHAR2(128);
/

create or replace TYPE numberArray IS TABLE OF NUMBER;
/

create or replace PACKAGE "MIGRATION_REPOSITORY_QUERY" AS

FUNCTION getAllProjectNames return varcharArray;
FUNCTION getProjectDescription(projectName IN VARCHAR2) return VARCHAR2;
FUNCTION getAllCaptureVersions(projectName IN VARCHAR2) return numberArray;
FUNCTION getAllConvertVersions(projectName IN VARCHAR2, captureVersion in NUMBER) return numberArray;
FUNCTION getAllGenerateVersions(projectName IN VARCHAR2, captureVersion in NUMBER, convertVersion in NUMBER) return numberArray;

END;
/

create or replace PACKAGE BODY "MIGRATION_REPOSITORY_QUERY" AS

FUNCTION getAllProjectNames return varcharArray
IS
namesArray varcharArray;
BEGIN
     DBMS_OUTPUT.PUT_LINE('getAllProjectNames -------');
     namesArray := varcharArray();
     FOR project_rec in (select project_name from md_projects)
       LOOP
        namesArray.EXTEND;
        namesArray(namesArray.last) := project_rec.project_name;
        DBMS_OUTPUT.PUT_LINE('Project Name -> ' || project_rec.project_name );
       END LOOP;
    return namesArray;
END getAllProjectNames;

FUNCTION getProjectDescription(projectName IN VARCHAR2) return VARCHAR2
IS
projDescription VARCHAR2(4000);
BEGIN
    DBMS_OUTPUT.PUT_LINE('getProjectDescription -------');
    select comments into projDescription from md_projects where project_name = projectName ;
    return projDescription;
END getProjectDescription;

FUNCTION getAllCaptureVersions(projectName IN VARCHAR2) return numberArray
IS
captureVersionArray numberArray;
BEGIN
     DBMS_OUTPUT.PUT_LINE('getAllCaptureVersions -------');
     captureVersionArray := numberArray();
     FOR captVersion_rec in (select distinct capt_version from MD_SCHEMAS where project_id = (select project_id from MD_PROJECTS where project_name = projectName) order by capt_version)
       LOOP
        captureVersionArray.EXTEND;
        captureVersionArray(captureVersionArray.last) := captVersion_rec.capt_version ;
        DBMS_OUTPUT.PUT_LINE('Project Name -> ' ||projectName || ' Capture Versions -> ' || captVersion_rec.capt_version );
       END LOOP;
    return captureVersionArray;
END getAllCaptureVersions;

FUNCTION getAllConvertVersions(projectName IN VARCHAR2, captureVersion in NUMBER) return numberArray
IS
convertVersionArray numberArray;
BEGIN
     DBMS_OUTPUT.PUT_LINE('getAllConvertVersions -------');
     convertVersionArray := numberArray();
     FOR convVersion_rec in (select distinct conv_version from MD_SCHEMAS where project_id = (select project_id from MD_PROJECTS where project_name = projectName) and capt_version = captureVersion order by conv_version)
       LOOP
        convertVersionArray.EXTEND;
        convertVersionArray(convertVersionArray.last) := convVersion_rec.conv_version ;
        DBMS_OUTPUT.PUT_LINE('Capture Version -> '||captureVersion || ' Convert Versions -> ' || convVersion_rec.conv_version );
       END LOOP;
    return convertVersionArray;
END getAllConvertVersions;

FUNCTION getAllGenerateVersions(projectName IN VARCHAR2, captureVersion in NUMBER, convertVersion in NUMBER) return numberArray
IS
generateVersionArray numberArray;
BEGIN
     DBMS_OUTPUT.PUT_LINE('getAllGenerateVersions -------');
     generateVersionArray := numberArray();
     FOR generateVersion_rec in (
                                 select distinct generate_version from MD_GENERATE 
                                     where project_id = (select project_id from MD_PROJECTS where project_name = projectName) 
                                     and capt_version = captureVersion and conv_version = convertVersion order by generate_version)
       LOOP
        generateVersionArray.EXTEND;
        generateVersionArray(generateVersionArray.last) := generateVersion_rec.generate_version ;
        DBMS_OUTPUT.PUT_LINE('Capture Version -> '||captureVersion || ' Convert Versions -> '||convertVersion ||' Generate Versions -> ' || generateVersion_rec.generate_version );
       END LOOP;
    return generateVersionArray;
END getAllGenerateVersions;

-- TODO
/*
Renamed object names 

'MIGR_DATATYPE_TRANSFORM_MAP'  -> 'MD_DATATYPE_TRANSFORM_MAP',
'MIGR_DATATYPE_TRANSFORM_RULE' -> 'MD_DATATYPE_TRANSFORM_RULE'
'MIGR_GENERATION_ORDER'        -> 'MD_GENERATION_ORDER'
'MIGRATION_RESERVED_WORDS'     -> 'MD_RESERVED_WORDS'
'MIGRLOG'                      -> 'MD_MIGRLOG'

MIGR_MIGRLOG_FK  ->  MD_MIGRLOG_FK

PACKAGE SESSIONSTATE   -> PACKAGE MIGRATION_SESSIONSTATE

*/

END;
/