/* Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. */
var OSN = {
  gotoAnchor: function(name) {
    var selector = name + "~div.sect2>ul:first .expandable";
    $(selector).parent().next('div').css('display', 'block');
  },

  gotoAnchorOnHashChange: function() {
    var hash = window.location.hash;
    if(0 !== hash.length) {
      OSN.gotoAnchor(hash);
    }
  }
};

$(document).ready(function() {
  $('h1').attr('id', 'pagetitle');
  $('.sect1').attr('aria-labelledby', 'pagetitle');
  $('.sect2').each(function(idx) {
      $(this).attr('id', 'docsection' + idx);
  });
  $('.expandable').click(function() {
    if($(this).parent().next('div').css('display') === 'none'){
	$(this).attr('aria-expanded', true);
      $(this).parent().next('div').css('display','block').focus();
    } else {
	  $(this).attr('aria-expanded', false);
      $(this).parent().next('div').css('display','none');
    }
  });

    // for anchors within the text
  $('a').not('.expandable').click(function(evt) {
      var href = $(this).attr('href');
      if(/^#/.test(href)) {
	  $(href).parent().next().find('.expandable').parent().next('div').css('display', 'block');
      }
  });

  $(window).bind('hashchange', function() {
    OSN.gotoAnchorOnHashChange();
  });

  OSN.gotoAnchorOnHashChange();
});
