/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CommonFormatter
extends Formatter {
    protected static final String THREAD_REC_PRFIX = "[THREAD: ";
    protected static final String THREAD_REC_SFFIX = "] ";
    private final String FILLER = "     ";
    private MessageFormat format = new MessageFormat("[{0, date,yyyy-MM-dd HH:mm:ss,SSS}] [{1}] [{2}] [{3}] [{4}] [{5}] [{6}] {7}");
    private Date _date = new Date();
    private Object[] args = new Object[8];
    private String lineSeparator = System.getProperty("line.separator");
    public static String ECID = "ECID";
    private static Map<String, String> fields = new HashMap<String, String>();

    public CommonFormatter() {
    }

    public CommonFormatter(String pattern) {
        this();
        if (pattern != null) {
            this.setMessageFormat(pattern);
        }
    }

    public void setMessageFormat(String pattern) {
        if (pattern != null) {
            String msgFormat = pattern.replaceAll("%d", "{0, date,yyyy-MM-dd HH:mm:ss,SSS}");
            msgFormat = msgFormat.replaceAll("%-5p", "{1}");
            msgFormat = msgFormat.replaceAll("%p", "{1}");
            msgFormat = msgFormat.replaceAll("%t", "{2}");
            msgFormat = msgFormat.replaceAll("%C", "{3}");
            msgFormat = msgFormat.replaceAll("%m", "{4}");
            if ((msgFormat = msgFormat.replaceAll("%n", "")).length() > 0) {
                this.format = new MessageFormat(msgFormat);
            }
        }
    }

    @Override
    public synchronized String format(LogRecord record) {
        this._date.setTime(record.getMillis());
        this.args[0] = this._date;
        String level = record.getLevel().getLocalizedName();
        this.args[1] = "componentID " + record.getLoggerName();
        this.args[2] = level == null ? "     " : (level.length() >= 5 ? level : level + "     ".substring(level.length()));
        String message = record.getMessage();
        String messageID = null;
        ResourceBundle rb = record.getResourceBundle();
        if (rb != null) {
            boolean isMessageKey = false;
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements()) {
                if (!e.nextElement().equals(message)) continue;
                isMessageKey = true;
                break;
            }
            if (isMessageKey) {
                messageID = message;
                message = rb.getString(messageID);
                record.setMessage(message);
            }
        }
        this.args[3] = messageID == null ? "" : "messageID_" + messageID;
        this.args[4] = "moduleID " + record.getSourceClassName();
        this.args[5] = CommonFormatter.getECID();
        this.args[6] = Thread.currentThread().getName() + "_" + Thread.currentThread().getId() + " " + String.valueOf(record.getThreadID());
        this.args[7] = message == null ? null : this.formatMessage(record);
        StringBuffer sb = new StringBuffer();
        this.format.format(this.args, sb, (FieldPosition)null);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static String getECID() {
        return fields.get(ECID);
    }

    static {
        String ecid = ECID + "_" + new Date().getTime();
        fields.put(ECID, ecid);
    }
}

