/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver.remote;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteNodes;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.RemoteOperations;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class GIHomeOperations
implements RemoteOperations {
    private static final int ERROR = -1;

    @Override
    public int executeAction(List<String> argsList) {
        int status = 0;
        if (argsList != null) {
            String giHomePath = null;
            String action = null;
            ArrayList<String> clusterNodes = null;
            for (int i = 0; i < argsList.size(); ++i) {
                if (argsList.get(i).equals("-GRID_HOME")) {
                    giHomePath = argsList.get(++i);
                    continue;
                }
                if (argsList.get(i).equals("-CRS_ACTION")) {
                    action = argsList.get(++i);
                    continue;
                }
                if (!argsList.get(i).equals("-CLUSTERNODES")) continue;
                String clusterNodeStr = argsList.get(++i);
                clusterNodes = new ArrayList<String>(Arrays.asList(clusterNodeStr.split(",")));
            }
            if (!StringUtil.isNullOrEmpty(action, (boolean)true)) {
                if (action.equals("delete")) {
                    status = this.deleteCRSInit(giHomePath);
                } else if (action.equals("check")) {
                    status = this.detectCRSInit(giHomePath, clusterNodes);
                }
            }
        }
        return status;
    }

    public int detectCRSInit(String giHomePath, ArrayList<String> clusterNodes) {
        int status = 0;
        System.setProperty("ORACLE_HOME", giHomePath);
        String hostname = OUIDriver.extractHostName(OsysUtility.getHostname());
        StringBuffer buff = new StringBuffer().append("HOST").append("=").append(hostname).append("\n");
        String filePath = giHomePath + ProductDriverConstants.OPATCH_AUTO_CRS_SESSION_INIT + hostname;
        File initFile = new File(filePath);
        buff.append("INIT_FILE_EXISTS").append("=");
        if (initFile.exists()) {
            buff.append("true").append("\n");
        } else {
            buff.append("false").append("\n");
        }
        if (clusterNodes != null && clusterNodes.size() > 0) {
            clusterNodes.remove(hostname);
            RemoteNodes nodes = new RemoteNodes(clusterNodes);
            try {
                nodes.saveDataObject(giHomePath);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                status = -1;
            }
        }
        Reporting.report((String)buff.toString());
        return status;
    }

    public int deleteCRSInit(String giHomePath) {
        int status = 0;
        System.setProperty("ORACLE_HOME", giHomePath);
        String hostname = OUIDriver.extractHostName(OsysUtility.getHostname());
        StringBuffer buff = new StringBuffer().append("HOST").append("=").append(hostname).append("\n");
        String filePath = giHomePath + ProductDriverConstants.OPATCH_AUTO_CRS_SESSION_INIT + hostname;
        File initFile = new File(filePath);
        buff.append("INIT_FILE_DELETED").append("=");
        if (initFile.exists()) {
            if (initFile.delete()) {
                buff.append("true").append("\n");
            } else {
                buff.append("false").append("\n");
                System.err.println("Unable to delete status file at " + filePath);
                status = -1;
            }
        } else {
            buff.append("false").append("\n");
        }
        Reporting.report((String)buff.toString());
        return status;
    }
}

