/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import java.util.ArrayList;
import java.util.List;

public class RHPApplyImageCommand
extends Command {
    @Override
    public List<String> generateCommand(RHPParams params) {
        OracleHomeInformationLoader.OracleHomeType homeType = OracleHomeInformationLoader.getInstance().getHomeType(params.getOracleHome());
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(this.getRHPExecutable(params.getRHPClientHome()));
        commandBuilder.append(" ");
        commandBuilder.append("add workingcopy");
        commandBuilder.append(" ");
        commandBuilder.append("-image");
        commandBuilder.append(" ");
        commandBuilder.append(params.getImageID());
        commandBuilder.append(" ");
        commandBuilder.append("-workingcopy");
        commandBuilder.append(" ");
        commandBuilder.append(params.getWorkingCopyID());
        commandBuilder.append(" ");
        commandBuilder.append("-path");
        commandBuilder.append(" ");
        commandBuilder.append(params.getPath());
        if (homeType == OracleHomeInformationLoader.OracleHomeType.CRS) {
            commandBuilder.append(" ");
            commandBuilder.append("-softwareonly");
        } else {
            String oraclebase = OracleHomeInformationLoader.getInstance().getOraclebaseLocation();
            if (!StringUtil.isNullOrEmpty((String)oraclebase)) {
                commandBuilder.append(" ");
                commandBuilder.append("-oraclebase");
                commandBuilder.append(" ");
                commandBuilder.append(oraclebase);
            }
            commandBuilder.append(" ");
            commandBuilder.append("-storagetype");
            commandBuilder.append(" ");
            commandBuilder.append("LOCAL");
        }
        if (params.isAnalyze()) {
            commandBuilder.append(" ");
            commandBuilder.append("-eval");
        }
        this._logger.fine("Generated command::" + commandBuilder.toString());
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandBuilder.toString());
        return commandList;
    }

    @Override
    public RHPOperation getOperationType() {
        return RHPOperation.PROVISION_HOME;
    }

    @Override
    public String getStatusMessage(RHPCommandExecutor.Status status, RHPParams params) {
        String statusMsg = "";
        switch (status) {
            case START: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.analyze.start", (Object[])new Object[]{params.getOracleHome()});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.start", (Object[])new Object[]{params.getPath()});
                break;
            }
            case SUCCESSFUL: {
                if (params.isAnalyze()) {
                    statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.analyze.successful", (Object[])new Object[]{params.getOracleHome()});
                    break;
                }
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.successful", (Object[])new Object[]{params.getPath()});
                break;
            }
            case FAILED: {
                statusMsg = params.isAnalyze() ? OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.analyze.failed", (Object[])new Object[]{params.getOracleHome()}) : OPatchAutoHelper.getLocalizedString((String)"RHPApplyImageCommand.status.msg.failed", (Object[])new Object[]{params.getPath()});
            }
        }
        return statusMsg;
    }
}

