/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.validation.rules;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.NullValuePropertyCause;
import oracle.osysmodel.validation.rules.BaseRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckForNullValues
extends BaseRule {
    private final Logger logger = Logger.getLogger(CheckForNullValues.class.getName());
    List<AbstractBaseTarget> methodValidationFilter = new ArrayList<AbstractBaseTarget>();
    private final Map<AbstractBaseTarget, List<Method>> failedResultMap = new HashMap<AbstractBaseTarget, List<Method>>();

    public CheckForNullValues(SystemInstance systemInstance, List<AbstractBaseTarget> list) {
        super(systemInstance);
        this.successMessage = "Checks if the all the required values specified by the method filter are non null.";
        this.methodValidationFilter = list;
    }

    @Override
    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Ensuring that all the required values specified by the method filter are non null.");
        ArrayList<NullValuePropertyCause> arrayList = new ArrayList<NullValuePropertyCause>();
        boolean bl = false;
        bl = this.validate(this.methodValidationFilter);
        ArrayList<AbstractBaseTarget> arrayList2 = new ArrayList<AbstractBaseTarget>();
        if (bl) {
            return new RuleResult((Rule)this);
        }
        for (AbstractBaseTarget abstractBaseTarget : this.failedResultMap.keySet()) {
            arrayList2.add(abstractBaseTarget);
        }
        arrayList.add(new NullValuePropertyCause(arrayList2, BundleUtils.getMessage(CheckForNullValues.class, (String)"VALUE_FOUND_TO_BE_NULL", (Object[])new Object[]{BundleUtils.makeStringForFailedResultMap(this.failedResultMap)}), this.failedResultMap));
        return new RuleResult((Rule)this, new Boolean(bl), arrayList);
    }

    public boolean validate(List<AbstractBaseTarget> list) {
        HashMap<Class<? extends AbstractBaseTarget>, List<Method>> hashMap = new HashMap<Class<? extends AbstractBaseTarget>, List<Method>>();
        for (AbstractBaseTarget abstractBaseTarget : list) {
            hashMap.put(abstractBaseTarget.getClass(), abstractBaseTarget.getRequestedGetters());
        }
        return this.validate(hashMap);
    }

    private boolean validate(Map<Class<? extends AbstractBaseTarget>, List<Method>> map) {
        boolean bl = true;
        for (BaseClass baseClass : this.config.getEntities()) {
            assert (baseClass instanceof AbstractBaseTarget);
            AbstractBaseTarget abstractBaseTarget = (AbstractBaseTarget)baseClass;
            if (map.get(abstractBaseTarget.getClass()) == null || map.get(abstractBaseTarget.getClass()).size() == 0) {
                this.logger.log(Level.INFO, "Method Filter's for " + baseClass.getClass() + " don't exist or is empty in the Validation Filter map. " + "This class will be ignored for validation");
                continue;
            }
            ArrayList<Method> arrayList = new ArrayList<Method>();
            for (Method method : map.get(abstractBaseTarget.getClass())) {
                Object object = null;
                try {
                    object = method.invoke((Object)baseClass, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.severe(illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.logger.severe(invocationTargetException.getMessage());
                }
                if (object != null && (!(object instanceof List) || !((List)object).isEmpty())) continue;
                bl = false;
                arrayList.add(method);
            }
            if (arrayList.isEmpty()) continue;
            this.failedResultMap.put(abstractBaseTarget, arrayList);
        }
        return bl;
    }
}

