/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.ConditionHelper;
import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.OrResolver;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class ConditionFinalizer
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _selectedItemVertices;
    private List<TVertex> _priorSelectedConflicts;
    private List<TVertex> _modifiedVertices;
    private List<TVertex> _unresolvedPrereqsErr;
    private List<TVertex> _selfConflictsErr;
    private boolean _allOrsResolved;

    public ConditionFinalizer(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
        this._selectedItemVertices = new ArrayList<TVertex>();
        this._priorSelectedConflicts = new ArrayList<TVertex>();
        this._modifiedVertices = new ArrayList<TVertex>();
        this._unresolvedPrereqsErr = new ArrayList<TVertex>();
        this._selfConflictsErr = new ArrayList<TVertex>();
    }

    public List<TVertex> getSelectedItemVertices() {
        return this._selectedItemVertices;
    }

    public List<TVertex> getPriorSelectedConflicts() {
        return this._priorSelectedConflicts;
    }

    public List<TVertex> getModifiedVertices() {
        return this._modifiedVertices;
    }

    public List<TVertex> getUnresolvedPrereqsErr() {
        return this._unresolvedPrereqsErr;
    }

    public List<TVertex> getSelfConflictsErr() {
        return this._selfConflictsErr;
    }

    public boolean isAllOrsResolved() {
        return this._allOrsResolved;
    }

    public boolean hasErrors() {
        return !this._allOrsResolved || !this._unresolvedPrereqsErr.isEmpty() || !this._selfConflictsErr.isEmpty();
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._selectedItemVertices.clear();
        this._priorSelectedConflicts.clear();
        this._modifiedVertices.clear();
        this._unresolvedPrereqsErr.clear();
        this._selfConflictsErr.clear();
        this._allOrsResolved = true;
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        if (((VKey)vertex.getKey()).isSkipNotDefaultNode()) {
            return false;
        }
        super.preVisit(edge, vertex);
        if (edge == null) {
            this.trace("FINALIZING RESOLVED OR <", vertex, ">");
        } else {
            this.trace("PROCESSING <", vertex, "> reached from <", edge.getSource(), ">");
        }
        VKey vKey = (VKey)vertex.getKey();
        if (vKey.getType() != VKey.VType.OR_COND && vKey.getType() != VKey.VType.AND_COND || vKey.getSelectedState() == VKey.SelectedState.NOTSELECTED) {
            this.traceAction("NOACTION: vertex is not selected or is not <OR> or <AND> vertex ", vKey);
            return false;
        }
        switch (vKey.getType()) {
            case OR_COND: {
                this.finalizeOrState(vertex);
                break;
            }
            case AND_COND: {
                this.finalizeAndState(vertex);
            }
        }
        return ConditionHelper.hasCondPrereqs(this._graph, vertex);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void finalizeOrState(TVertex vertex) {
        TEdge resolvedEdge;
        VKey vKey = (VKey)vertex.getKey();
        VKey.SelectedState orState = vKey.getSelectedState();
        if (!$assertionsDisabled) {
            if (vKey.getType() != VKey.VType.OR_COND) throw new AssertionError();
            if (orState != VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE && orState != VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE) {
                throw new AssertionError();
            }
        }
        this.setVertexState(vertex, VKey.SelectedState.SELECTED);
        if (ConditionHelper.isOrSatisfied(this._graph, vertex)) {
            this.traceAction("STOP: OR is already satisfied ", vKey);
            return;
        }
        OrResolver resolver = ((VKey)vertex.getKey()).getResolver();
        TEdge tEdge = resolvedEdge = resolver == null ? null : resolver.getResolved();
        if (resolvedEdge != null) {
            assert (resolvedEdge.getSource() == vertex);
            boolean isResolved = true;
            TVertex outV = (TVertex)resolvedEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)resolvedEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                if (outVKey.wasStateSetInOp() && outVKey.getSelectedState() == VKey.SelectedState.SELECTED) {
                    this.traceAction("ERROR: Found selected conflict ", outVKey);
                    this._selfConflictsErr.add(outV);
                    isResolved = false;
                } else {
                    this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                    this.traceAction("...MARK_CONFLICT_CANDIDATE... Marked conflict provided by resolver ", outVKey);
                    for (TVertex out : this._graph.getOutgoingVertices(vertex)) {
                        if (out == outV) continue;
                        ((VKey)out.getKey()).setSkipNotDefaultNode(true);
                    }
                }
            } else if (outVKey.wasStateSetInOp() && outVKey.getSelectedState() == VKey.SelectedState.CONFLICTS) {
                this.traceAction("ERROR: Prerequisite was marked as conflict in this session ", outVKey);
                this._selfConflictsErr.add(outV);
                isResolved = false;
            } else {
                this.setVertexState(outV, VKey.SelectedState.SELECTED);
                this.traceAction("...SELECTED_CANDIDATE... Selected prerequisite provided by resolver ", outVKey);
                for (TVertex out : this._graph.getOutgoingVertices(vertex)) {
                    if (out == outV) continue;
                    ((VKey)out.getKey()).setSkipNotDefaultNode(true);
                }
            }
            if (!isResolved) {
                this.traceAction("ERROR: Resolver pick couldn't be processed ", vKey);
                this._unresolvedPrereqsErr.add(vertex);
                return;
            }
            this.traceAction("RESOLVED: OR vertex was resolved ", vKey);
            return;
        }
        int numSelectedOptions = 0;
        block25: for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                assert (outVKey.getType() == VKey.VType.TINFO || outVKey.getType() == VKey.VType.UNRESOLVED);
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                    this.traceAction("...MARK_CONFLICT_CANDIDATE... Marking UNRESOLVED vertex as conflict ", outVKey);
                    ++numSelectedOptions;
                    continue;
                }
                switch (outVKey.getSelectedState()) {
                    case SELECTED: {
                        if (orState == VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE && !outVKey.wasStateSetInOp()) {
                            this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                            this.traceAction("...MARK_CONFLICT_CANDIDATE... Marked conflict candidate which was previously seleted ", outVKey);
                            ++numSelectedOptions;
                            break;
                        }
                        this.traceAction("...NOACTION... Selected conflict was marked in this session or wasn't unique choice ", outVKey);
                        break;
                    }
                    case CONFLICTS: {
                        if (!outVKey.wasStateSetInOp()) {
                            this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                            this.traceAction("...MARK_CONFLICT_CANDIDATE... Re-marked conflict which was marked in previous sessions ", outVKey);
                        } else {
                            this.traceAction("...COUNT... Conflict is already marked in this session ", outVKey);
                        }
                        ++numSelectedOptions;
                        break;
                    }
                    case NOTSELECTED: {
                        switch (outVKey.getInstalledState()) {
                            case INSTALLED: {
                                this.traceAction("...NOACTION... Conflict is installed ", outVKey);
                                break;
                            }
                            case CONFLICTS_WITH_INSTALLED: {
                                this.traceAction("...COUNT... Conflict is already conflicts with installed vertices ", outVKey);
                                ++numSelectedOptions;
                                break;
                            }
                            case NOTINSTALLED: 
                            case COND_CONFL: {
                                if (orState != VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE) break;
                                this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                                this.traceAction("...MARK_CONFLICT_CANDIDATE...Marked not selected conflict candidate ", outVKey);
                                ++numSelectedOptions;
                            }
                        }
                        continue block25;
                    }
                }
                continue;
            }
            block10 : switch (outVKey.getSelectedState()) {
                case SELECTED: {
                    if (!outVKey.wasStateSetInOp()) {
                        this.setVertexState(outV, VKey.SelectedState.SELECTED);
                        this.traceAction("...SELECT_CANDIDATE... Re-selecting candidate selected in prior sessions ", outVKey);
                    } else {
                        this.traceAction("...COUNT... Prerequisite is already selected in this session ", outVKey);
                    }
                    ++numSelectedOptions;
                    break;
                }
                case RESOLVED_SELECTION_CANDIDATE: {
                    ++numSelectedOptions;
                    break;
                }
                case RESOLVABLE_SELECTION_CANDIDATE: {
                    this.traceAction("...COUNT... selection candidate will be separately processed ", outVKey);
                    if (orState == VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE) {
                        this.traceAction("Unselecting resolvable vertex not needed for or " + outVKey);
                        this.setVertexState(outV, VKey.SelectedState.NOTSELECTED);
                        break;
                    }
                    ++numSelectedOptions;
                    break;
                }
                case POSSIBLE_SELECTION_CANDIDATE: {
                    this.setVertexState(outV, VKey.SelectedState.NOTSELECTED);
                    this.traceAction("...UNSELECT... Unselecting not deterministically resolvable vertex ", outVKey);
                    break;
                }
                case CONFLICTS: {
                    if (orState == VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE && !outVKey.wasStateSetInOp()) {
                        this.setVertexState(outV, VKey.SelectedState.SELECTED);
                        this.traceAction("...SELECT_CANDIDATE... Selecting candidate which was marked as conflict in prior sessions " + outVKey);
                        ++numSelectedOptions;
                        break;
                    }
                    this.traceAction("...NO_ACTION... Prerequisite was marked as conflict in this session or it's not unique choice ", outVKey);
                    break;
                }
                case NOTSELECTED: {
                    if (outVKey.getType() == VKey.VType.TINFO) {
                        switch (outVKey.getInstalledState()) {
                            case INSTALLED: {
                                this.traceAction("...COUNT... Prerequisite is already installed ", outVKey);
                                ++numSelectedOptions;
                                break block10;
                            }
                            case CONFLICTS_WITH_INSTALLED: {
                                this.traceAction("...NOACTION... Prerequisite conflicts with installed vertices ", outVKey);
                                break block10;
                            }
                            case NOTINSTALLED: 
                            case COND_CONFL: {
                                if (orState == VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE) {
                                    this.setVertexState(outV, VKey.SelectedState.SELECTED);
                                    this.traceAction("...SELECT_CANDIDATE... selected unselected prerequisite ", outVKey);
                                    ++numSelectedOptions;
                                    break block10;
                                }
                                this.traceAction("...NOACTION... selected unselected prerequisite ", outVKey);
                                continue block25;
                            }
                        }
                        break;
                    }
                    this.traceAction("...NOACTION... prerequisite is AND, OR, or UNRESOLVED", outVKey);
                    continue block25;
                }
            }
        }
        if (numSelectedOptions == 0) {
            this.traceAction("ERROR: None of the OR options were selected ", vKey);
            this._unresolvedPrereqsErr.add(vertex);
            return;
        }
        if (orState == VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE && numSelectedOptions > 1) {
            this.traceAction("ERROR: More than one options was selected for RESOLVABLE OR ", vKey);
            this._allOrsResolved = false;
            return;
        }
        this.traceAction("RESOLVED: OR vertex was resolved ", vKey);
    }

    private void finalizeAndState(TVertex vertex) {
        VKey vKey = (VKey)vertex.getKey();
        assert (vKey.getType() == VKey.VType.AND_COND && (vKey.getSelectedState() == VKey.SelectedState.RESOLVED_SELECTION_CANDIDATE || vKey.getSelectedState() == VKey.SelectedState.RESOLVABLE_SELECTION_CANDIDATE) || vKey.getSelectedState() == VKey.SelectedState.SELECTED);
        this.setVertexState(vertex, VKey.SelectedState.SELECTED);
        int numUnresolvedOptions = 0;
        for (TEdge outEdge : this._graph.getOutgoingEdges(vertex)) {
            TVertex outV = (TVertex)outEdge.getDest();
            VKey outVKey = (VKey)outV.getKey();
            if (((EKey)outEdge.getKey()).getType() == EKey.EType.CONFLICTS) {
                assert (outVKey.getType() == VKey.VType.TINFO || outVKey.getType() == VKey.VType.UNRESOLVED);
                if (outVKey.getType() == VKey.VType.UNRESOLVED) {
                    this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                    this.traceAction("...MARK_CONFLICT_CANDIDATE... Marked UNRESOLVED conflict ", outVKey);
                    continue;
                }
                block0 : switch (outVKey.getSelectedState()) {
                    case SELECTED: {
                        if (outVKey.wasStateSetInOp()) {
                            this.traceAction("...ERROR... Found selected conflict ", outVKey);
                            ++numUnresolvedOptions;
                            this._selfConflictsErr.add(outV);
                            break;
                        }
                        this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                        this.traceAction("...MARK_CONFLICT_CANDIDATE... Marked conflict which was selected in prior sessions ", outVKey);
                        break;
                    }
                    case CONFLICTS: {
                        if (!outVKey.wasStateSetInOp()) {
                            this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                            this.traceAction("...MARK_CONFLICT_CANDIDATE... Remarked conflict which was marked in previous sessions ", outVKey);
                            break;
                        }
                        this.traceAction("...NOACTION... Conflict is already marked ", outVKey);
                        break;
                    }
                    case NOTSELECTED: {
                        switch (outVKey.getInstalledState()) {
                            case INSTALLED: {
                                this.traceAction("...ERROR... Found installed conflict ", outVKey);
                                ++numUnresolvedOptions;
                                break block0;
                            }
                            case CONFLICTS_WITH_INSTALLED: {
                                this.traceAction("...NOACTION... Found conflict which conflicts with installed ", outVKey);
                                break block0;
                            }
                            case NOTINSTALLED: 
                            case COND_CONFL: {
                                this.setVertexState(outV, VKey.SelectedState.CONFLICTS);
                                this.traceAction("...MARK_CONFLICT_CANDIDATE... Marked notselected conflict ", outVKey);
                            }
                        }
                    }
                }
                continue;
            }
            block10 : switch (outVKey.getSelectedState()) {
                case SELECTED: {
                    if (!outVKey.wasStateSetInOp()) {
                        this.traceAction("...SELECT_CANDIDATE... Reselecting vertex which was selected in prior sessions ", outVKey);
                        this.setVertexState(outV, VKey.SelectedState.SELECTED);
                        break;
                    }
                    this.traceAction("...NOACTION... Prerequisite is already selected ", outVKey);
                    break;
                }
                case RESOLVED_SELECTION_CANDIDATE: 
                case RESOLVABLE_SELECTION_CANDIDATE: {
                    this.traceAction("...NOACTION... selection candidate will be separately processed ", outVKey);
                    break;
                }
                case POSSIBLE_SELECTION_CANDIDATE: {
                    this.traceAction("...ERROR... Found not deterministically resolvable vertex ", outVKey);
                    ++numUnresolvedOptions;
                    break;
                }
                case CONFLICTS: {
                    if (outVKey.wasStateSetInOp()) {
                        this.traceAction("...ERROR... Found prerequisite which was marked as conflict in this session ", outVKey);
                        ++numUnresolvedOptions;
                        this._selfConflictsErr.add(outV);
                        break;
                    }
                    this.setVertexState(outV, VKey.SelectedState.SELECTED);
                    this.traceAction("...SELECT_CANDIDATE... selecting prerequisite which was marked as conflict in prior sessions ", outVKey);
                    break;
                }
                case NOTSELECTED: {
                    if (outVKey.getType() == VKey.VType.TINFO) {
                        switch (outVKey.getInstalledState()) {
                            case INSTALLED: {
                                this.traceAction("...NOACTION... Prerequisite is installed ", outVKey);
                                break block10;
                            }
                            case CONFLICTS_WITH_INSTALLED: {
                                this.traceAction("...ERROR... Found prerequisite which conflicts with installed items ", outVKey);
                                ++numUnresolvedOptions;
                                break block10;
                            }
                            case NOTINSTALLED: 
                            case COND_CONFL: {
                                this.setVertexState(outV, VKey.SelectedState.SELECTED);
                                this.traceAction("...SELECT_CANDIDATE... selected unselected prerequisite ", outVKey);
                            }
                        }
                        break;
                    }
                    this.traceAction("...ERROR... found unresolved prerequisite condition ", outVKey);
                    ++numUnresolvedOptions;
                }
            }
        }
        if (numUnresolvedOptions > 0) {
            this.traceAction("ERROR: Found ", numUnresolvedOptions, " unresolved options for ", vKey);
            this._unresolvedPrereqsErr.add(vertex);
        } else {
            this.traceAction("RESOLVED: AND vertex was resolved ", vKey);
        }
    }

    private void setVertexState(TVertex vertex, VKey.SelectedState state) {
        VKey vKey = (VKey)vertex.getKey();
        boolean setVertexState = true;
        if (vKey.getType() == VKey.VType.TINFO && vKey.getSelectedState() != VKey.SelectedState.SELECTED && state == VKey.SelectedState.SELECTED) {
            this._selectedItemVertices.add(vertex);
            setVertexState = false;
        }
        if (vKey.getType() == VKey.VType.TINFO && vKey.getSelectedState() == VKey.SelectedState.SELECTED && state == VKey.SelectedState.CONFLICTS) {
            this._priorSelectedConflicts.add(vertex);
            setVertexState = false;
        }
        if (setVertexState) {
            vKey.setSelectedState(state);
        }
        this._modifiedVertices.add(vertex);
    }
}

