/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectConfirmationData
extends XMLElement {
    public SubjectConfirmationData(Element element) throws DOMException {
        super(element);
    }

    public SubjectConfirmationData(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public SubjectConfirmationData(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "SubjectConfirmationData");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public void setNotBefore(Date notBefore) {
        this.setAttribute("NotBefore", XMLUtils.formatDateTime((Date)notBefore));
    }

    public Date getNotBefore() {
        if (this.hasAttribute("NotBefore")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("NotBefore"));
        }
        return null;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.setAttribute("NotOnOrAfter", XMLUtils.formatDateTime((Date)notOnOrAfter));
    }

    public Date getNotOnOrAfter() {
        if (this.hasAttribute("NotOnOrAfter")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("NotOnOrAfter"));
        }
        return null;
    }

    public void setRecipient(String recipient) {
        this.setAttribute("Recipient", recipient);
    }

    public String getRecipient() {
        if (this.hasAttribute("Recipient")) {
            return this.getAttribute("Recipient");
        }
        return null;
    }

    public void setInResponseTo(String inResponseTo) {
        this.setAttribute("InResponseTo", inResponseTo);
    }

    public String getInResponseTo() {
        if (this.hasAttribute("InResponseTo")) {
            return this.getAttribute("InResponseTo");
        }
        return null;
    }

    public void setAddress(String address) {
        this.setAttribute("Address", address);
    }

    public String getAddress() {
        if (this.hasAttribute("Address")) {
            return this.getAttribute("Address");
        }
        return null;
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        ((Element)this.getNode()).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.getNode()).getAttributeNS(namespaceURI, localName);
    }

    public void setConfirmationData(List elements) {
        XMLUtils.removeAllChildren((Node)this.getNode());
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            this.getNode().appendChild((Node)elements.get(i));
        }
    }

    public List getConfirmationData() {
        ArrayList<Node> l = new ArrayList<Node>();
        NodeList nl = this.getNode().getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            l.add(nl.item(i));
        }
        return l;
    }

    public void setKeyInfoConfirmationData(List keyInfos) {
        XMLUtils.removeAllChildren((Node)this.getNode());
        this.addNSPrefixAttr("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", SAML2URI.schema_type_keyInfoConfirmationData.toString());
        for (Object obj : keyInfos) {
            if (!(obj instanceof XSKeyInfo)) continue;
            this.appendChild((XMLNode)((XSKeyInfo)obj));
        }
    }

    public List getKeyInfoConfirmationData() {
        ArrayList<XSKeyInfo> l = null;
        String attrVal = this.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        String nsURI = QName.resolvePrefix((String)attrVal, (Node)this.getNode());
        String lp = QName.getLocalPart((String)attrVal);
        NodeList nl = this.getNode().getChildNodes();
        int len = nl.getLength();
        if (len == 0) {
            return null;
        }
        if (len > 0) {
            l = new ArrayList<XSKeyInfo>();
            for (int i = 0; i < len; ++i) {
                l.add(new XSKeyInfo((Element)nl.item(i)));
            }
        }
        return l;
    }

    static {
        SAML2Initializer.initialize();
    }
}

