/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.Contact;
import oracle.security.xmlsec.saml2.metadata.Extensions;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContactPerson
extends XMLElement {
    String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};
    String[] tagList = new String[]{"Extensions", "Company", "GivenName", "SurName", "EmailAddress", "TelephoneNumber"};

    public ContactPerson(Element element) throws DOMException {
        super(element);
    }

    public ContactPerson(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ContactPerson(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    protected ContactPerson(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setContactType(Contact ct) {
        this.setAttribute("contactType", ct.getValue());
    }

    public Contact getContactType() {
        if (this.hasAttribute("contactType")) {
            return new Contact(this.getAttribute("contactType"));
        }
        return null;
    }

    public void setExtensions(Extensions extension) {
        SAML2Utils.setChildElement(this, extension, this.nsList, this.tagList);
    }

    public Extensions getExtensions() {
        return (Extensions)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Extensions");
    }

    public void setCompany(String company) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Company", this.nsList, this.tagList, company, true);
    }

    public String getCompany() {
        return SAML2Utils.collectTextFromChild(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Company");
    }

    public void setGivenName(String givenName) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:metadata", "GivenName", this.nsList, this.tagList, givenName, true);
    }

    public String getGivenName() {
        return SAML2Utils.collectTextFromChild(this, "urn:oasis:names:tc:SAML:2.0:metadata", "GivenName");
    }

    public void setSurName(String surname) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:metadata", "SurName", this.nsList, this.tagList, surname, true);
    }

    public String getSurName() {
        return SAML2Utils.collectTextFromChild(this, "urn:oasis:names:tc:SAML:2.0:metadata", "SurName");
    }

    public void addEmailAddress(String address) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:metadata", "EmailAddress", this.nsList, this.tagList, address, false);
    }

    public List getEmailAddresses() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:metadata", "EmailAddress");
    }

    public void addTelephoneNumber(String number) {
        SAML2Utils.insertChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:metadata", "TelephoneNumber", this.nsList, this.tagList, number, false);
    }

    public List getTelephoneNumbers() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:metadata", "TelephoneNumber");
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        ((Element)this.getNode()).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.getNode()).getAttributeNS(namespaceURI, localName);
    }

    static {
        SAML2Initializer.initialize();
    }
}

