/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.saml2.core.BaseID;
import oracle.security.xmlsec.saml2.core.EncryptedID;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.core.SAML2NameIdentifier;
import oracle.security.xmlsec.saml2.protocol.RequestAbstract;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogoutRequest
extends RequestAbstract {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:protocol"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Extensions", "BaseID", "NameID", "EncryptedID", "SessionIndex"};

    public LogoutRequest(Element element) throws DOMException {
        super(element);
    }

    public LogoutRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public LogoutRequest(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void setSubjectNameIdentifier(SAML2NameIdentifier nid) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"NameID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"EncryptedID");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"BaseID");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)((XMLElement)nid), (String[])nsList, (String[])tagList);
    }

    public SAML2NameIdentifier getSubjectNameIdentifier() {
        XMLElement nid = null;
        nid = (NameID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nid != null) {
            return nid;
        }
        nid = (EncryptedID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedID");
        if (nid != null) {
            return nid;
        }
        nid = (BaseID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "BaseID");
        if (nid != null) {
            return nid;
        }
        return null;
    }

    public void addSessionIndex(String index) {
        SAML2Utils.appendChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:protocol", "SessionIndex", index);
    }

    public List getSessionIndexes() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:protocol", "SessionIndex");
    }

    public void setReason(String reason) {
        this.setAttribute("Reason", reason);
    }

    public String getReason() {
        if (this.hasAttribute("Reason")) {
            return this.getAttribute("Reason");
        }
        return null;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.setAttribute("NotOnOrAfter", XMLUtils.formatDateTime((Date)notOnOrAfter));
    }

    public Date getNotOnOrAfter() {
        if (this.hasAttribute("NotOnOrAfter")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("NotOnOrAfter"));
        }
        return null;
    }
}

