/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.LocalPatchActionRunner;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionManager;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionResultsContainer;
import com.oracle.glcm.patch.auto.action.PatchActionRunner;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.action.RemotePatchActionRunner;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.plan.PatchPlanTargets;
import com.oracle.glcm.patch.auto.product.ProductSupportManager;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSessionImpl;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.tracking.PatchTracking;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatchActionExecutor {
    private static final Logger _logger = Logger.getLogger(PatchActionExecutor.class.getName());

    public static void execute(MutablePatchSession patchSession, Goal goal) throws OPatchAutoException {
        _logger.info("Execute called for patch actions of [" + goal + "] phase:goal.");
        patchSession.setCurrentGoal(goal);
        PatchActionManager manager = patchSession.getProductSupportManager().getPatchActionManager();
        List<PatchAction> patchActions = manager.getPatchActions(goal);
        if (patchActions != null && !patchActions.isEmpty()) {
            PatchPlanTargets patchPlanTargets = patchSession.getPatchPlanManager().getCurrentPatchPlanTargets();
            if (patchPlanTargets == null) {
                throw new OPatchAutoException("68065", new Object[0]);
            }
            _logger.info("Attempting to execute patch actions " + patchActions + " for [" + goal + "] phase:goal using patch targets " + patchPlanTargets.getPatchTargets(true) + " for types " + patchPlanTargets.getTypes());
            for (PatchAction patchAction : patchActions) {
                Set<String> supportedProductTypes = patchAction.getSupportedProductTypes();
                if (supportedProductTypes != null && !supportedProductTypes.isEmpty() && Collections.disjoint(supportedProductTypes, patchPlanTargets.getTypes())) {
                    _logger.log(Level.INFO, "Skipping patch action because it does not support one of the current patch target types " + patchPlanTargets.getTypes());
                    continue;
                }
                if (patchSession.isAnalyze() && !patchAction.isAnalyzeSupported()) {
                    _logger.log(Level.INFO, "Skipping patch action because it does not support analyze [" + patchAction + "].");
                    continue;
                }
                if (patchSession.isRollback() && !patchAction.isRollbackSupported()) {
                    _logger.log(Level.INFO, "Skipping patch action because it does not support rollback [" + patchAction + "].");
                    continue;
                }
                LinkedHashMap<PatchTarget, PatchActionResult> results = new LinkedHashMap<PatchTarget, PatchActionResult>();
                try {
                    boolean parallelEnabled = patchPlanTargets.isParallel(patchSession);
                    if (parallelEnabled && patchAction.isRemoteParallelExecutionSupported() && patchAction.isLocalParallelExecutionSupported()) {
                        results.putAll(PatchActionExecutor.executePatchActionIfRequired(patchPlanTargets.getPatchTargets(true, supportedProductTypes), patchAction, true));
                    } else {
                        boolean parallel;
                        Set<PatchTarget> localPatchTargets = patchPlanTargets.getLocalPatchTargets(true, supportedProductTypes);
                        Set<PatchTarget> remotePatchTargets = patchPlanTargets.getRemotePatchTargets(true, supportedProductTypes);
                        if (patchAction.isLocalTargetsToBeExecutedFirst()) {
                            if (localPatchTargets != null && !localPatchTargets.isEmpty()) {
                                parallel = parallelEnabled && patchAction.isLocalParallelExecutionSupported();
                                results.putAll(PatchActionExecutor.executePatchActionIfRequired(localPatchTargets, patchAction, parallel));
                            }
                            if (remotePatchTargets != null && !remotePatchTargets.isEmpty()) {
                                parallel = parallelEnabled && patchAction.isRemoteParallelExecutionSupported();
                                results.putAll(PatchActionExecutor.executePatchActionIfRequired(remotePatchTargets, patchAction, parallel));
                            }
                        } else {
                            if (remotePatchTargets != null && !remotePatchTargets.isEmpty()) {
                                parallel = parallelEnabled && patchAction.isRemoteParallelExecutionSupported();
                                results.putAll(PatchActionExecutor.executePatchActionIfRequired(remotePatchTargets, patchAction, parallel));
                            }
                            if (localPatchTargets != null && !localPatchTargets.isEmpty()) {
                                parallel = parallelEnabled && patchAction.isLocalParallelExecutionSupported();
                                results.putAll(PatchActionExecutor.executePatchActionIfRequired(localPatchTargets, patchAction, parallel));
                            }
                        }
                    }
                }
                catch (PatchActionException e) {
                    throw new OPatchAutoException("68066", (Throwable)e, patchAction.getClass().getName());
                }
                if (results.isEmpty()) continue;
                String failures = null;
                for (Map.Entry entry : results.entrySet()) {
                    PatchActionResult result = (PatchActionResult)entry.getValue();
                    if (result.isFailure()) {
                        Throwable e;
                        _logger.log(Level.SEVERE, "Failed to execute patch action [" + patchAction.getClass().getName() + "] on patch target [" + entry.getKey() + "].", result.getException());
                        failures = failures == null ? "" : "\n\n";
                        failures = failures + "Patch Target : " + entry.getKey();
                        String details = result.getDetails();
                        if (!StringUtil.isNullOrEmpty((String)details)) {
                            failures = failures + "\nDetails: " + details;
                        }
                        if ((e = result.getException()) == null) continue;
                        failures = failures + "\n" + StringUtil.getStackTrace((Throwable)e);
                        continue;
                    }
                    if (!result.isWarning()) continue;
                    _logger.log(Level.WARNING, "Execution completed with warnings for patch action [" + patchAction.getClass().getName() + "] on patch target [" + entry.getKey() + "] : " + result.getDetails(), result.getException());
                    Reporting.report((String)OPatchAutoHelper.getLocalizedString("PatchActionExecutor.execution.warnings", patchAction.getDisplayName(), entry.getKey(), result.getDetails()));
                }
                if (failures == null) continue;
                Reporting.report((String)(OPatchAutoHelper.getLocalizedString("PatchActionExecutor.execution.failed", patchAction.getDisplayName()) + "\n" + failures));
                throw new OPatchAutoException("68067", patchAction.getClass().getName() + "\n" + failures);
            }
        } else {
            _logger.info("There are no patch actions which require execution for [" + goal + "] phase:goal.");
        }
    }

    public static void executeSerializedPatchAction(String containerPath, ProductSupportManager productSupportManager, final ClassLoader pluginClassLoader) throws PatchActionException, OPatchAutoException {
        PatchActionExecutorContainer container;
        if (StringUtil.isNullOrEmpty((String)containerPath, (boolean)true)) {
            throw new PatchActionException("68068", new Object[0]);
        }
        File containerFile = new File(containerPath);
        if (!containerFile.exists() || !containerFile.isFile()) {
            throw new PatchActionException("68069", containerFile);
        }
        try {
            FileInputStream fis = new FileInputStream(containerFile);
            ObjectInputStream ois = new ObjectInputStream(fis){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (pluginClassLoader != null) {
                        String name = desc.getName();
                        try {
                            return Class.forName(name, false, pluginClassLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            return super.resolveClass(desc);
                        }
                    }
                    return super.resolveClass(desc);
                }
            };
            container = (PatchActionExecutorContainer)ois.readObject();
            ois.close();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new PatchActionException("68070", (Throwable)e, containerFile);
        }
        Map<PatchTarget, PatchActionResult> results = PatchActionExecutor.executePatchActionContainerLocally(container, productSupportManager);
        try {
            FileOutputStream fos = new FileOutputStream(container.getResults());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(new PatchActionResultsContainer(results));
            oos.close();
        }
        catch (IOException e) {
            throw new PatchActionException("68071", (Throwable)e, container.getResults());
        }
    }

    public static Map<PatchTarget, PatchActionResult> executePatchActionContainerLocally(PatchActionExecutorContainer container, ProductSupportManager productSupportManager) throws PatchActionException, OPatchAutoException {
        Goal goal = container.getGoal();
        if (goal == null) {
            throw new PatchActionException("68072", new Object[0]);
        }
        Set<PatchTarget> patchTargets = container.getPatchTargets();
        if (patchTargets == null || patchTargets.isEmpty()) {
            throw new PatchActionException("68073", new Object[0]);
        }
        String actionName = container.getActionName();
        if (StringUtil.isNullOrEmpty((String)actionName, (boolean)true)) {
            throw new PatchActionException("68074", new Object[0]);
        }
        boolean isRequired = container.isRequired();
        boolean parallel = container.isParallel();
        boolean analyze = container.isAnalyze();
        try {
            PatchSessionImpl patchSession = new PatchSessionImpl();
            patchSession.setOPatchAutoHome(new File(OPatchAutoHelper.getOPatchAutoHome()));
            patchSession.setPatchPlanManager(PatchPlanManager.createPatchPlanManager(productSupportManager, patchTargets.toArray(new PatchTarget[patchTargets.size()])));
            patchSession.setTopology(container.getTopology());
            patchSession.setParallelEnabled(parallel);
            patchSession.setAnalyze(analyze);
            patchSession.setCommand(container.getCommand());
            patchSession.setCurrentGoal(goal);
            patchSession.setOutOfPlaceEnabled(container.isOutOfPlacePatchingEnabled());
            patchSession.setApplyImageEnabled(container.isApplyImageEnabled());
            patchSession.setCreateImageEnabled(container.isCreateImageEnabled());
            patchSession.setProductSupportManager(productSupportManager);
            patchSession.setActionSession(true);
            PatchAction patchAction = productSupportManager.getPatchActionManager().getPatchAction(actionName);
            if (patchAction == null) {
                throw new PatchActionException("68075", actionName);
            }
            patchAction.setupRemoteActionExecutionEnvironment(patchSession, container);
            return PatchActionExecutor.executePatchAction(patchTargets, patchAction, parallel, isRequired, true);
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException("68076", (Throwable)e, actionName);
        }
    }

    private static Map<PatchTarget, PatchActionResult> executePatchActionIfRequired(Set<PatchTarget> patchTargets, PatchAction patchAction, boolean parallel) throws PatchActionException, OPatchAutoException {
        LinkedHashMap<PatchTarget, PatchActionResult> results = new LinkedHashMap<PatchTarget, PatchActionResult>();
        if (patchTargets != null && !patchTargets.isEmpty()) {
            LinkedHashSet<PatchTarget> updatedPatchTargets = new LinkedHashSet<PatchTarget>(patchTargets);
            PatchTracking patchTracking = patchAction.getPatchSession().getPatchTracking();
            if (patchTracking != null && patchTracking.isExistingSession()) {
                Goal currentGoal = patchAction.getPatchSession().getCurrentGoal();
                Iterator it = updatedPatchTargets.iterator();
                while (it.hasNext()) {
                    PatchTarget patchTarget = (PatchTarget)it.next();
                    PatchActionStatus previousStatus = patchTracking.getPreviousActionExecutionStatus(patchAction, patchTarget, currentGoal);
                    if (!previousStatus.isSuccess() && !previousStatus.isWarning() && !previousStatus.isSkipped()) continue;
                    _logger.info("Skipping " + currentGoal + " execution of action " + patchAction + " on patch target " + patchTarget + " due to previous session status of " + (Object)((Object)previousStatus));
                    results.put(patchTarget, new PatchActionResult(previousStatus));
                    it.remove();
                }
            }
            Map<PatchTarget, PatchActionResult> isRequiredResults = PatchActionExecutor.executePatchAction(updatedPatchTargets, patchAction, parallel, true);
            LinkedHashSet<PatchTarget> requiringExecution = new LinkedHashSet<PatchTarget>();
            for (PatchTarget patchTarget : updatedPatchTargets) {
                PatchActionResult result = isRequiredResults.get(patchTarget);
                if (result == null) {
                    PatchTracking.updateAction(patchAction, patchTarget, PatchActionStatus.failure);
                    throw new PatchActionException("68077", patchAction.getClass().getName(), patchTarget);
                }
                if (result.isSuccess()) {
                    if (result.isWarning()) {
                        _logger.warning("The is required check for patch action [" + patchAction + "] and target [" + patchTarget + "] completed with warning : " + result.getDetails());
                    }
                    requiringExecution.add(patchTarget);
                    continue;
                }
                if (result.hasException()) {
                    PatchTracking.updateAction(patchAction, patchTarget, PatchActionStatus.failure);
                    throw new PatchActionException("68078", result.getException(), patchAction, patchTarget);
                }
                PatchTracking.updateAction(patchAction, patchTarget, PatchActionStatus.skipped);
                _logger.info("No action required for patch action [" + patchAction.getClass().getName() + "] and patch target [" + patchTarget + "].");
            }
            if (!requiringExecution.isEmpty()) {
                _logger.info("Executing patch action [" + patchAction.getClass().getName() + "] for patch targets " + requiringExecution + ".");
                results.putAll(PatchActionExecutor.executePatchAction(requiringExecution, patchAction, parallel, false));
            }
        }
        return results;
    }

    private static Map<PatchTarget, PatchActionResult> executePatchAction(Set<PatchTarget> patchTargets, PatchAction patchAction, boolean parallel, boolean isRequiredCheck) throws PatchActionException, OPatchAutoException {
        return PatchActionExecutor.executePatchAction(patchTargets, patchAction, parallel, isRequiredCheck, false);
    }

    private static Map<PatchTarget, PatchActionResult> executePatchAction(Set<PatchTarget> patchTargets, PatchAction patchAction, boolean parallel, boolean isRequiredCheck, boolean forceLocalExecution) throws PatchActionException, OPatchAutoException {
        LinkedHashMap<PatchTarget, PatchActionResult> results = new LinkedHashMap<PatchTarget, PatchActionResult>();
        if (patchTargets != null && !patchTargets.isEmpty()) {
            if (isRequiredCheck && !patchAction.isActionRequiredNeeded()) {
                for (PatchTarget patchTarget : patchTargets) {
                    results.put(patchTarget, new PatchActionResult());
                }
                return results;
            }
            ArrayList<PatchActionRunner> runners = new ArrayList<PatchActionRunner>();
            LinkedHashMap<Host, LinkedHashSet<PatchTarget>> remoteHostToPatchTargets = new LinkedHashMap<Host, LinkedHashSet<PatchTarget>>();
            for (PatchTarget patchTarget : patchTargets) {
                if (forceLocalExecution || !patchTarget.isRemote() || patchAction.isRemoteExecutionHandled(patchTarget) || isRequiredCheck && patchAction.isActionRequiredLocalOnly()) {
                    runners.add(new LocalPatchActionRunner(PatchActionExecutor.getClonedPatchAction(patchAction), patchTarget, isRequiredCheck));
                    continue;
                }
                LinkedHashSet<PatchTarget> remotePatchTargets = (LinkedHashSet<PatchTarget>)remoteHostToPatchTargets.get(patchTarget.getHost());
                if (remotePatchTargets == null) {
                    remotePatchTargets = new LinkedHashSet<PatchTarget>();
                    remoteHostToPatchTargets.put(patchTarget.getHost(), remotePatchTargets);
                }
                remotePatchTargets.add(patchTarget);
            }
            for (Map.Entry entry : remoteHostToPatchTargets.entrySet()) {
                runners.add(new RemotePatchActionRunner(PatchActionExecutor.getClonedPatchAction(patchAction), (Set)entry.getValue(), (Host)entry.getKey(), isRequiredCheck, parallel));
            }
            LinkedHashMap<PatchActionRunner, Thread> threads = new LinkedHashMap<PatchActionRunner, Thread>();
            for (PatchActionRunner runner : runners) {
                Thread thread = new Thread(runner);
                threads.put(runner, thread);
            }
            if (parallel) {
                for (Thread thread : threads.values()) {
                    thread.start();
                }
                for (Thread thread : threads.values()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {}
                }
            } else {
                for (Thread thread : threads.values()) {
                    thread.start();
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {}
                }
            }
            for (PatchActionRunner runner : runners) {
                results.putAll(runner.getPatchActionResults());
            }
        }
        return results;
    }

    private static PatchAction getClonedPatchAction(PatchAction patchAction) throws PatchActionException {
        try {
            return patchAction.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new PatchActionException("68079", (Throwable)e, patchAction.getClass().getName());
        }
    }
}

