/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.product;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.util.Set;

public class ProductTypeImpl
implements ProductType {
    private String _type;
    private SupportType _supportType;
    private Set<String> _markerFiles;
    private boolean _anyMarkerFile;

    public ProductTypeImpl(String type, SupportType supportType, Set<String> markerFiles) {
        this(type, supportType, markerFiles, false);
    }

    public ProductTypeImpl(String type, SupportType supportType, Set<String> markerFiles, boolean anyMarkerFile) {
        if (StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
            throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68097", new Object[0]));
        }
        if (supportType == null) {
            throw new IllegalArgumentException(OPatchAutoHelper.getPublishedMessage("68098", new Object[0]));
        }
        this._type = type;
        this._supportType = supportType;
        this._markerFiles = markerFiles;
        this._anyMarkerFile = anyMarkerFile;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public SupportType getSupportType() {
        return this._supportType;
    }

    public Set<String> getMarkerFilePaths() {
        return this._markerFiles;
    }

    @Override
    public boolean isSupportedHome(Home home) throws OPatchAutoException {
        if (home == null) {
            throw new OPatchAutoException("68099", new Object[0]);
        }
        return OPatchAutoHelper.pathsExist(home.getLocation(), this.getMarkerFilePaths(), home.getHost(), this._anyMarkerFile, OPatchAutoHelper.getLocalizedString("ProductTypeImpl.home", new Object[0]));
    }

    @Override
    public boolean isSupportedInstance(Instance instance) throws OPatchAutoException {
        if (instance == null) {
            throw new OPatchAutoException("68100", new Object[0]);
        }
        return OPatchAutoHelper.pathsExist(instance.getLocation(), this.getMarkerFilePaths(), instance.getHost(), this._anyMarkerFile, OPatchAutoHelper.getLocalizedString("ProductTypeImpl.instance", new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProductTypeImpl)) {
            return false;
        }
        ProductTypeImpl that = (ProductTypeImpl)o;
        if (this._supportType != that._supportType) {
            return false;
        }
        return this._type.equals(that._type);
    }

    public int hashCode() {
        int result = this._type.hashCode();
        result = 31 * result + this._supportType.hashCode();
        return result;
    }

    public String toString() {
        return this._type + " [" + (Object)((Object)this._supportType) + "]";
    }
}

