/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.wizard.silent.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.plan.PatchPlanCustomizer;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.plan.PatchPlanManager;
import com.oracle.glcm.patch.auto.plan.PatchPlanTargets;
import com.oracle.glcm.patch.auto.product.ProductSupport;
import com.oracle.glcm.patch.auto.session.PatchSession;
import java.util.logging.Level;

@TaskDescription(name="patch-plan-targets")
public class PatchPlanTargetsTask
extends AbstractSilentTask {
    private String _sessionKey = "patch.session";
    private String _types;
    private boolean _incremental;
    private String _incrementType;
    private String _cacheKey;
    private String _loopKey;
    private String _parentKey;
    private boolean _currentParentContainer = false;
    private boolean _reset;
    private boolean _excludeDefault = false;
    private String _parallel;
    private boolean _consolidateShardHomes = false;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setSessionKey(String sessionKey) {
        this._sessionKey = sessionKey;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setTypes(String types) {
        this._types = types;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false)
    public void setIncremental(String incremental) {
        this._incremental = Boolean.valueOf(incremental);
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setParallel(String parallel) {
        this._parallel = parallel;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setCacheKey(String cacheKey) {
        this._cacheKey = cacheKey;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setLoopKey(String loopKey) {
        this._loopKey = loopKey;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setParentKey(String parentKey) {
        this._parentKey = parentKey;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false)
    public void setCurrentParentContainer(String currentParentContainer) {
        this._currentParentContainer = Boolean.valueOf(currentParentContainer);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false)
    public void setReset(String reset) {
        this._reset = Boolean.valueOf(reset);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false)
    public void setExcludeDefault(String excludeDefault) {
        this._excludeDefault = Boolean.valueOf(excludeDefault);
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=false)
    public void setIncrementType(String incrementType) {
        this._incrementType = incrementType;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false)
    public void setConsolidateSharedHomes(String consolidateSharedHomes) {
        this._consolidateShardHomes = Boolean.valueOf(consolidateSharedHomes);
    }

    public void execute() throws TaskExecutionException {
        String sessionKey = this._context.substitute(this._namespace, this._sessionKey);
        if (StringUtil.isNullOrEmpty((String)sessionKey, (boolean)true)) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68129", this._sessionKey));
        }
        Object o = this._context.retrieveObject(this._namespace, (Object)sessionKey);
        if (o == null || !(o instanceof PatchSession)) {
            throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68130", this._sessionKey));
        }
        PatchSession patchSession = (PatchSession)o;
        if (!StringUtil.isNullOrEmpty((String)this._cacheKey, (boolean)true)) {
            this._cacheKey = this._context.substitute(this._namespace, this._cacheKey);
        }
        if (!StringUtil.isNullOrEmpty((String)this._parentKey, (boolean)true)) {
            this._parentKey = this._context.substitute(this._namespace, this._parentKey);
        }
        PatchPlanManager manager = patchSession.getPatchPlanManager();
        String cacheKey = this.getCacheKey(this._types, this._excludeDefault, this._parentKey, this._currentParentContainer, this._cacheKey);
        if (this._reset) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Resetting patch plan targets at cache key \"" + cacheKey + "\"");
            }
            manager.resetPatchPlanTargets(cacheKey);
        } else if (manager.hasPatchPlanTargets(cacheKey)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Setting current patch plan targets to existing cache key \"" + cacheKey + "\"");
            }
            manager.setCurrentPatchPlanTargetsTypes(cacheKey, this._consolidateShardHomes);
        } else {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Creating current patch plan targets at cache key \"" + cacheKey + "\" with types " + this._types + " (excludeDefault=" + this._excludeDefault + ") and based on parent container at key \"" + this._parentKey + "\"");
            }
            manager.setCurrentPatchPlanTargetsTypes(this._types, this._excludeDefault, cacheKey, this._parentKey, this._consolidateShardHomes, this._currentParentContainer);
            PatchPlanTargets patchPlanTargets = manager.getCurrentPatchPlanTargets();
            if (this._parallel != null) {
                String parallel = this._parallel.trim();
                if ("true".equalsIgnoreCase(parallel)) {
                    patchPlanTargets.setParallel(true);
                } else if ("false".equalsIgnoreCase(parallel)) {
                    patchPlanTargets.setParallel(false);
                } else {
                    String[] split = parallel.split(":");
                    if (split.length != 2) {
                        throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68131", this._parallel));
                    }
                    ProductSupport productSupport = patchSession.getProductSupportManager().getProductSupport(split[0].trim());
                    PatchPlanCustomizer customizer = productSupport.getPatchPlanCustomizer(split[1].trim());
                    if (customizer == null) {
                        throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68132", this._parallel));
                    }
                    patchPlanTargets.setParallel(customizer.isParallelEnabled(patchPlanTargets));
                }
            }
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("Created patch plan targets at cache key \"" + cacheKey + "\" : " + patchPlanTargets);
            }
            if (this._incremental) {
                String loopKey;
                patchPlanTargets.setIncremental(true);
                if (!StringUtil.isNullOrEmpty((String)this._incrementType, (boolean)true)) {
                    String incrementType;
                    ProductSupport productSupport;
                    if (this._incrementType.contains(":")) {
                        String[] split = this._incrementType.split(":");
                        productSupport = patchSession.getProductSupportManager().getProductSupport(split[0].trim());
                        incrementType = split[1];
                    } else {
                        productSupport = patchSession.getProductSupportManager().getDefaultProductSupport();
                        incrementType = this._incrementType;
                    }
                    PatchPlanIncrementType patchPlanIncrementType = productSupport.getPatchPlanIncrementType(incrementType.trim());
                    if (patchPlanIncrementType == null) {
                        throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68133", this._incrementType));
                    }
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.finer("Setting patch plan increment type to " + this._incrementType);
                    }
                    patchPlanTargets.setIncrementType(patchPlanIncrementType);
                }
                String string = loopKey = StringUtil.isNullOrEmpty((String)this._loopKey, (boolean)true) ? cacheKey : this._loopKey;
                if (StringUtil.isNullOrEmpty((String)loopKey, (boolean)true)) {
                    throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68134", new Object[0]));
                }
                try {
                    this._context.storeObject(this._namespace, (Object)loopKey, patchPlanTargets.getIncrementalSet());
                }
                catch (OPatchAutoException e) {
                    throw new TaskExecutionException((Task)this, OPatchAutoHelper.getPublishedMessage("68135", this._types), (Throwable)e);
                }
            }
        }
    }

    private String getCacheKey(String types, boolean excludeDefault, String parentKey, boolean currentParentContainer, String cacheKey) {
        if (StringUtil.isNullOrEmpty((String)cacheKey, (boolean)true)) {
            if (types == null) {
                types = "";
            }
            cacheKey = PatchPlanTargets.class.getSimpleName() + ":" + types + ":" + excludeDefault + ":" + parentKey + ":" + currentParentContainer;
        }
        return cacheKey;
    }

    public void unconfigure() {
        this._sessionKey = null;
        this._types = null;
        this._incremental = false;
        this._loopKey = null;
    }
}

