/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xml;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import oracle.security.xml.Token;
import oracle.security.xml.saml20.bindings.ObjectFactory;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSXUtils {
    private static final JAXBContext jc;
    private static final JAXBIntrospector ji;
    private static NamespacePrefixMapper prefixMapper;
    private static String INDENT;
    private static String NL;
    private static Method M_XDKPRINT;

    public static JAXBContext getJAXBContext() {
        return jc;
    }

    public static JAXBIntrospector getJAXBIntrospector() {
        return ji;
    }

    public static NamespacePrefixMapper getNamespacePrefixMapper() {
        return prefixMapper;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        Marshaller m = WSSXUtils.getJAXBContext().createMarshaller();
        try {
            m.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)Boolean.FALSE);
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)prefixMapper);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return m;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller um = WSSXUtils.getJAXBContext().createUnmarshaller();
        return um;
    }

    public static QName getElementName(Token tok) {
        return WSSXUtils.getJAXBIntrospector().getElementName((Object)tok);
    }

    public static Element toElement(Token tok) {
        Document doc = XMLUtils.createDocument();
        DocumentFragment frag = doc.createDocumentFragment();
        try {
            WSSXUtils.createMarshaller().marshal((Object)tok, (Node)frag);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        return (Element)frag.getFirstChild();
    }

    public static XMLElement toXMLElement(Token tok) {
        return XMLUtils.getInstance((Element)WSSXUtils.toElement(tok));
    }

    private static Object getPropertyValue(Object bean, String propName, Class type) {
        try {
            String methodName = type == Boolean.class ? "is" + propName.substring(0, 1).toUpperCase() + propName.substring(1) : "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Method m = bean.getClass().getMethod(methodName, new Class[0]);
            return m.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            return new String(ex.toString());
        }
    }

    private static void dumpElement(Element element, StringBuilder sb) {
        if (element.getClass().getName().contains("oracle.xml.parser")) {
            try {
                if (M_XDKPRINT == null) {
                    M_XDKPRINT = element.getClass().getMethod("print", Writer.class);
                }
                StringWriter sw = new StringWriter();
                M_XDKPRINT.invoke((Object)element, sw);
                sb.append(sw.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else {
            sb.append(element.toString());
        }
        sb.append(NL);
    }

    private static void dumpValue(String indent, Object value, StringBuilder sb) {
        if (value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Enum) {
            sb.append(value.toString() + NL);
        } else if (value instanceof byte[]) {
            sb.append(Base64.toBase64((byte[])((byte[])value), (boolean)false) + NL);
        } else if (value instanceof Date) {
            DateFormat dformat = DateFormat.getDateTimeInstance();
            dformat.setTimeZone(TimeZone.getTimeZone("UTC"));
            sb.append(dformat.format((Date)value) + NL);
        } else if (value instanceof Element) {
            WSSXUtils.dumpElement((Element)value, sb);
        } else if (value instanceof List) {
            int i = 1;
            sb.append("List[" + ((List)value).size() + "]" + NL);
            for (Object v : (List)value) {
                sb.append(indent + i + ": ");
                WSSXUtils.dumpValue(indent + INDENT, v, sb);
                ++i;
            }
        } else if (value instanceof Map) {
            sb.append("Map[" + ((Map)value).size() + "]" + NL);
            for (Object key : ((Map)value).keySet()) {
                sb.append(indent + key + " -> ");
                WSSXUtils.dumpValue(indent + INDENT, ((Map)value).get(key), sb);
            }
        } else {
            sb.append(NL);
            WSSXUtils.dump(indent, value, sb);
        }
    }

    private static void dump(String indent, Object bean, StringBuilder sb) {
        PropertyDescriptor[] properties;
        BeanInfo bi;
        if (bean instanceof JAXBElement) {
            bean = ((JAXBElement)bean).getValue();
        }
        try {
            bi = Introspector.getBeanInfo(bean.getClass(), Object.class);
        }
        catch (IntrospectionException e) {
            return;
        }
        for (PropertyDescriptor prop : properties = bi.getPropertyDescriptors()) {
            Object value;
            String name = prop.getName();
            if (name.equals("requestType")) {
                System.out.println("requestType");
            }
            if ((value = WSSXUtils.getPropertyValue(bean, name, prop.getPropertyType())) == null || value instanceof Map && ((Map)value).size() == 0 || value instanceof Collection && ((Collection)value).size() == 0) continue;
            sb.append(indent + name + " : ");
            WSSXUtils.dumpValue(indent + "    ", value, sb);
        }
    }

    public static String debugPrint(Object jaxbObject) {
        StringBuilder sb = new StringBuilder();
        WSSXUtils.dump("", jaxbObject, sb);
        return sb.toString();
    }

    static {
        JAXBContext jc1 = null;
        try {
            jc1 = JAXBContext.newInstance((String)"oracle.security.xml.ws.trust.wssx.bindings");
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        jc = jc1;
        ji = jc1.createJAXBIntrospector();
        prefixMapper = new MyNamespacePrefixMapper();
        INDENT = "    ";
        NL = System.getProperty("line.separator");
    }

    private static class MyNamespacePrefixMapper
    extends NamespacePrefixMapper {
        final HashMap<String, String> prefixes = new HashMap();

        public MyNamespacePrefixMapper() {
            XmlSchema sch = oracle.security.xml.dsig.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "dsig");
            sch = oracle.security.xml.xenc.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "xenc");
            sch = oracle.security.xml.ws.wsu10.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsu");
            sch = oracle.security.xml.ws.secext10.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsse");
            sch = oracle.security.xml.ws.secext11.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsse11");
            sch = oracle.security.xml.ws.addressing.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsa");
            sch = oracle.security.xml.ws.policy.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsp");
            sch = oracle.security.xml.ws.trust.wssx.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wst");
            sch = oracle.security.xml.ws.secconv.wssx.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "wsc");
            sch = oracle.security.xml.saml11.bindings.ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "saml");
            sch = ObjectFactory.class.getPackage().getAnnotation(XmlSchema.class);
            this.prefixes.put(sch.namespace(), "saml2");
        }

        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            return this.prefixes.get(namespaceUri);
        }
    }
}

