/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias.patch;

import java.util.Set;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.patch.MaintenanceAliasRec;

public class MaintenanceAliasRecImpl
implements MaintenanceAliasRec {
    String maintenanceAliasKey;
    Set<String> patchUpis;

    private MaintenanceAliasRecImpl(Builder builder) throws MaintenanceAliasException {
        String maintenanceAliasKey = builder.maintenanceAliasKey;
        if (maintenanceAliasKey == null || maintenanceAliasKey.isEmpty()) {
            throw new MaintenanceAliasException("Can not convert an invalid value to maintenance alias key");
        }
        this.maintenanceAliasKey = maintenanceAliasKey;
        this.patchUpis = builder.patchUpis;
    }

    public String getMaintenanceAliasKey() {
        return this.maintenanceAliasKey;
    }

    public Set<String> getPatchUpis() {
        return this.patchUpis;
    }

    public boolean addPatchUpi(String patchUpi) {
        return this.patchUpis.add(patchUpi);
    }

    public boolean delPatchUpi(String patchUpi) {
        return this.patchUpis.remove(patchUpi);
    }

    public int hashCode() {
        return this.maintenanceAliasKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MaintenanceAliasRec) {
            MaintenanceAliasRec maintenanceAlias = (MaintenanceAliasRec)obj;
            return this.maintenanceAliasKey.equals(maintenanceAlias.getMaintenanceAliasKey());
        }
        return false;
    }

    public static class Builder
    implements MaintenanceAliasRec.Builder {
        String maintenanceAliasKey;
        Set<String> patchUpis;

        public Builder(String maintenanceAliasKey) {
            this.maintenanceAliasKey = maintenanceAliasKey;
        }

        public MaintenanceAliasRec.Builder setPatchUpis(Set<String> patchUpis) {
            this.patchUpis = patchUpis;
            return this;
        }

        public MaintenanceAliasRec build() throws MaintenanceAliasException {
            return new MaintenanceAliasRecImpl(this);
        }
    }
}

