/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchActions;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchActionsImpl;
import oracle.glcm.opatch.common.impl.dao.PositionalXMLReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchActionDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static String ONEOFF_ACTIONS = "oneoff_actions";
    private static String NAME = "name";
    private static String VERSION = "version";
    private static String OPT_REQ = "opt_req";
    private static String SYMBOL = "symbol";
    private static String PATCH_LEVEL = "patch_level";
    private static String ARCHIVE = "archive";
    private static String PATH = "path";
    private static String FILE_NAME = "file_name";
    private static String OBJECT_NAME = "object_name";
    private static String JAR = "jar";
    private static String CLASS_NAME = "class_name";
    private static String COPY = "copy";
    private static String UNZIP = "unzip";
    private static String UPDATE_TIMESTAMP = "update_timestamp";
    private static String FILE_VERSION = "file_version";
    private static String DIAGNOSTIC_STRING = "diagnostic_string";
    private static String RETAIN_PERMISSION = "retain_permission";
    private static String APP_DIR = "app_dir";
    private static String MODE = "mode";
    private static String DELETE = "delete";
    private static String ONE_WAY = "is_oneway";
    private static String DIRECTORY = "is_directory";
    private static String BACKUP_IN_ZIP = "backup_in_zip";
    private static String MAKE = "make";
    private static String CHANGE_DIR = "change_dir";
    private static String MAKE_FILE = "make_file";
    private static String MAKE_TARGET = "make_target";
    private static String ONEWAYCOPY = "onewaycopy";
    private static String SQL = "sql";
    private static String FILE_PATH = "file_path";
    private static String APPLY = "apply";
    private static String ROLLBACK = "rollback";
    private static String SQLPROC = "sqlproc";
    private static String PROC_TOUCHED_LIST = "proc_touched_list";
    private static String PORTAL = "portal";
    private static String PATCH_NAME = "patch_name";
    private static String HOTPATCH = "hotpatch";
    private static String MODIFIED_FUNCTION = "modified_function";
    private static String FILENAME = "filename";
    private static String MKPATCH_PARAM = "mkpatch_param";
    private static String SHAOLUE = "shaolue";
    private static String STRINGSUBS = "stringsubs";
    private static String CONFIGURE = "configure";
    private static String SCHEMA = "schema";
    private Document doc = null;

    public PatchActionDAO(String actionLoc) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchActionDAO constructor...");
        try {
            Path fXmlFile = NioServiceFactory.getNioService().getPath(actionLoc, new String[0]);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            try (InputStream inputStream = Files.newInputStream(fXmlFile, new OpenOption[0]);){
                this.doc = dBuilder.parse(inputStream);
            }
            this.doc.getDocumentElement().normalize();
            DOMSource domSource = new DOMSource(this.doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            ByteArrayInputStream is = new ByteArrayInputStream(writer.toString().getBytes());
            this.doc = PositionalXMLReader.readXML(is);
            ((InputStream)is).close();
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for action.xml", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read action.xml file", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse action.xml file", (Throwable)se);
        }
        catch (TransformerException te) {
            throw new PatchMetadataLoadingException("Failed to transformation", (Throwable)te);
        }
        this.logger.info("Finished PatchActionDAO creation.");
    }

    public void save(String xmlFile) throws PatchMetadataWritingException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(xmlFile, new String[0]), new OpenOption[0]);){
                transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
            }
        }
        catch (TransformerException te) {
            throw new PatchMetadataWritingException("Failed transformation while writing out actions.xml file " + xmlFile, (Throwable)te);
        }
        catch (IOException fnfe) {
            throw new PatchMetadataWritingException("Failed to write to file actions.xml file " + xmlFile, (Throwable)fnfe);
        }
    }

    public void saveToDir(String destinationPatchLoc) throws PatchMetadataWritingException {
        Path dir = NioServiceFactory.getNioService().getPath(destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PatchMetadataWritingException("Cannot create directory " + dir + " for cloning action.xml data", (Throwable)e);
            }
        }
        if (!Files.exists(dir, new LinkOption[0]) || Files.isRegularFile(dir, new LinkOption[0])) {
            throw new PatchMetadataWritingException("Cannot create directory " + destinationPatchLoc + Constants.PATH + Constants.PATCH_CONFIG_DIR + " for cloning action.xml data");
        }
        String inventoryFile = destinationPatchLoc + Constants.PATH + Constants.ACTIONS_XML;
        this.save(inventoryFile);
    }

    public List<PatchActions.Component> getComponents() {
        ArrayList<PatchActions.Component> result = new ArrayList<PatchActions.Component>();
        NodeList topList = this.doc.getElementsByTagName(ONEOFF_ACTIONS);
        Element topElem = (Element)topList.item(0);
        NodeList nList = topElem.getChildNodes();
        PatchActionsImpl ai = new PatchActionsImpl();
        for (int i = 0; i < nList.getLength(); ++i) {
            String backup_in_zip;
            String patchLevel;
            if (nList.item(i).getNodeType() != 1) continue;
            PatchActionsImpl.ComponentImpl ci = ai.new PatchActionsImpl.ComponentImpl();
            Element elem = (Element)nList.item(i);
            ci.setName(elem.getTagName());
            ci.setVersion(elem.getAttribute(VERSION));
            ci.setOptString(elem.getAttribute(OPT_REQ));
            String symbol = elem.getAttribute(SYMBOL);
            if (symbol != null) {
                ci.setSymbol(symbol);
            }
            if ((patchLevel = elem.getAttribute(PATCH_LEVEL)) != null) {
                ci.setPatchLevel(patchLevel);
            }
            ArrayList<PatchActions.Component.Archive> archiveList = new ArrayList<PatchActions.Component.Archive>();
            NodeList archives = elem.getElementsByTagName(ARCHIVE);
            for (int j = 0; j < archives.getLength(); ++j) {
                Element archive = (Element)archives.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.ArchiveImpl archiveImpl = componentImpl.new PatchActionsImpl.ComponentImpl.ArchiveImpl(archive.getAttribute(NAME), archive.getAttribute(PATH), archive.getAttribute(OBJECT_NAME), archive.getAttribute(SHAOLUE));
                archiveImpl.setOrder(Double.parseDouble(archive.getUserData("lineNumber").toString()));
                String backup_in_zip2 = archive.getAttribute(BACKUP_IN_ZIP);
                if (backup_in_zip2 != null && !backup_in_zip2.equals("")) {
                    archiveImpl.setBackupInZipFlag(new Boolean(backup_in_zip2));
                }
                archiveList.add(archiveImpl);
            }
            ci.setArchives(archiveList);
            ArrayList<PatchActions.Component.Copy> copyList = new ArrayList<PatchActions.Component.Copy>();
            NodeList copies = elem.getElementsByTagName(COPY);
            for (int j = 0; j < copies.getLength(); ++j) {
                String mode;
                String appDir;
                String retainPermisson;
                String updateTimeStamp;
                String diagString;
                Element copy = (Element)copies.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.CopyImpl copyImpl = componentImpl.new PatchActionsImpl.ComponentImpl.CopyImpl(copy.getAttribute(NAME), copy.getAttribute(PATH), copy.getAttribute(FILE_NAME), copy.getAttribute(SHAOLUE));
                copyImpl.setOrder(Double.parseDouble(copy.getUserData("lineNumber").toString()));
                String fileVersion = copy.getAttribute(FILE_VERSION);
                if (fileVersion != null && !fileVersion.equals("")) {
                    copyImpl.setFileVersion(fileVersion);
                }
                if ((diagString = copy.getAttribute(DIAGNOSTIC_STRING)) != null && !diagString.equals("")) {
                    copyImpl.setDiagnosticString(diagString);
                }
                if ((updateTimeStamp = copy.getAttribute(UPDATE_TIMESTAMP)) != null && !updateTimeStamp.equals("")) {
                    copyImpl.setUpdateTimeStamp(new Boolean(updateTimeStamp));
                }
                if ((retainPermisson = copy.getAttribute(RETAIN_PERMISSION)) != null && !retainPermisson.equals("")) {
                    copyImpl.setRetainPermission(new Boolean(retainPermisson));
                }
                if ((appDir = copy.getAttribute(APP_DIR)) != null && !appDir.equals("")) {
                    copyImpl.setAppDir(appDir);
                }
                if ((mode = copy.getAttribute(MODE)) != null && !mode.equals("")) {
                    copyImpl.setMode(mode);
                }
                if ((backup_in_zip = copy.getAttribute(BACKUP_IN_ZIP)) != null && !backup_in_zip.equals("")) {
                    copyImpl.setBackupInZipFlag(new Boolean(backup_in_zip));
                }
                copyList.add(copyImpl);
            }
            ci.setCopies(copyList);
            ArrayList<PatchActions.Component.Unzip> unzipList = new ArrayList<PatchActions.Component.Unzip>();
            NodeList unzips = elem.getElementsByTagName(UNZIP);
            for (int j = 0; j < unzips.getLength(); ++j) {
                String backup_in_zip3;
                String retainPermisson;
                String updateTimeStamp;
                Element unzip = (Element)unzips.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.UnzipImpl unzipImpl = componentImpl.new PatchActionsImpl.ComponentImpl.UnzipImpl(unzip.getAttribute(NAME), unzip.getAttribute(PATH), unzip.getAttribute(FILE_NAME), unzip.getAttribute(SHAOLUE));
                unzipImpl.setOrder(Double.parseDouble(unzip.getUserData("lineNumber").toString()));
                String fileVersion = unzip.getAttribute(FILE_VERSION);
                if (fileVersion != null && !fileVersion.equals("")) {
                    unzipImpl.setFileVersion(fileVersion);
                }
                if ((updateTimeStamp = unzip.getAttribute(UPDATE_TIMESTAMP)) != null && !updateTimeStamp.equals("")) {
                    unzipImpl.setUpdateTimeStamp(new Boolean(updateTimeStamp));
                }
                if ((retainPermisson = unzip.getAttribute(RETAIN_PERMISSION)) != null && !retainPermisson.equals("")) {
                    unzipImpl.setRetainPermission(new Boolean(retainPermisson));
                }
                if ((backup_in_zip3 = unzip.getAttribute(BACKUP_IN_ZIP)) != null && !backup_in_zip3.equals("")) {
                    unzipImpl.setBackupInZipFlag(new Boolean(backup_in_zip3));
                }
                unzipList.add(unzipImpl);
            }
            ci.setUnzips(unzipList);
            ArrayList<PatchActions.Component.Delete> deleteList = new ArrayList<PatchActions.Component.Delete>();
            NodeList deletes = elem.getElementsByTagName(DELETE);
            for (int j = 0; j < deletes.getLength(); ++j) {
                String backup_in_zip4;
                String directory;
                String oneWay;
                String Opt_req;
                Element delete = (Element)deletes.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.DeleteImpl deleteImpl = componentImpl.new PatchActionsImpl.ComponentImpl.DeleteImpl(delete.getAttribute(NAME), delete.getAttribute(PATH));
                deleteImpl.setOrder(Double.parseDouble(delete.getUserData("lineNumber").toString()));
                String fileVersion = delete.getAttribute(FILE_VERSION);
                if (fileVersion != null && !fileVersion.equals("")) {
                    deleteImpl.setFileVersion(fileVersion);
                }
                if ((Opt_req = delete.getAttribute(OPT_REQ)) != null && !Opt_req.equals("")) {
                    deleteImpl.setOpt_Req(Opt_req);
                }
                if ((oneWay = delete.getAttribute(ONE_WAY)) != null && !oneWay.equals("")) {
                    deleteImpl.setOneWayFlag(new Boolean(oneWay));
                }
                if ((directory = delete.getAttribute(DIRECTORY)) != null && !directory.equals("")) {
                    deleteImpl.setDirFlag(new Boolean(directory));
                }
                if ((backup_in_zip4 = delete.getAttribute(BACKUP_IN_ZIP)) != null && !backup_in_zip4.equals("")) {
                    deleteImpl.setBackupInZipFlag(new Boolean(backup_in_zip4));
                }
                deleteList.add(deleteImpl);
            }
            ci.setDeletes(deleteList);
            ArrayList<PatchActions.Component.Jar> jarList = new ArrayList<PatchActions.Component.Jar>();
            NodeList jars = elem.getElementsByTagName(JAR);
            for (int j = 0; j < jars.getLength(); ++j) {
                Element jar = (Element)jars.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.JarImpl jarImpl = componentImpl.new PatchActionsImpl.ComponentImpl.JarImpl(jar.getAttribute(NAME), jar.getAttribute(PATH), jar.getAttribute(CLASS_NAME), jar.getAttribute(SHAOLUE));
                jarImpl.setOrder(Double.parseDouble(jar.getUserData("lineNumber").toString()));
                backup_in_zip = jar.getAttribute(BACKUP_IN_ZIP);
                if (backup_in_zip != null && !backup_in_zip.equals("")) {
                    jarImpl.setBackupInZipFlag(new Boolean(backup_in_zip));
                }
                jarList.add(jarImpl);
            }
            ci.setJars(jarList);
            ArrayList<PatchActions.Component.Make> makeList = new ArrayList<PatchActions.Component.Make>();
            NodeList makes = elem.getElementsByTagName(MAKE);
            for (int j = 0; j < makes.getLength(); ++j) {
                Element make = (Element)makes.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.MakeImpl makeImpl = componentImpl.new PatchActionsImpl.ComponentImpl.MakeImpl(make.getAttribute(CHANGE_DIR), make.getAttribute(MAKE_FILE), make.getAttribute(MAKE_TARGET));
                makeImpl.setOrder(Double.parseDouble(make.getUserData("lineNumber").toString()));
                makeList.add(makeImpl);
            }
            ci.setMakes(makeList);
            ArrayList<PatchActions.Component.Copy> onewaycopyList = new ArrayList<PatchActions.Component.Copy>();
            NodeList onewaycopys = elem.getElementsByTagName(ONEWAYCOPY);
            for (int j = 0; j < onewaycopys.getLength(); ++j) {
                String backup_in_zip5;
                Element onewaycopy = (Element)onewaycopys.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.CopyImpl onewaycopyImpl = componentImpl.new PatchActionsImpl.ComponentImpl.CopyImpl(onewaycopy.getAttribute(NAME), onewaycopy.getAttribute(PATH), onewaycopy.getAttribute(FILE_NAME), onewaycopy.getAttribute(SHAOLUE));
                onewaycopyImpl.setOrder(Double.parseDouble(onewaycopy.getUserData("lineNumber").toString()));
                String mode = onewaycopy.getAttribute(MODE);
                if (mode != null && !mode.equals("")) {
                    onewaycopyImpl.setMode(mode);
                }
                if ((backup_in_zip5 = onewaycopy.getAttribute(BACKUP_IN_ZIP)) != null && !backup_in_zip5.equals("")) {
                    onewaycopyImpl.setBackupInZipFlag(new Boolean(backup_in_zip5));
                }
                onewaycopyList.add(onewaycopyImpl);
            }
            ci.setOneWayCopies(onewaycopyList);
            ArrayList<PatchActions.Component.Sql> sqlList = new ArrayList<PatchActions.Component.Sql>();
            NodeList sqls = elem.getElementsByTagName(SQL);
            for (int j = 0; j < sqls.getLength(); ++j) {
                Element sql = (Element)sqls.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.SqlImpl sqlImpl = componentImpl.new PatchActionsImpl.ComponentImpl.SqlImpl(sql.getAttribute(NAME), sql.getAttribute(FILE_PATH), new Boolean(sql.getAttribute(APPLY)), new Boolean(sql.getAttribute(ROLLBACK)));
                sqlImpl.setOrder(Double.parseDouble(sql.getUserData("lineNumber").toString()));
                String backup_in_zip6 = sql.getAttribute(BACKUP_IN_ZIP);
                if (backup_in_zip6 != null && !backup_in_zip6.equals("")) {
                    sqlImpl.setBackupInZipFlag(new Boolean(backup_in_zip6));
                }
                sqlList.add(sqlImpl);
            }
            ci.setSqls(sqlList);
            ArrayList<PatchActions.Component.Sqlproc> sqlprocList = new ArrayList<PatchActions.Component.Sqlproc>();
            NodeList sqlprocs = elem.getElementsByTagName(SQLPROC);
            for (int j = 0; j < sqlprocs.getLength(); ++j) {
                Element sqlproc = (Element)sqlprocs.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.SqlprocImpl sqlprocImpl = componentImpl.new PatchActionsImpl.ComponentImpl.SqlprocImpl(sqlproc.getAttribute(NAME), sqlproc.getAttribute(FILE_PATH), sqlproc.getAttribute(PROC_TOUCHED_LIST));
                sqlprocImpl.setOrder(Double.parseDouble(sqlproc.getUserData("lineNumber").toString()));
                String backup_in_zip7 = sqlproc.getAttribute(BACKUP_IN_ZIP);
                if (backup_in_zip7 != null && !backup_in_zip7.equals("")) {
                    sqlprocImpl.setBackupInZipFlag(new Boolean(backup_in_zip7));
                }
                sqlprocList.add(sqlprocImpl);
            }
            ci.setSqlprocs(sqlprocList);
            ArrayList<PatchActions.Component.Portal> portalList = new ArrayList<PatchActions.Component.Portal>();
            NodeList portals = elem.getElementsByTagName(PORTAL);
            for (int j = 0; j < portals.getLength(); ++j) {
                Element portal = (Element)portals.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.PortalImpl portalImpl = componentImpl.new PatchActionsImpl.ComponentImpl.PortalImpl(portal.getAttribute(PATCH_NAME));
                portalImpl.setOrder(Double.parseDouble(portal.getUserData("lineNumber").toString()));
                portalList.add(portalImpl);
            }
            ci.setPortals(portalList);
            ArrayList<PatchActions.Component.Hotpatch> hotpatchList = new ArrayList<PatchActions.Component.Hotpatch>();
            NodeList hotpatchs = elem.getElementsByTagName(HOTPATCH);
            for (int j = 0; j < hotpatchs.getLength(); ++j) {
                Element hotpatch = (Element)hotpatchs.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.HotpatchImpl hotpatchImpl = componentImpl.new PatchActionsImpl.ComponentImpl.HotpatchImpl(hotpatch.getAttribute(NAME), hotpatch.getAttribute(OBJECT_NAME), hotpatch.getAttribute(MODIFIED_FUNCTION), hotpatch.getAttribute(FILENAME), hotpatch.getAttribute(PATH), hotpatch.getAttribute(MKPATCH_PARAM));
                hotpatchList.add(hotpatchImpl);
            }
            ci.setHotpatchs(hotpatchList);
            ArrayList<PatchActions.Component.StringSubs> stringSubsList = new ArrayList<PatchActions.Component.StringSubs>();
            NodeList string_subs = elem.getElementsByTagName(STRINGSUBS);
            for (int j = 0; j < string_subs.getLength(); ++j) {
                Element stringsubs = (Element)string_subs.item(j);
                PatchActionsImpl.ComponentImpl componentImpl = ci;
                Objects.requireNonNull(componentImpl);
                PatchActionsImpl.ComponentImpl.StringSubsImpl stringsubsImpl = componentImpl.new PatchActionsImpl.ComponentImpl.StringSubsImpl(stringsubs.getAttribute(CONFIGURE), stringsubs.getAttribute(SCHEMA));
                stringSubsList.add(stringsubsImpl);
            }
            ci.setStringSubs(stringSubsList);
            result.add(ci);
        }
        return result;
    }
}

