/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.automation.Automation;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;
import org.xml.sax.SAXException;

public class PatchAutomationDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<Automation> AutomationClass = Automation.class;
    private static String AutomationPackage = AutomationClass.getPackage().getName();
    private static String automationXSD = "/oracle/glcm/opatch/common/impl/automation/automation.xsd";
    private Automation automationObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private Schema schema = null;

    public PatchAutomationDAO() throws PatchMetadataLoadingException {
        this((String)null);
    }

    public PatchAutomationDAO(Automation automationObj) throws PatchMetadataLoadingException {
        this.automationObj = automationObj;
    }

    public PatchAutomationDAO(String automationLocation) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchAutomationDAO constructor...");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)AutomationPackage, (ClassLoader)PatchAutomationDAO.class.getClassLoader());
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = AutomationClass.getResource(automationXSD);
            this.schema = sf.newSchema(url);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new PatchMetadataLoadingException("Failed to initialize jaxb context for patch deploy", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PatchMetadataLoadingException("Failed to initialize jaxb context for patch deploy", (Throwable)e);
        }
        try (InputStream inputStream = Files.newInputStream(NioServiceFactory.getNioService().getPath(automationLocation, new String[0]), new OpenOption[0]);){
            this.automationObj = (Automation)SecureUnmarshaller.unmarshal(this.unmarshaller, inputStream);
        }
        catch (Exception je) {
            throw new PatchMetadataLoadingException("Failed to load or parse " + automationLocation, (Throwable)je);
        }
        this.logger.info("Done PatchDeployDAO creation.");
    }

    public boolean validate() {
        return this.automationObj != null;
    }

    public Automation getPatchAutomationObj() {
        return this.automationObj;
    }

    public void savePatchAutomationObj(String fileLoc) throws PatchMetadataWritingException {
        try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(fileLoc, new String[0]), new OpenOption[0]);){
            this.marshaller.marshal((Object)this.automationObj, outputStream);
        }
        catch (Exception je) {
            throw new PatchMetadataWritingException("Failed to write or parse the patch deploy artifact", (Throwable)je);
        }
    }
}

