/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.xbean;

import com.oracle.cie.common.dao.CachingDataHandler;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlByte;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlDuration;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlFloat;
import org.apache.xmlbeans.XmlInt;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlLong;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.XmlShort;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XBeanDataHandler
extends CachingDataHandler {
    private static final Logger _log = Logger.getLogger(XBeanDataHandler.class.getName());
    private XmlObject _object = null;
    private String _element;
    private HashMap<String, SchemaProperty> _propertyMap = null;
    private ArrayList<String> _attributeNames = null;
    private ArrayList<String> _simpleNames = null;
    private ArrayList<String> _complexNames = null;
    private String _encoding;

    protected XBeanDataHandler() {
    }

    public XBeanDataHandler(XmlObject object, String element) {
        this._object = object;
        this._element = element;
        this.loadPropertyMap();
    }

    @Override
    public Object getObject() {
        return this._object;
    }

    @Override
    public String getElement() {
        return this._element;
    }

    @Override
    public String getType() {
        return this._object.schemaType().getName().getLocalPart();
    }

    @Override
    public String getNamespace() {
        return this._object.schemaType().getName().getNamespaceURI();
    }

    @Override
    public Object getSimpleContent() {
        String value = null;
        if (this._object.schemaType().getContentType() == 2) {
            XmlCursor cursor = this._object.newCursor();
            value = cursor.getTextValue();
            cursor.dispose();
        }
        return value;
    }

    @Override
    public void save(File file) throws DataHandlerException {
        XmlObject obj = this.getDocumentObject();
        XmlOptions opts = XBeanDataHandler.getXmlOptions();
        File backup = null;
        if (file.exists()) {
            try {
                backup = IOUtil.backupFile((File)file, (boolean)false);
            }
            catch (Exception e) {
                throw new DataHandlerException(e);
            }
        }
        try {
            obj.save(file, opts);
        }
        catch (IOException e) {
            if (file.exists() && !file.delete()) {
                _log.warning("Unable to delete failed save " + file);
            }
            if (backup != null && !backup.renameTo(file)) {
                _log.warning("Unable to restore backup of " + file + ". At this point data may be corrupt. It is recommended that you exit and manually rename " + backup + " to " + file);
            }
            throw new DataHandlerException(e);
        }
        finally {
            if (backup != null && backup.exists() && !backup.delete()) {
                _log.warning("Unable to cleanup backup file " + backup);
            }
        }
    }

    @Override
    public void save(OutputStream os) throws DataHandlerException {
        XmlObject obj = this.getDocumentObject();
        XmlOptions opts = XBeanDataHandler.getXmlOptions();
        try {
            obj.save(os, opts);
        }
        catch (IOException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public void save(StringBuffer sb) {
        sb.setLength(0);
        sb.append(this.getDocumentObject().toString());
    }

    @Override
    public void save(XMLStreamWriter writer) throws DataHandlerException {
        throw new DataHandlerException("The ability to save to a XmlStreamWriter is currently not supported.");
    }

    @Override
    public IDataHandler copy() {
        return new XBeanDataHandler(this._object.copy(), this.getElement());
    }

    @Override
    public boolean validate() {
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errorList = new ArrayList();
        validateOptions.setErrorListener(errorList);
        boolean valid = this._object.validate(validateOptions);
        if (!valid) {
            for (XmlError error : errorList) {
                _log.severe("  Location of invalid XML: " + error.getLine() + "   Message: " + error.getMessage() + " XML: " + error.getCursorLocation().xmlText());
            }
        }
        return valid;
    }

    @Override
    public String[] getComments() {
        Node node;
        ArrayList<String> comments = new ArrayList<String>();
        if (this._object != null && (node = this._object.getDomNode()) != null) {
            NodeList nl = node.getChildNodes();
            for (int x = 0; x < nl.getLength(); ++x) {
                Node n = nl.item(x);
                if (n.getNodeType() != 8) continue;
                comments.add(n.getNodeValue());
            }
        }
        return comments.toArray(new String[comments.size()]);
    }

    private XmlObject getDocumentObject() {
        XmlObject obj;
        block8: {
            obj = null;
            if (!this._object.schemaType().isDocumentType()) {
                try {
                    SchemaType[] docs;
                    Class objClass = this._object.schemaType().getJavaClass();
                    for (SchemaType doc : docs = this._object.schemaType().getTypeSystem().documentTypes()) {
                        Method[] methods;
                        Class c = doc.getJavaClass();
                        for (Method method : methods = c.getDeclaredMethods()) {
                            Class<?>[] classes;
                            Class<?>[] params = method.getParameterTypes();
                            if (params.length != 1 || !params[0].equals(objClass)) continue;
                            Class<?> factoryClass = null;
                            for (Class<?> cls : classes = doc.getJavaClass().getClasses()) {
                                if (!cls.getName().endsWith("Factory")) continue;
                                factoryClass = cls;
                                break;
                            }
                            if (factoryClass == null) {
                                throw new ClassNotFoundException("Unable to locate Factory class in xbean class " + doc.getJavaClass());
                            }
                            Method newInstance = factoryClass.getMethod("newInstance", new Class[0]);
                            obj = (XmlObject)newInstance.invoke(null, new Object[0]);
                            method.invoke((Object)obj, this._object);
                            break;
                        }
                        if (obj == null) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    if (!_log.isLoggable(Level.FINE)) break block8;
                    _log.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        return obj == null ? this._object : obj;
    }

    public static XmlOptions getXmlOptions() {
        XmlOptions opts = new XmlOptions();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(2);
        opts.setCharacterEncoding("UTF-8");
        opts.setUseDefaultNamespace();
        return opts;
    }

    @Override
    public String[] getSimpleNames() {
        this.loadSimpleNames();
        return this._simpleNames.toArray(new String[this._simpleNames.size()]);
    }

    @Override
    public boolean hasSimpleName(String name) {
        this.loadSimpleNames();
        return this._simpleNames.contains(name);
    }

    public Class getSimpleType(String name) {
        SchemaProperty schemaProperty = this._propertyMap.get(name);
        return schemaProperty != null ? this.getJavaClassType(schemaProperty, true) : null;
    }

    protected void loadSimpleNames() {
        if (this._simpleNames == null) {
            this._simpleNames = new ArrayList();
            for (String name : this._propertyMap.keySet()) {
                SchemaProperty prop = this._propertyMap.get(name);
                if (prop == null || prop.isAttribute() || prop.getJavaTypeCode() <= 0 && !prop.getType().isSimpleType()) continue;
                this._simpleNames.add(name);
            }
        }
    }

    @Override
    public String[] getComplexNames() {
        this.loadComplexNames();
        return this._complexNames.toArray(new String[this._complexNames.size()]);
    }

    @Override
    public boolean hasComplexName(String name) {
        this.loadComplexNames();
        return this._complexNames.contains(name);
    }

    protected void loadComplexNames() {
        if (this._complexNames == null) {
            this._complexNames = new ArrayList();
            for (String name : this._propertyMap.keySet()) {
                SchemaProperty prop = this._propertyMap.get(name);
                if (prop == null || prop.getJavaTypeCode() != 0 || prop.isAttribute() || prop.getType().isSimpleType()) continue;
                this._complexNames.add(name);
            }
        }
    }

    @Override
    public Object getAttributeValueInternal(String name) {
        return this.getValueFromObject(name);
    }

    @Override
    public void setAttributeValueInternal(String name, Object value) {
        this.setValueToObject(name, value);
    }

    @Override
    public Object getSimpleValueInternal(String name) {
        return this.getValueFromObject(name);
    }

    @Override
    public void setSimpleValueInternal(String name, Object value) {
        this.setValueToObject(name, value);
    }

    @Override
    public IDataHandler[] getComplexValueInternal(String name) {
        return this.createDataHandler(this.getValueFromObject(name), name);
    }

    @Override
    public void setComplexValueInternal(String name, IDataHandler[] value) {
        this.setValueToObject(name, this.getObjectArray(value));
    }

    @Override
    public void setComplexValueInternal(String name, IDataHandler value) {
        this.setValueToObject(name, value != null ? value.getObject() : null);
    }

    @Override
    public IDataHandler addComplexValueInternal(String name) {
        return this.createDataHandler(this.addNewValueToObject(name), name)[0];
    }

    @Override
    public void addComplexValueInternal(String name, IDataHandler dataHandler) {
        IDataHandler[] newArray;
        IDataHandler[] array = this.getComplexValue(name);
        if (array != null) {
            newArray = new IDataHandler[array.length + 1];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = dataHandler;
        } else {
            newArray = new IDataHandler[]{dataHandler};
        }
        this.setComplexValue(name, newArray);
    }

    @Override
    public IDataHandler createComplexValue(String name) {
        SchemaProperty schemaProperty = this.getSchemaProperty(name);
        if (schemaProperty != null) {
            Class<?>[] classes;
            Class<?> factoryClass = null;
            for (Class<?> cls : classes = schemaProperty.getType().getJavaClass().getClasses()) {
                if (!cls.getName().endsWith("Factory")) continue;
                factoryClass = cls;
                break;
            }
            if (factoryClass != null) {
                try {
                    Method newInstance = factoryClass.getMethod("newInstance", new Class[0]);
                    return new XBeanDataHandler((XmlObject)newInstance.invoke(null, new Object[0]), name);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Failed to create complex value " + name, e);
                }
            }
        } else {
            _log.log(Level.WARNING, "Unable to locate complex value with name " + name);
        }
        return null;
    }

    @Override
    public String[] getAttributeNames() {
        this.loadAttributeNames();
        return this._attributeNames.toArray(new String[this._attributeNames.size()]);
    }

    @Override
    public boolean hasAttributeName(String name) {
        this.loadAttributeNames();
        return this._attributeNames.contains(name);
    }

    public Class getAttributeType(String name) {
        SchemaProperty schemaProperty = this._propertyMap.get(name);
        return schemaProperty != null ? this.getJavaClassType(schemaProperty, true) : null;
    }

    protected void loadAttributeNames() {
        if (this._attributeNames == null) {
            this._attributeNames = new ArrayList();
            for (String name : this._propertyMap.keySet()) {
                SchemaProperty prop = this._propertyMap.get(name);
                if (prop == null || !prop.isAttribute()) continue;
                this._attributeNames.add(name);
            }
        }
    }

    protected Object[] getObjectArray(IDataHandler[] value) {
        if (value != null && value.length > 0) {
            Object[] array = (Object[])Array.newInstance(value[0].getObject().getClass(), value.length);
            for (int x = 0; x < value.length; ++x) {
                array[x] = value[x].getObject();
            }
            return array;
        }
        return new Object[0];
    }

    private IDataHandler[] createDataHandler(Object object, String element) {
        IDataHandler[] array;
        if (object != null) {
            if (object.getClass().isArray()) {
                Object[] objs = (Object[])object;
                array = new XBeanDataHandler[objs.length];
                for (int x = 0; x < objs.length; ++x) {
                    array[x] = new XBeanDataHandler((XmlObject)objs[x], element);
                }
            } else {
                array = new XBeanDataHandler[]{new XBeanDataHandler((XmlObject)object, element)};
            }
        } else {
            array = new IDataHandler[]{};
        }
        return array;
    }

    public Object getValueFromObject(String name) {
        String[] value;
        SchemaProperty prop;
        block8: {
            prop = this.getSchemaProperty(name);
            String javaName = prop.getJavaPropertyName();
            value = null;
            try {
                if (this.isValueSet(javaName)) {
                    Method m = prop.extendsJavaArray() ? this._object.getClass().getMethod("get" + javaName + "Array", new Class[0]) : this._object.getClass().getMethod("get" + javaName, new Class[0]);
                    value = m.invoke((Object)this._object, new Object[0]);
                }
            }
            catch (Exception e) {
                if (!_log.isLoggable(Level.FINE)) break block8;
                _log.log(Level.FINE, e.getMessage(), e);
            }
        }
        if (value == null && prop.hasDefault() == 2) {
            value = this.getDefaultValue(prop);
        }
        if (value != null && prop.getType().hasStringEnumValues()) {
            if (prop.extendsJavaArray()) {
                Object[] objs = value;
                String[] values = new String[objs.length];
                for (int x = 0; x < objs.length; ++x) {
                    values[x] = objs[x].toString();
                }
                value = values;
            } else {
                value = value.toString();
            }
        }
        return value;
    }

    public void setValueToObject(String name, Object value) {
        block18: {
            SchemaProperty prop = this.getSchemaProperty(name);
            String javaName = prop.getJavaPropertyName();
            Class type = this.getJavaClassType(prop);
            if (value != null && prop.getType().hasStringEnumValues()) {
                if (prop.extendsJavaArray()) {
                    Object[] values = value;
                    Object[] objs = (Object[])Array.newInstance(type, values.length);
                    for (int x = 0; x < objs.length; ++x) {
                        objs[x] = prop.getType().enumForString(values[x].toString());
                    }
                    value = objs;
                } else {
                    value = prop.getType().enumForString(value.toString());
                }
            }
            if (prop.getMaxOccurs() != null && prop.getMaxOccurs().intValue() == 1 && prop.getMinOccurs().intValue() == 0 && (value == null || value.getClass().isArray() && ((Object[])value).length == 0 || value.equals(this.getDefaultValue(prop)))) {
                block17: {
                    try {
                        if (this.isValueSet(javaName)) {
                            this._object.getClass().getMethod("unset" + javaName, new Class[0]).invoke((Object)this._object, new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        if (!_log.isLoggable(Level.FINE)) break block17;
                        _log.log(Level.FINE, "Error unsetting value to _object=" + this._object + " name=" + name, e);
                    }
                }
                return;
            }
            try {
                if (prop.extendsJavaArray()) {
                    Object[] arrayVal = Array.newInstance(type, 0);
                    Class<?> arrayClass = arrayVal.getClass();
                    if (value != null) {
                        if (!value.getClass().isArray()) {
                            arrayVal = Array.newInstance(value.getClass(), 1);
                            arrayVal[0] = value;
                        } else if (((Object[])value).length > 0) {
                            arrayVal = value;
                        }
                    }
                    this._object.getClass().getMethod("set" + javaName + "Array", arrayClass).invoke((Object)this._object, new Object[]{arrayVal});
                } else {
                    if (value.getClass().isArray()) {
                        Object[] array = value;
                        value = array.length > 0 ? array[0] : null;
                    }
                    this._object.getClass().getMethod("set" + javaName, type).invoke((Object)this._object, new Object[]{value});
                }
            }
            catch (Exception e) {
                if (!_log.isLoggable(Level.FINE)) break block18;
                _log.log(Level.FINE, "Error setting value to _object=" + this._object + " val=" + value + " name=" + name + " type=" + type + " isArray=" + prop.extendsJavaArray(), e);
            }
        }
    }

    private XmlObject addNewValueToObject(String name) {
        SchemaProperty prop = this.getSchemaProperty(name);
        String javaName = prop.getJavaPropertyName();
        try {
            return (XmlObject)this._object.getClass().getMethod("addNew" + javaName, new Class[0]).invoke((Object)this._object, new Object[0]);
        }
        catch (Exception e) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Error adding new object with name " + name + " to " + this._object, e);
            }
            return null;
        }
    }

    private SchemaProperty getSchemaProperty(String name) {
        if (this._propertyMap == null) {
            this.loadPropertyMap();
        }
        return this._propertyMap.get(name);
    }

    private void loadPropertyMap() {
        SchemaProperty[] props;
        this._propertyMap = new HashMap();
        for (SchemaProperty prop : props = this._object.schemaType().getProperties()) {
            this._propertyMap.put(prop.getName().getLocalPart(), prop);
        }
    }

    protected Class getJavaClassType(SchemaProperty prop) {
        return this.getJavaClassType(prop, false);
    }

    protected Class getJavaClassType(SchemaProperty prop, boolean treatEnumAsString) {
        Class type = null;
        switch (prop.getJavaTypeCode()) {
            case 1: {
                type = Boolean.TYPE;
                break;
            }
            case 2: {
                type = Float.TYPE;
                break;
            }
            case 3: {
                type = Double.TYPE;
                break;
            }
            case 4: {
                type = Byte.TYPE;
                break;
            }
            case 5: {
                type = Short.TYPE;
                break;
            }
            case 6: {
                type = Integer.TYPE;
                break;
            }
            case 7: {
                type = Long.TYPE;
                break;
            }
            case 8: {
                type = BigDecimal.class;
                break;
            }
            case 9: {
                type = BigInteger.class;
                break;
            }
            case 10: {
                type = String.class;
                break;
            }
            case 11: {
                type = byte[].class;
                break;
            }
            case 12: {
                type = Calendar.class;
                break;
            }
            case 13: {
                type = Calendar.class;
                break;
            }
            case 14: {
                type = Calendar.class;
                break;
            }
            case 15: {
                type = QName.class;
                break;
            }
            case 16: {
                type = List.class;
                break;
            }
            case 17: {
                type = Calendar.class;
                break;
            }
            case 18: {
                type = treatEnumAsString ? String.class : prop.getType().getEnumJavaClass();
                break;
            }
            case 19: {
                type = Object.class;
                break;
            }
            default: {
                type = prop.getType().getJavaClass();
            }
        }
        return type;
    }

    protected Object getDefaultValue(SchemaProperty prop) {
        XmlAnySimpleType type = prop.getDefaultValue();
        Object value = null;
        if (type != null) {
            switch (prop.getJavaTypeCode()) {
                case 1: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getBooleanValue() : ((XmlBoolean)type).getBooleanValue();
                    break;
                }
                case 2: {
                    value = Float.valueOf(type instanceof XmlObjectBase ? ((XmlObjectBase)type).getFloatValue() : ((XmlFloat)type).getFloatValue());
                    break;
                }
                case 3: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getDoubleValue() : ((XmlDouble)type).getDoubleValue();
                    break;
                }
                case 4: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getByteValue() : ((XmlByte)type).getByteValue();
                    break;
                }
                case 5: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getShortValue() : ((XmlShort)type).getShortValue();
                    break;
                }
                case 6: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getIntValue() : ((XmlInt)type).getIntValue();
                    break;
                }
                case 7: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getLongValue() : ((XmlLong)type).getLongValue();
                    break;
                }
                case 8: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getBigDecimalValue() : ((XmlDecimal)type).getBigDecimalValue();
                    break;
                }
                case 9: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getBigIntegerValue() : ((XmlInteger)type).getBigIntegerValue();
                    break;
                }
                case 10: {
                    value = type.getStringValue();
                    break;
                }
                case 11: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getByteArrayValue() : ((XmlBase64Binary)type).getByteArrayValue();
                    break;
                }
                case 12: {
                    value = type;
                    break;
                }
                case 13: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getGDurationValue() : ((XmlDuration)type).getGDurationValue();
                    break;
                }
                case 14: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getCalendarValue() : ((XmlDate)type).getCalendarValue();
                    break;
                }
                case 15: {
                    value = type instanceof XmlObjectBase ? ((XmlObjectBase)type).getQNameValue() : ((XmlQName)type).getQNameValue();
                    break;
                }
                case 16: {
                    value = type;
                    break;
                }
                case 17: {
                    value = type;
                    break;
                }
                case 18: {
                    value = ((SimpleValue)type).getEnumValue();
                    break;
                }
                case 19: {
                    value = type;
                }
            }
        }
        return value;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    protected boolean isValueSet(String name) {
        try {
            return (Boolean)this._object.getClass().getMethod("isSet" + name, new Class[0]).invoke((Object)this._object, new Object[0]);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String toString() {
        if (this._object != null) {
            return this._object.toString();
        }
        return "";
    }
}

