/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.artifact;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.opatch.system.automation.jaxb.ArtifactType;
import oracle.oplan.core.oplan.IOUtils;
import oracle.oplan.sdk.artifact.Artifact;
import oracle.oplan.sdk.artifact.ArtifactException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactSet {
    protected List<Artifact> artifactList = new ArrayList<Artifact>();

    protected ArtifactSet() {
    }

    public List<Artifact> getArtifactList() {
        return this.artifactList;
    }

    public List<Artifact> getArtifactList(String artifactTag) {
        if (artifactTag == null) {
            return this.getArtifactList();
        }
        ArrayList<Artifact> returnList = new ArrayList<Artifact>();
        for (Artifact artifact : this.artifactList) {
            if (artifact.getArtifactTag() == null || !artifact.getArtifactTag().equals(artifactTag)) continue;
            returnList.add(artifact);
        }
        if (returnList.size() == 0) {
            throw new ArtifactException("It can not find artifactTag: " + artifactTag + " in artifact.xml");
        }
        return returnList;
    }

    public static ArtifactSet makeArtifactSet(File artifactXml, ArtifactType artifactType) {
        String artifactContent;
        Logger logger = Logger.getLogger(Artifact.class.getName());
        ArtifactSet artifactSet = new ArtifactSet();
        try {
            artifactContent = IOUtils.getContent(new FileInputStream(artifactXml)).toString();
        }
        catch (IOException e) {
            logger.severe("some exception occurd while reading the " + artifactXml.getAbsolutePath());
            throw new ArtifactException("some exception occurd while reading the " + artifactXml.getAbsolutePath());
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(artifactContent));
            Document doc = builder.parse(is);
            NodeList artifactTypeNodeList = doc.getElementsByTagName("artifact-" + artifactType.value());
            if (artifactTypeNodeList == null) {
                logger.severe("the artifact type " + artifactType.value() + " can not be found in the " + artifactXml.getAbsolutePath());
                throw new ArtifactException("the artifact type " + artifactType.value() + " can not be found in the " + artifactXml.getAbsolutePath());
            }
            for (int i = 0; i < artifactTypeNodeList.getLength(); ++i) {
                Node artifactTypeNode = artifactTypeNodeList.item(i);
                if (artifactTypeNode.getNodeType() != 1) continue;
                Artifact artifact = new Artifact();
                Element artifactTypeElement = (Element)artifactTypeNode;
                if (artifactTypeElement.hasAttribute("name")) {
                    artifact.name = artifactTypeElement.getAttribute("name");
                }
                if (artifactTypeElement.hasAttribute("artifact-tag")) {
                    artifact.artifactTag = artifactTypeElement.getAttribute("artifact-tag");
                }
                NodeList parameterNodeList = artifactTypeElement.getElementsByTagName("*");
                for (int j = 0; j < parameterNodeList.getLength(); ++j) {
                    Node parameterNode = parameterNodeList.item(j);
                    String parameterName = parameterNode.getNodeName();
                    String parameterValue = parameterNode.getTextContent();
                    artifact.parameterList.put(parameterName, parameterValue);
                }
                artifactSet.artifactList.add(artifact);
            }
            return artifactSet;
        }
        catch (Exception e) {
            throw new ArtifactException(e);
        }
    }
}

