/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchLsinventoryCommand
extends SimpleShellCommand {
    public OPatchLsinventoryCommand(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String opatchPath = CommandUtils.getOPatchPath(oh);
        String mkdirCmd = "";
        String customLogDirCmd = "";
        Map<OPlanAccessOptParamKeys, String> optParam = OPlan.getInstance().getOPlanEnv().getOptionalParam();
        if (optParam.containsKey((Object)OPlanAccessOptParamKeys.opatchCustomLogDir)) {
            String customLogDirPath = CommandUtils.getCustomLogDir(optParam.get((Object)OPlanAccessOptParamKeys.opatchCustomLogDir), oh.getPath());
            mkdirCmd = "mkdir -p " + customLogDirPath + " ; ";
            customLogDirCmd = " -customLogDir " + customLogDirPath;
        }
        String cmd = mkdirCmd + opatchPath + " lsinventory" + invPtrOption + " -oh " + oh.getPath() + customLogDirCmd;
        return Collections.singletonList(cmd);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchLsinventoryCommand> {
        @Override
        public OPatchLsinventoryCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("lsinventory")) {
                return null;
            }
            OPatchLsinventoryCommand com = new OPatchLsinventoryCommand(a);
            return com;
        }
    }
}

