/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.DeploymentSubType;
import oracle.opatch.system.automation.jaxb.DeploymentType;
import oracle.oplan.sdk.exec.api.ExecutionPhase;
import oracle.oplan.sdk.exec.api.Patch;
import oracle.oplan.sdk.exec.api.Target;
import oracle.oplan.sdk.util.OPlanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="execution-plan", namespace="http://oracle.com/schema/opatch/ExecutionPlan", propOrder={"applyTarget", "applyPatch", "executionPhase"})
@XmlRootElement(name="execution-plan")
public class ExecutionPlan {
    @XmlElement(name="apply-traget", required=true)
    protected List<Target> applyTarget;
    @XmlElement(name="apply-patch", required=true)
    protected List<Patch> applyPatch;
    @XmlElement(name="execution-phase", required=true)
    protected List<ExecutionPhase> executionPhase;
    @XmlAttribute(name="generating-user")
    protected String generatingUser;
    @XmlAttribute(name="generation-time")
    protected String generationTime;
    @XmlAttribute(name="deployment-type")
    protected DeploymentType deploymentType;
    @XmlAttribute(name="deployment-sub-type")
    protected DeploymentSubType deploymentSubType;
    @XmlAttribute(name="generation-host")
    protected String generationHost;
    @XmlAttribute(name="patch-location")
    protected String patchLocation;
    @XmlTransient
    protected Automation automation;
    protected String status;

    public ExecutionPlan() {
        this(null);
    }

    public ExecutionPlan(Automation auto) {
        this.automation = auto;
    }

    public List<Target> getApplyTarget() {
        if (this.applyTarget == null) {
            this.applyTarget = new ArrayList<Target>();
        }
        return this.applyTarget;
    }

    public List<Patch> getApplyPatch() {
        if (this.applyPatch == null) {
            this.applyPatch = new ArrayList<Patch>();
        }
        return this.applyPatch;
    }

    public List<ExecutionPhase> getExecutionPhase() {
        if (this.executionPhase == null) {
            this.executionPhase = new ArrayList<ExecutionPhase>();
        }
        return this.executionPhase;
    }

    public String getGeneratingUser() {
        return this.generatingUser;
    }

    public void setGeneratingUser(String value) {
        this.generatingUser = value;
    }

    public String getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(String value) {
        this.generationTime = value;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(DeploymentType value) {
        this.deploymentType = value;
    }

    public DeploymentSubType getDeploymentSubType() {
        return this.deploymentSubType;
    }

    public void setDeploymentSubType(DeploymentSubType value) {
        this.deploymentSubType = value;
    }

    public String getGenerationHost() {
        return this.generationHost;
    }

    public void setGenerationHost(String value) {
        this.generationHost = value;
    }

    public String getPatchLocation() {
        return this.patchLocation;
    }

    public void setPatchLocation(String value) {
        this.patchLocation = value;
    }

    public Automation getAutomation() {
        return this.automation;
    }

    public int getAllStepsCount() {
        int count = 0;
        for (ExecutionPhase phase : this.getExecutionPhase()) {
            count += phase.getExecutionStep().size();
        }
        return count;
    }

    public String toString() {
        return OPlanUtils.getExecutionPlanInfo(this);
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }
}

