/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.oplan;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.patchmodel.PatchPackage;
import oracle.opatch.system.automation.jaxb.Automation;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.OPlanException;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanInternalException;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.oplan.sdk.patch.PatchPackageFactory;
import oracle.oplan.sdk.patch.PatchPackagesBag;
import oracle.osysmodel.patchsdk.PatchPackageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPlanEnv {
    private Logger logger = Logger.getLogger(OPlanEnv.class.getName());
    HashMap<String, Method> specialProperties;
    Properties props = new Properties();
    boolean isTargetOnWindows = false;
    InputStream bundleXMLStream = null;
    PatchPackagesBag patchesBag = null;
    Map<Automation, URL> automationFileMap = null;
    List<Automation> automations = null;
    Map<Class, List<String>> skippedTargetMap = new HashMap<Class, List<String>>();
    Map<String, String> OPatchNapplyOptions;
    Map<String, String> OPatchRollbackOptions;
    Map<String, String> patchingStatusOfOracleHome = new HashMap<String, String>();
    Map<OPlanAccessOptParamKeys, String> optionalParam = new HashMap<OPlanAccessOptParamKeys, String>();

    private void collectProperties() {
        this.specialProperties = new HashMap();
        for (Method m : this.getClass().getMethods()) {
            AProperty ann = m.getAnnotation(AProperty.class);
            if (ann == null) continue;
            this.specialProperties.put(ann.value(), m);
            this.logger.finest("Found property " + ann.value());
        }
    }

    private String getSpecialProperty(String propName) {
        this.logger.fine("Getting special property: " + propName);
        Method m = this.specialProperties.get(propName);
        try {
            Object o = m.invoke((Object)this, new Object[0]);
            return o.toString();
        }
        catch (IllegalAccessException e) {
            throw new OPlanInternalException(e);
        }
        catch (InvocationTargetException e) {
            throw new OPlanInternalException(e);
        }
    }

    public OPlanEnv() {
        this.collectProperties();
    }

    public void setProperties(Properties props) {
        this.validateProperties(props);
        if (this.props == null || this.props.isEmpty()) {
            this.props = props;
        } else {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                if (this.props.contains((String)entry.getKey())) continue;
                this.props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void validateProperties(Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (!(key instanceof String)) {
                throw new OPlanInternalException("Non-string property key");
            }
            String skey = (String)key;
            if (!(value instanceof String)) {
                throw new OPlanInternalException("Non-string property value of " + skey);
            }
            if (this.specialProperties.containsKey(skey)) continue;
            this.logger.warning("Unrecognized property \"" + skey + "\"");
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperty(String propName, String propValue) {
        this.props.setProperty(propName, propValue);
    }

    public String getProperty(String propName) {
        if (this.specialProperties.containsKey(propName)) {
            return this.getSpecialProperty(propName);
        }
        this.logger.config("Unrecognized property reference " + propName);
        return this.props.getProperty(propName);
    }

    protected File getRequiredFileProperty(String propName, boolean require_exists) {
        String value = this.props.getProperty(propName);
        if (value == null) {
            throw new OPlanInternalException(propName + " is required, but not set.");
        }
        File f = new File(value).getAbsoluteFile();
        if (require_exists && !f.exists()) {
            throw new OPlanUserException("FILE_PROPERTY_DNE", propName, f.getAbsolutePath());
        }
        return f;
    }

    protected File getOptionalFileProperty(String propName, File default_value, boolean require_exists) {
        String value = this.props.getProperty(propName);
        if (value == null) {
            return default_value;
        }
        File f = new File(value).getAbsoluteFile();
        if (require_exists && !f.exists()) {
            throw new OPlanUserException("FILE_PROPERTY_DNE", propName, f.getAbsolutePath());
        }
        return f;
    }

    protected List<File> getListOfPatchesForTargetProperty(String propName) {
        String[] patchLocs;
        ArrayList<File> patchLocations = new ArrayList<File>();
        if (this.props.getProperty(propName) == null) {
            return null;
        }
        for (String patchLoc : patchLocs = this.props.getProperty(propName).split(",")) {
            File patchLocation = new File(patchLoc).getAbsoluteFile();
            if (!patchLocation.exists()) {
                throw new OPlanUserException("FILE_PROPERTY_DNE", propName, patchLocation.getAbsolutePath());
            }
            patchLocations.add(patchLocation);
        }
        return patchLocations;
    }

    @AProperty(value="OPlanLocation")
    public File getOPlanLocation() {
        String FileSeparator = this.isTargetOnWindows() ? "\\" : "/";
        return this.getOptionalFileProperty("OPlanLocation", new File("$ORACLE_HOME" + FileSeparator + "OPatch" + FileSeparator + "oplan" + FileSeparator + "oplan"), true);
    }

    @AProperty(value="ConfigXML")
    public File getConfigXML() {
        return OPlan.getInstance().getLogInfo().getConfigXml().getAbsoluteFile();
    }

    @AProperty(value="SessionID")
    public String getSessionID() {
        String propName = "SessionID";
        if (!this.props.containsKey(propName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String datestr = sdf.format(new Date());
            this.props.put(propName, datestr);
        }
        return this.props.getProperty(propName);
    }

    static String checkLocalHost() {
        if (OPlan.getInstance().getLocalInfo() != null) {
            return OPlan.getInstance().getLocalInfo().getLocalHostName();
        }
        return "localhost";
    }

    @AProperty(value="LocalHost")
    public String getLocalHost() {
        String propName = "LocalHost";
        if (!this.props.containsKey(propName)) {
            this.props.put(propName, OPlanEnv.checkLocalHost());
        }
        return this.props.getProperty(propName);
    }

    @AProperty(value="OracleHome")
    public String getTargetHome() {
        return this.props.getProperty("OracleHome", System.getenv("ORACLE_HOME"));
    }

    @AProperty(value="OPlanVersion")
    public String getOPlanVersion() {
        return this.props.getProperty("OPlanVersion", "No Version Info");
    }

    @AProperty(value="UserInvokingOplan")
    public String getUserInvokingOplan() {
        return this.props.getProperty("UserInvokingOplan");
    }

    @AProperty(value="RootUser")
    public String getRootUser() {
        return this.props.getProperty("RootUser", "root");
    }

    @AProperty(value="TmpFilesDir")
    public File getTmpFilesDir() {
        File tmpFilesDif = null;
        tmpFilesDif = this.isTargetOnWindows() ? new File("C:\\Temp") : new File("/tmp");
        return this.getOptionalFileProperty("TmpFilesDir", tmpFilesDif, false);
    }

    @AProperty(value="ExecutionMode")
    public ExecutionMode getExecutionMode() {
        String executionMode = this.props.getProperty("ExecutionMode");
        if (executionMode == null) {
            executionMode = ExecutionMode.STANDALONE.toString();
        }
        try {
            return ExecutionMode.valueOf(executionMode);
        }
        catch (IllegalArgumentException e) {
            throw new OPlanUserException("EXECUTION_MODE_NOT_RECOGNIZED", executionMode);
        }
    }

    @AProperty(value="AdminServerURL")
    public String getAdminServerURL() {
        return this.props.getProperty("AdminServerURL", "");
    }

    @AProperty(value="AdminServerUser")
    public String getAdminServerUser() {
        return this.props.getProperty("AdminServerUser", "");
    }

    @AProperty(value="AdminServerPassword")
    public String getAdminServerPassword() {
        return this.props.getProperty("AdminServerPassword", "");
    }

    @AProperty(value="BundlePatchLocation")
    public File getBundlePatchloc() {
        return this.getRequiredFileProperty("BundlePatchLocation", true);
    }

    @AProperty(value="RACPatchLocations")
    public List<File> getRACPatchLocations() {
        return this.getListOfPatchesForTargetProperty("RACPatchLocations");
    }

    @AProperty(value="GIPatchLocations")
    public List<File> getGIPatchLocations() {
        return this.getListOfPatchesForTargetProperty("GIPatchLocations");
    }

    @AProperty(value="AllPatchLocations")
    public String getAllPatchLocations() {
        String propName = "AllPatchLocations";
        String allPatchLocs = "";
        if (!this.props.containsKey(propName)) {
            for (PatchPackage patch : this.getPatchesBag().getBagContents()) {
                if (allPatchLocs.equals("")) {
                    allPatchLocs = patch.getPatchLocation();
                    continue;
                }
                allPatchLocs = allPatchLocs + "," + patch.getPatchLocation();
            }
            this.props.put(propName, allPatchLocs);
        }
        return this.props.getProperty(propName);
    }

    public File getDummyPatchloc() {
        return this.getRequiredFileProperty("BundlePatchLocation", false);
    }

    @AProperty(value="PatchIDs")
    public String getPatchIDs() {
        String propName = "PatchIDs";
        if (!this.props.containsKey(propName)) {
            String patchIds = this.getPatchesBag().getPatchesListAsString();
            this.props.put(propName, patchIds);
        }
        return this.props.getProperty(propName);
    }

    @AProperty(value="Operation")
    public Operation getOperation() {
        String propName = "Operation";
        String value = this.props.getProperty(propName, "apply");
        try {
            return Operation.fromValue((String)value.trim());
        }
        catch (IllegalArgumentException e) {
            throw new OPlanInternalException("The value \"" + value + "\" is not valid for " + propName + ".");
        }
    }

    public File getTargetHomeLogDir() {
        String FileSeparator = this.isTargetOnWindows() ? "\\" : "/";
        return new File(this.getTargetHome(), "cfgtoollogs" + FileSeparator + "oplan");
    }

    @AProperty(value="logDir")
    public File getLogDir() {
        File logDir;
        if (this.props.getProperty("logDir") != null && this.props.getProperty("logDir").length() > 0) {
            logDir = new File(this.props.getProperty("logDir"));
        } else if (this.props.getProperty("LogFileDirectory") != null && this.props.getProperty("LogFileDirectory").length() > 0) {
            logDir = new File(this.props.getProperty("LogFileDirectory"));
        } else if (this.getTargetHome() != null && this.getTargetHome().length() > 0) {
            logDir = this.getTargetHomeLogDir();
        } else {
            String tmpdir = System.getProperty("java.io.tmpdir");
            logDir = new File(tmpdir, "oplanlog");
        }
        return logDir;
    }

    public boolean hasConfigurationSnapshot() {
        return this.props.containsKey("ConfigurationSnapshot");
    }

    @AProperty(value="ConfigurationSnapshot")
    public File getConfigurationSnapshot() {
        return this.getRequiredFileProperty("ConfigurationSnapshot", true);
    }

    @AProperty(value="SkipConfigValidation")
    public String getSkipConfigValidation() {
        return this.props.getProperty("SkipConfigValidation");
    }

    @AProperty(value="ProductFamily")
    public String getProductFamily() {
        return this.props.getProperty("ProductFamily");
    }

    public boolean getRequireExadata() {
        return Boolean.parseBoolean(this.props.getProperty("RequireExadata", "true"));
    }

    @AProperty(value="NodeNumberPerReadme")
    public String getNodeNumberPerReadme() {
        return this.props.getProperty("NodeNumberPerReadme", "-1");
    }

    @AProperty(value="MoveConfigToOH")
    public String getMoveConfigToOH() {
        return this.props.getProperty("MoveConfigToOH", "");
    }

    @AProperty(value="SelectivePatchingEnabled")
    public boolean selectivePatchingEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("SelectivePatchingEnabled", "false"));
    }

    public boolean getRequire_11_2_0_2() {
        return Boolean.parseBoolean(this.props.getProperty("Require_11.2.0.2", "true"));
    }

    public BigInteger getBundleHash() {
        if (!this.props.containsKey("BundleHash")) {
            return null;
        }
        return new BigInteger(this.props.getProperty("BundleHash"), 16);
    }

    @AProperty(value="MinimumOPatchVersion")
    public String getMinimumOPatchVersion() {
        return this.props.getProperty("MinimumOPatchVersion", "11.1.0.9.0");
    }

    @AProperty(value="ConsoleLogLevel")
    public Level getConsoleLogLevel() {
        String prop = this.props.getProperty("ConsoleLogLevel", Level.OFF.getName());
        return Level.parse(prop.trim());
    }

    @AProperty(value="LogFileLevel")
    public Level getLogFileLevel() {
        String prop = this.props.getProperty("LogFileLevel", Level.CONFIG.getName());
        return Level.parse(prop.trim());
    }

    @AProperty(value="IntgFactoryClass")
    public String getIntgFactoryClass() {
        return this.props.getProperty("IntgFactoryClass");
    }

    @AProperty(value="customLogPath")
    public String getCustomLogPath() {
        return this.props.getProperty("customLogPath");
    }

    public boolean isTargetOnWindows() {
        return this.isTargetOnWindows;
    }

    public void setTargetOnWindows(boolean isTargetOnWindows) {
        this.isTargetOnWindows = isTargetOnWindows;
    }

    public void setBundleXMLStream(InputStream bundleXMLStream) {
        this.bundleXMLStream = bundleXMLStream;
    }

    public void setPatchesBag(PatchPackagesBag patchesBag) {
        this.patchesBag = patchesBag;
    }

    public synchronized PatchPackagesBag getPatchesBag() {
        PatchPackage p;
        this.logger.entering(this.getClass().getName(), "getPatchesBag");
        if (this.patchesBag != null) {
            return this.patchesBag;
        }
        this.patchesBag = PatchPackageFactory.getInstance(OPlan.getInstance().getOPlanIntgFactory()).getPatchPackageBagInstance();
        if (this.bundleXMLStream != null) {
            try {
                PatchPackage patch = PatchPackageFactory.getInstance(OPlan.getInstance().getOPlanIntgFactory()).getPatchBundleFromBundleStream(this.bundleXMLStream, this.getDummyPatchloc().getPath());
                this.patchesBag.add(patch);
                this.patchesBag.setPrimaryPatchPackage(patch);
            }
            catch (PatchPackageException e) {
                throw new OPlanException(e);
            }
        }
        try {
            this.logger.log(Level.INFO, "Getting patch object for patch at location " + this.getBundlePatchloc().getAbsolutePath());
            PatchPackage p2 = PatchPackageFactory.getInstance(OPlan.getInstance().getOPlanIntgFactory()).getPatchPackageFromDir(this.getBundlePatchloc());
            this.patchesBag.add(p2);
            this.patchesBag.setPrimaryPatchPackage(p2);
        }
        catch (PatchPackageException e) {
            throw new OPlanException(e);
        }
        if (this.getRACPatchLocations() != null && !this.getRACPatchLocations().isEmpty()) {
            for (File patch : this.getRACPatchLocations()) {
                try {
                    this.logger.log(Level.FINE, "Adding RAC patch" + patch + " to the patch bag");
                    p = PatchPackageFactory.getInstance(OPlan.getInstance().getOPlanIntgFactory()).getPatchPackageFromDir(patch);
                    this.patchesBag.add(p);
                }
                catch (PatchPackageException e) {
                    throw new OPlanException(e);
                }
            }
        }
        if (this.getGIPatchLocations() != null && !this.getGIPatchLocations().isEmpty()) {
            for (File patch : this.getGIPatchLocations()) {
                try {
                    p = PatchPackageFactory.getInstance(OPlan.getInstance().getOPlanIntgFactory()).getPatchPackageFromDir(patch);
                    this.logger.log(Level.FINE, "Adding GI patch" + patch + " to the patch bag");
                    this.patchesBag.add(p);
                }
                catch (PatchPackageException e) {
                    throw new OPlanException(e);
                }
            }
        }
        this.logger.exiting(this.getClass().getName(), "getPatchBundle");
        return this.patchesBag;
    }

    public Map<Automation, URL> getAutomationFileMap() {
        return this.automationFileMap;
    }

    public void setAutomationFileMap(Map<Automation, URL> automationFileMap) {
        this.automationFileMap = automationFileMap;
    }

    public List<Automation> getAutomations() {
        return this.automations;
    }

    public void setAutomations(List<Automation> automations) {
        this.automations = automations;
    }

    public Map<Class, List<String>> getSkippedTargetMap() {
        return this.skippedTargetMap;
    }

    public void setOPatchNapplyOptions(Map<String, String> options) {
        this.OPatchNapplyOptions = options;
    }

    public Map<String, String> getOPatchNapplyOptions() {
        return this.OPatchNapplyOptions;
    }

    public void setOPatchRollbackOptions(Map<String, String> options) {
        this.OPatchRollbackOptions = options;
    }

    public Map<String, String> getOPatchRollbackOptions() {
        return this.OPatchRollbackOptions;
    }

    public Map<String, String> getPatchingStatusOfOracleHome() {
        return this.patchingStatusOfOracleHome;
    }

    public Map<OPlanAccessOptParamKeys, String> getOptionalParam() {
        return this.optionalParam;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AProperty {
        public String value();
    }
}

