/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.patch;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchBundlexml {
    private Logger logger = Logger.getLogger(PatchBundlexml.class.getName());
    private final String bundlexmlContent;
    protected Map<String, List<String>> patchToTargetList;
    protected BigInteger overriddenHash;
    protected String minOplanVersion;
    protected String bundleType;
    private BigInteger hashOfFullContent;
    protected List<String> patchesOrder;

    public PatchBundlexml(String bundlexmlContent) throws BundleValidationException, IOException, BundleXmlException {
        this.bundlexmlContent = bundlexmlContent;
        this.fillInfoFromBundleXml();
        this.hashOfFullContent = PatchBundlexml.getHash(bundlexmlContent);
    }

    public BigInteger getOverriddenHash() {
        return this.overriddenHash;
    }

    public String getMinOplanVersion() {
        return this.minOplanVersion;
    }

    public String getBundleType() {
        return this.bundleType;
    }

    public BigInteger getHashOfFullContent() {
        return this.hashOfFullContent;
    }

    public Map<String, List<String>> getPatchToTargetList() {
        return this.patchToTargetList;
    }

    public List<String> getPatchesOrder() {
        return this.patchesOrder;
    }

    public static BigInteger getHash(String fileContent) {
        try {
            MessageDigest md = MessageDigest.getInstance("sha1");
            byte[] buff = fileContent.getBytes();
            md.update(buff);
            return new BigInteger(1, md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void fillInfoFromBundleXml() throws BundleValidationException, IOException, BundleXmlException {
        this.logger.entering(PatchBundlexml.class.getName(), "fillInfoFromBundleXml");
        EntityHandler eh = new EntityHandler(this);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(new InputSource(new StringReader(this.bundlexmlContent)), (DefaultHandler)eh);
            if ((this.patchesOrder == null || this.patchesOrder.isEmpty()) && (this.patchToTargetList == null || this.patchToTargetList.isEmpty())) {
                this.logger.log(Level.WARNING, "Couldn't get the list of patches and order of patches from the bundle.xml");
                throw new SAXException("Couldn't get the list of patches and order of patches from the bundle.xml");
            }
            this.logger.exiting(PatchBundlexml.class.getName(), "fillInfoFromBundleXml");
        }
        catch (SAXException e) {
            throw new BundleValidationException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new BundleXmlException((Throwable)e);
        }
    }

    static class EntityHandler
    extends DefaultHandler {
        private Logger logger = Logger.getLogger(EntityHandler.class.getName());
        private PatchBundlexml pb;
        Map<String, List<String>> patches = new HashMap<String, List<String>>();
        List<String> patchesOrder = new ArrayList<String>();
        private String curFile = null;

        EntityHandler(PatchBundlexml pb) {
            this.pb = pb;
            pb.patchToTargetList = this.patches;
            pb.patchesOrder = this.patchesOrder;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("bundle")) {
                this.pb.bundleType = attributes.getValue("type");
            } else if (qName.equals("entity")) {
                this.curFile = attributes.getValue("location");
                if (this.curFile == null) {
                    throw new SAXException("Encountered \"entity\" element with no location attribute in bundle.xml");
                }
                if (!this.patches.containsKey(this.curFile)) {
                    this.patches.put(this.curFile, new ArrayList());
                    this.patchesOrder.add(this.curFile);
                }
            } else if (qName.equals("target")) {
                String type = attributes.getValue("type");
                if (type == null) {
                    throw new SAXException("Encountered \"target\" element with no type attribute in bundle.xml");
                }
                if (this.curFile == null) {
                    throw new SAXException("Encountered \"target\" element before \"entity\" element in bundle.xml");
                }
                this.patches.get(this.curFile).add(type);
            } else if (qName.equals("automation")) {
                String hash = attributes.getValue("hash");
                if (hash != null && hash.length() > 0) {
                    try {
                        this.pb.overriddenHash = new BigInteger(hash, 16);
                    }
                    catch (NumberFormatException e) {
                        this.logger.log(Level.SEVERE, "Automation hash key overridden in bundle.xml is invalid: ~" + hash + "~ Attempting to proceed further.", e);
                    }
                }
                this.pb.minOplanVersion = attributes.getValue("oplan-version");
            }
        }
    }
}

