/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.conf;

import com.oracle.cie.wizard.ConfigurationOption;
import com.oracle.cie.wizard.conf.OptionErrorHolder;
import com.oracle.cie.wizard.conf.WizardOptionsHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOptionsHandler
implements WizardOptionsHandler {
    protected List<String> _handledOptions = new ArrayList<String>();
    protected List<String> _unhandledOptions = new ArrayList<String>();
    protected Map<String, String> _processedOptions = new LinkedHashMap<String, String>();
    protected List<OptionErrorHolder> _errors = new ArrayList<OptionErrorHolder>();
    protected List<OptionErrorHolder> _warnings = new ArrayList<OptionErrorHolder>();

    @Override
    public abstract List<ConfigurationOption> getSupportedOptions();

    @Override
    public List<String> getHiddenOptions() {
        return Collections.emptyList();
    }

    @Override
    public void setOptionValues(Map<String, String> values) {
        this._handledOptions.clear();
        this._unhandledOptions.clear();
        this._processedOptions.clear();
        this._errors.clear();
        HashMap<String, String> valuesCopy = new HashMap<String, String>();
        if (values != null) {
            valuesCopy.putAll(values);
        }
        for (ConfigurationOption option : this.getSupportedOptions()) {
            String value;
            String name = option.getName();
            if (valuesCopy.containsKey(name)) {
                value = (String)valuesCopy.remove(name);
                this._handledOptions.add(name);
                this._processedOptions.put(name, value);
                continue;
            }
            if (option.isRequired()) {
                this._errors.add(new OptionErrorHolder("wizard.conf.errors.required", "Required option \"{0}\" is not set.", name));
                continue;
            }
            if (!option.hasDefault()) continue;
            value = option.getDefaultValue();
            this._processedOptions.put(name, value);
        }
        this._unhandledOptions.addAll(valuesCopy.keySet());
    }

    @Override
    public Map<String, String> getProcessedOptions() {
        return Collections.unmodifiableMap(this._processedOptions);
    }

    @Override
    public List<String> getHandledOptions() {
        return Collections.unmodifiableList(this._handledOptions);
    }

    @Override
    public List<String> getUnhandledOptions() {
        return Collections.unmodifiableList(this._unhandledOptions);
    }

    @Override
    public List<OptionErrorHolder> getErrors() {
        return Collections.unmodifiableList(this._errors);
    }

    @Override
    public List<OptionErrorHolder> getWarnings() {
        return Collections.unmodifiableList(this._warnings);
    }
}

