/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.panel;

import com.oracle.cie.common.SecureUnmarshaller;
import com.oracle.cie.wizard.ext.panel.xml.PanelType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CustomPanelParser {
    private static final Logger LOGGER = Logger.getLogger(CustomPanelParser.class.getName());
    private static final String CUSTOM_PANEL_SCHEMA = "wcf/schema/custom_panel.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PanelType parse(InputStream is) throws SAXException, JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("Invalid Stream");
        }
        try {
            URL schemaUrl = CustomPanelParser.class.getClassLoader().getResource(CUSTOM_PANEL_SCHEMA);
            JAXBContext context = JAXBContext.newInstance((String)PanelType.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(schemaUrl);
            unmarshaller.setSchema(schema);
            InputSource inputSource = new InputSource(is);
            Object obj = SecureUnmarshaller.unmarshal((Unmarshaller)unmarshaller, (InputSource)inputSource);
            PanelType panelType = obj instanceof JAXBElement ? (PanelType)((JAXBElement)obj).getValue() : (PanelType)obj;
            return panelType;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "Issue in closing the custom panel configuration stream", e);
            }
        }
    }
}

