/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.wizard.tasks.InvalidTaskException;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskFactory;
import com.oracle.cie.wizard.wcf.TaskDefinition;
import com.oracle.cie.wizard.wcf.TaskEntry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WizardTaskFactory
implements TaskFactory {
    private static Logger _log = Logger.getLogger(WizardTaskFactory.class.getName());
    protected Map<TaskDefinition, Task<?>> _globalTaskCache = new HashMap();
    protected Map<TaskEntry, Task<?>> _entryTaskCache = new HashMap();
    protected ClassLoader _taskClazzLoader;

    @Override
    public void setTaskClazzLoader(ClassLoader cl) {
        this._taskClazzLoader = cl;
    }

    @Override
    public Task<?> getTaskInstance(TaskEntry taskEntry) throws InvalidTaskException {
        if (taskEntry == null) {
            throw new InvalidTaskException(null, null, "Task entry is null.");
        }
        TaskDefinition taskDef = taskEntry.getTaskDefinition();
        if (taskDef == null) {
            throw new InvalidTaskException(taskEntry.getName(), null, "No task definition found.");
        }
        Task<?> task = null;
        switch (taskDef.getCachingPolicy()) {
            case REUSE: {
                task = this._globalTaskCache.get(taskDef);
                break;
            }
            case TASK_ENTRY: {
                task = this._entryTaskCache.get(taskEntry);
                break;
            }
        }
        if (task == null) {
            task = this.createTask(taskDef);
            switch (taskDef.getCachingPolicy()) {
                case REUSE: {
                    this._globalTaskCache.put(taskDef, task);
                    break;
                }
                case TASK_ENTRY: {
                    this._entryTaskCache.put(taskEntry, task);
                    break;
                }
            }
        }
        if (task != null) {
            this.configureTask(task, taskEntry);
        }
        return task;
    }

    public void clearCache() {
        this._globalTaskCache.clear();
    }

    @Override
    public Task<?> createTask(TaskDefinition td) throws InvalidTaskException {
        Task task;
        Class<?> clazz;
        if (td == null) {
            throw new InvalidTaskException(null, null, "Task definition is null.");
        }
        try {
            clazz = this._taskClazzLoader.loadClass(td.getClassName());
        }
        catch (ClassNotFoundException cnfx) {
            throw new InvalidTaskException(td.getName(), td.getClassName(), "Unable to locate task class!", cnfx);
        }
        try {
            task = (Task)Task.class.cast(clazz.newInstance());
        }
        catch (IllegalAccessException iax) {
            throw new InvalidTaskException(td.getName(), td.getClassName(), "Unable to access default constructor", iax);
        }
        catch (InstantiationException ix) {
            throw new InvalidTaskException(td.getName(), td.getClassName(), "Unable to instantiate task class!", ix);
        }
        return task;
    }

    @Override
    public void configureTask(Task<?> task, TaskEntry entry) {
        if (task == null || entry == null) {
            return;
        }
        task.setEntry(entry);
        StringBuilder sb = new StringBuilder("set");
        Class<?> clazz = task.getClass();
        _log.fine("Configuring task: " + entry.getTaskDefinition().getName() + " --> " + clazz.getName());
        Map<String, String> attributes = entry.getAttributeMap();
        for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
            String key = attrEntry.getKey();
            if (key == null || key.isEmpty()) {
                _log.severe("Unspecified attribute name in " + task);
                continue;
            }
            sb.setLength(3);
            sb.append(key);
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            try {
                Method meth = clazz.getMethod(sb.toString(), String.class);
                _log.finest("Invoking method: " + meth.toString());
                meth.invoke(task, attrEntry.getValue());
            }
            catch (NoSuchMethodException nsmx) {
                _log.log(Level.SEVERE, "Unable to locate method: " + sb.toString(), nsmx);
            }
            catch (Throwable x) {
                _log.log(Level.SEVERE, "Unable to invoke method: " + sb.toString(), x);
            }
        }
    }
}

