/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

@TaskDescription(name="loadNamespace")
public class LoadObjectStoreTask
extends AbstractSilentTask {
    protected String _propertyFilename = "";
    protected String _key = null;
    protected boolean _abort = true;
    protected boolean _silent = false;
    protected String _replace = "true";

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setPropertyFile(String bn) {
        this._propertyFilename = bn;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setKey(String key) {
        this._key = key;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setReplace(String replace) {
        this._replace = replace;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setAbort(String abort) {
        this._abort = Boolean.parseBoolean(abort);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setSilent(String silent) {
        this._silent = Boolean.parseBoolean(silent);
    }

    @Override
    public void execute() throws TaskExecutionException {
        try {
            String keyFilename;
            if (this._key != null && !this._key.equals("") && (keyFilename = this._context.getString(this._namespace, this._key)) != null && !"".equals(keyFilename)) {
                this._propertyFilename = keyFilename;
            }
            this._propertyFilename = this._context.substitute(this._namespace, this._propertyFilename);
            if ("true".equalsIgnoreCase(this._replace)) {
                this._context.storeAll(this._namespace, this._propertyFilename);
            } else {
                this._context.storeNew(this._namespace, this._propertyFilename);
            }
        }
        catch (IOException iox) {
            if (this._abort) {
                String msg;
                this._logger.log(Level.SEVERE, "Unable to load object store namespace <" + this._namespace + "> with file (" + this._propertyFilename + ")!", iox);
                try {
                    msg = MessageFormat.format(this._context.getI18nString("wizard", "LoadObjectStoreTask.error.msg"), this._propertyFilename);
                }
                catch (Exception ignore) {
                    msg = "Unable to load object store namespace <" + this._namespace + "> with file (" + this._propertyFilename + ")!";
                }
                throw new TaskExecutionException(this, msg, iox);
            }
            if (!this._silent) {
                this._logger.log(Level.SEVERE, "Unable to load object store namespace <" + this._namespace + "> with file (" + this._propertyFilename + ")!", iox);
            }
            this._logger.log(Level.FINE, "Unable to load object store namespace <" + this._namespace + "> with file (" + this._propertyFilename + ")!");
        }
    }
}

