/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table;

import com.oracle.cie.wizardx.gui.table.AbstractTableCellDecorator;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationSupport;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public abstract class AbstractTableCellEditor<C extends JComponent>
extends AbstractCellEditor
implements TableCellEditor {
    protected C _component;
    protected JTable _table;
    protected int _row;
    protected int _column;
    protected int _modelColumn;
    protected Object _startValue;

    protected AbstractTableCellEditor(C component) {
        this._component = component;
    }

    @Override
    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._table = table;
        this._row = row;
        this._column = column;
        this._modelColumn = this._table.convertColumnIndexToModel(column);
        this._startValue = value;
        JComponent editorComponent = this.getComponent(table, value, isSelected, row, column);
        this.addDocListenerToTableCell();
        return AbstractTableCellDecorator.decorateComponent(editorComponent, table, isSelected, isSelected, row, column, false);
    }

    @Override
    public void cancelCellEditing() {
        this.resetCellLocation();
        this.removeDocListenerFromTableCell();
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.resetCellLocation();
        this.removeDocListenerFromTableCell();
        return super.stopCellEditing();
    }

    protected abstract JComponent getComponent(JTable var1, Object var2, boolean var3, int var4, int var5);

    protected void addDocListenerToTableCell() {
    }

    protected void removeDocListenerFromTableCell() {
    }

    protected void notifyCellIsChanging() {
        if (this._table instanceof CellDecorationSupport && this._row >= 0 && this._column >= 0) {
            ((CellDecorationSupport)CellDecorationSupport.class.cast(this._table)).cellValueChanging(this._row, this._column);
        }
    }

    protected void resetCellLocation() {
        this._table = null;
        this._row = -1;
        this._column = -1;
        this._modelColumn = -1;
    }

    public class CustomDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            AbstractTableCellEditor.this.notifyCellIsChanging();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AbstractTableCellEditor.this.notifyCellIsChanging();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AbstractTableCellEditor.this.notifyCellIsChanging();
        }
    }
}

