/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.enc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XECipherReference
extends ObjectReference {
    public XECipherReference(Element cipherRef) throws DOMException {
        super(cipherRef);
    }

    public XECipherReference(Element cipherRef, String systemId) throws DOMException {
        super(cipherRef, systemId);
    }

    XECipherReference(Document doc, String uri) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#", "CipherReference", uri);
    }

    @Override
    public void addTransform(XSAlgorithmIdentifier trans) throws DOMException {
        String name = trans.getLocalName();
        if (name == null) {
            String tn = trans.getTagName();
            int i = tn.indexOf(":");
            String string = name = i == -1 ? tn : tn.substring(i + 1);
        }
        if (!"Transform".equals(name)) {
            throw new IllegalArgumentException("Tag name \"" + name + "\" not allowed for Transform");
        }
        String prefix = trans.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            trans.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
        } else {
            trans.addNSPrefixAttr(prefix, "http://www.w3.org/2000/09/xmldsig#");
        }
        NodeList tsList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
        Element ts = null;
        if (tsList.getLength() > 0) {
            ts = (Element)tsList.item(0);
        } else {
            ts = this.getOwnerDocument().createElementNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
            XMLUtils.copyNSPrefix((Element)this.node, ts);
            this.appendChild(ts);
        }
        ts.appendChild(trans.getNode());
    }

    @Override
    public Vector getTransforms() {
        NodeList tsList = this.getChildElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "Transforms");
        Vector<XSAlgorithmIdentifier> list = new Vector<XSAlgorithmIdentifier>();
        if (tsList.getLength() != 0) {
            NodeList tList = XMLElement.getChildElementsByTagNameNS((Element)tsList.item(0), "http://www.w3.org/2000/09/xmldsig#", "Transform");
            int n = tList.getLength();
            for (int i = 0; i < n; ++i) {
                list.addElement(new XSAlgorithmIdentifier((Element)tList.item(i), this.systemId));
            }
        }
        return list;
    }

    public byte[] getCipherValue() throws ReferenceException {
        XMLContainer result = (XMLContainer)this.dereference();
        if (result.octetsAvailable()) {
            try {
                return result.toByteArray();
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
        }
        if (result.nodeSetAvailable() || result.subTreeAvailable()) {
            throw new ReferenceException("Dereference expected octet stream, got node-set");
        }
        return null;
    }

    public InputStream getCipherValueAsStream() throws ReferenceException {
        XMLContainer result = (XMLContainer)this.dereference();
        if (result.octetsAvailable()) {
            try {
                return result.getOctetStream();
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
        }
        if (result.nodeSetAvailable() || result.subTreeAvailable()) {
            throw new ReferenceException("Dereference expected octet stream, got node-set");
        }
        return null;
    }
}

