/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import javax.crypto.KeyAgreement;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.ECKeyValue;
import oracle.security.xmlsec.keys.KeyDerivationMethod;
import oracle.security.xmlsec.keys.KeyDerivationParams;
import oracle.security.xmlsec.keys.KeyValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ECDHESAgreementMethod
extends AgreementMethod {
    public ECDHESAgreementMethod(Document doc) throws DOMException {
        super(doc, "http://www.w3.org/2009/xmlenc11#ECDH-ES");
    }

    public ECDHESAgreementMethod(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ECDHESAgreementMethod(Element element) throws DOMException {
        super(element);
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2009/xmlenc11#ECDH-ES";
    }

    @Override
    public void setAlgorithm(String algURI) {
        if (!algURI.equals("http://www.w3.org/2009/xmlenc11#ECDH-ES")) {
            throw new IllegalArgumentException("Unknown Elliptic curve Diffie-Hellman key agreement algorithm: " + algURI);
        }
        this.setAttribute("Algorithm", "http://www.w3.org/2009/xmlenc11#ECDH-ES");
    }

    @Override
    public byte[] generateKeyMaterial(XEEncryptionMethod encMtd, PrivateKey loKey, PublicKey opKey) throws XESchemaException, XECipherException {
        KeyDerivationParams keyDerivator = this.getKeyDerivationMethod().getKeyDerivationParams();
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(loKey);
            ka.doPhase(opKey, true);
            byte[] secret = ka.generateSecret();
            return keyDerivator.deriveKey(secret, encMtd.keySize() / 8);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new XECipherException(ex);
        }
    }

    @Override
    public KeyPair setToDefaultParameters(KeyPair originatorKeyPair, PublicKey recipientKey, String keyDerivationAlgURI) throws XECipherException {
        if (originatorKeyPair == null) {
            try {
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("EC");
                keygen.initialize(((ECPublicKey)recipientKey).getParams());
                originatorKeyPair = keygen.generateKeyPair();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XECipherException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new XECipherException(ex);
            }
        }
        KeyDerivationMethod kmethod = new KeyDerivationMethod(this.getOwnerDocument());
        this.setKeyDerivationMethod(kmethod);
        KeyDerivationParams kdf = KeyDerivationParams.getInstance(this.getOwnerDocument(), keyDerivationAlgURI);
        kmethod.setKeyDerivationParams(kdf);
        kdf.setToDefaultParameters();
        ECKeyValue kval = new ECKeyValue(this.getOwnerDocument(), (ECPublicKey)originatorKeyPair.getPublic());
        OriginatorKeyInfo kinfo = new OriginatorKeyInfo(this.getOwnerDocument());
        kinfo.addKeyInfoData(new KeyValue(this.getOwnerDocument(), kval));
        this.setOriginatorKeyInfo(kinfo);
        return originatorKeyPair;
    }
}

