/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import oracle.security.xmlsec.util.NodeReaderException;
import org.w3c.dom.Node;

public abstract class NodeReader {
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int PROCESSING_INSTRUCTION = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 5;
    public static final int CDATA = 12;
    public static final int START_DOCUMENT = 7;
    public static final int END_DOCUMENT = 8;
    public static final int DTD = 11;
    ArrayList listeners = new ArrayList();

    public abstract boolean hasNext() throws NodeReaderException;

    public abstract int next() throws NodeReaderException;

    public abstract int getEventType();

    public abstract String getLocalName();

    public abstract String getNamespaceURI();

    public abstract String getPrefix();

    public abstract char[] getText();

    public abstract int getTextStart();

    public abstract int getTextLength();

    public abstract String getPIData();

    public abstract String getPITarget();

    public boolean isElementIncluded() {
        return true;
    }

    public Node getNode() {
        return null;
    }

    public abstract Iterator getAttributes();

    public SortedMap getSortedAttributes() {
        return null;
    }

    public Map getNamespaces() {
        return null;
    }

    public boolean isElementAnOrphan() {
        return false;
    }

    public Collection getAncestorXmlAttributes(boolean c14n11) throws NodeReaderException {
        return null;
    }

    public boolean isElementInheritingNamespaces() {
        return true;
    }

    public Iterator getNamespacesForMissingAncestors() {
        return null;
    }

    public boolean isUnnecessaryEmptyDefaultNsRequired() {
        return false;
    }

    public void addListener(NodeListener nodeListener) {
        this.listeners.add(nodeListener);
    }

    public void removeListener(NodeListener nodeListener) {
        this.listeners.remove(nodeListener);
    }

    protected void fireConsumeNode() throws NodeReaderException {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((NodeListener)this.listeners.get(i)).consumeNode();
        }
    }

    public static interface NodeListener {
        public void consumeNode() throws NodeReaderException;
    }
}

