/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.services.ClassLoaderService;
import com.oracle.cie.common.util.ManifestInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Version {
    private static final Logger _log = Logger.getLogger(Version.class.getName());
    public static final Attributes.Name RELEASE_VERSION_ATTRIBUTE = new Attributes.Name("Release-Version");
    public static final String DEFAULT_VERSION = "1.8.1.1";
    public static final String DEFAULT_RELEASE_VERSION = "13.9.3.0.0";
    public static final String DEFAULT_VENDOR = "Oracle Corp.";
    public static final String DEFAULT_VENDOR_ID = "Oracle";
    private static String _version;
    private static String _releaseVersion;
    private static String _vendor;
    private static String _vendorId;
    private static boolean _loaded;

    public static String getVersion() {
        Version.loadManifestAttributes();
        if (_version == null) {
            return DEFAULT_VERSION;
        }
        return _version;
    }

    public static String getReleaseVersion() {
        Version.loadManifestAttributes();
        if (_releaseVersion == null) {
            return DEFAULT_RELEASE_VERSION;
        }
        return _releaseVersion;
    }

    public static String getVendor() {
        if (_vendor == null) {
            return DEFAULT_VENDOR;
        }
        return _vendor;
    }

    public static String getVendorId() {
        if (_vendorId == null) {
            return DEFAULT_VENDOR_ID;
        }
        return _vendorId;
    }

    private static void loadManifestAttributes() {
        if (!_loaded) {
            _loaded = true;
            try {
                File myLocation = ClassLoaderService.getInstance().locateClass(Version.class, Version.class.getClassLoader());
                if (myLocation.getName().endsWith(".jar")) {
                    JarFile jar = new JarFile(myLocation);
                    _version = ManifestInfo.getAttributeValue((JarFile)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
                    _vendor = ManifestInfo.getAttributeValue((JarFile)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR);
                    _vendorId = ManifestInfo.getAttributeValue((JarFile)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                    _releaseVersion = ManifestInfo.getAttributeValue((JarFile)jar, (Attributes.Name)RELEASE_VERSION_ATTRIBUTE);
                    jar.close();
                } else {
                    String path = myLocation.getAbsolutePath();
                    File manifestFile = new File(myLocation = new File(path.substring(0, path.length() - (Version.class.getName().length() + 6))), "META-INF/MANIFEST.MF");
                    if (manifestFile.exists()) {
                        FileInputStream fis = new FileInputStream(manifestFile);
                        Manifest manifest = new Manifest(fis);
                        fis.close();
                        Attributes attributes = manifest.getMainAttributes();
                        _version = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        _vendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                        _vendorId = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
                        _releaseVersion = attributes.getValue(RELEASE_VERSION_ATTRIBUTE);
                    }
                }
            }
            catch (IOException e) {
                _log.log(Level.FINEST, "Unable to load manifest attributes.", e);
            }
        }
    }

    static {
        _loaded = false;
    }
}

