/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.Delete;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.gdr.carbdiff.CarbDiff;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.pad.ArtifactInfoOverride;
import com.oracle.cie.gdr.dao.pad.PatchArtifactDefinition;
import com.oracle.cie.gdr.helpers.PatchArtifactDefinitionHelper;
import com.oracle.cie.gdr.utils.ComponentArchiveUtils;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

public class CarbDiffGenerator {
    private Logger _log = Logger.getLogger(CarbDiffGenerator.class.getName());
    private String _coordinates;
    private boolean _useLatest;
    private List<CarbDiff> _carbDiffList;
    private PatchArtifactDefinition _patchArtifactDef;
    private File _destination;
    private RestHandler _restHandler;
    private List<Repository> _repos;
    private Strategy _strategy;
    private boolean _excludeGenericPlatform;
    private static final String _uid = "12345678";

    public CarbDiffGenerator(String coordinates, boolean useLatest) {
        this._coordinates = coordinates;
        this._useLatest = useLatest;
        this._restHandler = RestFactory.getRestHandler();
        this._repos = new ArrayList<Repository>();
        this._strategy = Strategy.Injection;
    }

    public CarbDiffGenerator(PatchArtifactDefinition pad) {
        this._patchArtifactDef = pad;
        this._restHandler = RestFactory.getRestHandler();
        this._repos = new ArrayList<Repository>();
        this._strategy = Strategy.Injection;
    }

    public boolean diff() throws GdrException {
        if (this._patchArtifactDef == null) {
            this._patchArtifactDef = this.retrievePatchArtifactDef(this._coordinates, this._useLatest);
            if (this._patchArtifactDef == null) {
                throw new GdrException("Unable to continue because there is no patch artifact def to process.");
            }
        }
        this._log.finest("Starting the diff process for al components.");
        try {
            boolean hasDiffs = false;
            List<ArtifactInfoOverride> carbInfos = this._patchArtifactDef.getCarbInfos();
            if (carbInfos != null && !carbInfos.isEmpty()) {
                this._log.fine("Executing diff on carbs.");
                File componentsLocation = new File(this._destination, "deltas");
                Delete.delete((File)componentsLocation);
                if (this._carbDiffList == null) {
                    this._carbDiffList = new ArrayList<CarbDiff>();
                }
                for (ArtifactInfoOverride artifactInfo : carbInfos) {
                    Artifact releasedArtifact;
                    Artifact baseArtifact = artifactInfo.getBaseArtifact().getArtifact("carb");
                    Artifact patchedArtifact = artifactInfo.getPatchedArtifact().getArtifact("carb");
                    Artifact artifact = releasedArtifact = artifactInfo.getReleasedArtifact() != null ? artifactInfo.getReleasedArtifact().getArtifact("carb") : null;
                    if (!baseArtifact.equalsBase((Object)patchedArtifact)) {
                        throw new GdrException("The base carb artifact " + baseArtifact.getCoordinateString() + " did not correspond to the patched carb artifact " + patchedArtifact.getCoordinateString());
                    }
                    File baseArtifactFile = this._restHandler.retrieveArtifact(baseArtifact, this._repos, true);
                    File patchedArtifactFile = this._restHandler.retrieveArtifact(patchedArtifact, this._repos, true);
                    File releasedArtifactFile = releasedArtifact != null ? this._restHandler.retrieveArtifact(releasedArtifact, this._repos, true) : null;
                    CarbDiff carbDiff = new CarbDiff();
                    if (artifactInfo.getFileMapFilter() != null) {
                        FileMapFilterer filterer = new FileMapFilterer(artifactInfo.getFileMapFilter().getInclude(), artifactInfo.getFileMapFilter().getExclude());
                        carbDiff.setBypassDiff(artifactInfo.getFileMapFilter().bypassDiff());
                        filterer.setReversed(this.isReversed(artifactInfo.getFileMapFilter().getPrecedence()));
                        carbDiff.setFileMapFilterer(filterer);
                    }
                    String targetedCarbClassifier = ComponentArchiveUtils.getTargetedCarbClassifier(patchedArtifact);
                    File componentLocation = new File(componentsLocation, ComponentArchiveUtils.getComponentArchiveExtractionDirectoryName(patchedArtifact.getName(), patchedArtifact.getBaseVersion(), targetedCarbClassifier));
                    if (componentLocation.exists()) {
                        throw new CarbDiffException("The component diff output area already existed " + componentLocation);
                    }
                    if (!carbDiff.diff(baseArtifactFile, patchedArtifactFile, releasedArtifactFile, componentLocation, this._strategy, this._patchArtifactDef.getPlatform(), this._excludeGenericPlatform, _uid)) continue;
                    this._carbDiffList.add(carbDiff);
                    hasDiffs = true;
                }
            }
            return hasDiffs;
        }
        catch (GdrException | RestException | IOException e) {
            throw new GdrException(e.getCause());
        }
    }

    private boolean isReversed(String precedence) {
        return !StringUtil.isNullOrEmpty((String)precedence) && precedence.equals("exclude");
    }

    private PatchArtifactDefinition retrievePatchArtifactDef(String gav, boolean useLatest) throws GdrException {
        File padFile = null;
        try {
            PatchArtifactDefinition pad;
            if (useLatest) {
                String[] coordinates = gav.split(":");
                if (coordinates.length < 3) {
                    throw new GdrException("The provided coordinates do not have the correct GAV.");
                }
                String patchInputsGroupId = "com.oracle.cie.gdr.patch.inputs." + coordinates[1] + "." + coordinates[2].replace(".", "-");
                for (Repository repo : this._repos) {
                    List<Artifact> patchDefArtifacts = this.retrieveLatestArtifacts(patchInputsGroupId, "patch-artifact-def", null, "xml", repo);
                    if (patchDefArtifacts == null || patchDefArtifacts.isEmpty()) continue;
                    padFile = RestFactory.getRestHandler().retrieveArtifact((Artifact)patchDefArtifacts.iterator().next(), repo, true);
                }
            } else {
                Artifact padArtifact = DependencyManagementFactory.getArtifact((String)gav);
                padFile = RestFactory.getRestHandler().retrieveArtifact(padArtifact, this._repos, true);
            }
            if (padFile != null && (pad = (PatchArtifactDefinition)PatchArtifactDefinitionHelper.getInstance().getRootWrapper(padFile)) != null) {
                return pad;
            }
        }
        catch (DataHandlerException | DependencyManagementException | RestException | IOException e) {
            throw new GdrException("Failed to retrieve patch artifact definition.", e);
        }
        return null;
    }

    private List<Artifact> retrieveLatestArtifacts(String groupId, String artifactId, String version, String type, Repository repo) throws RestException {
        Map artifactMap;
        TreeMap<Version, Artifact> sortedVersionMap = new TreeMap<Version, Artifact>();
        GavcSearchResult gavcSearchResult = RestFactory.getRestHandler().gavcSearch(groupId, artifactId, version, null, repo, true);
        Map map = artifactMap = gavcSearchResult != null ? gavcSearchResult.getArtifactMap() : null;
        if (artifactMap != null && !artifactMap.isEmpty()) {
            for (Map.Entry entry : artifactMap.entrySet()) {
                Artifact artifact = (Artifact)entry.getKey();
                if (!artifact.getType().equals(type)) continue;
                this._log.fine("Adding artifact " + artifact + " to latest artifacts");
                sortedVersionMap.put(artifact.getVersion(), artifact);
            }
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(sortedVersionMap.values());
        Collections.reverse(artifacts);
        return artifacts;
    }

    public List<CarbDiff> getCarbDiffList() {
        return this._carbDiffList;
    }

    public Map<com.oracle.cie.gdr.dao.cpd.File, List<String>> getFileTargets(FileMap fileMap) throws CarbDiffException {
        HashMap<com.oracle.cie.gdr.dao.cpd.File, List<String>> filesMap = new HashMap<com.oracle.cie.gdr.dao.cpd.File, List<String>>();
        for (com.oracle.cie.gdr.dao.cpd.File aFile : fileMap.getFiles()) {
            ArrayList<String> filteredEntries = new ArrayList<String>();
            File file = new File(aFile.getSource());
            if (JarUtils.isArchive((File)file)) {
                try {
                    List<String> entries = JarUtils.getJarEntries((File)file, null);
                    entries = this.filterDirectories(entries);
                    for (String entry : entries) {
                        if (JarUtils.isArchive((File)file, (String)entry)) {
                            filteredEntries.addAll(this.getInnerEntries(file, entry, aFile.getDest()));
                            continue;
                        }
                        filteredEntries.add(aFile.getDest() + "/" + entry);
                    }
                    filesMap.put(aFile, filteredEntries);
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    throw new CarbDiffException("Unable to retrive file targets from file: " + file.getName());
                }
            }
            filesMap.put(aFile, null);
        }
        return filesMap;
    }

    private List<String> filterDirectories(List<String> entries) {
        ArrayList<String> filteredEntries = new ArrayList<String>();
        for (String entry : entries) {
            if (entry.endsWith(File.separator) || entry.endsWith("/")) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    private List<String> getInnerEntries(File parentFile, String entry, String dest) throws IllegalArgumentException, IOException {
        ArrayList<String> entries = new ArrayList<String>();
        List<Object> innerEntries = new ArrayList();
        File innerFile = JarUtils.extractIntoTempFile((File)parentFile, (String)entry);
        innerEntries = JarUtils.getJarEntries((File)innerFile, null);
        innerEntries = this.filterDirectories(innerEntries);
        for (String string : innerEntries) {
            if (JarUtils.isArchive((File)innerFile, (String)string)) {
                entries.addAll(this.getInnerEntries(innerFile, string, dest + "/" + entry + "/"));
                continue;
            }
            entries.add(dest + "/" + entry + "/" + string);
        }
        return entries;
    }

    public void setDestination(File file) {
        this._destination = file;
    }

    public void addRepos(List<Repository> repos) {
        this._repos.addAll(repos);
    }
}

