/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.StringUtil;

public enum Strategy {
    Replacement,
    ReplacementInUse,
    Injection,
    Delete,
    Upgrade,
    Install,
    Deinstall;


    public boolean isReplacement() {
        return this == Replacement;
    }

    public boolean isUpgrade() {
        return this == Upgrade;
    }

    public boolean isInstall() {
        return this == Install;
    }

    public boolean isDeinstall() {
        return this == Deinstall;
    }

    public boolean isReplacementInUse() {
        return this == ReplacementInUse;
    }

    public boolean isInjection() {
        return this == Injection;
    }

    public boolean isDelete() {
        return this == Delete;
    }

    public String getXmlName() {
        return this.name().toLowerCase();
    }

    public static Strategy getStrategy(String name) {
        Strategy strategy = null;
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            name = name.trim();
            for (Strategy s : Strategy.values()) {
                if (!s.name().equalsIgnoreCase(name)) continue;
                strategy = s;
                break;
            }
        }
        return strategy;
    }
}

