/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.cpd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.DataHandlerHelper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.IncludeExclude;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.dao.cpd.Modifier;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.cpd.Rule;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.services.RepositoryArtifact;
import java.util.List;

public class RepoDirectory
extends AbstractDataHandlerWrapper
implements RepositoryArtifact,
Mapping {
    public RepoDirectory(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public RepoDirectory() {
        this(ComponentHelper.getInstance().create("repo-directory"));
    }

    @Override
    public String getSource() {
        return this.getStringAttribute("source");
    }

    @Override
    public void setSource(String source) {
        this.setAttribute("source", source);
    }

    @Override
    public String getDest() {
        return this.getStringAttribute("dest");
    }

    @Override
    public void setDest(String dest) {
        this.setAttribute("dest", dest);
    }

    @Override
    public String getId() {
        return this.getStringAttribute("id");
    }

    @Override
    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public boolean isDeinstall() {
        return this.getBooleanAttribute("deinstall");
    }

    public void setDeinstall(boolean uninstall) {
        this.setAttribute("deinstall", uninstall);
    }

    public boolean isRecursive() {
        return this.getBooleanAttribute("recurse");
    }

    public void setRecursive(boolean recursive) {
        this.setAttribute("recurse", recursive);
    }

    public boolean isIncludeEmptyDirs() {
        return this.getBooleanAttribute("include-empty-dirs");
    }

    public void setIncludeEmptyDirs(boolean include) {
        this.setAttribute("include-empty-dirs", include);
    }

    public boolean isPreserveSymlinks() {
        return this.getBooleanAttribute("preserve-symlinks");
    }

    public void setPreserveSymlinks(boolean preserveSymlinks) {
        this.setAttribute("preserve-symlinks", preserveSymlinks);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    public List<Rule> getRules() {
        return this.getComplexValueWrappedList("rule", Rule.class);
    }

    public void setRules(List<Rule> rules) {
        this.setComplexValueWrappedList("rule", rules);
    }

    public List<Permission> getPermissions() {
        return DataHandlerHelper.getWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms"), (String)"permission", Permission.class);
    }

    public void setPermissions(List<Permission> permissions) {
        DataHandlerHelper.setWrapperList((IDataHandler)this.getSingleOccuranceComplexValue("file-perms", true), (String)"permission", permissions);
    }

    public List<Modifier> getModifiers() {
        return this.getComplexValueWrappedList("modifier", Modifier.class);
    }

    public void setModifiers(List<Modifier> modifiers) {
        this.setComplexValueWrappedList("modifier", modifiers);
    }

    public List<IncludeExclude> getIncludes() {
        return this.getComplexValueWrappedList("include", IncludeExclude.class);
    }

    public void setIncludes(List<IncludeExclude> includes) {
        this.setComplexValueWrappedList("include", includes);
    }

    public List<IncludeExclude> getExcludes() {
        return this.getComplexValueWrappedList("exclude", IncludeExclude.class);
    }

    public void setExcludes(List<IncludeExclude> excludes) {
        this.setComplexValueWrappedList("exclude", excludes);
    }

    @Override
    public String getGroup() {
        return this.getStringAttribute("group");
    }

    @Override
    public void setGroup(String group) {
        this.setAttribute("group", group);
    }

    @Override
    public String getArtifact() {
        return this.getStringAttribute("artifact");
    }

    @Override
    public void setArtifact(String artifact) {
        this.setAttribute("artifact", artifact);
    }

    @Override
    public String getVersion() {
        return this.getStringAttribute("version");
    }

    @Override
    public void setVersion(String version) {
        this.setAttribute("version", version);
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this.getBooleanAttribute("ignore-version-keywords");
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignore) {
        this.setAttribute("ignore-version-keywords", ignore);
    }

    @Override
    public String getBaseVersion() {
        return this.getStringAttribute("baseVersion");
    }

    @Override
    public void setBaseVersion(String version) {
        this.setAttribute("baseVersion", version);
    }

    @Override
    public String getClassifier() {
        String classifier = this.getStringAttribute("classifier");
        if (classifier != null && classifier.trim().length() < 1) {
            classifier = null;
        }
        return classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this.setAttribute("classifier", classifier);
    }

    @Override
    public String getType() {
        String type = this.getStringAttribute("type");
        if (type != null && type.trim().length() < 1) {
            type = null;
        }
        return type;
    }

    @Override
    public void setType(String type) {
        this.setAttribute("type", type);
    }

    public Directory createDirectory() {
        List<IncludeExclude> excludes;
        List<IncludeExclude> includes;
        List<Rule> rules;
        List<Permission> permissions;
        List<Modifier> modifiers;
        boolean b;
        Directory directory = new Directory();
        String tmpStr = this.getDest();
        if (tmpStr != null) {
            directory.setDest(tmpStr);
        }
        if ((tmpStr = this.getSource()) != null) {
            directory.setSource(tmpStr);
        }
        if ((tmpStr = this.getId()) != null) {
            directory.setId(tmpStr);
        }
        if ((tmpStr = this.getMode()) != null) {
            directory.setMode(tmpStr);
        }
        if ((tmpStr = this.getGroup()) != null) {
            directory.setGroup(tmpStr);
        }
        if ((tmpStr = this.getArtifact()) != null) {
            directory.setArtifact(tmpStr);
        }
        if ((tmpStr = this.getVersion()) != null) {
            directory.setVersion(tmpStr);
        }
        if ((tmpStr = this.getBaseVersion()) != null) {
            directory.setBaseVersion(tmpStr);
        }
        if ((tmpStr = this.getType()) != null) {
            directory.setType(tmpStr);
        }
        if ((tmpStr = this.getClassifier()) != null) {
            directory.setClassifier(tmpStr);
        }
        if ((b = this.isDeinstall()) != directory.isDeinstall()) {
            directory.setDeinstall(b);
        }
        if ((b = this.isIncludeEmptyDirs()) != directory.isIncludeEmptyDirs()) {
            directory.setIncludeEmptyDirs(b);
        }
        if ((b = this.isPreserveSymlinks()) != directory.isPreserveSymlinks()) {
            directory.setPreserveSymlinks(b);
        }
        if ((b = this.isRecursive()) != directory.isRecursive()) {
            directory.setRecursive(b);
        }
        if ((modifiers = this.getModifiers()) != null && !modifiers.isEmpty()) {
            directory.setModifiers(modifiers);
        }
        if ((permissions = this.getPermissions()) != null && !permissions.isEmpty()) {
            directory.setPermissions(permissions);
        }
        if ((rules = this.getRules()) != null && !rules.isEmpty()) {
            directory.setRules(rules);
        }
        if ((includes = this.getIncludes()) != null && !includes.isEmpty()) {
            directory.setIncludes(includes);
        }
        if ((excludes = this.getExcludes()) != null && !excludes.isEmpty()) {
            directory.setExcludes(excludes);
        }
        return directory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepoDirectory directory = (RepoDirectory)o;
        String thisDest = this.getDest();
        String theirDest = directory.getDest();
        return !(thisDest == null ? theirDest != null : !thisDest.equals(theirDest));
    }

    public int hashCode() {
        String dest = this.getDest();
        return dest != null ? dest.hashCode() : 0;
    }

    public Boolean getPatchable() {
        return (Boolean)this.getDataHandler().getAttributeValue("patchable");
    }

    public void setPatchable(boolean patchable) {
        this.setAttribute("patchable", patchable);
    }
}

