/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.dbd;

import com.oracle.cie.common.dao.AbstractDataHandlerWrapper;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.dbd.MappingSymbol;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import java.util.ArrayList;
import java.util.List;

public class RootMapping
extends AbstractDataHandlerWrapper {
    private String _directoryMapName;
    private List<MappingSymbol> _mappingSymbols;

    public RootMapping(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public RootMapping() {
        this(DistributionHelper.getInstance().create("root-mapping"));
    }

    public String[] getSymbols() {
        return (String[])this.getDataHandler().getSimpleValue("symbol");
    }

    public MappingSymbol getMappingSymbol(String symbol, boolean regex) {
        return new MappingSymbol(symbol, regex);
    }

    public List<MappingSymbol> getMappingSymbols() {
        if (this._mappingSymbols == null) {
            this._mappingSymbols = new ArrayList<MappingSymbol>();
            String[] symbols = this.getSymbols();
            if (symbols != null && symbols.length > 0) {
                for (String symbol : symbols) {
                    this._mappingSymbols.add(this.getMappingSymbol(symbol, false));
                }
            }
        }
        return this._mappingSymbols;
    }

    public void setSymbols(List<MappingSymbol> symbols) {
        String[] symbolArray = null;
        if (symbols != null) {
            this._mappingSymbols = new ArrayList<MappingSymbol>(symbols);
            symbolArray = new String[symbols.size()];
            for (int x = 0; x < symbols.size(); ++x) {
                symbolArray[x] = symbols.get(x).getSymbol();
            }
        } else {
            this._mappingSymbols = null;
        }
        this.setSymbols(symbolArray);
    }

    public void setSymbols(String[] symbols) {
        this.getDataHandler().setSimpleValue("symbol", (Object)symbols);
    }

    public String getMode() {
        return this.getStringAttribute("mode");
    }

    public void setMode(String mode) {
        this.setAttribute("mode", mode);
    }

    public String getDirectoryMapName() {
        return this._directoryMapName;
    }

    public void setDirectoryMapName(String directoryMapName) {
        this._directoryMapName = directoryMapName;
    }
}

