/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.dao.nfo;

import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.gdr.dao.nfo.InstallerSizeInfo;
import com.oracle.cie.gdr.dao.nfo.RegexReference;
import com.oracle.cie.gdr.helpers.InstallerInfoHelper;
import java.util.List;

public class InstallerComponentInfo
extends RegexReference {
    public InstallerComponentInfo(IDataHandler dataHandler) {
        super(dataHandler);
    }

    public InstallerComponentInfo() {
        this(InstallerInfoHelper.getInstance().create("component-info"));
    }

    public InstallerComponentInfo(String name, String version) {
        this();
        this.setName(name);
        this.setVersion(version);
    }

    public boolean isPackaged() {
        return this.getBooleanAttribute("packaged");
    }

    public void setPackaged(boolean packaged) {
        this.setAttribute("packaged", packaged);
    }

    public int getDisk() {
        return (Integer)this.getNumberAttribute("disk", Integer.class);
    }

    public void setDisk(int disk) {
        this.setAttribute("disk", disk);
    }

    public boolean isCarb() {
        return this.getBooleanAttribute("carb");
    }

    public void setCarb(boolean carb) {
        this.setAttribute("carb", carb);
    }

    public List<InstallerSizeInfo> getInstallerSizeInfo() {
        return this.getComplexValueWrappedList("size-info", InstallerSizeInfo.class);
    }

    public void setInstallerSizeInfo(List<InstallerSizeInfo> sizeInfo) {
        this.setComplexValueWrappedList("size-info", sizeInfo);
    }

    public String getPatchLevel() {
        return this.getStringAttribute("patch-level");
    }

    public void setPatchLevel(String patchLevel) {
        this.setAttribute("patch-level", patchLevel);
    }
}

