/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.deinstallation;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.ComponentLoader;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.rgy.ComponentInfo;
import com.oracle.cie.gdr.dao.rgy.DistributionInfo;
import com.oracle.cie.gdr.dao.rgy.FeatureInfo;
import com.oracle.cie.gdr.dao.rgy.Registry;
import com.oracle.cie.gdr.dao.rgy.SessionInfo;
import com.oracle.cie.gdr.dao.rgy.TargetInfo;
import com.oracle.cie.gdr.deinstallation.CommonDeInstaller;
import com.oracle.cie.gdr.deinstallation.DeInstallationSession;
import com.oracle.cie.gdr.external.DeInstallerSession;
import com.oracle.cie.gdr.helpers.RegistryHelper;
import com.oracle.cie.gdr.selection.Status;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentArchiveDeInstaller
extends CommonDeInstaller {
    private static final Logger _log = Logger.getLogger(ComponentArchiveDeInstaller.class.getName());
    private Map<DistributionTarget, ComponentLoader> _distributionsMap;
    private String oracleHome;

    public ComponentArchiveDeInstaller(DeInstallerSession deInstallationSession, Set<Reference> featureRefs, Set<Reference> componentReferences) throws IOException, DataHandlerException, GdrException {
        super((DeInstallationSession)deInstallationSession);
        this.oracleHome = deInstallationSession.getHomeDir().getPath();
        this.init(featureRefs, componentReferences);
    }

    protected void init(Set<Reference> featureRefs, Set<Reference> componentReferences) throws GdrException, IOException, DataHandlerException {
        if ((featureRefs == null || featureRefs.isEmpty()) && (componentReferences == null || componentReferences.isEmpty())) {
            GdrException ex = new GdrException("Failed to deinstall because no components or features were provided.");
            _log.throwing(this.getClass().getName(), "init", ex);
            throw ex;
        }
        this._distributionsMap = new HashMap<DistributionTarget, ComponentLoader>();
        if (featureRefs != null && !featureRefs.isEmpty()) {
            for (Reference featureRef : featureRefs) {
                FeatureSet installedFeature = this.getHome().getInstalledFeature(featureRef);
                if (installedFeature == null || !installedFeature.getStatus().isInstalled()) {
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.fine("FeatureSet " + (Object)((Object)featureRef) + " was not installed in the home directory " + this.oracleHome + ", skipping...");
                    continue;
                }
                this.addFeatureSet(installedFeature, null);
            }
        }
        if (componentReferences != null && !componentReferences.isEmpty()) {
            for (Reference componentReference : componentReferences) {
                ComponentReference installedComp = this.getHome().getInstalledComponent(componentReference.getName(), componentReference.getVersion());
                if (installedComp == null || installedComp.getStatus().isNotInstalled()) {
                    if (!_log.isLoggable(Level.FINE)) continue;
                    _log.fine("Component " + (Object)((Object)componentReference) + " was not installed in the home directory " + this.oracleHome + ", skipping...");
                    continue;
                }
                Set<FeatureSet> componentsFeatureSets = this.getHome().getInstalledFeatureSets(installedComp);
                if (componentsFeatureSets.isEmpty()) {
                    GdrException ex = new GdrException("The Component " + (Object)((Object)installedComp) + " is not a member of any feature sets in the home directory " + this.oracleHome);
                    _log.throwing(this.getClass().getName(), "init", ex);
                    throw ex;
                }
                for (FeatureSet componentFeatureSet : componentsFeatureSets) {
                    this.addFeatureSet(componentFeatureSet, componentReferences);
                }
            }
        }
        if (this._distributionsMap.isEmpty()) {
            GdrException ex = new GdrException("None of the features or components specified for deinstall were installed.");
            _log.throwing(this.getClass().getName(), "init", ex);
            throw ex;
        }
    }

    protected void addFeatureSet(FeatureSet featureSet, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        Collection<DistributionTarget> featureDistributions = this.getHome().getInstalledDistributions(featureSet);
        if (featureDistributions != null && !featureDistributions.isEmpty()) {
            for (DistributionTarget featureDistribution : featureDistributions) {
                FeatureSet actualFeatureSet = featureDistribution.getFeatureSet(featureSet.getName(), featureSet.getVersion());
                ComponentLoader componentLoader = this._distributionsMap.get(featureDistribution);
                if (componentLoader == null) {
                    componentLoader = new ComponentLoader(this.getMetaDataHome(), this.getServiceHolder(), Mode.DEINSTALL, actualFeatureSet, featureDistribution.getDirectoryMap(), this.getDeInstallInfo(), componentFilter);
                    this._distributionsMap.put(featureDistribution, componentLoader);
                    continue;
                }
                componentLoader.loadFeature(actualFeatureSet, componentFilter);
            }
        } else {
            GdrException ex = new GdrException("The FeatureSet " + featureSet + " is not a member of any distribution in the home directory " + this.oracleHome);
            _log.throwing(this.getClass().getName(), "init", ex);
            throw ex;
        }
    }

    @Override
    protected void updateRegistry(Registry registry, SessionInfo session) {
        for (DistributionTarget distribution : this._distributionsMap.keySet()) {
            ComponentLoader componentLoader = this._distributionsMap.get(distribution);
            DistributionInfo dinfo = RegistryHelper.getInstance().getDistributionInfo(registry, distribution.getDistributionName(), distribution.getDistributionVersion());
            dinfo.addSession(session);
            List<FeatureInfo> finfos = dinfo.getFeatures();
            for (FeatureSet feature : this.getSelectedFeatures()) {
                Set<Component> comps = componentLoader.getComponents();
                FeatureInfo finfo = RegistryHelper.getInstance().getFeatureInfo(finfos, feature.getName(), feature.getVersion());
                if (finfo == null) continue;
                boolean featureSetEmpty = true;
                List<ComponentInfo> cinfos = finfo.getComponents();
                for (ComponentInfo cinfo : cinfos) {
                    for (Component removeComp : comps) {
                        if (!cinfo.getName().equals(removeComp.getName()) || !cinfo.getVersion().equals(removeComp.getVersion())) continue;
                        cinfo.setStatus(Status.notinstalled);
                        cinfo.addSession(session);
                        List<TargetInfo> tinfos = cinfo.getTargets();
                        if (tinfos == null || tinfos.isEmpty()) break;
                        for (TargetInfo tinfo : tinfos) {
                            tinfo.setStatus(Status.notinstalled);
                            tinfo.addSession(session);
                        }
                    }
                    if (!cinfo.getStatus().isInstalled()) continue;
                    featureSetEmpty = false;
                }
                if (!featureSetEmpty) continue;
                finfo.setStatus(Status.notinstalled);
                finfo.addSession(session);
            }
            boolean distributionEmpty = true;
            for (FeatureInfo finfo : finfos) {
                if (!finfo.getStatus().isInstalled()) continue;
                distributionEmpty = false;
                break;
            }
            if (!distributionEmpty) continue;
            dinfo.setStatus(Status.notinstalled);
        }
    }

    @Override
    public Set<Component> getComponents() {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        for (ComponentLoader componentLoader : this._distributionsMap.values()) {
            components.addAll(componentLoader.getComponents());
        }
        return components;
    }

    @Override
    public Map<Distribution, Set<FeatureSet>> getFeatureSetsMap() {
        HashMap<Distribution, Set<FeatureSet>> featureSetsMap = new HashMap<Distribution, Set<FeatureSet>>();
        for (Map.Entry<DistributionTarget, ComponentLoader> entry : this._distributionsMap.entrySet()) {
            DistributionTarget distributionTarget = entry.getKey();
            ComponentLoader componentLoader = entry.getValue();
            featureSetsMap.put(distributionTarget.getDistribution(), componentLoader.getComponentsMap().keySet());
        }
        return featureSetsMap;
    }

    @Override
    public Set<Distribution> getDistributions() {
        LinkedHashSet<Distribution> distributions = new LinkedHashSet<Distribution>();
        for (DistributionTarget distribution : this._distributionsMap.keySet()) {
            distributions.add(distribution.getDistribution());
        }
        return distributions;
    }

    @Override
    public Set<FeatureSet> getSelectedFeatures() {
        return new LinkedHashSet<FeatureSet>(this.getComponentsMap().keySet());
    }

    @Override
    public List<Component> getSelectedComponents(FeatureSet featureSet) {
        return new ArrayList<Component>(this.getComponentsMap().get(featureSet));
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap(Distribution distribution) {
        HashMap<FeatureSet, Collection<Component>> componentsMap = new HashMap<FeatureSet, Collection<Component>>();
        ComponentLoader componentLoader = null;
        for (DistributionTarget distTarget : this._distributionsMap.keySet()) {
            if (!distTarget.getDistribution().equals(distribution)) continue;
            componentLoader = this._distributionsMap.get(distTarget);
        }
        if (componentLoader != null) {
            Map<FeatureSet, Collection<Component>> compMap = componentLoader.getComponentsMap();
            for (FeatureSet feature : compMap.keySet()) {
                if (componentsMap.containsKey(feature)) {
                    Collection components = (Collection)componentsMap.get(feature);
                    for (Component component : compMap.get(feature)) {
                        if (components.contains(component)) continue;
                        components.add(component);
                    }
                    continue;
                }
                componentsMap.put(feature, new LinkedHashSet<Component>(compMap.get(feature)));
            }
        }
        return componentsMap;
    }

    @Override
    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        LinkedHashMap<FeatureSet, Collection<Component>> componentMap = new LinkedHashMap<FeatureSet, Collection<Component>>();
        for (ComponentLoader componentLoader : this._distributionsMap.values()) {
            Map<FeatureSet, Collection<Component>> compMap = componentLoader.getComponentsMap();
            for (FeatureSet feature : compMap.keySet()) {
                if (componentMap.containsKey(feature)) {
                    Collection components = (Collection)componentMap.get(feature);
                    for (Component component : compMap.get(feature)) {
                        if (components.contains(component)) continue;
                        components.add(component);
                    }
                    continue;
                }
                componentMap.put(feature, new LinkedHashSet<Component>(compMap.get(feature)));
            }
        }
        return componentMap;
    }

    @Override
    Collection<DistributionTarget> getAffectedDistributions() {
        return new HashSet<DistributionTarget>(this._distributionsMap.keySet());
    }

    @Override
    protected boolean isForcedDeInstall() {
        return true;
    }

    @Override
    int getFeatureRemainingRefCount(FeatureSet feature) {
        int refCount = 0;
        block0: for (ComponentLoader componentLoader : this._distributionsMap.values()) {
            Collection<Component> components;
            FeatureSet actualFeature = null;
            Map<FeatureSet, Collection<Component>> componentMap = componentLoader.getComponentsMap();
            for (FeatureSet f : componentMap.keySet()) {
                if (!f.equals(feature)) continue;
                actualFeature = f;
                break;
            }
            if (actualFeature == null || (components = componentMap.get(actualFeature)) == null) continue;
            List<ComponentReference> compRefs = actualFeature.getComponentReferences();
            for (ComponentReference compRef : compRefs) {
                if (!compRef.getStatus().isInstalled()) continue;
                boolean found = false;
                for (Component component : components) {
                    if (!component.getName().equals(compRef.getName()) || !component.getVersion().equals(compRef.getVersion())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ++refCount;
                continue block0;
            }
        }
        return refCount;
    }
}

